/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNode;
import com.iplanet.ias.admin.server.gui.jato.TopFramesetViewBean;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HeaderViewBean
extends ViewBeanBase {
    public static final String CHILD_LOGOUT = "logout";
    public static final String CHILD_LOGIN_NAME = "loginname";
    public static final String CHILD_INSTANCE_NAME = "InstanceName";
    public static final String CHILD_INSTANCE_STATUS = "InstanceStatus";
    public static final String CHILD_INSTANCE_ACTION = "InstanceAction";
    private boolean showMessage = false;
    public static final String DEFAULT_DISPLAY_URL = BasicViewBeanBase.DEFAULT_DISPLAY_URL_DIR + "Header.jsp";
    public static final String PAGE_NAME = "Header";

    public HeaderViewBean(RequestContext requestContext) {
        super(PAGE_NAME);
        this.setDefaultDisplayURL(BasicViewBeanBase.getLocalizedURL(requestContext, DEFAULT_DISPLAY_URL));
        this.registerChildren();
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
        String string = (String)this.getSession().getAttribute("iASAdminUserName");
        this.setDisplayFieldValue(CHILD_LOGIN_NAME, string);
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getSession().getAttribute("selectedNode");
        if (indexTreeNode == null) {
            this.getSession().removeAttribute("masthead-instance-name");
            this.getSession().removeAttribute("masthead-status-message");
            this.showMessage = false;
            return;
        }
        String string2 = indexTreeNode.getInstanceName();
        if (string2 != null) {
            this.getSession().setAttribute("masthead-instance-name", (Object)string2);
            this.setDisplayFieldValue(CHILD_INSTANCE_NAME, string2);
        } else {
            this.getSession().removeAttribute("masthead-instance-name");
            this.setDisplayFieldValue(CHILD_INSTANCE_NAME, "");
        }
        if (indexTreeNode.isRestartNeeded()) {
            this.setDisplayFieldValue(CHILD_INSTANCE_STATUS, I18NResourceBundleModel.getLocalizedString("MSG_NeedRestartHeading"));
            this.showMessage = true;
            this.getSession().setAttribute("masthead-status-message", (Object)"true");
        } else if (indexTreeNode.isApplyNeeded()) {
            this.setDisplayFieldValue(CHILD_INSTANCE_STATUS, I18NResourceBundleModel.getLocalizedString("MSG_NeedApplyChangesHeading"));
            this.showMessage = true;
            this.getSession().setAttribute("masthead-status-message", (Object)"true");
        } else {
            this.setDisplayFieldValue(CHILD_INSTANCE_STATUS, "");
            this.showMessage = false;
            this.getSession().removeAttribute("masthead-status-message");
        }
    }

    public boolean beginMessageDisplay(ChildDisplayEvent childDisplayEvent) throws Exception {
        return this.showMessage;
    }

    public void handleLogoutRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        this.getSession().removeAttribute("iASAdminUserName");
        this.getSession().invalidate();
        ViewBean viewBean = this.getViewBean(TopFramesetViewBean.class);
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleInstanceActionRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        InstanceNode instanceNode = null;
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getSession().getAttribute("selectedNode");
        if (indexTreeNode != null) {
            instanceNode = indexTreeNode.getInstanceNode();
        }
        if (instanceNode == null) {
            this.showMessage = false;
            this.forwardTo();
        } else {
            this.getSession().setAttribute("selectedNode", (Object)instanceNode);
            if (indexTreeNode.getInstanceName() != null) {
                this.getSession().setAttribute("instance-name", (Object)instanceNode.getInstanceName());
            } else {
                this.getSession().removeAttribute("instance-name");
            }
            RequestContext requestContext = requestInvocationEvent.getRequestContext();
            requestContext.getServletContext().getRequestDispatcher(BasicViewBeanBase.getLocalizedURL(requestContext, instanceNode.getHtmlName())).forward((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse());
        }
    }

    protected void registerChildren() {
        this.registerChild(CHILD_LOGIN_NAME, StaticTextField.class);
        this.registerChild(CHILD_INSTANCE_NAME, StaticTextField.class);
        this.registerChild(CHILD_INSTANCE_STATUS, StaticTextField.class);
        this.registerChild(CHILD_INSTANCE_ACTION, HREF.class);
        this.registerChild(CHILD_LOGOUT, HREF.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_LOGIN_NAME)) {
            StaticTextField staticTextField = new StaticTextField((View)this, this.getDefaultModel(), string, string, (Object)"", null);
            return staticTextField;
        }
        if (string.equals(CHILD_INSTANCE_NAME)) {
            StaticTextField staticTextField = new StaticTextField((View)this, this.getDefaultModel(), string, string, (Object)"", null);
            return staticTextField;
        }
        if (string.equals(CHILD_INSTANCE_STATUS)) {
            StaticTextField staticTextField = new StaticTextField((View)this, this.getDefaultModel(), string, string, (Object)"", null);
            return staticTextField;
        }
        if (string.equals(CHILD_INSTANCE_ACTION)) {
            HREF hREF = new HREF((View)this, this.getDefaultModel(), string, string, (Object)"", null);
            return hREF;
        }
        if (string.equals(CHILD_LOGOUT)) {
            HREF hREF = new HREF((View)this, this.getDefaultModel(), string, string, (Object)"", null);
            return hREF;
        }
        throw new IllegalArgumentException("Invalid child name '" + string + "'");
    }
}

