/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.domains.registry.ContactData;
import com.iplanet.ias.admin.common.domains.registry.ContactDataSet;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.net.URL;
import java.util.Iterator;

public class DomainsTiledView
extends RequestHandlingTiledViewBase {
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_ROOT = "Root";
    public static final String CHILD_HOST = "Host";
    public static final String CHILD_PORT = "Port";
    public static final String CHILD_SSL = "UseSSL";
    public static final String CHILD_URL = "URL";
    public static final String CHILD_HREFLINK = "HrefLink";
    private RequestContext rc;

    public DomainsTiledView(View view, String string, RequestContext requestContext) {
        super(view, string);
        this.rc = requestContext;
        this.setMaxDisplayTiles(-1);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_NAME, StaticTextField.class);
        this.registerChild(CHILD_ROOT, StaticTextField.class);
        this.registerChild(CHILD_HOST, StaticTextField.class);
        this.registerChild(CHILD_PORT, StaticTextField.class);
        this.registerChild(CHILD_SSL, StaticTextField.class);
        this.registerChild(CHILD_HREFLINK, HREF.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_NAME) || string.equals(CHILD_ROOT) || string.equals(CHILD_HOST) || string.equals(CHILD_PORT) || string.equals(CHILD_SSL)) {
            return new TextField((View)this, (Model)this.getPrimaryModel(), string, string, (Object)"", null);
        }
        if (string.equals(CHILD_HREFLINK)) {
            return new HREF((View)this, (Model)this.getPrimaryModel(), CHILD_HREFLINK, CHILD_HREFLINK, (Object)"", null);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        if (this.getPrimaryModel() == null) {
            throw new ModelControlException("Primary model is null");
        }
        super.beginDisplay(displayEvent);
        this.loadModel();
        this.resetTileIndex();
    }

    private void loadModel() {
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            Iterator iterator = domainRegistry.iterator();
            while (iterator.hasNext()) {
                DomainEntry domainEntry = (DomainEntry)iterator.next();
                ContactDataSet contactDataSet = domainEntry.getContactData();
                Iterator iterator2 = contactDataSet.iterator();
                while (iterator2.hasNext()) {
                    ContactData contactData = (ContactData)iterator2.next();
                    ((DefaultModel)this.getPrimaryModel()).appendRow();
                    this.getPrimaryModel().setValue(CHILD_NAME, (Object)domainEntry.getName());
                    this.getPrimaryModel().setValue(CHILD_ROOT, (Object)domainEntry.getRoot());
                    this.getPrimaryModel().setValue(CHILD_HOST, (Object)contactData.getHost());
                    this.getPrimaryModel().setValue(CHILD_PORT, (Object)contactData.getPort());
                    if (contactData.useSSL()) {
                        this.getPrimaryModel().setValue(CHILD_SSL, (Object)BasicViewBeanBase.getLocalizedString("VALUE_Yes"));
                        continue;
                    }
                    this.getPrimaryModel().setValue(CHILD_SSL, (Object)BasicViewBeanBase.getLocalizedString("VALUE_No"));
                }
            }
        }
        catch (Exception exception) {
            BasicViewBeanBase.log(exception);
        }
    }

    public String endHrefLinkDisplay(ChildContentDisplayEvent childContentDisplayEvent) {
        CharSequence charSequence;
        Object object;
        String string = (String)this.getPrimaryModel().getValue(CHILD_HOST);
        try {
            object = this.rc.getRequest();
            charSequence = object.getRequestURL();
            URL uRL = new URL(charSequence.toString());
            String string2 = uRL.getHost();
            if (string.indexOf(".") < 0 && string2.indexOf(".") > 0) {
                string = string + string2.substring(string2.indexOf("."), string2.length());
            }
        }
        catch (Exception exception) {
            BasicViewBeanBase.log(exception);
        }
        object = (String)this.getPrimaryModel().getValue(CHILD_SSL);
        charSequence = "http://";
        if (((String)object).equals(BasicViewBeanBase.getLocalizedString("VALUE_Yes"))) {
            charSequence = "https://";
        }
        return "<a href = javascript:selectDomain('" + (String)charSequence + string + ":" + (String)this.getPrimaryModel().getValue(CHILD_PORT) + "') >" + (String)this.getPrimaryModel().getValue(CHILD_NAME) + "</a>";
    }
}

