/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.server.gui.jato.IASViewBean;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.beans.JDBCConnectionPool;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import java.util.ArrayList;

public class DatasourceViewBean
extends IASViewBean
implements ConfigAttributeName.JDBCResource {
    public static final String PAGE_NAME = "Datasource";
    private static String[] name = new String[]{"Id", "PoolName", "Enable", "Description"};
    private String[] attributes = new String[]{"Enable", "Description"};
    private String[] configAttr = new String[]{"enabled", "description"};
    private static String[] configName = new String[]{"name", "pool", "enabled", "description"};
    private static short[] type = new short[]{1, 5, 3, 1};
    private static String[] listName = new String[]{"Id", "Description", "Enable", "PoolName"};
    private RequestContext rc = null;

    public DatasourceViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.rc = requestContext;
        this.populatePoolName();
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected short[] getTypes() {
        return type;
    }

    protected String[] getListNames() {
        return listName;
    }

    protected void add() throws Exception {
        AppServerInstance appServerInstance = this.getInstance();
        String string = this.getDisplayFieldStringValue(name[0]);
        String string2 = this.getDisplayFieldStringValue(name[1]);
        appServerInstance.createJDBCResource(string, string2);
        JDBCResource jDBCResource = appServerInstance.getJDBCResource(string);
        this.setAttributes(this.attributes, this.configAttr, (ServerComponent)jDBCResource);
    }

    protected ServerComponent getServerComponent(String string) throws Exception {
        AppServerInstance appServerInstance = this.getInstance();
        JDBCResource jDBCResource = appServerInstance.getJDBCResource(string);
        return jDBCResource;
    }

    public String getAddURL() {
        return "CreateDatasource.jsp";
    }

    public String getEditURL() {
        return "EditDatasource.jsp";
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public String getForwardPageName() {
        return "Datasources";
    }

    public String getKeyAttribute() {
        return name[0];
    }

    protected String getListViewBeanName() {
        return "DatasourcesViewBean";
    }

    protected IASViewBean getIASViewBean() {
        return this;
    }

    private void populatePoolName() {
        String string = "PoolName";
        ComboBox comboBox = this.getComboBoxChild(string);
        comboBox.setLabelForNoneSelected(DatasourceViewBean.getLocalizedString("MSG_SelectPoolName"));
        ArrayList arrayList = this.getPoolList();
        if (arrayList.size() > 0) {
            String[] stringArray = arrayList.toArray(new String[0]);
            OptionList optionList = new OptionList(stringArray, stringArray);
            comboBox.setOptions(optionList);
        }
    }

    private ArrayList getPoolList() {
        ServerModelIterator serverModelIterator = null;
        AppServerInstance appServerInstance = this.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (appServerInstance != null) {
                serverModelIterator = appServerInstance.getJDBCConnectionPools();
            }
        }
        catch (AFException aFException) {
            serverModelIterator = null;
            String string = "Pool List not found";
            this.rc.getServletContext().log("DatasourceViewBean: AFException PoolList");
            ResponseBean.sendResponse(string, "Datasources", this.rc);
            return arrayList;
        }
        if (serverModelIterator != null) {
            while (serverModelIterator.hasNext()) {
                JDBCConnectionPool jDBCConnectionPool = (JDBCConnectionPool)serverModelIterator.next();
                arrayList.add(jDBCConnectionPool.getDisplayName());
            }
        }
        return arrayList;
    }

    protected String getObjectType() {
        return "jdbc-resource";
    }
}

