/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.gui.jato.IASPropertySheetViewBean;
import com.iplanet.ias.admin.server.gui.jato.SSLContainerView;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class AdminHttpListenerViewBean
extends IASPropertySheetViewBean
implements ConfigAttributeName.HTTPListener,
ConfigAttributeName.Ssl {
    public static final String PAGE_NAME = "AdminHttpListener";
    private static final String CHILD_SSLCONTAINERVIEW = "SSLContainerView";
    private static String[] name = new String[]{"Address", "Port", "ServerName", "Family", "AccptThreads", "BlockEnable", "SecurityEnable", "Enable"};
    private static String[] configName = new String[]{"address", "port", "serverName", "family", "acceptorThreads", "blockingEnabled", "securityEnabled", "enabled"};
    private static short[] type = new short[]{1, 2, 1, 1, 2, 3, 3, 3};
    private static String[] SSLName = new String[]{"CertName", "SSL2Enable", "SSL3Enable", "TLSEnable", "TLSRollback", "ClientEnable"};
    private static String[] SSLConfigName = new String[]{"cert", "ssl2", "ssl3", "tls", "tlsRollback", "clientAuth"};
    short[] SSLType = new short[]{5, 3, 3, 3, 3, 3};
    private static String listenerId = "IdStatic";
    private static String CHILD_VIRTUAL = "VirtualServer";
    private RequestContext rc;
    private AppServerInstance adminInstance;
    HttpListener hl = null;

    public AdminHttpListenerViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        try {
            ServerInstanceManager serverInstanceManager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager();
            this.adminInstance = serverInstanceManager.getAdminInstance();
            this.hl = (HttpListener)this.getServerComponent();
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
        this.registerChild(listenerId, StaticTextField.class);
        this.registerChild(CHILD_VIRTUAL, ComboBox.class);
        this.registerChild(CHILD_SSLCONTAINERVIEW, SSLContainerView.class);
    }

    protected String getDefaultURL() {
        return "AdminHttpListener.jsp";
    }

    protected View createChild(String string) {
        if (string.equals(listenerId)) {
            return new StaticTextField((ContainerView)this, string, (Object)"");
        }
        if (string.equals(CHILD_VIRTUAL)) {
            return new ComboBox((ContainerView)this, string, (Object)"");
        }
        if (string.equals(CHILD_SSLCONTAINERVIEW)) {
            return new SSLContainerView((View)this, CHILD_SSLCONTAINERVIEW);
        }
        return super.createChild(string);
    }

    private SSLContainerView getSSLContainerView() {
        return (SSLContainerView)this.getChild(CHILD_SSLCONTAINERVIEW);
    }

    private void setCipherAttributes() throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        HttpListener httpListener = (HttpListener)this.getServerComponent();
        if (httpListener.isSSLCreated()) {
            String string = (String)httpListener.getAttribute("ssl2Ciphers");
            sSLContainerView.setCipherFields(string);
            String string2 = (String)httpListener.getAttribute("ssl3Ciphers");
            sSLContainerView.setCipherFields(string2);
        }
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        try {
            super.beginDisplay(displayEvent);
            this.populateVirtualServers();
            Object var2_2 = null;
            if (this.hl != null) {
                this.setDisplayFieldValue(listenerId, this.hl.getDisplayName());
            }
            String[] stringArray = this.adminInstance.getCertNickNames();
            SSLContainerView sSLContainerView = this.getSSLContainerView();
            sSLContainerView.populateCertificateNickNames(stringArray);
            if (this.hl.isSSLCreated()) {
                for (int i = 0; i < SSLName.length; ++i) {
                    Object object;
                    if (this.SSLType[i] == 3) {
                        object = (Boolean)this.hl.getAttribute(SSLConfigName[i]);
                        if (object == null) {
                            object = (Boolean)this.hl.getDefaultAttributeValue(SSLConfigName[i]);
                        }
                        sSLContainerView.setBooleanValue(SSLName[i], (Boolean)object);
                        continue;
                    }
                    object = this.hl.getAttribute(SSLConfigName[i]);
                    sSLContainerView.setObjectValue(SSLName[i], object);
                }
                this.setCipherAttributes();
            } else {
                this.setDefaultSSLValues();
            }
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
    }

    private void setDefaultSSLValues() throws Exception {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        for (int i = 0; i < SSLName.length; ++i) {
            Object object;
            if (this.SSLType[i] == 3) {
                object = (Boolean)this.hl.getDefaultAttributeValue(SSLConfigName[i]);
                if (object == null) {
                    object = new Boolean(false);
                }
                sSLContainerView.setBooleanValue(SSLName[i], (Boolean)object);
                continue;
            }
            object = this.hl.getAttribute(SSLConfigName[i]);
            sSLContainerView.setObjectValue(SSLName[i], object);
        }
        sSLContainerView.resetCipherAttributes();
        sSLContainerView.setCipherValue("rsa_des_56_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_56_sha", true);
        sSLContainerView.setCipherValue("rsa_des_sha", true);
        sSLContainerView.setCipherValue("rsa_rc4_128_md5", true);
        sSLContainerView.setCipherValue("rsa_3des_sha", true);
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected short[] getTypes() {
        return type;
    }

    public void handleSaveRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        if (this.hl != null) {
            try {
                if (sSLContainerView.isCertificateSelected()) {
                    this.AddSSLAttributes();
                } else if (this.hl.isSSLCreated()) {
                    this.hl.deleteSSL();
                    sSLContainerView.resetCipherAttributes();
                }
                this.hl.setAttribute("defaultVirtualServer", (Object)((String)this.getDisplayFieldValue(CHILD_VIRTUAL)));
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
            }
        }
        super.handleSaveRequest(requestInvocationEvent);
    }

    private void AddSSLAttributes() throws Exception {
        String[] stringArray = new String[]{"rc4", "rc4export", "rc2", "rc2export", "idea", "des", "desede3"};
        String[] stringArray2 = new String[]{"rsa_rc4_128_md5", "rsa_3des_sha", "rsa_des_sha", "rsa_rc4_40_md5", "rsa_rc2_40_md5", "rsa_null_md5", "rsa_des_56_sha", "rsa_rc4_56_sha"};
        String[] stringArray3 = new String[]{"CertName", "SSL2Enable", "SSL3Enable", "TLSEnable", "TLSRollback", "ClientEnable"};
        SSLContainerView sSLContainerView = this.getSSLContainerView();
        String string = sSLContainerView.getSSLValue("CertName").toString();
        if (this.hl.isSSLCreated()) {
            this.hl.setAttribute("cert", (Object)string);
        } else {
            this.hl.createSSL(string);
        }
        for (int i = 1; i < stringArray3.length; ++i) {
            this.hl.setAttribute(SSLConfigName[i], sSLContainerView.getSSLValue(stringArray3[i]));
        }
        this.hl.setAttribute("ssl2Ciphers", (Object)sSLContainerView.getSelectedCiphers(stringArray));
        this.hl.setAttribute("ssl3Ciphers", (Object)sSLContainerView.getSelectedCiphers(stringArray2));
    }

    public ServerComponent getServerComponent() throws Exception {
        HttpServiceComponentBean httpServiceComponentBean = this.adminInstance.getHttpService();
        ServerModelIterator serverModelIterator = httpServiceComponentBean.getHttpListeners();
        HttpListener httpListener = null;
        if (serverModelIterator != null) {
            httpListener = (HttpListener)serverModelIterator.next();
        }
        return httpListener;
    }

    protected String getPageName() {
        return PAGE_NAME;
    }

    private void populateVirtualServers() {
        String[] stringArray;
        ComboBox comboBox = (ComboBox)this.getChild("VirtualServer");
        ArrayList arrayList = this.getVSList();
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(new String[0]);
            OptionList optionList = new OptionList(stringArray, stringArray);
            comboBox.setOptions(optionList);
        }
        stringArray = "";
        try {
            stringArray = this.hl.getAttribute("defaultVirtualServer");
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
        this.setDisplayFieldValue(CHILD_VIRTUAL, stringArray);
    }

    private ArrayList getVSList() {
        VirtualServerClass virtualServerClass;
        ServerModelIterator serverModelIterator = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.adminInstance != null) {
                virtualServerClass = this.adminInstance.getHttpService().getVirtualServerClass("defaultclass");
                serverModelIterator = virtualServerClass.getVirtualServers();
            }
        }
        catch (AFException aFException) {
            serverModelIterator = null;
            this.setErrorMessage(aFException.getMessage());
            return arrayList;
        }
        if (serverModelIterator != null) {
            while (serverModelIterator.hasNext()) {
                virtualServerClass = (VirtualServer)serverModelIterator.next();
                arrayList.add(virtualServerClass.getDisplayName());
            }
        }
        return arrayList;
    }
}

