/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.logging.Level;

public class LoggerJDK14
extends java.util.logging.Logger
implements Logger {
    protected String sourceClassName;
    protected String sourceMethodName;

    public LoggerJDK14(String string, String string2) {
        super(string, string2);
    }

    public boolean isLoggable() {
        return this.isLoggable(Level.FINE);
    }

    public void fine(String string, Object[] objectArray) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, string, objectArray);
        }
    }

    public void fine(String string, Object object) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, string, object);
        }
    }

    public void fine(String string, Object object, Object object2) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2});
        }
    }

    public void fine(String string, Object object, Object object2, Object object3) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2, object3});
        }
    }

    public void finer(String string, Object[] objectArray) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, string, objectArray);
        }
    }

    public void finer(String string, Object object) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, string, object);
        }
    }

    public void finer(String string, Object object, Object object2) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2});
        }
    }

    public void finer(String string, Object object, Object object2, Object object3) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2, object3});
        }
    }

    public void finest(String string, Object[] objectArray) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, string, objectArray);
        }
    }

    public void finest(String string, Object object) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, string, object);
        }
    }

    public void finest(String string, Object object, Object object2) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2});
        }
    }

    public void finest(String string, Object object, Object object2, Object object3) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2, object3});
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LoggerJDK14: ");
        stringBuffer.append(" name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(", super: ");
        stringBuffer.append(super.toString());
        stringBuffer.append(", logging level: ");
        stringBuffer.append(this.getLevel());
        return stringBuffer.toString();
    }

    public void log(int n, String string, Object object) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string, object);
        }
    }

    public void log(int n, String string, Object object, Object object2) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2});
        }
    }

    public void log(int n, String string, Object object, Object object2, Object object3) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string, new Object[]{object, object2, object3});
        }
    }

    public void log(int n, String string, Object[] objectArray) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string, objectArray);
        }
    }

    public void log(int n, String string) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string);
        }
    }

    public void log(int n, String string, Throwable throwable) {
        Level level = this.convertLevel(n);
        if (this.isLoggable(level)) {
            this.inferCaller();
            this.logp(level, this.sourceClassName, this.sourceMethodName, string, throwable);
        }
    }

    public boolean isLoggable(int n) {
        return this.isLoggable(this.convertLevel(n));
    }

    protected Level convertLevel(int n) {
        int n2 = n / 100;
        switch (n2) {
            case 3: {
                return Level.FINEST;
            }
            case 4: {
                return Level.FINER;
            }
            case 5: {
                return Level.FINE;
            }
            case 7: {
                return Level.CONFIG;
            }
            case 8: {
                return Level.INFO;
            }
            case 9: {
                return Level.WARNING;
            }
            case 10: {
                return Level.SEVERE;
            }
        }
        return Level.CONFIG;
    }

    protected void inferCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            if (this.isLoggerClass(string)) continue;
            this.sourceClassName = string;
            this.sourceMethodName = stackTraceElement.getMethodName();
            return;
        }
    }

    protected boolean isLoggerClass(String string) {
        return "com.sun.jdo.spi.persistence.utility.logging.LoggerJDK14".equals(string);
    }
}

