/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.AbstractLoggerFactory;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.logging.LoggerJDK14;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;

public class LoggerFactoryJDK14
extends AbstractLoggerFactory {
    private static final ResourceBundle _messages = I18NHelper.loadBundle(LoggerFactoryJDK14.class);

    protected static ResourceBundle getMessages() {
        return _messages;
    }

    protected LoggerJDK14 findLogger(String string) {
        return (LoggerJDK14)LogManager.getLogManager().getLogger(string);
    }

    protected Logger createLogger(final String string, final String string2, final ClassLoader classLoader) {
        return (Logger)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                LoggerJDK14 loggerJDK14 = null;
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    LoggerFactoryJDK14.this.setContextClassLoader(classLoader);
                }
                try {
                    loggerJDK14 = LoggerFactoryJDK14.this.createLogger(string, string2);
                    LogManager.getLogManager().addLogger(loggerJDK14);
                    LoggerFactoryJDK14.this.configureFileHandler(loggerJDK14);
                    LoggerJDK14 loggerJDK142 = loggerJDK14;
                    return loggerJDK142;
                }
                catch (Exception exception) {
                    MessageFormat messageFormat = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.create.exception"));
                    AbstractLoggerFactory.getErrorLogger().log(1000, messageFormat.format(new String[]{string}), exception);
                }
                finally {
                    LoggerFactoryJDK14.this.setContextClassLoader(classLoader2);
                }
                return loggerJDK14;
            }
        });
    }

    protected void setContextClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected LoggerJDK14 createLogger(String string, String string2) {
        LoggerJDK14 loggerJDK14 = new LoggerJDK14(string, string2);
        return loggerJDK14;
    }

    protected void configureFileHandler(LoggerJDK14 loggerJDK14) {
        String string = loggerJDK14.getName();
        String string2 = string + ".FileHandler";
        LogManager logManager = LogManager.getLogManager();
        String string3 = logManager.getProperty(string2 + ".pattern");
        if (string3 != null) {
            Object object;
            int n = 0;
            String string4 = logManager.getProperty(string2 + ".limit");
            if (string4 != null) {
                try {
                    n = Integer.parseInt(string4);
                    if (n < 0) {
                        n = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n2 = 1;
            String string5 = logManager.getProperty(string2 + ".count");
            if (string5 != null) {
                try {
                    n2 = Integer.parseInt(string5);
                    if (n2 < 1) {
                        n2 = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            String string6 = logManager.getProperty(string2 + ".append");
            if (string6 != null) {
                bl = Boolean.valueOf(string6);
            }
            FileHandler fileHandler = null;
            try {
                fileHandler = new FileHandler(string3, n, n2, bl);
            }
            catch (Exception exception) {
                object = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.filehandler.initialize.exception"));
                LoggerFactoryJDK14.getErrorLogger().log(900, ((Format)object).format(new String[]{string}), exception);
            }
            if (fileHandler != null) {
                String string7 = logManager.getProperty(string2 + ".level");
                if (string7 != null) {
                    try {
                        fileHandler.setLevel(Level.parse(string7));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                object = null;
                String string8 = logManager.getProperty(string2 + ".formatter");
                if (string8 != null) {
                    try {
                        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string8);
                        object = (Formatter)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        MessageFormat messageFormat = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.formatter.initialize.exception"));
                        LoggerFactoryJDK14.getErrorLogger().log(900, messageFormat.format(new String[]{string}), exception);
                    }
                }
                if (object == null) {
                    object = new SimpleFormatter();
                }
                try {
                    fileHandler.setFormatter((Formatter)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                loggerJDK14.addHandler(fileHandler);
            }
        }
    }
}

