/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator;

import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;

public class JavaClassWriterHelper
extends JavaTypeHelper {
    public static final String javaExtension_ = ".java";
    public static final String void_ = "void";
    public static final String boolean_ = "boolean";
    public static final String byteArray_ = "byte[]";
    public static final String param_ = "param";
    public static final String param0_ = "param0";
    public static final String null_ = "null";
    public static final String home_ = "home";
    public static final String delim_ = ";";
    public static final String paramInitializer_ = "\"\" + ";
    public static final String paramSeparator_ = ", ";
    public static final String paramList_ = ",";
    public static final String paramConcatenator_ = " + \", \" + ";
    public static final String space_ = " ";
    public static final String none_ = "";
    public static final String noneLiteral_ = "\"\"";
    public static final String dot_ = ".";
    public static final String parenleft_ = "(";
    public static final String parenright_ = ")";
    public static final String parenthesis_ = "()";
    public static final String new_ = "new";
    public static final String endLine_ = "\n";
    public static final String true_ = "true";
    public static final String false_ = "false";
    public static final String[] super_ = new String[]{"super();"};
    public static final String Collection_ = "java.util.Collection";
    public static final String Set_ = "java.util.Set";
    public static final String PersistenceCapable_ = "PersistenceCapable";
    public static final String brackets_ = "[]";
    public static final String[] identation_ = new String[]{"    ", "        ", "            ", "                "};
    public static final String get_ = "get";
    public static final String set_ = "set";
    public static final String Oid_ = ".Oid";
    public static final String Helper_ = "_JDOHelper";
    public static final String Object_ = "Object";
    public static final String returnNull_ = "return null;";
    public static final String fileName_ = "fileName";
    public static final String int_ = "int";
    public static final String string_ = "String";
    public static final String class_ = "Class";

    public static String[] getBodyAsStrings(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, endLine_);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.lastIndexOf(9);
            stringArray[n] = n2 > -1 ? identation_[n2] + string2.substring(n2 + 1) : string2;
            ++n;
        }
        return stringArray;
    }

    public static Class getWrapperType(Class clazz) {
        Class clazz2 = JavaClassWriterHelper.getWrapperClass(clazz);
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    public static String getWrapperExpr(Class clazz, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new_);
        stringBuffer.append(space_);
        stringBuffer.append(JavaClassWriterHelper.getWrapperType(clazz).getName());
        stringBuffer.append(parenleft_);
        stringBuffer.append(string);
        stringBuffer.append(parenright_);
        return stringBuffer.toString();
    }

    public static String getUnwrapMethodName(Class clazz) {
        return clazz.getName() + "Value()";
    }

    public static String getPrimitiveType(Class clazz) {
        String string = JavaClassWriterHelper.getPrimitiveName(clazz);
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    public static String[] getExceptionNames(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static String getParameterTypesList(Method method) {
        if (method == null) {
            return none_;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(paramList_);
            }
            stringBuffer.append(JavaClassWriterHelper.getTypeRepr(classArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String getParametersList(Method method) {
        return JavaClassWriterHelper.getParametersListWithSeparator(method, paramSeparator_, null);
    }

    public static String getParametersListWithSeparator(Method method, String string) {
        return JavaClassWriterHelper.getParametersListWithSeparator(method, string, paramInitializer_);
    }

    public static String getParametersListWithSeparator(Method method, String string, String string2) {
        int n = method.getParameterTypes().length;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && n > 0) {
            stringBuffer.append(string2);
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(param_ + i);
        }
        return stringBuffer.toString();
    }

    public static void addFields(String string, int n, JavaClassWriter javaClassWriter) throws IOException {
        String[] stringArray = JavaClassWriterHelper.getBodyAsStrings(string);
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], space_);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken() + space_);
            }
            int n2 = stringBuffer.length();
            stringBuffer.deleteCharAt(n2 - 1);
            javaClassWriter.addField(string3, n, string2, stringBuffer.toString(), null);
        }
    }

    public static void addPrivateField(String string, int n, JavaClassWriter javaClassWriter) throws IOException {
        JavaClassWriterHelper.addFields(string, 2 + n, javaClassWriter);
    }

    public static void addGenericMethod(Method method, String string, String string2, String string3, JavaClassWriter javaClassWriter) throws IOException {
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = JavaClassWriterHelper.getTypeRepr(classArray[i]);
            stringArray2[i] = param_ + i;
        }
        String[] stringArray3 = JavaClassWriterHelper.getExceptionNames(method);
        int n2 = method.getModifiers();
        if (Modifier.isAbstract(n2)) {
            n2 -= 1024;
        }
        javaClassWriter.addMethod(string, n2, string2, stringArray2, stringArray, stringArray3, JavaClassWriterHelper.getBodyAsStrings(string3), null);
    }

    public static String getTypeRepr(Class clazz) {
        return clazz.isArray() ? JavaClassWriterHelper.getTypeRepr(clazz.getComponentType()) + brackets_ : clazz.getName();
    }
}

