/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class WeakHashSet
extends HashSet {
    ReferenceQueue queue = new ReferenceQueue();

    public Iterator iterator() {
        this.processQueue();
        final Iterator iterator = super.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return WeakHashSet.this.getReferenceObject((WeakReference)iterator.next());
            }

            public void remove() {
                iterator.remove();
            }
        };
    }

    public boolean contains(Object object) {
        return super.contains(WeakElement.create(object));
    }

    public boolean add(Object object) {
        this.processQueue();
        return super.add(WeakElement.create(object, this.queue));
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(WeakElement.create(object));
        this.processQueue();
        return bl;
    }

    private final Object getReferenceObject(WeakReference weakReference) {
        return weakReference != null ? weakReference.get() : null;
    }

    private final void processQueue() {
        WeakElement weakElement = null;
        while ((weakElement = (WeakElement)this.queue.poll()) != null) {
            super.remove(weakElement);
        }
    }

    private static class WeakElement
    extends WeakReference {
        private int hash;

        private WeakElement(Object object) {
            super(object);
            this.hash = object.hashCode();
        }

        private WeakElement(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = object.hashCode();
        }

        private static WeakElement create(Object object) {
            return object == null ? null : new WeakElement(object);
        }

        private static WeakElement create(Object object, ReferenceQueue referenceQueue) {
            return object == null ? null : new WeakElement(object, referenceQueue);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            Object t2 = ((WeakElement)object).get();
            if (t == null || t2 == null) {
                return false;
            }
            if (t == t2) {
                return true;
            }
            return t.equals(t2);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

