/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18NHelper {
    private static final String bundleSuffix = ".Bundle";
    private static Hashtable bundles = new Hashtable();
    private static Locale locale = Locale.getDefault();

    public static ResourceBundle loadBundle(String string) {
        return I18NHelper.loadBundle(string, I18NHelper.class.getClassLoader());
    }

    public static ResourceBundle loadBundle(String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    public static ResourceBundle loadBundle(Class clazz) {
        return I18NHelper.loadBundle(JavaTypeHelper.getPackageName(clazz.getName()) + bundleSuffix, clazz.getClassLoader());
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = "";
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        return messageFormat.format(objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string2, string3, string4};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    public static final String getMessage(ResourceBundle resourceBundle, String string, boolean bl) {
        Object[] objectArray = new Object[]{String.valueOf(bl)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }
}

