/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BucketizedHashtable
implements Cloneable,
Map,
Serializable {
    private int bucketSize;
    private Hashtable[] hashtables = null;

    public BucketizedHashtable(int n, int n2, float f) {
        if (n <= 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.bucketSize = n;
        this.hashtables = new Hashtable[n];
        int n3 = (int)Math.ceil((double)n2 / (double)n);
        for (int i = 0; i < n; ++i) {
            this.hashtables[i] = new Hashtable(n3, f);
        }
    }

    public BucketizedHashtable(int n, int n2) {
        this(n, n2, 0.75f);
    }

    public BucketizedHashtable(int n) {
        this(n, 11 * n, 0.75f);
    }

    public BucketizedHashtable() {
        this(11, 121, 0.75f);
    }

    public Object get(Object object) {
        return this.hashtables[this.getBucketIndex(object)].get(object);
    }

    public Object remove(Object object) {
        return this.hashtables[this.getBucketIndex(object)].remove(object);
    }

    public Object put(Object object, Object object2) {
        return this.hashtables[this.getBucketIndex(object)].put(object, object2);
    }

    public void putAll(Map map) {
        if (map instanceof BucketizedHashtable) {
            BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)map;
            for (int i = 0; i < bucketizedHashtable.bucketSize; ++i) {
                this.putAllFromMapWithEntrySet(bucketizedHashtable.hashtables[i]);
            }
        } else {
            this.putAllFromMapWithEntrySet(map);
        }
    }

    public boolean containsKey(Object object) {
        return this.hashtables[this.getBucketIndex(object)].containsKey(object);
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.bucketSize; ++i) {
            if (!this.hashtables[i].containsValue(object)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.bucketSize; ++i) {
            n += this.hashtables[i].size();
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.bucketSize; ++i) {
            n += this.hashtables[i].hashCode();
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.bucketSize; ++i) {
            if (this.hashtables[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.bucketSize; ++i) {
            this.hashtables[i].clear();
        }
    }

    public Set entrySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].entrySet();
        }
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].keySet();
        }
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].values();
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BucketizedHashtable)) {
            return false;
        }
        BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)object;
        if (bucketizedHashtable.bucketSize != this.bucketSize || bucketizedHashtable.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.bucketSize; ++i) {
            if (this.hashtables[i].equals(bucketizedHashtable.hashtables[i])) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)super.clone();
            bucketizedHashtable.bucketSize = this.bucketSize;
            bucketizedHashtable.hashtables = new Hashtable[this.bucketSize];
            for (int i = 0; i < this.bucketSize; ++i) {
                bucketizedHashtable.hashtables[i] = (Hashtable)this.hashtables[i].clone();
            }
            return bucketizedHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.hashtables[0].toString());
        for (int i = 1; i < this.bucketSize; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(this.hashtables[i].toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void putAllFromMapWithEntrySet(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private int getBucketIndex(Object object) {
        return object.hashCode() % this.bucketSize;
    }
}

