/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalDataStoreException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;

public class SelectStatement
extends Statement {
    public static int PROP_JOINED = 1;
    public static int PROP_IS_SUPERTABLE = 2;
    public SelectQueryPlan plan;
    private StringBuffer orderClause;
    public StringBuffer columnText;

    public SelectStatement(DBVendorType dBVendorType, QueryPlan queryPlan) {
        super(dBVendorType, queryPlan);
        this.plan = (SelectQueryPlan)queryPlan;
        this.properties = 0;
    }

    public boolean isJoined() {
        return (this.properties & PROP_JOINED) > 0;
    }

    public boolean isSupertable() {
        return (this.properties & PROP_IS_SUPERTABLE) > 0;
    }

    public ColumnRef addColumn(ColumnElement columnElement, QueryTable queryTable) {
        ColumnRef columnRef = null;
        columnRef = this.getColumnRef(columnElement);
        if (columnRef == null) {
            columnRef = new ColumnRef(columnElement, queryTable);
            this.addColumnRef(columnRef);
        }
        return columnRef;
    }

    public void addColumn(LocalFieldDesc localFieldDesc) {
        QueryTable queryTable = null;
        ColumnElement columnElement = null;
        for (int i = 0; i < localFieldDesc.columnDescs.size() && (queryTable = this.plan.findQueryTable((columnElement = (ColumnElement)localFieldDesc.columnDescs.get(i)).getDeclaringTable())) == null; ++i) {
        }
        if (queryTable == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.fieldnotable", localFieldDesc.getName()));
        }
        this.addColumnRef(new ColumnRef(columnElement, queryTable));
    }

    public void copyColumns(SelectStatement selectStatement) {
        ArrayList arrayList = selectStatement.getColumnRefs();
        int n = this.columns.size() + 1;
        for (int i = 0; i < arrayList.size(); ++i) {
            ColumnRef columnRef = (ColumnRef)arrayList.get(i);
            columnRef.setIndex(n + i);
            this.columns.add(columnRef);
        }
    }

    public void getTableText(QueryTable queryTable, StringBuffer stringBuffer) {
        super.getTableText(queryTable, stringBuffer);
        if (queryTable.getTableDesc().isUpdateLockRequired()) {
            stringBuffer.append(this.vendorType.getHoldlock());
        }
    }

    public void getJoinTableText(QueryTable queryTable, StringBuffer stringBuffer) {
        int n = this.operationFormat(queryTable.joinOp);
        if ((n & 1) > 0) {
            stringBuffer.append(this.prefixOperator(queryTable.joinOp));
        }
        if (queryTable.prevTable == null) {
            this.getTableText(queryTable, stringBuffer);
        }
        for (int i = 0; i < queryTable.nextTable.size(); ++i) {
            QueryTable queryTable2 = (QueryTable)queryTable.nextTable.get(i);
            stringBuffer.append(this.infixOperator(queryTable.joinOp, 1));
            this.getTableText(queryTable2, stringBuffer);
            if (queryTable2.onClause != null) {
                stringBuffer.append(" on ");
                stringBuffer.append(queryTable2.onClause);
            }
            if (queryTable2.nextTable != null) {
                this.getJoinTableText(queryTable2, stringBuffer);
            }
            if ((n & 4) <= 0) continue;
            stringBuffer.append(this.postfixOperator(queryTable.joinOp));
        }
    }

    public String getTableListText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tableList.size(); ++i) {
            QueryTable queryTable = (QueryTable)this.tableList.get(i);
            if (queryTable.prevTable == null && queryTable.nextTable == null) {
                this.getTableText(queryTable, stringBuffer);
                stringBuffer.append(", ");
                continue;
            }
            if (queryTable.prevTable != null) continue;
            stringBuffer.append(this.vendorType.getTableListStart());
            this.getJoinTableText(queryTable, stringBuffer);
            stringBuffer.append(this.vendorType.getTableListEnd());
            stringBuffer.append(", ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        return stringBuffer.toString();
    }

    public String getText() {
        String string;
        Object object;
        int n;
        StringBuffer stringBuffer;
        if (this.statementText != null) {
            return this.statementText.toString();
        }
        String string2 = "";
        String string3 = "";
        if (!this.vendorType.getQuoteSpecialOnly()) {
            string2 = this.vendorType.getQuoteCharStart();
            string3 = this.vendorType.getQuoteCharEnd();
        }
        this.statementText = stringBuffer = new StringBuffer();
        if (this.columns.size() < 1) {
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.columnText = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer().append(this.processConstraints());
        for (n = 0; n < this.columns.size(); ++n) {
            object = (ColumnRef)this.columns.get(n);
            this.columnText.append("t").append(((ColumnRef)object).getQueryTable().getTableIndex()).append(".").append(string2).append(((ColumnRef)object).getName()).append(string3).append(", ");
        }
        this.columnText.delete(this.columnText.length() - 2, this.columnText.length());
        n = this.isUpdateLockRequired() ? 1 : 0;
        if (n != 0 && !this.vendorType.isUpdateLockSupported()) {
            throw new JDOFatalDataStoreException(I18NHelper.getMessage(messages, "sqlstore.selectstatement.noupdatelocksupport"));
        }
        object = new StringBuffer();
        if (n != 0) {
            boolean bl;
            this.plan.options |= 0x80;
            string = this.vendorType.getForUpdate().trim();
            boolean bl2 = bl = string.length() != 0;
            if (bl) {
                ((StringBuffer)object).append(" ").append(string).append(" ");
                for (int i = 0; i < this.tableList.size(); ++i) {
                    QueryTable queryTable = (QueryTable)this.tableList.get(i);
                    TableDesc tableDesc = queryTable.getTableDesc();
                    if (!tableDesc.isUpdateLockRequired()) continue;
                    ColumnElement columnElement = (ColumnElement)tableDesc.getKey().getColumns().get(0);
                    ((StringBuffer)object).append("t").append(i).append(".").append(string2).append(columnElement.getName().getName()).append(string3).append(", ");
                }
                ((StringBuffer)object).delete(((StringBuffer)object).length() - 2, ((StringBuffer)object).length());
            }
        }
        string = "";
        if ((this.plan.options & 0x40) > 0 && (n == 0 || this.vendorType.isDistinctSupportedWithUpdateLock())) {
            string = "distinct ";
        }
        stringBuffer.append("select ").append(string).append(this.columnText).append(" from ").append(this.getTableListText()).append(stringBuffer3).append(this.orderClause).append((StringBuffer)object);
        return stringBuffer.toString();
    }

    private boolean isUpdateLockRequired() {
        boolean bl = false;
        for (int i = 0; i < this.tableList.size() && !bl; ++i) {
            QueryTable queryTable = (QueryTable)this.tableList.get(i);
            TableDesc tableDesc = queryTable.getTableDesc();
            bl = tableDesc.isUpdateLockRequired();
        }
        return bl;
    }

    public String processConstraints() {
        int n;
        this.orderClause = new StringBuffer();
        StringBuffer stringBuffer = null;
        if (this.plan.parentField != null && !this.plan.correlated && !this.plan.parentConstraintsAdded) {
            boolean bl = this.plan.parentField.useJoinTable();
            for (n = 0; n < this.plan.parentField.localFields.size(); ++n) {
                this.constraint.addForeignField((LocalFieldDesc)this.plan.parentField.localFields.get(n));
                if (!bl) {
                    this.constraint.addField((LocalFieldDesc)this.plan.parentField.foreignFields.get(n));
                } else {
                    this.constraint.addField((LocalFieldDesc)this.plan.parentField.assocLocalFields.get(n));
                }
                this.constraint.addOperation(9);
            }
            this.plan.parentConstraintsAdded = true;
        }
        ArrayList arrayList = (ArrayList)this.constraint.stack.clone();
        while (arrayList.size() > 0) {
            StringBuffer stringBuffer2;
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(arrayList.size() - 1);
            n = 0;
            if (!(constraintNode instanceof ConstraintOperation)) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintOperation"));
            }
            n = ((ConstraintOperation)constraintNode).operation;
            int n2 = this.operationFormat(n);
            if ((n2 & 0x20) > 0) {
                stringBuffer2 = stringBuffer;
                stringBuffer = new StringBuffer().append(this.getWhereText(arrayList));
                if (stringBuffer2 == null || stringBuffer2.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer2.append(" and ");
                }
                stringBuffer2.append(stringBuffer);
                stringBuffer = stringBuffer2;
                continue;
            }
            if (this.action != 4) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalaction", "" + this.action));
            }
            if ((n2 & 0x10) > 0) {
                arrayList.remove(arrayList.size() - 1);
                constraintNode = (ConstraintNode)arrayList.get(arrayList.size() - 1);
                if (!(constraintNode instanceof ConstraintField)) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
                }
                stringBuffer2 = null;
                ConstraintFieldDesc constraintFieldDesc = (ConstraintFieldDesc)constraintNode;
                QueryTable queryTable = null;
                int n3 = -1;
                for (int i = 0; i < constraintFieldDesc.desc.columnDescs.size(); ++i) {
                    QueryPlan queryPlan = null;
                    queryPlan = constraintFieldDesc.originalPlan != null ? constraintFieldDesc.originalPlan : this.plan;
                    queryTable = queryPlan.findQueryTable(((ColumnElement)constraintFieldDesc.desc.columnDescs.get(i)).getDeclaringTable());
                    if (queryTable == null) continue;
                    n3 = i;
                    break;
                }
                if (n3 == -1) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.fieldnotable", constraintFieldDesc.desc.getName()));
                }
                if (this.orderClause.length() > 0) {
                    stringBuffer2 = this.orderClause;
                    this.orderClause = new StringBuffer();
                }
                StringBuffer stringBuffer3 = new StringBuffer().append(((ColumnElement)constraintFieldDesc.desc.columnDescs.get(n3)).getName().getName());
                this.orderClause.append("t").append(queryTable.getTableIndex()).append(".").append(this.quoteCharStart).append(stringBuffer3).append(this.quoteCharEnd);
                if (n == 31) {
                    this.orderClause.append(" desc");
                }
                if (stringBuffer2 != null) {
                    this.orderClause.append(", ");
                    this.orderClause.append(stringBuffer2);
                }
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.remove(arrayList.size() - 1);
            while (arrayList.size() > 0 && arrayList.get(arrayList.size() - 1) instanceof ConstraintOperation) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        if (stringBuffer != null && stringBuffer.length() > 0) {
            stringBuffer4.append(" where ");
            stringBuffer4.append(stringBuffer);
        }
        if (this.orderClause.length() > 0) {
            StringBuffer stringBuffer5 = this.orderClause;
            this.orderClause = new StringBuffer();
            this.orderClause.append(" order by ").append(stringBuffer5);
        }
        return stringBuffer4.toString();
    }
}

