/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldNameSubQuery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintForeignFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintSubquery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;

public class SelectQueryPlan
extends QueryPlan {
    public static final int ST_COLLECTIVE = 8;
    public static final int ST_JOINED = 4;
    public static final int ST_FC_BUILT = 32;
    public static final int ST_ACTIVE = 64;
    public Constraint constraint;
    public ArrayList foreignPlans;
    private int maxRows;
    public ArrayList orderBy = null;
    public ForeignFieldDesc parentField;
    public SqlIDDesc resultIDDesc;
    private RetrieveDescImpl retrieveDesc;
    private Concurrency concurrency;
    private BitSet hierarchicalGroupMask;
    private BitSet independentGroupMask;
    private BitSet fieldMask = new BitSet();
    private int fetchDepth;
    private int maxFetchDepth;
    private Hashtable foreignConstraintPlans;
    public boolean correlated;
    public boolean useDependentKey;
    public boolean useInstanceKey;
    public boolean parentConstraintsAdded = false;
    private boolean isSubQueryPlan;
    private boolean appendAndOp;
    private ResultDesc resultDesc;
    public static boolean excludeSubclasses;
    private boolean projection = false;
    private int projectionId = -1;
    private static Logger logger;

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency) {
        super(actionDesc, sQLStoreManager);
        this.hierarchicalGroupMask = new BitSet();
        this.independentGroupMask = new BitSet();
        this.concurrency = concurrency;
        this.action = 4;
        this.retrieveDesc = (RetrieveDescImpl)actionDesc;
        this.retrieveDesc.plan = this;
        this.constraint = this.retrieveDesc.constraint;
        this.options = this.retrieveDesc.options;
    }

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency, int n, int n2) {
        this(actionDesc, sQLStoreManager, concurrency, n, n2, false);
    }

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency, int n, int n2, boolean bl) {
        this(actionDesc, sQLStoreManager, concurrency);
        this.maxFetchDepth = n;
        this.fetchDepth = n2;
        this.projection = bl;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public ResultDesc getResultDesc() {
        return this.resultDesc;
    }

    public void setResultDesc(ResultDesc resultDesc) {
        this.resultDesc = resultDesc;
    }

    private void setFieldMask(int n) {
        if (n < 0) {
            n = this.config.fields.size() - n;
        }
        this.fieldMask.set(n);
    }

    private boolean getFieldMask(int n) {
        if (n < 0) {
            n = this.config.fields.size() - n;
        }
        return this.fieldMask.get(n);
    }

    private void addDefaultOrderConstraint() {
        SqlIDDesc sqlIDDesc = (SqlIDDesc)this.config.persistenceIDDesc;
        if (this.constraint == null) {
            this.constraint = new Constraint();
        }
        ArrayList arrayList = sqlIDDesc.getFields();
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldDesc fieldDesc = (FieldDesc)arrayList.get(i);
            this.constraint.addField((LocalFieldDesc)fieldDesc);
            this.constraint.addOperation(30);
            this.orderBy.add(new ConstraintFieldDesc((LocalFieldDesc)fieldDesc, 1));
        }
    }

    public void addColumn(LocalFieldDesc localFieldDesc, boolean bl) {
        this.addColumn(localFieldDesc, bl, false);
    }

    private void addColumn(LocalFieldDesc localFieldDesc, boolean bl, boolean bl2) {
        for (int i = 0; i < localFieldDesc.columnDescs.size(); ++i) {
            SelectStatement selectStatement;
            ColumnElement columnElement = (ColumnElement)localFieldDesc.columnDescs.get(i);
            QueryTable queryTable = this.findQueryTable(columnElement.getDeclaringTable());
            if (queryTable == null) {
                queryTable = this.addQueryTable(columnElement.getDeclaringTable(), null);
            }
            if ((selectStatement = (SelectStatement)this.getStatement(queryTable)) == null) {
                selectStatement = (SelectStatement)this.addStatement(queryTable);
            }
            if (!bl) continue;
            ColumnRef columnRef = selectStatement.addColumn(columnElement, queryTable);
            if (this.resultDesc == null) {
                this.resultDesc = this.newResultDesc();
            }
            this.resultDesc.addField(localFieldDesc, columnRef, bl2);
        }
    }

    private void processJoinTable(ClassDesc classDesc) {
        ColumnElement columnElement = (ColumnElement)this.parentField.assocLocalColumns.get(0);
        this.addQueryTable(columnElement.getDeclaringTable(), classDesc);
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = 10;
        constraintJoin.fromColumns = this.parentField.assocForeignColumns;
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = this.parentField.foreignColumns;
        constraintJoin.toPlan = this;
        this.constraint.stack.add(constraintJoin);
    }

    private void processForeignFields(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() == 0) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield", this.config.getPersistenceCapableClass().getName());
        }
        this.foreignPlans = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ConstraintFieldName constraintFieldName = (ConstraintFieldName)arrayList.get(i);
            SelectQueryPlan selectQueryPlan = new SelectQueryPlan(constraintFieldName.desc, this.store, this.concurrency, this.maxFetchDepth, this.fetchDepth + 1, constraintFieldName.isProjection());
            selectQueryPlan.parentField = (ForeignFieldDesc)this.config.getField(constraintFieldName.name);
            if (selectQueryPlan.parentField == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", constraintFieldName.name, this.config.getPersistenceCapableClass().getName()));
            }
            selectQueryPlan.build();
            if (selectQueryPlan.parentField.useJoinTable()) {
                selectQueryPlan.processJoinTable(this.config);
            }
            for (int j = 0; j < selectQueryPlan.parentField.localFields.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)selectQueryPlan.parentField.localFields.get(j);
                if (this.getFieldMask(fieldDesc.absoluteID)) continue;
                arrayList2.add(fieldDesc);
            }
            this.foreignPlans.add(selectQueryPlan);
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield.exit");
        }
    }

    private boolean getGroupMask(int n) {
        if (n >= 1) {
            return this.hierarchicalGroupMask.get(n);
        }
        if (n < 0) {
            return this.independentGroupMask.get(-(n + 1));
        }
        return true;
    }

    private void setGroupMask(int n) {
        if (n >= 1) {
            this.hierarchicalGroupMask.set(n);
        } else if (n < 0) {
            this.independentGroupMask.set(-(n + 1));
        }
    }

    private void addFetchGroup(int n, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList arrayList3 = this.config.getFetchGroup(n);
        this.setGroupMask(n);
        if (arrayList3 != null) {
            for (int i = arrayList3.size() - 1; i >= 0; --i) {
                FieldDesc fieldDesc = (FieldDesc)arrayList3.get(i);
                if (this.getFieldMask(fieldDesc.absoluteID)) continue;
                this.setFieldMask(fieldDesc.absoluteID);
                if (fieldDesc instanceof LocalFieldDesc) {
                    arrayList.add(0, fieldDesc);
                    continue;
                }
                if (this.fetchDepth >= this.maxFetchDepth) continue;
                ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
                RetrieveDesc retrieveDesc = this.store.getRetrieveDesc(foreignFieldDesc.foreignConfig.getPersistenceCapableClass());
                ConstraintFieldName constraintFieldName = new ConstraintFieldName(foreignFieldDesc.getName(), retrieveDesc);
                arrayList2.add(constraintFieldName);
            }
        }
    }

    private void addFetchGroups(int n, ArrayList arrayList, ArrayList arrayList2) {
        if (n >= 1) {
            for (int i = 1; i <= n; ++i) {
                if (this.getGroupMask(i)) continue;
                this.addFetchGroup(i, arrayList, arrayList2);
            }
        } else if (n < 0) {
            if (!this.getGroupMask(1)) {
                this.addFetchGroup(1, arrayList, arrayList2);
            }
            if (!this.getGroupMask(n)) {
                this.addFetchGroup(n, arrayList, arrayList2);
            }
        }
    }

    private void processFetchGroups(ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.size() + arrayList2.size();
        if (!this.getGroupMask(1)) {
            this.addFetchGroups(1, arrayList, arrayList2);
        }
        if (n > 0) {
            Object object;
            int n2;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (FieldDesc)arrayList.get(n2);
                this.setFieldMask(((FieldDesc)object).absoluteID);
                if (((FieldDesc)object).fetchGroup == 0 || this.getGroupMask(((FieldDesc)object).fetchGroup)) continue;
                this.addFetchGroups(((FieldDesc)object).fetchGroup, arrayList, arrayList2);
            }
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                object = (ConstraintFieldName)arrayList2.get(n2);
                FieldDesc fieldDesc = this.config.getField(((ConstraintFieldName)object).name);
                this.setFieldMask(fieldDesc.absoluteID);
                if (fieldDesc.fetchGroup == 0 || this.getGroupMask(fieldDesc.fetchGroup)) continue;
                this.addFetchGroups(fieldDesc.fetchGroup, arrayList, arrayList2);
            }
        }
    }

    private void processLocalFields(ArrayList arrayList) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield", this.config.getPersistenceCapableClass().getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)arrayList.get(i);
            boolean bl2 = this.projectionId != -1 && this.projectionId == i;
            this.addColumn(localFieldDesc, true, bl2);
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield.exit");
        }
    }

    private void addJoinConstraint(ReferenceKeyDesc referenceKeyDesc, int n) {
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = n;
        constraintJoin.fromColumns = referenceKeyDesc.getReferencedKey().getColumns();
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = referenceKeyDesc.getReferencingKey().getColumns();
        constraintJoin.toPlan = this;
        this.constraint.stack.add(constraintJoin);
    }

    private void joinSubtableStatement(SelectStatement selectStatement, SelectStatement selectStatement2) {
        selectStatement.copyColumns(selectStatement2);
        QueryTable queryTable = (QueryTable)selectStatement2.getQueryTables().get(0);
        ReferenceKeyDesc referenceKeyDesc = queryTable.getTableDesc().getSupertableKey();
        int n = 16;
        if (selectStatement.isSupertable()) {
            n = 10;
        }
        this.addJoinConstraint(referenceKeyDesc, n);
        selectStatement2.setProperty(SelectStatement.PROP_JOINED);
    }

    private void joinSecondaryTableStatement(SelectStatement selectStatement, SelectStatement selectStatement2) {
        selectStatement.copyColumns(selectStatement2);
        QueryTable queryTable = (QueryTable)selectStatement2.getQueryTables().get(0);
        ReferenceKeyDesc referenceKeyDesc = queryTable.getTableDesc().getPrimaryTableKey();
        this.addJoinConstraint(referenceKeyDesc, 16);
        selectStatement2.setProperty(SelectStatement.PROP_JOINED);
    }

    private void processRelatedStatements(SelectStatement selectStatement) {
        ArrayList arrayList;
        ArrayList arrayList2 = selectStatement.getSubtableStatements();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                SelectStatement selectStatement2 = (SelectStatement)arrayList2.get(i);
                if (selectStatement2.isJoined()) continue;
                this.processRelatedStatements(selectStatement2);
                this.joinSubtableStatement(selectStatement, selectStatement2);
            }
            arrayList2.clear();
        }
        if ((arrayList = selectStatement.getSecondaryTableStatements()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SelectStatement selectStatement3 = (SelectStatement)arrayList.get(i);
                if (selectStatement3.isJoined()) continue;
                this.processRelatedStatements(selectStatement3);
                this.joinSecondaryTableStatement(selectStatement, selectStatement3);
            }
            arrayList.clear();
        }
    }

    protected void processStatements() {
        int n;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this.config.getPersistenceCapableClass().getName(), new Integer(this.statements.size())};
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts", objectArray);
        }
        if (this.concurrency != null) {
            this.concurrency.select(this);
        }
        if ((n = this.statements.size()) > 1) {
            SelectStatement selectStatement;
            int n2;
            super.processStatements();
            for (n2 = 0; n2 < n; ++n2) {
                selectStatement = (SelectStatement)this.statements.get(n2);
                if (selectStatement.isJoined()) continue;
                this.processRelatedStatements(selectStatement);
            }
            for (n2 = 0; n2 < this.statements.size(); ++n2) {
                selectStatement = (SelectStatement)this.statements.get(n2);
                if (!selectStatement.isJoined()) continue;
                this.statements.remove(n2);
                --n2;
            }
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts.exit");
        }
    }

    private void processLocalConstraints() {
        for (int i = 0; i < this.constraint.stack.size(); ++i) {
            Object object;
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(i);
            if (!(constraintNode instanceof ConstraintFieldName)) continue;
            ConstraintFieldName constraintFieldName = (ConstraintFieldName)constraintNode;
            SelectQueryPlan selectQueryPlan = null;
            if (constraintFieldName.desc == null) {
                selectQueryPlan = this;
            } else {
                object = (RetrieveDescImpl)constraintFieldName.desc;
                selectQueryPlan = this.newForeignConstraintPlan((RetrieveDescImpl)object, null);
            }
            if (constraintFieldName.originalPlan != null) continue;
            constraintFieldName.originalPlan = selectQueryPlan;
            if (constraintFieldName.name == null || !((object = selectQueryPlan.config.getField(constraintFieldName.name)) instanceof LocalFieldDesc)) continue;
            selectQueryPlan.addColumn((LocalFieldDesc)object, false);
        }
    }

    private SelectQueryPlan newForeignConstraintPlan(RetrieveDescImpl retrieveDescImpl, String string) {
        SelectQueryPlan selectQueryPlan = retrieveDescImpl.plan;
        if (selectQueryPlan == null) {
            selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
        }
        if (string == null) {
            return selectQueryPlan;
        }
        if (this.foreignConstraintPlans == null) {
            this.foreignConstraintPlans = new Hashtable();
        }
        SelectQueryPlan selectQueryPlan2 = null;
        Object object = retrieveDescImpl.getNavigationalId() != null ? retrieveDescImpl.getNavigationalId() : string;
        selectQueryPlan2 = (SelectQueryPlan)this.foreignConstraintPlans.get(object);
        if (selectQueryPlan2 != null) {
            selectQueryPlan.tables = selectQueryPlan2.tables;
            selectQueryPlan.foreignConstraintPlans = selectQueryPlan2.foreignConstraintPlans;
        } else {
            this.foreignConstraintPlans.put(object, selectQueryPlan);
            selectQueryPlan.foreignConstraintPlans = new Hashtable();
        }
        return selectQueryPlan;
    }

    private void buildForeignConstraint() {
        if ((this.status & 0x20) > 0 || (this.status & 0x40) > 0) {
            return;
        }
        this.status |= 0x40;
        this.processLocalConstraints();
        this.processStatements();
        this.processForeignConstraints();
        if (this.parentField == null) {
            this.processHybridConstraints();
        }
        this.status = (this.status | 0x20) & 0xFFFFFFBF;
    }

    private void addSubqueryConstraint(ForeignFieldDesc foreignFieldDesc, int n) {
        RetrieveDescImpl retrieveDescImpl = null;
        retrieveDescImpl = foreignFieldDesc.cardinalityUPB > 1 ? (RetrieveDescImpl)this.store.getRetrieveDesc(foreignFieldDesc.getComponentType()) : (RetrieveDescImpl)this.store.getRetrieveDesc(foreignFieldDesc.getType());
        SelectQueryPlan selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
        ConstraintSubquery constraintSubquery = new ConstraintSubquery();
        constraintSubquery.operation = n;
        constraintSubquery.plan = selectQueryPlan;
        selectQueryPlan.isSubQueryPlan = true;
        LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(0);
        selectQueryPlan.addColumn(localFieldDesc, true);
        selectQueryPlan.build();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        boolean bl = false;
        bl = foreignFieldDesc.useJoinTable();
        if (bl) {
            selectQueryPlan.parentField = foreignFieldDesc;
            selectQueryPlan.processJoinTable(this.config);
            arrayList = foreignFieldDesc.localFields;
            arrayList2 = foreignFieldDesc.assocLocalFields;
        } else {
            arrayList = foreignFieldDesc.localFields;
            arrayList2 = foreignFieldDesc.foreignFields;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            LocalFieldDesc localFieldDesc2 = (LocalFieldDesc)arrayList.get(i);
            LocalFieldDesc localFieldDesc3 = (LocalFieldDesc)arrayList2.get(i);
            ConstraintFieldDesc constraintFieldDesc = new ConstraintFieldDesc(localFieldDesc2, this, 0);
            ConstraintFieldDesc constraintFieldDesc2 = new ConstraintFieldDesc(localFieldDesc3, selectQueryPlan, 0);
            retrieveDescImpl.constraint.addField(constraintFieldDesc);
            retrieveDescImpl.constraint.addField(constraintFieldDesc2);
            retrieveDescImpl.constraint.addOperation(9);
            if (bl) continue;
            selectQueryPlan.addColumn(localFieldDesc3, false);
        }
        selectQueryPlan.processStatements();
        selectQueryPlan.parentConstraintsAdded = true;
        this.addQueryTables(selectQueryPlan.tables);
        this.constraint.stack.add(constraintSubquery);
    }

    private void processForeignConstraints() {
        ArrayList arrayList = this.constraint.stack;
        this.constraint.stack = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(i);
            if (constraintNode instanceof ConstraintForeignFieldName) {
                this.processForeignFieldConstraint((ConstraintForeignFieldName)constraintNode);
                continue;
            }
            if (constraintNode instanceof ConstraintFieldName) {
                i = this.processLocalFieldConstraint((ConstraintFieldName)constraintNode, arrayList, i);
                continue;
            }
            if (constraintNode instanceof ConstraintFieldNameSubQuery) {
                this.processSubQueryConstraint((ConstraintFieldNameSubQuery)constraintNode);
                continue;
            }
            this.constraint.stack.add(constraintNode);
        }
    }

    private void processForeignFieldConstraint(ConstraintForeignFieldName constraintForeignFieldName) {
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)constraintForeignFieldName.desc;
        if (retrieveDescImpl == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.constraint.noretrievedesc", constraintForeignFieldName.name, this.config.getPersistenceCapableClass().getName()));
        }
        SelectQueryPlan selectQueryPlan = this.newForeignConstraintPlan(retrieveDescImpl, constraintForeignFieldName.name);
        if ((selectQueryPlan.status & 4) == 0) {
            selectQueryPlan.addParentField(this.config, constraintForeignFieldName.name);
            this.processJoin(selectQueryPlan, 10);
            selectQueryPlan.appendAndOp = true;
        } else {
            selectQueryPlan.appendAndOp = false;
        }
    }

    private int processLocalFieldConstraint(ConstraintFieldName constraintFieldName, ArrayList arrayList, int n) {
        FieldDesc fieldDesc;
        FieldDesc fieldDesc2 = fieldDesc = constraintFieldName.name != null ? this.config.getField(constraintFieldName.name) : null;
        if (constraintFieldName.desc != null) {
            SelectQueryPlan selectQueryPlan = ((RetrieveDescImpl)constraintFieldName.desc).plan;
            this.constraint.stack.add(constraintFieldName);
            if ((selectQueryPlan.status & 4) == 0) {
                selectQueryPlan.appendAndOp = true;
            } else {
                this.constraint.stack.add(arrayList.get(++n));
                this.constraint.stack.add(arrayList.get(++n));
                if (selectQueryPlan.appendAndOp) {
                    ConstraintOperation constraintOperation = new ConstraintOperation();
                    constraintOperation.operation = 3;
                    this.constraint.stack.add(constraintOperation);
                }
            }
        } else if (fieldDesc != null && fieldDesc instanceof ForeignFieldDesc && n + 1 < arrayList.size()) {
            ConstraintNode constraintNode;
            if ((constraintNode = (ConstraintNode)arrayList.get(++n)) instanceof ConstraintOperation && (((ConstraintOperation)constraintNode).operation == 28 || ((ConstraintOperation)constraintNode).operation == 27)) {
                ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
                if ((foreignFieldDesc.sqlProperties & 0x40) > 0) {
                    ArrayList arrayList2 = foreignFieldDesc.getLocalFields();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        this.constraint.stack.add(new ConstraintFieldDesc((LocalFieldDesc)arrayList2.get(i)));
                        this.constraint.stack.add(constraintNode);
                    }
                } else {
                    int n2 = 45;
                    if (((ConstraintOperation)constraintNode).operation == 27) {
                        n2 = 46;
                    }
                    this.addSubqueryConstraint(foreignFieldDesc, n2);
                }
            } else {
                this.constraint.stack.add(constraintFieldName);
                this.constraint.stack.add(constraintNode);
            }
        } else {
            this.constraint.stack.add(constraintFieldName);
        }
        return n;
    }

    private void processSubQueryConstraint(ConstraintFieldNameSubQuery constraintFieldNameSubQuery) {
        FieldDesc fieldDesc = this.config.getField(constraintFieldNameSubQuery.fieldName);
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)constraintFieldNameSubQuery.desc;
        if (fieldDesc != null && fieldDesc instanceof ForeignFieldDesc) {
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
            if (foreignFieldDesc.getComponentType() != retrieveDescImpl.getPersistenceCapableClass()) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", constraintFieldNameSubQuery.fieldName, retrieveDescImpl.getPersistenceCapableClass().getName()));
            }
            SelectQueryPlan selectQueryPlan = retrieveDescImpl.plan;
            if (selectQueryPlan == null) {
                selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
            }
            selectQueryPlan.isSubQueryPlan = true;
            selectQueryPlan.processSubQueryPlan(foreignFieldDesc);
            this.addQueryTables(selectQueryPlan.tables);
            ConstraintSubquery constraintSubquery = new ConstraintSubquery();
            constraintSubquery.plan = selectQueryPlan;
            this.constraint.stack.add(constraintSubquery);
            ArrayList arrayList = foreignFieldDesc.getLocalFields();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.constraint.addField((LocalFieldDesc)arrayList.get(i), this);
            }
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", constraintFieldNameSubQuery.fieldName, retrieveDescImpl.getPersistenceCapableClass().getName()));
        }
    }

    private void processSubQueryPlan(ForeignFieldDesc foreignFieldDesc) {
        ArrayList arrayList = null;
        boolean bl = foreignFieldDesc.useJoinTable();
        arrayList = bl ? foreignFieldDesc.getAssocLocalFields() : foreignFieldDesc.getForeignFields();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addColumn((LocalFieldDesc)arrayList.get(i), true);
        }
        if (bl) {
            ConstraintJoin constraintJoin = new ConstraintJoin();
            constraintJoin.operation = 10;
            constraintJoin.fromColumns = foreignFieldDesc.foreignColumns;
            constraintJoin.fromPlan = this;
            constraintJoin.toColumns = foreignFieldDesc.assocForeignColumns;
            constraintJoin.toPlan = this;
            this.constraint.stack.add(constraintJoin);
            ArrayList arrayList2 = foreignFieldDesc.getForeignFields();
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.addColumn((LocalFieldDesc)arrayList2.get(i), false);
            }
        }
        this.build();
    }

    private void processHybridConstraints() {
        ArrayList arrayList = this.constraint.stack;
        this.constraint.stack = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(i);
            if (constraintNode instanceof ConstraintFieldName) {
                ConstraintFieldName constraintFieldName = (ConstraintFieldName)constraintNode;
                boolean bl = constraintFieldName.name != null;
                if (bl) {
                    this.constraint.stack.add(constraintFieldName);
                }
                if (constraintFieldName.desc == null) continue;
                SelectQueryPlan selectQueryPlan = ((RetrieveDescImpl)constraintFieldName.desc).plan;
                if (bl) {
                    this.constraint.stack.add(arrayList.get(++i));
                    this.constraint.stack.add(arrayList.get(++i));
                }
                if ((selectQueryPlan.status & 0x40) != 0 || this.foreignPlans != null && this.foreignPlans.contains(selectQueryPlan) || (selectQueryPlan.status & 4) != 0) continue;
                this.processJoin(selectQueryPlan, 52);
                continue;
            }
            this.constraint.stack.add(constraintNode);
        }
    }

    private void processJoin(SelectQueryPlan selectQueryPlan, int n) {
        selectQueryPlan.buildForeignConstraint();
        this.doJoin(selectQueryPlan, n);
        if (n != 52) {
            selectQueryPlan.removeOrderConstraints();
            if (!selectQueryPlan.constraint.stack.isEmpty() || selectQueryPlan.appendAndOp) {
                ConstraintOperation constraintOperation = new ConstraintOperation();
                constraintOperation.operation = 3;
                this.constraint.stack.add(constraintOperation);
            }
        }
    }

    private void addParentField(ClassDesc classDesc, String string) {
        FieldDesc fieldDesc = classDesc.getField(string);
        if (fieldDesc == null || !(fieldDesc instanceof ForeignFieldDesc)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", string, classDesc.getPersistenceCapableClass().getName()));
        }
        this.parentField = (ForeignFieldDesc)fieldDesc;
        for (int i = 0; i < this.parentField.foreignFields.size(); ++i) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)this.parentField.foreignFields.get(i);
            this.addColumn(localFieldDesc, false);
        }
        if (this.parentField.useJoinTable()) {
            this.processJoinTable(classDesc);
        }
    }

    public void build() {
        Object object;
        int n;
        FieldDesc fieldDesc = null;
        if ((this.status & 1) > 0 || (this.status & 0x40) > 0) {
            return;
        }
        this.status |= 0x40;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<FieldDesc> arrayList2 = new ArrayList<FieldDesc>();
        for (n = 0; n < this.retrieveDesc.fields.size(); ++n) {
            object = (ConstraintFieldName)this.retrieveDesc.fields.get(n);
            FieldDesc fieldDesc2 = this.config.getField(((ConstraintFieldName)object).name);
            if (fieldDesc2 == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", ((ConstraintFieldName)object).name, this.config.getPersistenceCapableClass().getName()));
            }
            this.setFieldMask(fieldDesc2.absoluteID);
            if (((ConstraintFieldName)object).desc != null) {
                arrayList.add(object);
                continue;
            }
            arrayList2.add(fieldDesc2);
            if (!((ConstraintFieldName)object).isProjection()) continue;
            fieldDesc = fieldDesc2;
        }
        if (!this.isSubQueryPlan) {
            this.processFetchGroups(arrayList2, arrayList);
            if (fieldDesc != null) {
                this.projectionId = arrayList2.indexOf(fieldDesc);
            }
        }
        this.buildSuperclass();
        for (n = 0; n < this.statements.size(); ++n) {
            object = (SelectStatement)this.statements.get(n);
            ((Statement)object).setProperty(SelectStatement.PROP_IS_SUPERTABLE);
        }
        this.processForeignFields(arrayList, arrayList2);
        this.processLocalFields(arrayList2);
        this.processGlobalConstraints();
        this.processLocalConstraints();
        this.buildSubclasses();
        this.processStatements();
        this.processForeignConstraints();
        this.processHybridConstraints();
        this.status = (this.status | 1) & 0xFFFFFFBF;
    }

    private void processFields() {
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.fieldMask = new BitSet();
        for (n = 0; n < this.hierarchicalGroupMask.length(); ++n) {
            this.addFetchGroup(n, arrayList, arrayList2);
        }
        for (n = 0; n < this.independentGroupMask.length(); ++n) {
            this.addFetchGroup(-(n + 1), arrayList, arrayList2);
        }
        this.processForeignFields(arrayList2, arrayList);
        this.processLocalFields(arrayList);
    }

    private ResultDesc newResultDesc() {
        ResultDesc resultDesc = new ResultDesc();
        resultDesc.setClassDesc(this.config);
        resultDesc.setProjection(this.projection);
        return resultDesc;
    }

    private void addVerticalDiscriminatorConstraint(boolean bl) {
        LocalFieldDesc localFieldDesc = this.config.getVerticalDiscriminatorField();
        if (localFieldDesc != null) {
            if (bl) {
                this.addColumn(localFieldDesc, true);
            }
            this.constraint.addField(localFieldDesc);
            this.constraint.addOperation(28);
        }
    }

    private void addHorizontalDiscriminatorConstraint(boolean bl) {
        ArrayList arrayList = this.config.getHorizontalDiscriminatorFields();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                LocalFieldDesc localFieldDesc = (LocalFieldDesc)arrayList.get(i);
                if (bl) {
                    this.addColumn(localFieldDesc, true);
                }
                this.constraint.addValue(localFieldDesc.getDiscriminatorValue());
                this.constraint.addField(localFieldDesc);
                this.constraint.addOperation(25);
            }
        }
    }

    private void buildSuperclass() {
        ClassDesc classDesc = this.config.getSuperclassConfig();
        if (classDesc == null) {
            return;
        }
        ClassDesc classDesc2 = this.config;
        ResultDesc resultDesc = this.resultDesc;
        this.config = classDesc;
        this.resultDesc = this.newResultDesc();
        resultDesc.setSuperclassResultDesc(this.resultDesc);
        this.buildSuperclass();
        this.processFields();
        this.addHorizontalDiscriminatorConstraint(false);
        this.config = classDesc2;
        this.resultDesc = resultDesc;
    }

    private void buildSubclasses() {
        ArrayList arrayList = this.config.getSubclassConfigs();
        if (arrayList == null) {
            return;
        }
        ClassDesc classDesc = this.config;
        ResultDesc resultDesc = this.resultDesc;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.config = (ClassDesc)arrayList.get(i);
            this.resultDesc = this.newResultDesc();
            this.resultDesc.setSuperclassResultDesc(resultDesc);
            if (!excludeSubclasses) {
                this.processFields();
            } else {
                this.addVerticalDiscriminatorConstraint(true);
                this.addHorizontalDiscriminatorConstraint(true);
            }
            this.buildSubclasses();
        }
        this.config = classDesc;
        this.resultDesc = resultDesc;
    }

    private void doJoin(SelectQueryPlan selectQueryPlan, int n) {
        if ((selectQueryPlan.status & 4) > 0) {
            return;
        }
        SelectStatement selectStatement = (SelectStatement)this.statements.get(0);
        SelectStatement selectStatement2 = (SelectStatement)selectQueryPlan.statements.get(0);
        if (!selectQueryPlan.isSubQueryPlan) {
            selectStatement.copyColumns(selectStatement2);
            this.addQueryTables(selectQueryPlan.tables);
            ResultDesc resultDesc = selectQueryPlan.resultDesc;
            if (this.resultDesc != null && resultDesc != null) {
                this.resultDesc.addField(resultDesc);
                resultDesc.setParentField(selectQueryPlan.parentField);
            }
        }
        this.options |= selectQueryPlan.options;
        if (n == 52) {
            selectStatement.tableList.addAll(selectStatement2.tableList);
        } else {
            this.addJoinConstraint(selectQueryPlan, n);
        }
        this.constraint.stack.addAll(selectQueryPlan.constraint.stack);
        selectQueryPlan.status |= 4;
    }

    private void addJoinConstraint(SelectQueryPlan selectQueryPlan, int n) {
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = n;
        constraintJoin.fromColumns = selectQueryPlan.parentField.localColumns;
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = selectQueryPlan.parentField.useJoinTable() ? selectQueryPlan.parentField.assocLocalColumns : selectQueryPlan.parentField.foreignColumns;
        constraintJoin.toPlan = selectQueryPlan;
        this.constraint.stack.add(constraintJoin);
    }

    private void copyConstraints(SelectQueryPlan selectQueryPlan, int n) {
        int n2;
        int n3;
        ConstraintNode constraintNode = null;
        if (n == 52 && this.constraint.stack.get(n3 = this.constraint.stack.size() - 1) instanceof ConstraintOperation && (n2 = ((ConstraintOperation)this.constraint.stack.get((int)n3)).operation) == 3) {
            constraintNode = (ConstraintNode)this.constraint.stack.remove(n3);
        }
        this.constraint.stack.addAll(selectQueryPlan.constraint.stack);
        if (constraintNode != null) {
            this.constraint.stack.add(constraintNode);
        }
    }

    private void processGlobalConstraints() {
        if (this.constraint.stack.size() >= 2 && this.constraint.stack.get(1) instanceof ConstraintOperation && ((ConstraintOperation)this.constraint.stack.get((int)1)).operation == 23) {
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(0);
            this.constraint.stack.remove(1);
            this.constraint.stack.remove(0);
            if (!(constraintNode instanceof ConstraintValue)) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "core.constraint.needvalnode", constraintNode.getClass().getName(), "ConstraintValue"));
            }
            this.maxRows = (Integer)((ConstraintValue)constraintNode).value;
        }
    }

    public void processJoins(SelectQueryPlan selectQueryPlan) {
        SelectQueryPlan selectQueryPlan2;
        int n;
        if (selectQueryPlan == null) {
            selectQueryPlan = this;
        }
        if ((this.status & 4) > 0) {
            return;
        }
        if (selectQueryPlan.foreignPlans == null || selectQueryPlan.foreignPlans.size() == 0) {
            return;
        }
        for (n = 0; n < selectQueryPlan.foreignPlans.size(); ++n) {
            selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n);
            selectQueryPlan2.processJoins(null);
        }
        if (selectQueryPlan.statements.size() == 1 && (this.options & 0x20) == 0) {
            for (n = 0; n < selectQueryPlan.foreignPlans.size(); ++n) {
                selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n);
                if (selectQueryPlan2.statements.size() != 1 || selectQueryPlan2.parentField.cardinalityUPB != 1 || selectQueryPlan2.constraint != null && (selectQueryPlan2.options & 0x100) != 0) continue;
                this.doJoin(selectQueryPlan2, 16);
            }
        }
    }

    private void removeOrderConstraints() {
        for (int i = 0; i < this.constraint.stack.size(); ++i) {
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(i);
            if (!(constraintNode instanceof ConstraintOperation) || ((ConstraintOperation)constraintNode).operation != 30 && ((ConstraintOperation)constraintNode).operation != 31) continue;
            if (i > 1 && this.constraint.stack.get(i - 2) instanceof ConstraintValue) {
                this.constraint.stack.remove(i - 2);
                --i;
            }
            this.constraint.stack.remove(i);
            this.constraint.stack.remove(i - 1);
            --i;
        }
    }

    public ArrayList processOrderConstraints() {
        if (this.orderBy == null) {
            Object object;
            ArrayList arrayList = new ArrayList();
            int n = 0;
            if (this.constraint != null) {
                for (int i = 0; i < this.constraint.stack.size(); ++i) {
                    Object object2;
                    ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(i);
                    if (!(constraintNode instanceof ConstraintOperation) || ((ConstraintOperation)constraintNode).operation != 30 && ((ConstraintOperation)constraintNode).operation != 31) continue;
                    int n2 = -1;
                    if (i > 1 && this.constraint.stack.get(i - 2) instanceof ConstraintValue) {
                        n2 = (Integer)((ConstraintValue)this.constraint.stack.get((int)(i - 2))).value;
                        this.constraint.stack.remove(i - 2);
                        --i;
                    }
                    if (n2 > 0) {
                        n = n2;
                    }
                    for (int j = arrayList.size(); j <= n; ++j) {
                        arrayList.add(null);
                    }
                    if (arrayList.get(n) == null) {
                        arrayList.set(n, new ArrayList());
                    }
                    ConstraintNode constraintNode2 = (ConstraintNode)this.constraint.stack.get(i - 1);
                    object = null;
                    if (constraintNode2 instanceof ConstraintFieldName) {
                        FieldDesc fieldDesc;
                        object2 = this;
                        if (((ConstraintField)constraintNode2).originalPlan != null) {
                            object2 = ((ConstraintField)constraintNode2).originalPlan;
                        }
                        if (!((fieldDesc = ((QueryPlan)object2).config.getField(((ConstraintFieldName)constraintNode2).name)) instanceof LocalFieldDesc)) {
                            throw new JDOUserException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", fieldDesc.getClass().getName(), "LocalFieldDesc"));
                        }
                        object = new ConstraintFieldDesc((LocalFieldDesc)fieldDesc, (QueryPlan)object2, 1);
                    } else if (constraintNode2 instanceof ConstraintFieldDesc) {
                        object = (ConstraintFieldDesc)constraintNode2;
                    } else {
                        throw new JDOUserException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode2.getClass().getName(), "ConstraintFieldName/ConstraintFieldDesc"));
                    }
                    if (((ConstraintOperation)constraintNode).operation == 31) {
                        ((ConstraintFieldDesc)object).ordering = -1;
                    }
                    object2 = (ArrayList)arrayList.get(n);
                    ((ArrayList)object2).add(object);
                    this.constraint.stack.remove(i);
                    this.constraint.stack.remove(i - 1);
                    i = i - 2 + 1;
                }
            }
            this.orderBy = new ArrayList();
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                object = (ArrayList)arrayList.get(i);
                if (this.constraint == null) {
                    this.constraint = new Constraint();
                }
                int n4 = ((ArrayList)object).size();
                for (int j = 0; j < n4; ++j) {
                    ConstraintFieldDesc constraintFieldDesc = (ConstraintFieldDesc)((ArrayList)object).get(j);
                    this.orderBy.add(constraintFieldDesc);
                    if (constraintFieldDesc.ordering < 0) {
                        this.constraint.addField(constraintFieldDesc);
                        this.constraint.addOperation(31);
                        continue;
                    }
                    this.constraint.addField(constraintFieldDesc);
                    this.constraint.addOperation(30);
                }
            }
        }
        return this.orderBy;
    }

    protected Statement newStatement() {
        SelectStatement selectStatement = new SelectStatement(this.store.getVendorType(), this);
        selectStatement.constraint = this.constraint;
        return selectStatement;
    }

    static {
        logger = LogHelperSQLStore.getLogger();
    }
}

