/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.TableIndex;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.ResourceBundle;

public abstract class QueryPlan {
    public static final int ACT_NOOP = 5;
    public static final int ACT_DELETE = 3;
    public static final int ACT_INSERT = 2;
    public static final int ACT_SELECT = 4;
    public static final int ACT_UPDATE = 1;
    public static final int ST_BUILT = 1;
    public static final int ST_EXECUTED = 2;
    public ArrayList statements;
    public ClassDesc config;
    public int status;
    public int action;
    public int options;
    protected SQLStoreManager store;
    protected ArrayList tables = new ArrayList();
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", QueryPlan.class.getClassLoader());

    public QueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager) {
        this.statements = new ArrayList();
        this.store = sQLStoreManager;
        this.config = (ClassDesc)sQLStoreManager.getPersistenceConfig(actionDesc.getPersistenceCapableClass());
    }

    public QueryTable addQueryTable(TableDesc tableDesc) {
        QueryTable queryTable = new QueryTable(tableDesc);
        this.tables.add(queryTable);
        queryTable.setTableIndex(new TableIndex(this.tables.size() - 1));
        return queryTable;
    }

    public QueryTable addQueryTable(TableElement tableElement, ClassDesc classDesc) {
        TableDesc tableDesc = null;
        tableDesc = classDesc == null ? this.config.findTableDesc(tableElement) : classDesc.findTableDesc(tableElement);
        if (tableDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.classnotmapped", this.config.getPersistenceCapableClass().getName(), tableDesc.getName()));
        }
        return this.addQueryTable(tableDesc);
    }

    public void addQueryTables(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            QueryTable queryTable = (QueryTable)arrayList.get(i);
            if (this.tables.indexOf(queryTable) != -1) continue;
            this.tables.add(queryTable);
            queryTable.getTableIndex().setValue(this.tables.size() - 1);
        }
    }

    public QueryTable findQueryTable(TableElement tableElement) {
        for (int i = 0; i < this.tables.size(); ++i) {
            QueryTable queryTable = (QueryTable)this.tables.get(i);
            if (queryTable.getTableDesc().getTableElement() != tableElement) continue;
            return queryTable;
        }
        return null;
    }

    public QueryTable findQueryTable(TableDesc tableDesc) {
        for (int i = 0; i < this.tables.size(); ++i) {
            QueryTable queryTable = (QueryTable)this.tables.get(i);
            if (queryTable.getTableDesc() != tableDesc) continue;
            return queryTable;
        }
        return null;
    }

    public ArrayList getStatements() {
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement statement = (Statement)this.statements.get(i);
            String string = statement.getText();
        }
        return this.statements;
    }

    protected Statement addStatement(QueryTable queryTable) {
        Statement statement = this.createStatement(queryTable);
        this.statements.add(statement);
        return statement;
    }

    protected abstract Statement newStatement();

    protected Statement createStatement(QueryTable queryTable) {
        Statement statement = this.newStatement();
        statement.plan = this;
        statement.action = this.action;
        statement.addQueryTable(queryTable);
        return statement;
    }

    protected Statement getStatement(QueryTable queryTable) {
        if (queryTable == null) {
            return null;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement statement = (Statement)this.statements.get(i);
            if (statement.tableList.indexOf(queryTable) == -1) continue;
            return statement;
        }
        return null;
    }

    public abstract void build();

    protected void processStatements() {
        for (int i = 0; i < this.statements.size(); ++i) {
            ArrayList arrayList;
            Statement statement = (Statement)this.statements.get(i);
            QueryTable queryTable = (QueryTable)statement.getQueryTables().get(0);
            ArrayList arrayList2 = queryTable.getTableDesc().getSubtableKeys();
            if (arrayList2 != null) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    ReferenceKeyDesc referenceKeyDesc = (ReferenceKeyDesc)arrayList2.get(j);
                    statement.addSubtableStatement(this.getStatement(this.findQueryTable(referenceKeyDesc.getTableDesc())));
                }
            }
            if ((arrayList = queryTable.getTableDesc().getSecondaryTableKeys()) == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                ReferenceKeyDesc referenceKeyDesc = (ReferenceKeyDesc)arrayList.get(j);
                statement.addSecondaryTableStatement(this.getStatement(this.findQueryTable(referenceKeyDesc.getTableDesc())));
            }
        }
    }
}

