/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;

public class Vector
extends java.util.Vector
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient java.util.Vector added = new java.util.Vector();
    private transient java.util.Vector removed = new java.util.Vector();
    private transient boolean isUnloaded;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", Vector.class.getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", Vector.class.getClassLoader());

    public Vector(Object object, String string, Class clazz, boolean bl) {
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    public Vector(Object object, String string, Class clazz, boolean bl, int n) {
        super(n);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    public synchronized void setElementAt(Object object, int n) {
        StateManager stateManager;
        this.throwUnsupportedOption();
        if (object == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            this.removeElementAt(n);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            stateManager = this.makeDirty();
            Object e = super.elementAt(n);
            super.setElementAt(object, n);
            if (!this.added.remove(e)) {
                this.removed.add(e);
            }
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized void removeElementAt(int n) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object e = super.elementAt(n);
        super.removeElementAt(n);
        if (!this.added.remove(e)) {
            this.removed.add(e);
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized void insertElementAt(Object object, int n) {
        StateManager stateManager;
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            stateManager = this.makeDirty();
            super.insertElementAt(object, n);
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized void addElement(Object object) {
        StateManager stateManager;
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            stateManager = this.makeDirty();
            super.addElement(object);
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized boolean removeElement(Object object) {
        StateManager stateManager = this.makeDirty();
        int n = super.indexOf(object);
        if (n > -1) {
            super.removeElementAt(n);
            if (!this.added.remove(object)) {
                this.removed.add(object);
            }
            this.applyUpdates(stateManager, true);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        StateManager stateManager = this.makeDirty();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.added.remove(e)) continue;
            this.removed.add(e);
        }
        this.added.clear();
        super.removeAllElements();
        this.applyUpdates(stateManager, true);
    }

    public synchronized Object set(int n, Object object) {
        this.throwUnsupportedOption();
        if (object == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            return this.remove(n);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            StateManager stateManager = this.makeDirty();
            Object object2 = super.set(n, object);
            if (!this.added.remove(object2)) {
                this.removed.add(object2);
            }
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
            this.applyUpdates(stateManager, true);
            return object2;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
    }

    public synchronized boolean add(Object object) {
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            StateManager stateManager = this.makeDirty();
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
            boolean bl = super.add(object);
            this.applyUpdates(stateManager, bl);
            return bl;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public synchronized Object remove(int n) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object e = super.remove(n);
        if (!this.added.remove(e)) {
            this.removed.add(e);
        }
        this.applyUpdates(stateManager, true);
        return e;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized boolean addAll(Collection collection) {
        Object object;
        if (!this.allowNulls && collection.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        java.util.Vector vector = new java.util.Vector();
        if (this.elementType != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.elementType.isAssignableFrom(e.getClass())) continue;
                vector.add(e);
            }
        }
        if (vector != null && vector.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), vector.toArray());
        }
        object = this.makeDirty();
        this.removed.removeAll(collection);
        this.added.addAll(collection);
        boolean bl = super.addAll(collection);
        this.applyUpdates((StateManager)object, bl);
        return bl;
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean bl = false;
        StateManager stateManager = this.makeDirty();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!super.contains(e)) continue;
            this.removeInternal(e);
            if (!this.added.remove(e)) {
                this.removed.add(e);
            }
            bl = true;
        }
        this.applyUpdates(stateManager, bl);
        return bl;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        Object object;
        if (!this.allowNulls && collection.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        java.util.Vector vector = new java.util.Vector();
        if (this.elementType != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.elementType.isAssignableFrom(e.getClass())) continue;
                vector.add(e);
            }
        }
        if (vector != null && vector.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), vector.toArray());
        }
        object = this.makeDirty();
        this.removed.removeAll(collection);
        this.added.addAll(collection);
        boolean bl = super.addAll(n, collection);
        this.applyUpdates((StateManager)object, bl);
        return bl;
    }

    public synchronized boolean retainAll(Collection collection) {
        boolean bl = false;
        java.util.Vector vector = new java.util.Vector();
        StateManager stateManager = this.makeDirty();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            vector.add(e);
            if (!this.added.remove(e)) {
                this.removed.add(e);
            }
            bl = true;
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.removeInternal(iterator.next());
        }
        this.applyUpdates(stateManager, bl);
        return bl;
    }

    public Object clone() {
        Vector vector = (Vector)super.clone();
        vector.unsetOwner();
        return vector;
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public void markDeferred() {
    }

    public boolean isDeferred() {
        return false;
    }

    public void applyDeferredUpdates(Collection collection) {
        super.addAll(collection);
    }

    public void addInternal(Object object) {
        super.addElement(object);
    }

    public void addAllInternal(Collection collection) {
        super.addAll(collection);
    }

    public void removeAllInternal(Collection collection) {
        super.removeAll(collection);
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        int n;
        for (int i = n = super.size() - 1; i > -1; --i) {
            super.removeElementAt(i);
        }
        this.reset();
    }

    public void removeInternal(Object object) {
        int n = super.indexOf(object);
        super.remove(n);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public StateManager makeDirty() {
        if (this.owner != null) {
            StateManager stateManager = this.owner.jdoGetStateManager();
            if (stateManager != null) {
                stateManager.makeDirty(this.fieldName);
            }
            return stateManager;
        }
        return null;
    }

    public void applyUpdates(StateManager stateManager, boolean bl) {
        if (bl && stateManager != null) {
            stateManager.applyUpdates(this.fieldName, this);
        }
    }

    private void throwUnsupportedOption() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "sco.not_supported"));
    }

    public void setOwner(Object object, String string, Class clazz) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
            this.elementType = clazz;
        }
    }
}

