/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.ObjectStreamException;
import java.sql.Timestamp;

public class SqlTimestamp
extends Timestamp
implements SCODate {
    private transient PersistenceCapable owner;
    private transient String fieldName;

    public SqlTimestamp(Object object, String string) {
        super(0L);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
    }

    public SqlTimestamp(Object object, String string, long l) {
        super(l);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
    }

    public void setTime(long l) {
        this.makeDirty();
        super.setTime(l);
    }

    public void setNanos(int n) {
        this.makeDirty();
        super.setNanos(n);
    }

    public Object clone() {
        SqlTimestamp sqlTimestamp = (SqlTimestamp)super.clone();
        sqlTimestamp.owner = null;
        sqlTimestamp.fieldName = null;
        return sqlTimestamp;
    }

    public void setYear(int n) {
        this.makeDirty();
        super.setYear(n);
    }

    public void setMonth(int n) {
        this.makeDirty();
        super.setMonth(n);
    }

    public void setDate(int n) {
        this.makeDirty();
        super.setDate(n);
    }

    public void setHours(int n) {
        this.makeDirty();
        super.setHours(n);
    }

    public void setMinutes(int n) {
        this.makeDirty();
        super.setMinutes(n);
    }

    public void setSeconds(int n) {
        this.makeDirty();
        super.setSeconds(n);
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void setTimeInternal(long l) {
        super.setTime(l);
    }

    public void setNanosInternal(int n) {
        super.setNanos(n);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager makeDirty() {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                StateManager stateManager2 = stateManager;
                synchronized (stateManager2) {
                    block9: {
                        if (this.owner == null) break block9;
                        stateManager.makeDirty(this.fieldName);
                        StateManager stateManager3 = stateManager;
                        return stateManager3;
                    }
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return null;
    }

    public void applyUpdates(StateManager stateManager, boolean bl) {
    }

    Object writeReplace() throws ObjectStreamException {
        Timestamp timestamp = new Timestamp(this.getTime());
        timestamp.setNanos(this.getNanos());
        return timestamp;
    }
}

