/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;

public class HashSet
extends java.util.HashSet
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient java.util.HashSet added = new java.util.HashSet();
    private transient java.util.HashSet removed = new java.util.HashSet();
    private transient boolean isDeferred;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", HashSet.class.getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", HashSet.class.getClassLoader());

    public HashSet(Object object, String string, Class clazz, boolean bl) {
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    public HashSet(Object object, String string, Class clazz, boolean bl, int n) {
        super(n);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        StateManager stateManager;
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType != null && !this.elementType.isAssignableFrom(object.getClass())) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
        }
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            boolean bl = false;
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    bl = super.add(object);
                    if (bl) {
                        if (!this.removed.remove(object)) {
                            this.added.add(object);
                        }
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl2 = bl;
                    persistenceManager.releaseFieldUpdateLock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    try {
                        persistenceManager.releaseFieldUpdateLock();
                        throw throwable;
                    }
                    catch (JDOUserException jDOUserException) {
                        Object[] objectArray = jDOUserException.getFailedObjectArray();
                        if (bl && objectArray != null) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                Object object2 = objectArray[i];
                                if (object2 != object) continue;
                                super.remove(object2);
                                break;
                            }
                        }
                        throw jDOUserException;
                    }
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return super.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        Object object;
        if (!this.allowNulls && collection.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.elementType != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (this.elementType.isAssignableFrom(object.getClass())) continue;
                arrayList.add(object);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), arrayList.toArray());
        }
        boolean bl = false;
        if (this.owner != null && (object = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)object.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    object.makeDirty(this.fieldName);
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (super.contains(e)) continue;
                        if (!this.removed.remove(e)) {
                            this.added.add(e);
                        }
                        super.add(e);
                        bl = true;
                    }
                    if (bl) {
                        object.applyUpdates(this.fieldName, this);
                    }
                    boolean bl2 = bl;
                    persistenceManager.releaseFieldUpdateLock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    try {
                        persistenceManager.releaseFieldUpdateLock();
                        throw throwable;
                    }
                    catch (JDOUserException jDOUserException) {
                        Object[] objectArray = jDOUserException.getFailedObjectArray();
                        if (bl && objectArray != null) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                super.remove(objectArray[i]);
                            }
                        }
                        throw jDOUserException;
                    }
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return super.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    boolean bl = super.remove(object);
                    if (bl) {
                        if (!this.added.remove(object)) {
                            this.removed.add(object);
                        }
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl2 = bl;
                    persistenceManager.releaseFieldUpdateLock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    persistenceManager.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return super.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!super.contains(e) || this.added.remove(e)) continue;
                        this.removed.add(e);
                    }
                    boolean bl = super.removeAll(collection);
                    if (bl) {
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl2 = bl;
                    persistenceManager.releaseFieldUpdateLock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    persistenceManager.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return super.removeAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    Iterator iterator = super.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (collection.contains(e) || this.added.remove(e)) continue;
                        this.removed.add(e);
                    }
                    boolean bl = super.retainAll(collection);
                    if (bl) {
                        stateManager.applyUpdates(this.fieldName, this);
                    }
                    boolean bl2 = bl;
                    persistenceManager.releaseFieldUpdateLock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    persistenceManager.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        return super.retainAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            persistenceManager.acquireShareLock();
            try {
                persistenceManager.acquireFieldUpdateLock();
                try {
                    stateManager.makeDirty(this.fieldName);
                    this.removed.clear();
                    this.added.clear();
                    Iterator iterator = super.iterator();
                    while (iterator.hasNext()) {
                        this.removed.add(iterator.next());
                    }
                    super.clear();
                    stateManager.applyUpdates(this.fieldName, this);
                    persistenceManager.releaseFieldUpdateLock();
                    return;
                }
                catch (Throwable throwable) {
                    persistenceManager.releaseFieldUpdateLock();
                    throw throwable;
                }
            }
            finally {
                persistenceManager.releaseShareLock();
            }
        }
        super.clear();
    }

    public Object clone() {
        HashSet hashSet = (HashSet)super.clone();
        hashSet.unsetOwner();
        return hashSet;
    }

    public Iterator iterator() {
        return new SCOHashIterator(super.iterator(), this);
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void reset() {
        if (this.added != null) {
            this.added.clear();
        }
        if (this.removed != null) {
            this.removed.clear();
        }
    }

    public void markDeferred() {
        this.isDeferred = true;
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    public void applyDeferredUpdates(Collection collection) {
        if (!this.isDeferred) {
            return;
        }
        this.isDeferred = false;
        this.addAllInternal(collection);
        this.addAllInternal(this.added);
        this.removeAllInternal(this.removed);
        this.added.clear();
        this.removed.clear();
    }

    public void addInternal(Object object) {
        if (this.isDeferred) {
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
        } else {
            super.add(object);
        }
    }

    public void addAllInternal(Collection collection) {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addInternal(iterator.next());
        }
    }

    public void removeAllInternal(Collection collection) {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeInternal(iterator.next());
        }
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object object) {
        if (this.isDeferred) {
            if (!this.added.remove(object)) {
                this.removed.add(object);
            }
        } else {
            super.remove(object);
        }
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public StateManager makeDirty() {
        StateManager stateManager = this.owner.jdoGetStateManager();
        if (stateManager != null) {
            stateManager.makeDirty(this.fieldName);
        }
        return stateManager;
    }

    public void applyUpdates(StateManager stateManager, boolean bl) {
        if (bl && stateManager != null) {
            stateManager.applyUpdates(this.fieldName, this);
        }
    }

    public void setOwner(Object object, String string, Class clazz) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
            this.elementType = clazz;
        }
    }

    private class SCOHashIterator
    implements Iterator {
        Iterator _iterator = null;
        HashSet _caller = null;
        Object lastReturned = null;

        SCOHashIterator(Iterator iterator, HashSet hashSet2) {
            this._iterator = iterator;
            this._caller = hashSet2;
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() {
            this.lastReturned = this._iterator.next();
            return this.lastReturned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this._caller.owner != null) {
                StateManager stateManager = this._caller.owner.jdoGetStateManager();
                if (stateManager != null) {
                    PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
                    persistenceManager.acquireShareLock();
                    try {
                        persistenceManager.acquireFieldUpdateLock();
                        try {
                            stateManager.makeDirty(this._caller.fieldName);
                            this._iterator.remove();
                            if (!HashSet.this.added.remove(this.lastReturned)) {
                                HashSet.this.removed.add(this.lastReturned);
                            }
                            stateManager.applyUpdates(this._caller.fieldName, this._caller);
                        }
                        finally {
                            persistenceManager.releaseFieldUpdateLock();
                        }
                    }
                    finally {
                        persistenceManager.releaseShareLock();
                    }
                }
            } else {
                this._iterator.remove();
            }
            this.lastReturned = null;
        }
    }
}

