/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.BooleanType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ErrorType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FloatingPointType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.IntegralType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.MathType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NullType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.StringType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.WrapperClassType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class TypeTable {
    public static final NullType nullType = new NullType();
    public static final ErrorType errorType = new ErrorType();
    public BooleanType booleanType;
    public IntegralType charType;
    public IntegralType byteType;
    public IntegralType shortType;
    public IntegralType intType;
    public IntegralType longType;
    public FloatingPointType floatType;
    public FloatingPointType doubleType;
    public StringType stringType;
    public MathType bigDecimalType;
    public MathType bigIntegerType;
    protected Model model;
    protected ClassLoader classLoader;
    protected Map types = new HashMap();
    private static Map typeTables = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeTable getInstance(ClassLoader classLoader) {
        Map map = typeTables;
        synchronized (map) {
            TypeTable typeTable = (TypeTable)typeTables.get(classLoader);
            if (typeTable == null) {
                typeTable = new TypeTable(classLoader);
                typeTables.put(classLoader, typeTable);
            }
            return typeTable;
        }
    }

    private TypeTable(ClassLoader classLoader) {
        this.model = Model.RUNTIME;
        this.classLoader = classLoader;
        this.booleanType = new BooleanType();
        this.types.put(this.booleanType.getName(), this.booleanType);
        this.charType = new IntegralType("char", Character.TYPE, 2);
        this.types.put(this.charType.getName(), this.charType);
        this.byteType = new IntegralType("byte", Byte.TYPE, 3);
        this.types.put(this.byteType.getName(), this.byteType);
        this.shortType = new IntegralType("short", Short.TYPE, 4);
        this.types.put(this.shortType.getName(), this.shortType);
        this.intType = new IntegralType("int", Integer.TYPE, 5);
        this.types.put(this.intType.getName(), this.intType);
        this.longType = new IntegralType("long", Long.TYPE, 6);
        this.types.put(this.longType.getName(), this.longType);
        this.floatType = new FloatingPointType("float", Float.TYPE, 7);
        this.types.put(this.floatType.getName(), this.floatType);
        this.doubleType = new FloatingPointType("double", Double.TYPE, 8);
        this.types.put(this.doubleType.getName(), this.doubleType);
        this.stringType = new StringType(this);
        this.types.put(this.stringType.getName(), this.stringType);
        WrapperClassType wrapperClassType = new WrapperClassType("java.lang.Boolean", Boolean.class, 11, this.booleanType, this);
        this.types.put(wrapperClassType.getName(), wrapperClassType);
        NumericWrapperClassType numericWrapperClassType = new NumericWrapperClassType("java.lang.Byte", Byte.class, 13, this.byteType, this);
        this.types.put(numericWrapperClassType.getName(), numericWrapperClassType);
        NumericWrapperClassType numericWrapperClassType2 = new NumericWrapperClassType("java.lang.Short", Short.class, 14, this.shortType, this);
        this.types.put(numericWrapperClassType2.getName(), numericWrapperClassType2);
        NumericWrapperClassType numericWrapperClassType3 = new NumericWrapperClassType("java.lang.Integer", Integer.class, 15, this.intType, this);
        this.types.put(numericWrapperClassType3.getName(), numericWrapperClassType3);
        NumericWrapperClassType numericWrapperClassType4 = new NumericWrapperClassType("java.lang.Long", Long.class, 16, this.longType, this);
        this.types.put(numericWrapperClassType4.getName(), numericWrapperClassType4);
        NumericWrapperClassType numericWrapperClassType5 = new NumericWrapperClassType("java.lang.Character", Character.class, 12, this.charType, this);
        this.types.put(numericWrapperClassType5.getName(), numericWrapperClassType5);
        NumericWrapperClassType numericWrapperClassType6 = new NumericWrapperClassType("java.lang.Float", Float.class, 17, this.floatType, this);
        this.types.put(numericWrapperClassType6.getName(), numericWrapperClassType6);
        NumericWrapperClassType numericWrapperClassType7 = new NumericWrapperClassType("java.lang.Double", Double.class, 18, this.doubleType, this);
        this.types.put(numericWrapperClassType7.getName(), numericWrapperClassType7);
        this.booleanType.setWrapper(wrapperClassType);
        this.byteType.setWrapper(numericWrapperClassType);
        this.shortType.setWrapper(numericWrapperClassType2);
        this.intType.setWrapper(numericWrapperClassType3);
        this.longType.setWrapper(numericWrapperClassType4);
        this.charType.setWrapper(numericWrapperClassType5);
        this.floatType.setWrapper(numericWrapperClassType6);
        this.doubleType.setWrapper(numericWrapperClassType7);
        this.bigDecimalType = new MathType("java.math.BigDecimal", BigDecimal.class, 19, this);
        this.types.put(this.bigDecimalType.getName(), this.bigDecimalType);
        this.bigIntegerType = new MathType("java.math.BigInteger", BigInteger.class, 20, this);
        this.types.put(this.bigIntegerType.getName(), this.bigIntegerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type checkType(String string) {
        Map map = this.types;
        synchronized (map) {
            Type type = (Type)this.types.get(string);
            if (type == null) {
                try {
                    Class<?> clazz = Class.forName(string, true, this.classLoader);
                    type = new ClassType(string, clazz, this);
                    this.types.put(string, type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type checkType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        Map map = this.types;
        synchronized (map) {
            Type type = (Type)this.types.get(string);
            if (type == null) {
                type = new ClassType(string, clazz, this);
                this.types.put(string, type);
            }
            return type;
        }
    }

    public Type binaryNumericPromotion(Type type, Type type2) {
        if (type instanceof NumericType && type2 instanceof NumericType) {
            if (type.equals(this.doubleType) || type2.equals(this.doubleType)) {
                return this.doubleType;
            }
            if (type.equals(this.floatType) || type2.equals(this.floatType)) {
                return this.floatType;
            }
            if (type.equals(this.longType) || type2.equals(this.longType)) {
                return this.longType;
            }
            return this.intType;
        }
        return errorType;
    }

    public Type unaryNumericPromotion(Type type) {
        if (type instanceof NumericType) {
            if (type.equals(this.byteType) || type.equals(this.shortType) || type.equals(this.charType)) {
                return this.intType;
            }
            return type;
        }
        return errorType;
    }

    public boolean isNumberType(Type type) {
        Type type2 = this.checkType("java.lang.Number");
        return type instanceof NumericType || type.isCompatibleWith(type2);
    }

    public boolean isIntegralType(Type type) {
        if (type instanceof IntegralType) {
            return true;
        }
        if (type instanceof NumericWrapperClassType) {
            return ((NumericWrapperClassType)type).getPrimitiveType() instanceof IntegralType;
        }
        return false;
    }

    public boolean isFloatingPointType(Type type) {
        if (type instanceof FloatingPointType) {
            return true;
        }
        if (type instanceof NumericWrapperClassType) {
            return ((NumericWrapperClassType)type).getPrimitiveType() instanceof FloatingPointType;
        }
        return false;
    }

    public boolean isDoubleType(Type type) {
        return type.equals(this.doubleType) || type.equals(this.doubleType.getWrapper());
    }

    public boolean isIntType(Type type) {
        return type.equals(this.intType) || type.equals(this.intType.getWrapper());
    }

    public boolean isCharType(Type type) {
        return type.equals(this.charType) || type.equals(this.charType.getWrapper());
    }

    public boolean isBooleanType(Type type) {
        return type.equals(this.booleanType) || type.equals(this.booleanType.getWrapper());
    }

    public boolean isPersistenceCapableType(Type type) {
        return type instanceof ClassType && ((ClassType)type).isPersistenceCapable();
    }

    public boolean isCollectionType(Type type) {
        Type type2 = this.checkType("java.util.Collection");
        return type instanceof ClassType && type.isCompatibleWith(type2);
    }

    public boolean isJavaLangMathType(Type type) {
        Type type2 = this.checkType("java.lang.Math");
        return type instanceof ClassType && type.isCompatibleWith(type2);
    }
}

