/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class VariableTable {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(VariableTable.class);
    private ErrorMsg errorMsg;
    private List declaredVars;
    private Map varInfos;

    public VariableTable(ErrorMsg errorMsg) {
        this.errorMsg = errorMsg;
        this.declaredVars = new ArrayList();
        this.varInfos = new HashMap();
    }

    public VariableTable(VariableTable variableTable) {
        this.errorMsg = variableTable.errorMsg;
        this.declaredVars = variableTable.declaredVars;
        this.varInfos = new HashMap();
        Iterator iterator = variableTable.varInfos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.varInfos.put(entry.getKey(), new VarInfo((VarInfo)entry.getValue()));
        }
    }

    public void add(String string) {
        this.declaredVars.add(string);
        this.varInfos.put(string, new VarInfo());
    }

    public void markUsed(JQLAST jQLAST, String string) {
        String string2 = jQLAST.getText();
        VarInfo varInfo = (VarInfo)this.varInfos.get(string2);
        if (varInfo == null) {
            throw new JDOFatalInternalException("VariableTable.markUsed variable " + string2 + " not found");
        }
        varInfo.used.add(jQLAST);
        if (string != null) {
            VarInfo varInfo2 = (VarInfo)this.varInfos.get(string);
            if (varInfo2.dependsOn != null) {
                throw new JDOFatalInternalException("VariableTable.markUsed multiple dependencies for variable " + string + " old: " + varInfo2.dependsOn + " new " + string2);
            }
            varInfo2.dependsOn = string2;
        }
    }

    public void markConstraint(JQLAST jQLAST, JQLAST jQLAST2) {
        String string;
        String string2 = jQLAST.getText();
        VarInfo varInfo = (VarInfo)this.varInfos.get(string2);
        if (varInfo == null) {
            throw new JDOFatalInternalException("VariableTable.markConstraint variable " + string2 + " not found");
        }
        String string3 = string = varInfo.constraint == null ? null : varInfo.constraint.getText();
        if (string != null && !string.equals(jQLAST2.getText())) {
            this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.variabletable.markconstraint.multiple", string2));
        }
        varInfo.constraint = jQLAST2;
    }

    public void merge(VariableTable variableTable) {
        Iterator iterator = this.declaredVars.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            VarInfo varInfo = (VarInfo)this.varInfos.get(string);
            VarInfo varInfo2 = (VarInfo)variableTable.varInfos.get(string);
            if (varInfo.constraint == null && varInfo.used.size() == 0) {
                varInfo.constraint = varInfo2.constraint;
                varInfo.used = varInfo2.used;
                varInfo.dependsOn = varInfo2.dependsOn;
                varInfo.status = varInfo2.status;
                continue;
            }
            if (varInfo2.constraint == null && varInfo2.used.size() == 0) continue;
            if (varInfo.constraint != null && varInfo2.constraint != null) {
                if (!varInfo2.constraint.getText().equals(varInfo.constraint.getText())) {
                    throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.merge.different", string));
                }
            } else {
                varInfo.constraint = null;
                varInfo.dependsOn = null;
                varInfo.status = 0;
            }
            varInfo.used.addAll(varInfo2.used);
        }
    }

    public void checkConstraints() {
        Iterator iterator = this.declaredVars.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            VarInfo varInfo = (VarInfo)this.varInfos.get(string);
            this.checkConstraint(string, varInfo);
        }
    }

    protected void checkConstraint(String string, VarInfo varInfo) {
        switch (varInfo.status) {
            case 0: {
                varInfo.status = 1;
                break;
            }
            case 1: {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.checkconstraint.cycle", string));
            }
            case 2: {
                return;
            }
        }
        if (varInfo.dependsOn != null) {
            VarInfo varInfo2 = (VarInfo)this.varInfos.get(varInfo.dependsOn);
            this.checkConstraint(varInfo.dependsOn, varInfo2);
        }
        if (varInfo.constraint != null && varInfo.used.size() == 0) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.variabletable.checkconstraint.unused", string));
        }
        this.attachConstraintToUsedAST(varInfo);
        varInfo.status = 2;
    }

    protected void attachConstraintToUsedAST(VarInfo varInfo) {
        Iterator iterator = varInfo.used.iterator();
        while (iterator.hasNext()) {
            JQLAST jQLAST = (JQLAST)iterator.next();
            if (jQLAST.getFirstChild() != null) continue;
            jQLAST.setFirstChild(JQLAST.Factory.getInstance().dupTree(varInfo.constraint));
        }
    }

    static class VarInfo {
        JQLAST constraint;
        Set used;
        String dependsOn;
        int status;
        static final int UNCHECKED = 0;
        static final int IN_PROGRESS = 1;
        static final int CHECKED = 2;

        VarInfo() {
            this.constraint = null;
            this.used = new HashSet();
            this.dependsOn = null;
            this.status = 0;
        }

        VarInfo(VarInfo varInfo) {
            this.constraint = varInfo.constraint;
            this.used = new HashSet(varInfo.used);
            this.dependsOn = varInfo.dependsOn;
            this.status = varInfo.status;
        }
    }
}

