/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.QueryValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.ParameterInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ParameterTable {
    List names = null;
    List types = null;
    transient List values = null;
    private static final String NULL_ = "null";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String OTHER_ = "other";
    private static final String NOPARAMS_ = "noparams";
    private static final char PARAMKEY_SEPARATOR = '/';
    static final Unbound unbound = new Unbound();
    protected static final ResourceBundle messages = I18NHelper.loadBundle(ParameterTable.class);

    public ParameterTable() {
    }

    public ParameterTable(ParameterTable parameterTable) {
        this.names = parameterTable.names;
        this.types = parameterTable.types;
        this.values = parameterTable.values;
    }

    public void add(String string, Type type) {
        this.names.add(string);
        this.types.add(type);
    }

    public void init() {
        this.names = new ArrayList();
        this.types = new ArrayList();
    }

    public void initValueHandling() {
        this.values = new ArrayList(this.names.size());
        int n = this.names.size();
        for (int i = 0; i < n; ++i) {
            this.values.add(unbound);
        }
    }

    public void setValues(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.defineValueByIndex(i, object);
            }
        }
    }

    public void checkUnboundParams() {
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            if (this.values.get(i) != unbound) continue;
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.parametertable.checkunboundparams.unboundparam", this.names.get(i)));
        }
    }

    public void setValues(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                this.defineValueByName(string, v);
            }
        }
    }

    public Object getValueByName(String string) {
        int n = this.names.indexOf(string);
        if (n == -1) {
            throw new JDOFatalInternalException("ParameterTable.getValueByName: undefined parameter " + string);
        }
        return this.getValueByIndex(n);
    }

    public Object getValueByIndex(int n) {
        if (n < 0 || n >= this.values.size()) {
            throw new JDOFatalInternalException("ParameterTable.getValueByIndex: wrong index " + n);
        }
        return this.values.get(n);
    }

    public List getValues() {
        return this.values;
    }

    public ValueFetcher getValueFetcher() {
        return new QueryValueFetcher(this.values.toArray(new Object[this.values.size()]));
    }

    public String getKeyForRetrieveDescCache() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.values.get(i);
            Object e2 = this.types.get(i);
            if (e2 instanceof ClassType && ((ClassType)e2).isPersistenceCapable()) {
                return null;
            }
            if (e == null) {
                stringBuffer.append(NULL_);
            } else if (e instanceof Boolean) {
                if (((Boolean)e).booleanValue()) {
                    stringBuffer.append(TRUE_);
                } else {
                    stringBuffer.append(FALSE_);
                }
            } else {
                stringBuffer.append(OTHER_);
            }
            stringBuffer.append('/');
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(NOPARAMS_);
        }
        return stringBuffer.toString();
    }

    public boolean inline(String string) {
        int n = this.names.indexOf(string);
        Object e = this.values.get(n);
        Object e2 = this.types.get(n);
        if (e2 instanceof ClassType && ((ClassType)e2).isPersistenceCapable()) {
            return true;
        }
        if (e == null) {
            return true;
        }
        return e instanceof Boolean;
    }

    public Integer getIndexForParamName(String string) {
        return new Integer(this.names.indexOf(string));
    }

    public ParameterInfo getParameterInfoForParamName(String string) {
        int n = this.names.indexOf(string);
        Type type = (Type)this.types.get(n);
        return new ParameterInfo(n, type.getEnumType());
    }

    private void defineValueByName(String string, Object object) {
        int n = this.names.indexOf(string);
        if (n == -1) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.parametertable.definevaluebyname.undefinedparam", string));
        }
        this.defineValueByIndex(n, object);
    }

    private void defineValueByIndex(int n, Object object) {
        if (n < 0) {
            throw new JDOFatalInternalException("ParameterTable.defineValueByIndex: wrong index " + n);
        }
        if (n >= this.types.size()) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.parametertable.definevaluebyindex.wrongnumberofargs"));
        }
        Class clazz = ((Type)this.types.get(n)).getJavaClass();
        if (!this.isCompatibleValue(clazz, object)) {
            String string = object == null ? "<type of null>" : object.getClass().getName();
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.parametertable.definevaluebyindex.typemismatch", string, clazz.getName()));
        }
        this.values.set(n, object);
    }

    private boolean isCompatibleValue(Class clazz, Object object) {
        boolean bl = true;
        if (object == null) {
            bl = !clazz.isPrimitive();
        } else {
            Class<?> clazz2 = object.getClass();
            if (clazz.isPrimitive()) {
                clazz = JavaTypeHelper.getWrapperClass(clazz);
            }
            bl = clazz.isAssignableFrom(clazz2);
        }
        return bl;
    }

    static class Unbound {
        Unbound() {
        }
    }
}

