/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.CodeGeneration;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.OptimizerTokenTypes;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumberType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.ResourceBundle;

public class Optimizer
extends TreeParser
implements OptimizerTokenTypes {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(Optimizer.class);
    protected TypeTable typetab;
    protected ParameterTable paramtab;
    protected ErrorMsg errorMsg;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"import\"", "\"this\"", "\"ascending\"", "\"descending\"", "\"distinct\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "\"null\"", "\"true\"", "\"false\"", "LPAREN", "RPAREN", "COMMA", "EQUAL", "LNOT", "BNOT", "NOT_EQUAL", "DIV", "PLUS", "MINUS", "STAR", "MOD", "GE", "GT", "LE", "LT", "BXOR", "BOR", "OR", "BAND", "AND", "SEMI", "WS", "NEWLINE", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "HEX_DIGIT", "INT_LITERAL", "EXPONENT", "FLOAT_SUFFIX", "DOUBLE_SUFFIX", "an identifier", "UNICODE_DIGIT", "UNICODE_STR", "QUERY", "CLASS_DEF", "IMPORT_DEF", "PARAMETER_DEF", "VARIABLE_DEF", "ORDERING_DEF", "FILTER_DEF", "ARG_LIST", "UNARY_MINUS", "UNARY_PLUS", "TYPECAST", "OBJECT_EQUAL", "OBJECT_NOT_EQUAL", "COLLECTION_EQUAL", "COLLECTION_NOT_EQUAL", "CONCAT", "FIELD_ACCESS", "STATIC_FIELD_ACCESS", "CONTAINS", "NOT_CONTAINS", "NAVIGATION", "STARTS_WITH", "ENDS_WITH", "IS_EMPTY", "VARIABLE", "PARAMETER", "TYPENAME", "VALUE", "RESULT_DEF", "LIKE", "SUBSTRING", "INDEXOF", "LENGTH", "ABS", "SQRT", "NOT_IN", "DOT", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL"};

    public void init(TypeTable typeTable, ParameterTable parameterTable, ErrorMsg errorMsg) {
        this.typetab = typeTable;
        this.paramtab = parameterTable;
        this.errorMsg = errorMsg;
    }

    public void reportError(RecognitionException recognitionException) {
        this.errorMsg.fatal("Optimizer error", recognitionException);
    }

    public void reportError(String string) {
        this.errorMsg.fatal("Optimizer error: " + string);
    }

    protected static char parseChar(String string) {
        char c = string.charAt(0);
        if (c == '\\') {
            char c2 = string.charAt(1);
            switch (c2) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
                case 'u': {
                    return (char)Integer.parseInt(string.substring(2, string.length()), 16);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return (char)Integer.parseInt(string.substring(1, string.length()), 8);
                }
            }
            return c2;
        }
        return c;
    }

    protected JQLAST checkAnd(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (this.isBooleanValueAST(jQLAST2)) {
            jQLAST4 = this.handleValueAndExpr(jQLAST, jQLAST2.getValue(), jQLAST3);
        } else if (this.isBooleanValueAST(jQLAST3)) {
            jQLAST4 = this.handleValueAndExpr(jQLAST, jQLAST3.getValue(), jQLAST2);
        }
        return jQLAST4;
    }

    protected JQLAST checkOr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (this.isBooleanValueAST(jQLAST2)) {
            jQLAST4 = this.handleValueOrExpr(jQLAST, jQLAST2.getValue(), jQLAST3);
        } else if (this.isBooleanValueAST(jQLAST3)) {
            jQLAST4 = this.handleValueOrExpr(jQLAST, jQLAST3.getValue(), jQLAST2);
        }
        return jQLAST4;
    }

    protected JQLAST checkEqualityOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, boolean bl) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            jQLAST4 = this.handleValueEqValue(jQLAST, jQLAST2, jQLAST3, bl);
        } else if (this.isBooleanValueAST(jQLAST2)) {
            jQLAST4 = this.handleBooleanValueEqExpr(jQLAST, jQLAST2.getValue(), jQLAST3, bl);
        } else if (this.isBooleanValueAST(jQLAST3)) {
            jQLAST4 = this.handleBooleanValueEqExpr(jQLAST, jQLAST3.getValue(), jQLAST2, bl);
        }
        return jQLAST4;
    }

    protected JQLAST checkObjectEqualityOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, boolean bl) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            jQLAST4 = this.handleValueEqValue(jQLAST, jQLAST2, jQLAST3, bl);
        }
        return jQLAST4;
    }

    protected JQLAST checkCollectionEqualityOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, boolean bl) {
        boolean bl2;
        JQLAST jQLAST4 = jQLAST;
        boolean bl3 = jQLAST2.getType() == 82;
        boolean bl4 = bl2 = jQLAST3.getType() == 82;
        if (bl3 && bl2) {
            jQLAST4 = this.handleValueEqValue(jQLAST, jQLAST2, jQLAST3, bl);
        } else if (bl3 && jQLAST2.getValue() == null && this.isNonConstantCollection(jQLAST3) || bl2 && jQLAST3.getValue() == null && this.isNonConstantCollection(jQLAST2)) {
            jQLAST4.setType(82);
            jQLAST4.setValue(new Boolean(bl));
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkLogicalNotOp(JQLAST jQLAST, JQLAST jQLAST2) {
        JQLAST jQLAST3 = jQLAST;
        if (jQLAST2.getType() == 82) {
            Object object = jQLAST2.getValue();
            boolean bl = object instanceof Boolean ? (Boolean)object : false;
            jQLAST2.setType(82);
            jQLAST2.setValue(new Boolean(!bl));
            jQLAST2.setNextSibling(null);
            jQLAST3 = jQLAST2;
        } else {
            jQLAST3 = this.deMorgan(jQLAST2);
        }
        return jQLAST3;
    }

    protected JQLAST checkBinaryPlusOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            Object object = jQLAST2.getValue();
            Object object2 = jQLAST3.getValue();
            Object object3 = null;
            if (object == null) {
                object3 = object2;
            } else if (object2 == null) {
                object3 = object;
            } else {
                Type type = jQLAST.getJQLType();
                if (type instanceof NumericWrapperClassType) {
                    type = ((NumericWrapperClassType)type).getPrimitiveType();
                }
                if (type.equals(this.typetab.intType)) {
                    object3 = new Integer(((Number)object).intValue() + ((Number)object2).intValue());
                } else if (type.equals(this.typetab.longType)) {
                    object3 = new Long(((Number)object).longValue() + ((Number)object2).longValue());
                } else if (type.equals(this.typetab.floatType)) {
                    object3 = new Float(((Number)object).floatValue() + ((Number)object2).floatValue());
                } else if (type.equals(this.typetab.doubleType)) {
                    object3 = new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
                } else if (type.equals(this.typetab.bigDecimalType)) {
                    object3 = this.getBigDecimalValue(object).add(this.getBigDecimalValue(object2));
                } else if (type.equals(this.typetab.bigIntegerType)) {
                    object3 = this.getBigIntegerValue(object).add(this.getBigIntegerValue(object2));
                } else {
                    this.errorMsg.fatal("Optimizer.checkBinaryPlusOp: invalid type " + type);
                }
            }
            jQLAST4.setType(82);
            jQLAST4.setValue(object3);
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkConcatOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            Object object = jQLAST2.getValue();
            Object object2 = jQLAST3.getValue();
            Object object3 = null;
            object3 = object == null ? object2 : (object2 == null ? object : object.toString() + object2.toString());
            jQLAST4.setType(82);
            jQLAST4.setValue(object3);
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkBinaryMinusOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            Object object = jQLAST2.getValue();
            Object object2 = jQLAST3.getValue();
            Object object3 = null;
            if (object2 == null) {
                object3 = object;
            } else {
                Type type;
                if (object == null) {
                    object = new Integer(0);
                }
                if ((type = jQLAST.getJQLType()) instanceof NumericWrapperClassType) {
                    type = ((NumericWrapperClassType)type).getPrimitiveType();
                }
                if (type.equals(this.typetab.intType)) {
                    object3 = new Integer(((Number)object).intValue() - ((Number)object2).intValue());
                } else if (type.equals(this.typetab.longType)) {
                    object3 = new Long(((Number)object).longValue() - ((Number)object2).longValue());
                } else if (type.equals(this.typetab.floatType)) {
                    object3 = new Float(((Number)object).floatValue() - ((Number)object2).floatValue());
                } else if (type.equals(this.typetab.doubleType)) {
                    object3 = new Double(((Number)object).doubleValue() - ((Number)object2).doubleValue());
                } else if (type.equals(this.typetab.bigDecimalType)) {
                    object3 = this.getBigDecimalValue(object).subtract(this.getBigDecimalValue(object2));
                } else if (type.equals(this.typetab.bigIntegerType)) {
                    object3 = this.getBigIntegerValue(object).subtract(this.getBigIntegerValue(object2));
                } else {
                    this.errorMsg.fatal("Optimizer.checkBinaryMinusOp: invalid type " + type);
                }
            }
            jQLAST4.setType(82);
            jQLAST4.setValue(object3);
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkMultiplicationOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            Type type;
            Object object = jQLAST2.getValue();
            Object object2 = jQLAST3.getValue();
            Number number = null;
            if (object == null) {
                object = new Integer(0);
            }
            if (object2 == null) {
                object2 = new Integer(0);
            }
            if ((type = jQLAST.getJQLType()) instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                number = new Integer(((Number)object).intValue() * ((Number)object2).intValue());
            } else if (type.equals(this.typetab.longType)) {
                number = new Long(((Number)object).longValue() * ((Number)object2).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                number = new Float(((Number)object).floatValue() * ((Number)object2).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                number = new Double(((Number)object).doubleValue() * ((Number)object2).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                number = this.getBigDecimalValue(object).multiply(this.getBigDecimalValue(object2));
            } else if (type.equals(this.typetab.bigIntegerType)) {
                number = this.getBigIntegerValue(object).multiply(this.getBigIntegerValue(object2));
            } else {
                this.errorMsg.fatal("Optimizer.checkMultiplicationOp: invalid type " + type);
            }
            jQLAST4.setType(82);
            jQLAST4.setValue(number);
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkDivisionOp(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        JQLAST jQLAST4 = jQLAST;
        if (jQLAST2.getType() == 82 && jQLAST3.getType() == 82) {
            Type type;
            Object object = jQLAST2.getValue();
            Object object2 = jQLAST3.getValue();
            Number number = null;
            if (object == null) {
                object = new Integer(0);
            }
            if (object2 == null) {
                object2 = new Integer(0);
            }
            if ((type = jQLAST.getJQLType()) instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                number = new Integer(((Number)object).intValue() / ((Number)object2).intValue());
            } else if (type.equals(this.typetab.longType)) {
                number = new Long(((Number)object).longValue() / ((Number)object2).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                number = new Float(((Number)object).floatValue() / ((Number)object2).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                number = new Double(((Number)object).doubleValue() / ((Number)object2).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                number = this.getBigDecimalValue(object).divide(this.getBigDecimalValue(object2), 6);
            } else if (type.equals(this.typetab.bigIntegerType)) {
                number = this.getBigIntegerValue(object).divide(this.getBigIntegerValue(object2));
            } else {
                this.errorMsg.fatal("Optimizer.checkDivisionOp: invalid type " + type);
            }
            jQLAST4.setType(82);
            jQLAST4.setValue(number);
            jQLAST4.setFirstChild(null);
        }
        return jQLAST4;
    }

    protected JQLAST checkUnaryMinusOp(JQLAST jQLAST, JQLAST jQLAST2) {
        JQLAST jQLAST3 = jQLAST;
        if (jQLAST2.getType() == 82) {
            Object object = jQLAST2.getValue();
            Type type = jQLAST.getJQLType();
            Number number = null;
            if (type instanceof NumberType) {
                number = ((NumberType)((Object)type)).negate((Number)object);
            } else {
                this.errorMsg.fatal("Optimizer.checkUnaryMinusOp: invalid type " + type);
            }
            jQLAST3.setType(82);
            jQLAST3.setValue(number);
            jQLAST3.setFirstChild(null);
        }
        return jQLAST3;
    }

    protected BigDecimal getBigDecimalValue(Object object) {
        BigDecimal bigDecimal = null;
        if (object instanceof Number) {
            bigDecimal = (BigDecimal)this.typetab.bigDecimalType.getValue((Number)object);
        } else {
            this.errorMsg.fatal("Optimizer.getBigDecimalValue: expected number value " + object);
        }
        return bigDecimal;
    }

    protected BigInteger getBigIntegerValue(Object object) {
        BigInteger bigInteger = null;
        if (object instanceof Number) {
            bigInteger = (BigInteger)this.typetab.bigIntegerType.getValue((Number)object);
        } else {
            this.errorMsg.fatal("Optimizer.getBigIntegerValue: expected number value " + object);
        }
        return bigInteger;
    }

    protected JQLAST handleValueEqValue(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, boolean bl) {
        Object object = jQLAST2.getValue();
        Object object2 = jQLAST3.getValue();
        boolean bl2 = false;
        bl2 = object == null && object2 == null ? true : (object != null && object2 != null ? object.equals(object2) : false);
        if (bl) {
            bl2 = !bl2;
        }
        jQLAST.setType(82);
        jQLAST.setValue(new Boolean(bl2));
        jQLAST.setFirstChild(null);
        return jQLAST;
    }

    private JQLAST handleBooleanValueEqExpr(JQLAST jQLAST, Object object, JQLAST jQLAST2, boolean bl) {
        JQLAST jQLAST3;
        boolean bl2;
        boolean bl3 = bl2 = object instanceof Boolean ? (Boolean)object : false;
        if (bl) {
            boolean bl4 = bl2 = !bl2;
        }
        if (bl2) {
            jQLAST3 = jQLAST2;
        } else {
            switch (jQLAST2.getType()) {
                case 23: {
                    jQLAST2.setType(26);
                    jQLAST2.setText("!=");
                    jQLAST3 = jQLAST2;
                    break;
                }
                case 26: {
                    jQLAST2.setType(23);
                    jQLAST2.setText("==");
                    jQLAST3 = jQLAST2;
                    break;
                }
                case 24: {
                    jQLAST3 = (JQLAST)jQLAST2.getFirstChild();
                    break;
                }
                default: {
                    jQLAST.setType(24);
                    jQLAST.setText("!");
                    jQLAST.setFirstChild(jQLAST2);
                    jQLAST3 = jQLAST;
                }
            }
            jQLAST2.setNextSibling(null);
        }
        return jQLAST3;
    }

    private JQLAST handleValueAndExpr(JQLAST jQLAST, Object object, JQLAST jQLAST2) {
        JQLAST jQLAST3;
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            jQLAST2.setNextSibling(null);
            jQLAST3 = jQLAST2;
        } else {
            jQLAST.setType(82);
            jQLAST.setText("false");
            jQLAST.setValue(new Boolean(false));
            jQLAST.setFirstChild(null);
            jQLAST3 = jQLAST;
        }
        return jQLAST3;
    }

    private JQLAST handleValueOrExpr(JQLAST jQLAST, Object object, JQLAST jQLAST2) {
        JQLAST jQLAST3;
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            jQLAST.setType(82);
            jQLAST.setText("true");
            jQLAST.setValue(new Boolean(true));
            jQLAST.setFirstChild(null);
            jQLAST3 = jQLAST;
        } else {
            jQLAST2.setNextSibling(null);
            jQLAST3 = jQLAST2;
        }
        return jQLAST3;
    }

    protected boolean isBooleanValueAST(JQLAST jQLAST) {
        return jQLAST.getType() == 82 && this.typetab.booleanType.equals(jQLAST.getJQLType());
    }

    protected boolean isNonConstantCollection(JQLAST jQLAST) {
        switch (jQLAST.getType()) {
            case 71: 
            case 75: {
                return true;
            }
            case 65: {
                JQLAST jQLAST2 = (JQLAST)jQLAST.getFirstChild().getNextSibling();
                return this.isNonConstantCollection(jQLAST2);
            }
        }
        return false;
    }

    protected JQLAST deMorgan(JQLAST jQLAST) {
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        switch (jQLAST.getType()) {
            case 39: 
            case 40: {
                jQLAST3 = (JQLAST)jQLAST.getFirstChild();
                jQLAST4 = (JQLAST)jQLAST3.getNextSibling();
                String string = this.getVariableFromContainsClause(jQLAST3);
                String string2 = this.getVariableFromContainsClause(jQLAST4);
                if (string != null) {
                    jQLAST2 = this.buildAST(jQLAST, jQLAST3, this.deMorgan(jQLAST4, string));
                    break;
                }
                if (string2 != null) {
                    jQLAST2 = this.buildAST(jQLAST, jQLAST4, this.deMorgan(jQLAST3, string2));
                    break;
                }
                this.invertNode(jQLAST);
                jQLAST2 = this.buildAST(jQLAST, this.deMorgan(jQLAST3), this.deMorgan(jQLAST4));
                break;
            }
            case 37: 
            case 38: {
                jQLAST3 = (JQLAST)jQLAST.getFirstChild();
                jQLAST4 = (JQLAST)jQLAST3.getNextSibling();
                this.invertNode(jQLAST);
                jQLAST2 = this.buildAST(jQLAST, this.deMorgan(jQLAST3), this.deMorgan(jQLAST4));
                break;
            }
            case 24: {
                jQLAST2 = (JQLAST)jQLAST.getFirstChild();
                break;
            }
            default: {
                jQLAST2 = this.buildAST(new JQLAST(24, "!", this.typetab.booleanType), jQLAST);
            }
        }
        return jQLAST2;
    }

    protected JQLAST deMorgan(JQLAST jQLAST, String string) {
        JQLAST jQLAST2 = jQLAST;
        switch (jQLAST.getType()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                JQLAST jQLAST3 = (JQLAST)jQLAST.getFirstChild();
                JQLAST jQLAST4 = (JQLAST)jQLAST3.getNextSibling();
                if (!this.includesVariableAccess(jQLAST3, string) || !this.includesVariableAccess(jQLAST4, string)) {
                    this.invertNode(jQLAST);
                }
                jQLAST2 = this.buildAST(jQLAST, this.deMorgan(jQLAST3, string), this.deMorgan(jQLAST4, string));
                break;
            }
            default: {
                if (this.includesVariableAccess(jQLAST, string)) break;
                jQLAST2 = this.deMorgan(jQLAST);
            }
        }
        return jQLAST2;
    }

    protected String getVariableFromContainsClause(JQLAST jQLAST) {
        switch (jQLAST.getType()) {
            case 73: 
            case 74: {
                return jQLAST.getFirstChild().getNextSibling().getText();
            }
        }
        return null;
    }

    protected boolean includesVariableAccess(AST aST, String string) {
        if (aST == null || string == null) {
            return false;
        }
        boolean bl = false;
        JQLAST jQLAST = (JQLAST)aST.getFirstChild();
        if (aST.getType() == 79 && aST.getText().equals(string) && jQLAST != null) {
            bl = true;
            if (jQLAST.getType() != 90) {
                aST.setFirstChild(this.buildAST(new JQLAST(90, "notIn", this.typetab.booleanType), jQLAST));
            }
        }
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (!this.includesVariableAccess(aST2, string)) continue;
            bl = true;
        }
        return bl;
    }

    protected void invertNode(JQLAST jQLAST) {
        switch (jQLAST.getType()) {
            case 40: {
                jQLAST.setType(38);
                jQLAST.setText("||");
                break;
            }
            case 39: {
                jQLAST.setType(37);
                jQLAST.setText("|");
                break;
            }
            case 38: {
                jQLAST.setType(40);
                jQLAST.setText("&&");
                break;
            }
            case 37: {
                jQLAST.setType(39);
                jQLAST.setText("&");
                break;
            }
            case 23: {
                jQLAST.setType(26);
                jQLAST.setText("!=");
                break;
            }
            case 26: {
                jQLAST.setType(23);
                jQLAST.setText("==");
                break;
            }
            case 35: {
                jQLAST.setType(32);
                jQLAST.setText(">=");
                break;
            }
            case 34: {
                jQLAST.setType(33);
                jQLAST.setText(">");
                break;
            }
            case 33: {
                jQLAST.setType(34);
                jQLAST.setText("<=");
                break;
            }
            case 32: {
                jQLAST.setType(35);
                jQLAST.setText("<");
            }
        }
    }

    protected JQLAST buildAST(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        jQLAST.setFirstChild(jQLAST2);
        jQLAST2.setNextSibling(jQLAST3);
        jQLAST3.setNextSibling(null);
        return jQLAST;
    }

    protected JQLAST buildAST(JQLAST jQLAST, JQLAST jQLAST2) {
        jQLAST.setFirstChild(jQLAST2);
        jQLAST2.setNextSibling(null);
        return jQLAST;
    }

    public Optimizer() {
        this.tokenNames = _tokenNames;
    }

    public final void query(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        AST aST2 = aST;
        jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 55);
        aST = aST.getFirstChild();
        this.candidateClass(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.parameters(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.variables(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.ordering(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.result(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.filter(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void candidateClass(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("setCandidates");
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        this.match(aST, 56);
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void parameters(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("declareParameters");
        while (true) {
            if (aST == null) {
                aST = ASTNULL;
            }
            if (aST.getType() != 58) break;
            this.declareParameter(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void variables(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("declareVariables");
        while (true) {
            if (aST == null) {
                aST = ASTNULL;
            }
            if (aST.getType() != 59) break;
            this.declareVariable(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void ordering(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("setOrdering");
        while (true) {
            if (aST == null) {
                aST = ASTNULL;
            }
            if (aST.getType() != 60) break;
            this.orderSpec(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void result(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        this.errorMsg.setContext("setResult");
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 83: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 83);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 8: {
                        JQLAST jQLAST7 = null;
                        JQLAST jQLAST8 = null;
                        jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                        jQLAST8 = (JQLAST)aST;
                        this.astFactory.addASTChild(aSTPair, jQLAST7);
                        this.match(aST, 8);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 5: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 44: 
                    case 45: 
                    case 48: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 82: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 92: 
                    case 93: 
                    case 94: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 61: {
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void filter(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("setFilter");
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 61);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void declareParameter(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 58);
        aST = aST.getFirstChild();
        this.type(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST6 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST5);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void type(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 81: {
                JQLAST jQLAST3 = null;
                JQLAST jQLAST4 = null;
                jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST4 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST3);
                this.match(aST, 81);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.primitiveType(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void declareVariable(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 59);
        aST = aST.getFirstChild();
        this.type(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST6 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST5);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void orderSpec(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 60);
        aST = aST.getFirstChild();
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 6: {
                JQLAST jQLAST5 = null;
                JQLAST jQLAST6 = null;
                jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST6 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST5);
                this.match(aST, 6);
                aST = aST.getNextSibling();
                break;
            }
            case 7: {
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                this.match(aST, 7);
                aST = aST.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void expression(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 44: 
            case 45: 
            case 48: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                this.primary(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 36: 
            case 37: 
            case 39: {
                this.bitwiseExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 38: 
            case 40: {
                this.conditionalExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 23: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                this.relationalExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 70: {
                this.binaryArithmeticExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 63: 
            case 64: {
                this.unaryArithmeticExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 24: 
            case 25: {
                this.complementExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void primary(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 65: {
                AST aST2 = aST;
                JQLAST jQLAST3 = null;
                JQLAST jQLAST4 = null;
                jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST4 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST3);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 65);
                aST = aST.getFirstChild();
                this.type(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 44: 
            case 45: 
            case 48: 
            case 92: 
            case 93: 
            case 94: {
                this.literal(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 82: {
                JQLAST jQLAST5 = null;
                JQLAST jQLAST6 = null;
                jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST6 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST5);
                this.match(aST, 82);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 5: {
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                this.match(aST, 5);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 80: {
                this.parameter(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 72: {
                this.staticFieldAccess(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 71: {
                this.fieldAccess(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 75: {
                this.navigation(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 79: {
                this.variableAccess(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 73: {
                AST aST3 = aST;
                JQLAST jQLAST9 = null;
                JQLAST jQLAST10 = null;
                jQLAST9 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST10 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST9);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 73);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                JQLAST jQLAST11 = null;
                JQLAST jQLAST12 = null;
                jQLAST11 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST12 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST11);
                this.match(aST, 79);
                aST = aST.getNextSibling();
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 74: {
                AST aST4 = aST;
                JQLAST jQLAST13 = null;
                JQLAST jQLAST14 = null;
                jQLAST13 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST14 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST13);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 74);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                JQLAST jQLAST15 = null;
                JQLAST jQLAST16 = null;
                jQLAST15 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST16 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST15);
                this.match(aST, 79);
                aST = aST.getNextSibling();
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 76: {
                this.startsWith(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 77: {
                this.endsWith(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 78: {
                this.isEmpty(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 84: {
                this.like(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 85: {
                this.substring(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 86: {
                this.indexOf(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 87: {
                this.length(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 88: {
                this.abs(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 89: {
                this.sqrt(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void bitwiseExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 39: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 39);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkAnd(jQLAST4, jQLAST5, jQLAST7);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 37: {
                AST aST3 = aST;
                jQLAST9 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 37);
                aST = aST.getFirstChild();
                jQLAST12 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkOr(jQLAST10, jQLAST11, jQLAST13);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 36: {
                AST aST4 = aST;
                jQLAST15 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 36);
                aST = aST.getFirstChild();
                jQLAST18 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void conditionalExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 40: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 40);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkAnd(jQLAST4, jQLAST5, jQLAST7);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 38: {
                AST aST3 = aST;
                jQLAST9 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 38);
                aST = aST.getFirstChild();
                jQLAST12 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkOr(jQLAST10, jQLAST11, jQLAST13);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void relationalExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        JQLAST jQLAST21 = null;
        JQLAST jQLAST22 = null;
        JQLAST jQLAST23 = null;
        JQLAST jQLAST24 = null;
        JQLAST jQLAST25 = null;
        JQLAST jQLAST26 = null;
        JQLAST jQLAST27 = null;
        JQLAST jQLAST28 = null;
        JQLAST jQLAST29 = null;
        JQLAST jQLAST30 = null;
        JQLAST jQLAST31 = null;
        JQLAST jQLAST32 = null;
        JQLAST jQLAST33 = null;
        JQLAST jQLAST34 = null;
        JQLAST jQLAST35 = null;
        JQLAST jQLAST36 = null;
        JQLAST jQLAST37 = null;
        JQLAST jQLAST38 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 23: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 23);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkEqualityOp(jQLAST4, jQLAST5, jQLAST7, false);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 26: {
                AST aST3 = aST;
                jQLAST9 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 26);
                aST = aST.getFirstChild();
                jQLAST12 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkEqualityOp(jQLAST10, jQLAST11, jQLAST13, true);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 66: {
                AST aST4 = aST;
                jQLAST15 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 66);
                aST = aST.getFirstChild();
                jQLAST18 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkObjectEqualityOp(jQLAST16, jQLAST17, jQLAST19, false);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 67: {
                AST aST5 = aST;
                jQLAST21 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST22 = (JQLAST)this.astFactory.create(jQLAST21);
                this.astFactory.addASTChild(aSTPair, jQLAST22);
                ASTPair aSTPair5 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 67);
                aST = aST.getFirstChild();
                jQLAST24 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST23 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST26 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST25 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair5;
                aST = aST5;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkObjectEqualityOp(jQLAST22, jQLAST23, jQLAST25, true);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 68: {
                AST aST6 = aST;
                jQLAST27 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST28 = (JQLAST)this.astFactory.create(jQLAST27);
                this.astFactory.addASTChild(aSTPair, jQLAST28);
                ASTPair aSTPair6 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 68);
                aST = aST.getFirstChild();
                jQLAST30 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST29 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST32 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST31 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair6;
                aST = aST6;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkCollectionEqualityOp(jQLAST28, jQLAST29, jQLAST31, false);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 69: {
                AST aST7 = aST;
                jQLAST33 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST34 = (JQLAST)this.astFactory.create(jQLAST33);
                this.astFactory.addASTChild(aSTPair, jQLAST34);
                ASTPair aSTPair7 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 69);
                aST = aST.getFirstChild();
                jQLAST36 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST35 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST38 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST37 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair7;
                aST = aST7;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkCollectionEqualityOp(jQLAST34, jQLAST35, jQLAST37, true);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 35: {
                AST aST8 = aST;
                JQLAST jQLAST39 = null;
                JQLAST jQLAST40 = null;
                jQLAST39 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST40 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST39);
                ASTPair aSTPair8 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 35);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair8;
                aST = aST8;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 33: {
                AST aST9 = aST;
                JQLAST jQLAST41 = null;
                JQLAST jQLAST42 = null;
                jQLAST41 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST42 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST41);
                ASTPair aSTPair9 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 33);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair9;
                aST = aST9;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 34: {
                AST aST10 = aST;
                JQLAST jQLAST43 = null;
                JQLAST jQLAST44 = null;
                jQLAST43 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST44 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST43);
                ASTPair aSTPair10 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 34);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair10;
                aST = aST10;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 32: {
                AST aST11 = aST;
                JQLAST jQLAST45 = null;
                JQLAST jQLAST46 = null;
                jQLAST45 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST46 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST45);
                ASTPair aSTPair11 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 32);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair11;
                aST = aST11;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void binaryArithmeticExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        JQLAST jQLAST21 = null;
        JQLAST jQLAST22 = null;
        JQLAST jQLAST23 = null;
        JQLAST jQLAST24 = null;
        JQLAST jQLAST25 = null;
        JQLAST jQLAST26 = null;
        JQLAST jQLAST27 = null;
        JQLAST jQLAST28 = null;
        JQLAST jQLAST29 = null;
        JQLAST jQLAST30 = null;
        JQLAST jQLAST31 = null;
        JQLAST jQLAST32 = null;
        JQLAST jQLAST33 = null;
        JQLAST jQLAST34 = null;
        JQLAST jQLAST35 = null;
        JQLAST jQLAST36 = null;
        JQLAST jQLAST37 = null;
        JQLAST jQLAST38 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 28: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 28);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkBinaryPlusOp(jQLAST4, jQLAST5, jQLAST7);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 70: {
                AST aST3 = aST;
                jQLAST9 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 70);
                aST = aST.getFirstChild();
                jQLAST12 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkConcatOp(jQLAST10, jQLAST11, jQLAST13);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 29: {
                AST aST4 = aST;
                jQLAST15 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 29);
                aST = aST.getFirstChild();
                jQLAST18 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkBinaryMinusOp(jQLAST16, jQLAST17, jQLAST19);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 30: {
                AST aST5 = aST;
                jQLAST21 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST22 = (JQLAST)this.astFactory.create(jQLAST21);
                this.astFactory.addASTChild(aSTPair, jQLAST22);
                ASTPair aSTPair5 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 30);
                aST = aST.getFirstChild();
                jQLAST24 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST23 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST26 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST25 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair5;
                aST = aST5;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkMultiplicationOp(jQLAST22, jQLAST23, jQLAST25);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 27: {
                AST aST6 = aST;
                jQLAST27 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST28 = (JQLAST)this.astFactory.create(jQLAST27);
                this.astFactory.addASTChild(aSTPair, jQLAST28);
                ASTPair aSTPair6 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 27);
                aST = aST.getFirstChild();
                jQLAST30 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST29 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST32 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST31 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair6;
                aST = aST6;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkDivisionOp(jQLAST28, jQLAST29, jQLAST31);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 31: {
                AST aST7 = aST;
                jQLAST33 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST34 = (JQLAST)this.astFactory.create(jQLAST33);
                this.astFactory.addASTChild(aSTPair, jQLAST34);
                ASTPair aSTPair7 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 31);
                aST = aST.getFirstChild();
                jQLAST36 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST35 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST38 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST37 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair7;
                aST = aST7;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void unaryArithmeticExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 64: {
                AST aST2 = aST;
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 64);
                aST = aST.getFirstChild();
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 63: {
                AST aST3 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 63);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkUnaryMinusOp(jQLAST4, jQLAST5);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void complementExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 25: {
                AST aST2 = aST;
                jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 25);
                aST = aST.getFirstChild();
                jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 24: {
                AST aST3 = aST;
                jQLAST7 = aST == ASTNULL ? null : (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 24);
                aST = aST.getFirstChild();
                jQLAST10 = aST == ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST9 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                jQLAST2 = this.checkLogicalNotOp(jQLAST8, jQLAST9);
                aSTPair.root = jQLAST2;
                aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
                aSTPair.advanceChildToEnd();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void literal(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        Object object = null;
        jQLAST4 = aST == ASTNULL ? null : (JQLAST)aST;
        object = this.literalHelper(aST);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST3.setType(82);
        jQLAST3.setValue(object);
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void parameter(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        this.match(aST, 80);
        aST = aST.getNextSibling();
        if (this.paramtab.inline(jQLAST4.getText())) {
            jQLAST4.setType(82);
            jQLAST4.setValue(this.paramtab.getValueByName(jQLAST4.getText()));
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void staticFieldAccess(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        Object object = null;
        AST aST2 = aST;
        jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 72);
        aST = aST.getFirstChild();
        jQLAST5 = (JQLAST)aST;
        jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
        this.astFactory.addASTChild(aSTPair, jQLAST6);
        this.match(aST, 81);
        aST = aST.getNextSibling();
        jQLAST7 = (JQLAST)aST;
        jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
        this.astFactory.addASTChild(aSTPair, jQLAST8);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        ClassType classType = (ClassType)jQLAST5.getJQLType();
        FieldInfo fieldInfo = classType.getFieldInfo(jQLAST7.getText());
        try {
            object = fieldInfo.getField().get(null);
            jQLAST4.setType(82);
            jQLAST4.setValue(object);
            jQLAST4.setFirstChild(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jqlc.optimizer.staticfieldaccess.illegal", jQLAST7.getText(), classType.getName()), illegalAccessException);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void fieldAccess(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        AST aST2 = aST;
        jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 71);
        aST = aST.getFirstChild();
        jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
        this.expression(aST);
        aST = this._retTree;
        jQLAST5 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST7 = (JQLAST)aST;
        jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
        this.astFactory.addASTChild(aSTPair, jQLAST8);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        if (jQLAST5.getType() == 82) {
            Object object = jQLAST5.getValue();
            ClassType classType = (ClassType)jQLAST5.getJQLType();
            Object object2 = CodeGeneration.getFieldValue(classType, object, jQLAST8.getText());
            jQLAST4.setType(82);
            jQLAST4.setValue(object2);
            jQLAST4.setFirstChild(null);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void navigation(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        AST aST2 = aST;
        jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 75);
        aST = aST.getFirstChild();
        jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
        this.expression(aST);
        aST = this._retTree;
        jQLAST5 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST7 = (JQLAST)aST;
        jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
        this.astFactory.addASTChild(aSTPair, jQLAST8);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        if (jQLAST5.getType() == 82) {
            Object object = jQLAST5.getValue();
            ClassType classType = (ClassType)jQLAST5.getJQLType();
            Object object2 = CodeGeneration.getFieldValue(classType, object, jQLAST8.getText());
            jQLAST4.setType(82);
            jQLAST4.setValue(object2);
            jQLAST4.setFirstChild(null);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void variableAccess(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 79);
        aST = aST.getFirstChild();
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 48: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void startsWith(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 76);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void endsWith(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 77);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void isEmpty(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        AST aST2 = aST;
        jQLAST3 = aST == ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 78);
        aST = aST.getFirstChild();
        jQLAST6 = aST == ASTNULL ? null : (JQLAST)aST;
        this.expression(aST);
        aST = this._retTree;
        jQLAST5 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        if (jQLAST5.getType() == 82) {
            Object object = jQLAST5.getValue();
            Boolean bl = null;
            if (object == null) {
                bl = new Boolean(false);
            } else if (object instanceof Collection) {
                bl = new Boolean(((Collection)object).isEmpty());
            } else {
                this.errorMsg.fatal("CodeGeneration.constantValue: isEmpty requires collection value");
            }
            jQLAST4.setType(82);
            jQLAST4.setValue(bl);
            jQLAST4.setFirstChild(null);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void like(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 84);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 48: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void substring(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 85);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void indexOf(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 86);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 48: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                this.expression(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void length(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 87);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void abs(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 88);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void sqrt(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 89);
        aST = aST.getFirstChild();
        this.expression(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final Object literalHelper(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        Object object = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 18: {
                JQLAST jQLAST17 = null;
                JQLAST jQLAST18 = null;
                jQLAST17 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST18 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST17);
                this.match(aST, 18);
                aST = aST.getNextSibling();
                object = new Boolean(true);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 19: {
                JQLAST jQLAST19 = null;
                JQLAST jQLAST20 = null;
                jQLAST19 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST20 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST19);
                this.match(aST, 19);
                aST = aST.getNextSibling();
                object = new Boolean(false);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 48: {
                jQLAST3 = (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                this.match(aST, 48);
                aST = aST.getNextSibling();
                object = new Integer(jQLAST3.getText());
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 92: {
                jQLAST5 = (JQLAST)aST;
                jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
                this.astFactory.addASTChild(aSTPair, jQLAST6);
                this.match(aST, 92);
                aST = aST.getNextSibling();
                String string = jQLAST5.getText();
                char c = string.charAt(string.length() - 1);
                if (c == 'l' || c == 'L') {
                    string = string.substring(0, string.length() - 1);
                }
                object = new Long(string);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 93: {
                jQLAST7 = (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                this.match(aST, 93);
                aST = aST.getNextSibling();
                String string = jQLAST7.getText();
                char c = string.charAt(string.length() - 1);
                if (c == 'f' || c == 'F') {
                    string = string.substring(0, string.length() - 1);
                }
                object = new Float(string);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 94: {
                jQLAST9 = (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                this.match(aST, 94);
                aST = aST.getNextSibling();
                String string = jQLAST9.getText();
                char c = string.charAt(string.length() - 1);
                if (c == 'd' || c == 'd') {
                    string = string.substring(0, string.length() - 1);
                }
                object = new Double(string);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 44: {
                jQLAST11 = (JQLAST)aST;
                jQLAST12 = (JQLAST)this.astFactory.create(jQLAST11);
                this.astFactory.addASTChild(aSTPair, jQLAST12);
                this.match(aST, 44);
                aST = aST.getNextSibling();
                object = new Character(Optimizer.parseChar(jQLAST11.getText()));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 45: {
                jQLAST13 = (JQLAST)aST;
                jQLAST14 = (JQLAST)this.astFactory.create(jQLAST13);
                this.astFactory.addASTChild(aSTPair, jQLAST14);
                this.match(aST, 45);
                aST = aST.getNextSibling();
                object = jQLAST13.getText();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 17: {
                jQLAST15 = (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                this.match(aST, 17);
                aST = aST.getNextSibling();
                object = null;
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return object;
    }

    public final void primitiveType(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 9: {
                JQLAST jQLAST3 = null;
                JQLAST jQLAST4 = null;
                jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST4 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST3);
                this.match(aST, 9);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 10: {
                JQLAST jQLAST5 = null;
                JQLAST jQLAST6 = null;
                jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST6 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST5);
                this.match(aST, 10);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 11: {
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                this.match(aST, 11);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 12: {
                JQLAST jQLAST9 = null;
                JQLAST jQLAST10 = null;
                jQLAST9 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST10 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST9);
                this.match(aST, 12);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 13: {
                JQLAST jQLAST11 = null;
                JQLAST jQLAST12 = null;
                jQLAST11 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST12 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST11);
                this.match(aST, 13);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 14: {
                JQLAST jQLAST13 = null;
                JQLAST jQLAST14 = null;
                jQLAST13 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST14 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST13);
                this.match(aST, 14);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 15: {
                JQLAST jQLAST15 = null;
                JQLAST jQLAST16 = null;
                jQLAST15 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST16 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST15);
                this.match(aST, 15);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 16: {
                JQLAST jQLAST17 = null;
                JQLAST jQLAST18 = null;
                jQLAST17 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST18 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST17);
                this.match(aST, 16);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }
}

