/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public class ForeignFieldDesc
extends FieldDesc {
    private static Logger logger = LogHelperSQLStore.getLogger();
    public static final int ACT_CASCADE = 3;
    public static final int ACT_NONE = 0;
    public static final int ACT_NULLIFY = 1;
    public static final int ACT_RESTRICT = 2;
    public static final int ACT_AGGREGATE = 4;
    public transient ClassDesc foreignConfig;
    public transient int cardinalityLWB;
    public transient int cardinalityUPB;
    public transient int deleteAction;
    public transient ArrayList foreignFields;
    public transient ArrayList foreignColumns;
    public transient ArrayList localFields;
    public transient ArrayList localColumns;
    public transient ArrayList assocForeignFields;
    public transient ArrayList assocForeignColumns;
    public transient ArrayList assocLocalFields;
    public transient ArrayList assocLocalColumns;
    public transient int updateAction;
    private ForeignFieldDesc inverseRelationshipField;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", ForeignFieldDesc.class.getClassLoader());

    public boolean useJoinTable() {
        return this.assocLocalFields != null && this.assocLocalFields.size() > 0;
    }

    public ArrayList getLocalFields() {
        if (this.localFields == null) {
            this.localFields = new ArrayList();
        }
        return this.localFields;
    }

    public ArrayList getForeignFields() {
        if (this.foreignFields == null) {
            this.foreignFields = new ArrayList();
        }
        return this.foreignFields;
    }

    public ArrayList getAssocLocalFields() {
        if (this.assocLocalFields == null && this.assocLocalColumns != null) {
            this.assocLocalFields = new ArrayList();
        }
        return this.assocLocalFields;
    }

    public ArrayList getAssocForeignFields() {
        if (this.assocForeignFields == null) {
            this.assocForeignFields = new ArrayList();
        }
        return this.assocForeignFields;
    }

    public Collection newCollection() {
        try {
            Class clazz = this.getType();
            if (clazz == Collection.class) {
                return new ArrayList();
            }
            return (Collection)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.log(900, "sqlstore.exception.log", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(900, "sqlstore.exception.log", illegalAccessException);
        }
        return null;
    }

    public ForeignFieldDesc getInverseRelationshipField() {
        return this.inverseRelationshipField;
    }

    public void setInverseRelationshipField(ForeignFieldDesc foreignFieldDesc) {
        this.inverseRelationshipField = foreignFieldDesc;
    }

    public Object createObjectId(SQLStateManager sQLStateManager, FieldDesc fieldDesc, Object object) {
        Class clazz = this.foreignConfig.getOidClass();
        Object var5_5 = null;
        try {
            var5_5 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantnewoid", clazz.getName()), exception);
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (fieldDesc instanceof ForeignFieldDesc) {
            if ((fieldDesc.sqlProperties & 0x40) > 0) {
                arrayList = ((ForeignFieldDesc)fieldDesc).localFields;
                arrayList2 = ((ForeignFieldDesc)fieldDesc).foreignFields;
            } else {
                arrayList = ((ForeignFieldDesc)fieldDesc).foreignFields;
                arrayList2 = ((ForeignFieldDesc)fieldDesc).localFields;
            }
        }
        Field[] fieldArray = this.foreignConfig.getKeyFields();
        String[] stringArray = this.foreignConfig.getKeyFieldNames();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            for (int j = 0; j < this.foreignFields.size(); ++j) {
                FieldDesc fieldDesc2 = (FieldDesc)this.foreignFields.get(j);
                if (fieldDesc2.getName().compareTo(stringArray[i]) != 0) continue;
                Object object2 = null;
                FieldDesc fieldDesc3 = (FieldDesc)this.localFields.get(j);
                if (fieldDesc instanceof LocalFieldDesc) {
                    object2 = fieldDesc3 == fieldDesc ? object : fieldDesc3.getValue(sQLStateManager);
                } else {
                    int n = arrayList.indexOf(fieldDesc3);
                    if (n != -1) {
                        FieldDesc fieldDesc4 = (FieldDesc)arrayList2.get(n);
                        object2 = fieldDesc4.getValue((SQLStateManager)object);
                    } else {
                        object2 = fieldDesc3.getValue(sQLStateManager);
                    }
                }
                try {
                    field.set(var5_5, fieldDesc2.convertValue(object2, sQLStateManager));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantsetkeyfield", field.getName()), illegalAccessException);
                }
            }
        }
        return var5_5;
    }
}

