/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCO;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public class FieldDesc
implements Serializable {
    public static final int GROUP_DEFAULT = 1;
    public static final int GROUP_NONE = 0;
    public static final int PROP_IN_CONCURRENCY_CHECK = 1;
    public static final int PROP_LOG_ON_ACCESS = 2;
    public static final int PROP_LOG_ON_UPDATE = 4;
    public static final int PROP_MOD_BI_ON_UPDATE = 8;
    public static final int PROP_READ_ONLY = 16;
    public static final int PROP_RECORD_ON_UPDATE = 32;
    public static final int PROP_REF_INTEGRITY_UPDATES = 64;
    public static final int PROP_XLATE_FIELD = 128;
    public static final int PROP_PRIMARY_TRACKED_FIELD = 256;
    public static final int PROP_SECONDARY_TRACKED_FIELD = 512;
    public static final int PROP_TRACK_RELATIONSHIP_FIELD = 1024;
    public static final int PROP_PRIMARY_KEY_FIELD = 2048;
    public static final int PROP_VERTICAL_DISCRIMINATOR = 4096;
    public static final int PROP_HORIZONTAL_DISCRIMINATOR = 8192;
    public static final BigDecimal LONG_MIN_VALUE = new BigDecimal(String.valueOf(Long.MIN_VALUE));
    public static final BigDecimal LONG_MAX_VALUE = new BigDecimal(String.valueOf(Long.MAX_VALUE));
    public int absoluteID;
    public transient int fetchGroup;
    public transient int concurrencyGroup;
    public transient int sqlProperties;
    private transient Field field;
    private transient Class fieldType;
    private transient int enumFieldType;
    private String fieldName;
    private String declaringClassName;
    private transient Class declaringClass;
    public transient Class componentType;
    public boolean isPersistent;
    private ArrayList trackedFields;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", FieldDesc.class.getClassLoader());

    public FieldDesc() {
        this.sqlProperties |= 0x40;
        this.sqlProperties |= 1;
        this.sqlProperties |= 4;
        this.concurrencyGroup = -1;
    }

    public void setupDesc(Field field) {
        this.field = field;
        this.fieldName = field.getName();
        this.declaringClass = this.field.getDeclaringClass();
        this.declaringClassName = this.declaringClass.getName();
        this.fieldType = this.field.getType();
        this.enumFieldType = this.translateToEnumeratedFieldType(this.fieldType);
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this.fieldName, this.fieldType};
            logger.finest("sqlstore.model.fielddesc.setupdesc", objectArray);
        }
        this.initializeConcurrencyCheckProperty(this.fieldType);
    }

    protected void initializeConcurrencyCheckProperty(Class clazz) {
        if (this.isByteArrayType()) {
            this.sqlProperties &= 0xFFFFFFFE;
        }
    }

    public void setupDesc(final Class clazz, final String string) {
        Field field = null;
        field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return clazz.getDeclaredField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    logger.fine("sqlstore.model.filedesc.getdeclaredfiled.fail", string);
                    return null;
                }
            }
        });
        this.setupDesc(field);
    }

    public void setComponentType(Class clazz) {
        this.componentType = clazz;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class getType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        return Object.class;
    }

    public int getEnumType() {
        return this.enumFieldType;
    }

    public boolean isByteArrayType() {
        return this.enumFieldType == 51;
    }

    public String getName() {
        if (this.fieldName == null) {
            this.fieldName = "hidden" + -this.absoluteID;
        }
        return this.fieldName;
    }

    public Object getValue(StateManager stateManager) {
        if (stateManager == null) {
            return null;
        }
        if (this.absoluteID >= 0) {
            return ((PersistenceCapable)stateManager.getPersistent()).jdoGetField(this.absoluteID);
        }
        return stateManager.getHiddenValue(this.absoluteID);
    }

    public void setValue(StateManager stateManager, Object object) {
        if (stateManager == null) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        if (this.absoluteID >= 0) {
            if (bl) {
                if (object != null && (object instanceof com.sun.jdo.api.persistence.support.PersistenceCapable || object instanceof Collection)) {
                    Object[] objectArray = new Object[]{this.field.getName(), object.getClass()};
                    logger.finest("sqlstore.model.fielddesc.fieldname", objectArray);
                } else {
                    Object[] objectArray = new Object[]{this.field.getName(), object};
                    logger.finest("sqlstore.model.fielddesc.fieldname", objectArray);
                }
            }
            if (object == null) {
                switch (this.enumFieldType) {
                    case 1: {
                        object = new Boolean(false);
                        break;
                    }
                    case 2: {
                        object = new Character('\u0000');
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        object = this.convertValue(new Integer(0), stateManager);
                    }
                }
            }
            ((PersistenceCapable)stateManager.getPersistent()).jdoSetField(this.absoluteID, object);
        } else {
            if (bl) {
                Object[] objectArray = new Object[]{this.getName(), object};
                logger.finest("sqlstore.model.fielddesc.fieldname", objectArray);
            }
            stateManager.setHiddenValue(this.absoluteID, object);
        }
    }

    public Object convertValue(Object object, StateManager stateManager) {
        Object object2;
        boolean bl = logger.isLoggable(300);
        if (object == null) {
            if (bl) {
                logger.finest("sqlstore.model.fielddesc.convertvalue");
            }
            return object;
        }
        if (this.absoluteID < 0) {
            if (bl) {
                logger.finest("sqlstore.model.fielddesc.convertvalue.hidden", new Integer(this.absoluteID));
            }
            return object;
        }
        if (bl) {
            object2 = new Object[]{object, object.getClass().getName(), this.fieldType};
            logger.finest("sqlstore.model.fielddesc.convertvalue.from_to", (Object[])object2);
        }
        if (object instanceof Number) {
            object2 = (Number)object;
            switch (this.enumFieldType) {
                case 1: 
                case 11: {
                    if (((Number)object2).doubleValue() == 0.0) {
                        object = new Boolean(false);
                        break;
                    }
                    object = new Boolean(true);
                    break;
                }
                case 3: 
                case 13: {
                    if (object instanceof Byte) break;
                    this.assertIsValid((Number)object2, -128.0, 127.0);
                    object = new Byte(((Number)object2).byteValue());
                    break;
                }
                case 4: 
                case 14: {
                    if (object instanceof Short) break;
                    this.assertIsValid((Number)object2, -32768.0, 32767.0);
                    object = new Short(((Number)object2).shortValue());
                    break;
                }
                case 5: 
                case 15: {
                    if (object instanceof Integer) break;
                    this.assertIsValid((Number)object2, -2.147483648E9, 2.147483647E9);
                    object = new Integer(((Number)object2).intValue());
                    break;
                }
                case 6: 
                case 16: {
                    if (object instanceof Long) break;
                    this.assertIsValidLong((Number)object2);
                    object = new Long(((Number)object2).longValue());
                    break;
                }
                case 7: 
                case 17: {
                    if (object instanceof Float) break;
                    object = new Float(((Number)object2).floatValue());
                    break;
                }
                case 8: 
                case 18: {
                    if (object instanceof Double) break;
                    if (object instanceof Float) {
                        object = new Double(object2.toString());
                        break;
                    }
                    object = new Double(((Number)object2).doubleValue());
                    break;
                }
                case 19: {
                    if (object instanceof BigDecimal) break;
                    if (object instanceof Double) {
                        object = new BigDecimal(((Number)object2).doubleValue());
                        break;
                    }
                    if (object instanceof BigInteger) {
                        object = new BigDecimal((BigInteger)object);
                        break;
                    }
                    object = new BigDecimal(object2.toString());
                    break;
                }
                case 20: {
                    if (object instanceof BigInteger) break;
                    object = object instanceof BigDecimal ? ((BigDecimal)object).toBigInteger() : new BigInteger(object2.toString());
                }
            }
        } else if (this.enumFieldType == 21) {
            if (!(object instanceof String)) {
                object = object.toString();
            }
        } else if (java.util.Date.class.isAssignableFrom(this.fieldType)) {
            object2 = (java.util.Date)object;
            if (object instanceof SCO) {
                ((SCO)object).unsetOwner();
            }
            long l = ((java.util.Date)object2).getTime();
            int n = 0;
            n = object2 instanceof Timestamp ? ((Timestamp)object2).getNanos() : (int)(l % 1000L * 1000000L);
            if (stateManager != null) {
                PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
                object = (SCODate)persistenceManager.newSCOInstanceInternal(this.fieldType, stateManager.getPersistent(), this.getName());
                if (object instanceof SqlTimestamp) {
                    ((SCODate)object).setTimeInternal(l);
                    ((SqlTimestamp)object).setNanosInternal(n);
                } else if (object2 instanceof Timestamp) {
                    ((SCODate)object).setTimeInternal(l + (long)(n / 1000000));
                } else {
                    ((SCODate)object).setTimeInternal(l);
                }
            } else if (!this.fieldType.equals(object2.getClass())) {
                if (this.enumFieldType == 25) {
                    object = new Timestamp(l);
                    ((Timestamp)object).setNanos(n);
                } else {
                    if (object2 instanceof Timestamp) {
                        l += (long)(n / 1000000);
                    }
                    object = this.enumFieldType == 22 ? new java.util.Date(l) : (this.enumFieldType == 23 ? new Date(l) : new Time(l));
                }
            }
        } else if (this.enumFieldType == 2 || this.enumFieldType == 12) {
            if (!(object instanceof Character)) {
                object2 = object.toString();
                object = FieldDesc.getCharFromString((String)object2);
            }
        } else if (!(this.enumFieldType != 1 && this.enumFieldType != 11 || object instanceof Boolean)) {
            if (object instanceof String && ((String)object).equals("1")) {
                object = "true";
            }
            object = new Boolean(object.toString());
        }
        return object;
    }

    public static Character getCharFromString(String string) {
        Character c = null;
        c = string.length() == 0 ? new Character('\u0000') : new Character(string.charAt(0));
        return c;
    }

    private int translateToEnumeratedFieldType(Class clazz) {
        int n = 0;
        if (clazz == Boolean.TYPE) {
            n = 1;
        } else if (clazz == Character.TYPE) {
            n = 2;
        } else if (clazz == Byte.TYPE) {
            n = 3;
        } else if (clazz == Short.TYPE) {
            n = 4;
        } else if (clazz == Integer.TYPE) {
            n = 5;
        } else if (clazz == Long.TYPE) {
            n = 6;
        } else if (clazz == Float.TYPE) {
            n = 7;
        } else if (clazz == Double.TYPE) {
            n = 8;
        } else if (clazz == Boolean.class) {
            n = 11;
        } else if (clazz == Character.class) {
            n = 12;
        } else if (clazz == Byte.class) {
            n = 13;
        } else if (clazz == Short.class) {
            n = 14;
        } else if (clazz == Integer.class) {
            n = 15;
        } else if (clazz == Long.class) {
            n = 16;
        } else if (clazz == Float.class) {
            n = 17;
        } else if (clazz == Double.class) {
            n = 18;
        } else if (clazz == BigDecimal.class) {
            n = 19;
        } else if (clazz == BigInteger.class) {
            n = 20;
        } else if (clazz == String.class) {
            n = 21;
        } else if (clazz == Date.class) {
            n = 23;
        } else if (clazz == java.util.Date.class) {
            n = 22;
        } else if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
            n = 51;
        }
        return n;
    }

    private void assertIsValid(Number number, double d, double d2) {
        double d3 = number.doubleValue();
        if (d3 < d) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.minvalue", new Object[]{number, String.valueOf(d), this.fieldType.getName()}));
        }
        if (d3 > d2) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.maxvalue", new Object[]{number, String.valueOf(d2), this.fieldType.getName()}));
        }
    }

    private void assertIsValidLong(Number number) {
        BigDecimal bigDecimal = null;
        bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        if (bigDecimal.compareTo(LONG_MIN_VALUE) < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.minvalue", new Object[]{number, String.valueOf(Long.MIN_VALUE), this.fieldType.getName()}));
        }
        if (bigDecimal.compareTo(LONG_MAX_VALUE) > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.maxvalue", new Object[]{number, String.valueOf(Long.MAX_VALUE), this.fieldType.getName()}));
        }
    }

    public void addTrackedField(FieldDesc fieldDesc) {
        if (this.trackedFields == null) {
            this.trackedFields = new ArrayList();
        }
        if (logger.isLoggable(300)) {
            Object[] objectArray = new Object[]{fieldDesc.getName(), this.getName()};
            logger.finest("sqlstore.model.fielddesc.addingfield", objectArray);
        }
        this.trackedFields.add(fieldDesc);
    }

    public ArrayList getTrackedFields() {
        return this.trackedFields;
    }

    public boolean isKeyField() {
        return (this.sqlProperties & 0x800) > 0;
    }

    public void setProperty(int n) {
        this.sqlProperties |= n;
    }

    public void unsetProperty(int n) {
        this.sqlProperties &= ~n;
    }

    public boolean isVerticalDiscriminator() {
        return (this.sqlProperties & 0x1000) > 0;
    }

    public boolean isHorizontalDiscriminator() {
        return (this.sqlProperties & 0x2000) > 0;
    }
}

