/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceMemberElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ObjectIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.KeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyCheckDirty;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyDBNative;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyOptVerify;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.ParameterInfo;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ClassDesc
implements PersistenceConfig {
    public static boolean supportInheritance = false;
    private ArrayList fetchGroups;
    private int maxHierarchicalGroupID;
    public ArrayList fields;
    public ArrayList declaredFields;
    public ArrayList hiddenFields;
    public ArrayList declaredHiddenFields;
    public ArrayList foreignFields;
    public ArrayList declaredForeignFields;
    private ArrayList horizontalDiscriminatorFields;
    private LocalFieldDesc verticalDiscriminatorField;
    public ArrayList tables;
    private Class pcClass;
    private Class oidClass;
    public boolean navigable;
    public ObjectIDDesc persistenceIDDesc;
    public int properties;
    public int maxFields;
    public int maxVisibleFields;
    public int maxHiddenFields;
    private Concurrency optimisticConcurrency;
    private Concurrency checkDirtyConcurrency;
    private Concurrency databaseConcurrency;
    private int consistencyLevel;
    private MappingClassElementImpl mdConfig;
    private ClassLoader classLoader;
    PersistenceClassElement pcElement;
    PersistenceFieldElement[] persistentFields;
    private ClassDesc superclassConfig;
    private ArrayList subclassConfigs;
    private Field[] keyFields;
    private String[] keyFieldNames;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private final Map retrieveDescCache = new HashMap();
    private final Map updateQueryPlanCache = new HashMap();
    private UpdateQueryPlan updateQueryPlanForInsert;
    private Object updateQueryPlanForInsertSynchObj = new Object();
    private UpdateQueryPlan updateQueryPlanForDelete;
    private Object updateQueryPlanForDeleteSynchObj = new Object();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", ClassDesc.class.getClassLoader());
    private boolean debug = false;
    private static Class[] nonNullableNonScaledTypes = new Class[]{Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE, BigInteger.class, BigDecimal.class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class};
    private static Class[] nullableNonScaledTypes = new Class[]{BigInteger.class, BigDecimal.class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE};
    private static Class[] nonNullableScaledTypes = new Class[]{Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, BigDecimal.class, Double.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class};
    private static Class[] nullableScaledTypes = new Class[]{BigDecimal.class, Double.class, Float.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class, Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE};

    public ClassDesc(MappingClassElement mappingClassElement, Class clazz) {
        this.mdConfig = (MappingClassElementImpl)mappingClassElement;
        this.pcElement = this.mdConfig.getPersistenceElement();
        this.pcClass = clazz;
        this.classLoader = clazz.getClassLoader();
        this.fields = new ArrayList();
        this.declaredFields = new ArrayList();
        this.foreignFields = new ArrayList();
        this.declaredForeignFields = new ArrayList();
        this.tables = new ArrayList();
        this.fetchGroups = new ArrayList();
        this.consistencyLevel = mappingClassElement.getConsistencyLevel();
        this.maxFields = -1;
    }

    private Class getSuperclass(Class clazz) {
        String string = clazz.getName();
        String string2 = null;
        if (string.compareTo("empdept.PartTimeEmployee") == 0) {
            string2 = "empdept.Employee";
        } else if (string.compareTo("empdept.FullTimeEmployee") == 0) {
            string2 = "empdept.Employee";
        } else if (string.compareTo("empdept.Employee") == 0) {
            string2 = "empdept.Person";
        } else if (string.compareTo("empdept.SalesDepartment") == 0) {
            string2 = "empdept.Department";
        } else if (string.compareTo("empdept.EngineeringDepartment") == 0) {
            string2 = "empdept.Department";
        } else if (string.compareTo("empdept.PPOInsurance") == 0) {
            string2 = "empdept.Insurance";
        } else if (string.compareTo("empdept.HMOInsurance") == 0) {
            string2 = "empdept.Insurance";
        } else if (string.compareTo("empdept.EPOInsurance") == 0) {
            string2 = "empdept.HMOInsurance";
        } else if (string.compareTo("empdept.OutSourcedProject") == 0) {
            string2 = "empdept.Project";
        }
        if (string2 != null) {
            try {
                return this.classLoader.loadClass(string2);
            }
            catch (Throwable throwable) {
                logger.log(900, "sqlstore.exception.log", throwable);
                return null;
            }
        }
        return null;
    }

    private Class[] getSubclasses(Class clazz) {
        String string = clazz.getName();
        String[] stringArray = null;
        if (string.compareTo("empdept.Person") == 0) {
            stringArray = new String[]{"empdept.Employee"};
        } else if (string.compareTo("empdept.Employee") == 0) {
            stringArray = new String[]{"empdept.PartTimeEmployee", "empdept.FullTimeEmployee"};
        } else if (string.compareTo("empdept.Department") == 0) {
            stringArray = new String[]{"empdept.EngineeringDepartment", "empdept.SalesDepartment"};
        } else if (string.compareTo("empdept.Insurance") == 0) {
            stringArray = new String[]{"empdept.HMOInsurance", "empdept.PPOInsurance"};
        } else if (string.compareTo("empdept.HMOInsurance") == 0) {
            stringArray = new String[]{"empdept.EPOInsurance"};
        } else if (string.compareTo("empdept.Project") == 0) {
            stringArray = new String[]{"empdept.OutSourcedProject"};
        }
        if (stringArray != null) {
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    classArray[i] = this.classLoader.loadClass(stringArray[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(900, "sqlstore.exception.log", throwable);
                }
            }
            return classArray;
        }
        return null;
    }

    private void loadSuperclassConfig(SQLStoreManager sQLStoreManager) {
        Class clazz;
        if (!supportInheritance) {
            return;
        }
        if (this.superclassConfig == null && (clazz = this.getSuperclass(this.pcClass)) != null) {
            this.superclassConfig = (ClassDesc)sQLStoreManager.getPersistenceConfig(clazz);
            this.oidClass = this.superclassConfig.oidClass;
            this.persistenceIDDesc = this.superclassConfig.persistenceIDDesc;
            this.fields.addAll(this.superclassConfig.fields);
            this.foreignFields.addAll(this.superclassConfig.foreignFields);
            if (this.superclassConfig.hiddenFields != null) {
                this.hiddenFields = (ArrayList)this.superclassConfig.hiddenFields.clone();
            }
        }
    }

    private void loadSubclassConfigs(SQLStoreManager sQLStoreManager) {
        Class[] classArray;
        if (!supportInheritance) {
            return;
        }
        if (this.subclassConfigs == null && (classArray = this.getSubclasses(this.pcClass)) != null) {
            this.subclassConfigs = new ArrayList(classArray.length);
            for (int i = 0; i < classArray.length; ++i) {
                this.subclassConfigs.add(sQLStoreManager.getPersistenceConfig(classArray[i]));
            }
        }
    }

    public void initialize(SQLStoreManager sQLStoreManager) {
        this.debug = logger.isLoggable();
        if (this.debug) {
            logger.fine("sqlstore.model.classdesc.persistconfiginit", this.mdConfig);
        }
        this.loadSuperclassConfig(sQLStoreManager);
        this.loadOidClass();
        this.initializeFields();
        this.computeTrackedPrimitiveFields();
        this.initializeTables();
        this.initializeHorizontalDiscriminator();
        this.initializeConcurrency();
        this.initializePersistenceIDDesc();
        this.initializeFetchGroups();
        this.fixupForeignReferences(sQLStoreManager);
        this.fixupFieldProperties();
        this.computeTrackedRelationshipFields();
        if (this.hiddenFields != null) {
            this.maxHiddenFields = this.hiddenFields.size();
        }
        this.maxFields = this.maxVisibleFields + this.maxHiddenFields;
        this.initializeJoinTables();
        this.navigable = this.mdConfig.isNavigable();
        this.loadSubclassConfigs(sQLStoreManager);
        if (this.debug) {
            logger.fine("sqlstore.model.classdesc.persistconfiginit.exit");
        }
    }

    private void loadOidClass() {
        if (this.oidClass != null) {
            return;
        }
        String string = this.pcElement.getKeyClass();
        String string2 = string.substring(string.length() - 4);
        if (string2.compareToIgnoreCase(".oid") == 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(stringBuffer.length() - 4, '$');
            string = stringBuffer.toString();
        }
        try {
            this.oidClass = this.classLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.cantloadclass", string));
        }
        if (this.debug) {
            logger.fine("sqlstore.model.classdesc.loadedclass", this.oidClass);
        }
    }

    private void initializeFields() {
        ArrayList<PersistenceMemberElement> arrayList = new ArrayList<PersistenceMemberElement>();
        this.persistentFields = this.pcElement.getFields();
        for (int i = 0; i < this.persistentFields.length; ++i) {
            PersistenceMemberElement persistenceMemberElement;
            ConcurrencyGroupElement[] concurrencyGroupElementArray;
            ConcurrencyGroupElement[] concurrencyGroupElementArray2;
            PersistenceFieldElement persistenceFieldElement = this.persistentFields[i];
            MappingFieldElementImpl mappingFieldElementImpl = (MappingFieldElementImpl)this.mdConfig.getField(persistenceFieldElement.getName());
            if (mappingFieldElementImpl == null) {
                throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.fieldnotmapped", persistenceFieldElement.getName(), this.pcElement.getName()));
            }
            if (!(mappingFieldElementImpl instanceof MappingRelationshipElement)) {
                concurrencyGroupElementArray = concurrencyGroupElementArray2 = new LocalFieldDesc();
                concurrencyGroupElementArray2.columnDescs = mappingFieldElementImpl.getColumnObjects();
                if (concurrencyGroupElementArray2.columnDescs == null || concurrencyGroupElementArray2.columnDescs.size() == 0) {
                    continue;
                }
            } else {
                Cloneable cloneable;
                concurrencyGroupElementArray2 = (MappingRelationshipElementImpl)mappingFieldElementImpl;
                persistenceMemberElement = (RelationshipElement)persistenceFieldElement;
                ForeignFieldDesc foreignFieldDesc = new ForeignFieldDesc();
                this.addForeignField(foreignFieldDesc);
                concurrencyGroupElementArray = foreignFieldDesc;
                foreignFieldDesc.cardinalityLWB = ((RelationshipElement)persistenceMemberElement).getLowerBound();
                foreignFieldDesc.cardinalityUPB = ((RelationshipElement)persistenceMemberElement).getUpperBound();
                foreignFieldDesc.deleteAction = ((RelationshipElement)persistenceMemberElement).getDeleteAction();
                foreignFieldDesc.updateAction = ((RelationshipElement)persistenceMemberElement).getUpdateAction();
                ArrayList arrayList2 = concurrencyGroupElementArray2.getAssociatedColumnObjects();
                ArrayList arrayList3 = concurrencyGroupElementArray2.getColumnObjects();
                ArrayList<ColumnElement> arrayList4 = new ArrayList<ColumnElement>();
                ArrayList<ColumnElement> arrayList5 = new ArrayList<ColumnElement>();
                if (arrayList2 == null || arrayList2.size() == 0) {
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        cloneable = (ColumnPairElement)arrayList3.get(j);
                        arrayList4.add(((ColumnPairElement)cloneable).getLocalColumn());
                        arrayList5.add(((ColumnPairElement)cloneable).getReferencedColumn());
                    }
                    foreignFieldDesc.localColumns = arrayList4;
                    foreignFieldDesc.foreignColumns = arrayList5;
                } else {
                    ColumnPairElement columnPairElement;
                    int n;
                    ArrayList<ColumnElement> arrayList6 = new ArrayList<ColumnElement>();
                    cloneable = new ArrayList();
                    for (n = 0; n < arrayList3.size(); ++n) {
                        columnPairElement = (ColumnPairElement)arrayList3.get(n);
                        arrayList4.add(columnPairElement.getLocalColumn());
                        arrayList6.add(columnPairElement.getReferencedColumn());
                    }
                    for (n = 0; n < arrayList2.size(); ++n) {
                        columnPairElement = (ColumnPairElement)arrayList2.get(n);
                        ((ArrayList)cloneable).add(columnPairElement.getLocalColumn());
                        arrayList5.add(columnPairElement.getReferencedColumn());
                    }
                    foreignFieldDesc.localColumns = arrayList4;
                    foreignFieldDesc.assocLocalColumns = arrayList6;
                    foreignFieldDesc.assocForeignColumns = cloneable;
                    foreignFieldDesc.foreignColumns = arrayList5;
                }
                if (Model.RUNTIME.isCollection(((RelationshipElement)persistenceMemberElement).getCollectionClass()) && foreignFieldDesc.cardinalityUPB <= 1) {
                    foreignFieldDesc.cardinalityUPB = Integer.MAX_VALUE;
                }
                if (foreignFieldDesc.cardinalityUPB > 1) {
                    try {
                        foreignFieldDesc.componentType = this.classLoader.loadClass(((RelationshipElement)persistenceMemberElement).getElementClass());
                    }
                    catch (Throwable throwable) {
                        logger.log(900, "sqlstore.exception.log", throwable);
                    }
                }
            }
            concurrencyGroupElementArray.fetchGroup = mappingFieldElementImpl.getFetchGroup();
            concurrencyGroupElementArray2 = persistenceFieldElement.getConcurrencyGroups();
            if (concurrencyGroupElementArray2 == null || concurrencyGroupElementArray2.length == 0) {
                if (concurrencyGroupElementArray.fetchGroup == 1) {
                    concurrencyGroupElementArray.concurrencyGroup = concurrencyGroupElementArray.fetchGroup;
                }
            } else {
                persistenceMemberElement = concurrencyGroupElementArray2[0];
                int n = 0;
                n = arrayList.indexOf(persistenceMemberElement);
                if (n == -1) {
                    n = arrayList.size();
                    arrayList.add(persistenceMemberElement);
                }
                concurrencyGroupElementArray.concurrencyGroup = n;
            }
            if (mappingFieldElementImpl.isReadOnly()) {
                concurrencyGroupElementArray.sqlProperties |= 0x10;
            }
            try {
                concurrencyGroupElementArray.setupDesc(this.pcClass, mappingFieldElementImpl.getName());
                if (!supportInheritance) {
                    concurrencyGroupElementArray.absoluteID = persistenceFieldElement.getFieldNumber();
                }
            }
            catch (Exception exception) {
                logger.log(900, "sqlstore.exception.log", exception);
            }
            this.addField((FieldDesc)concurrencyGroupElementArray);
            if (supportInheritance) {
                concurrencyGroupElementArray.absoluteID = this.fields.size() - 1;
            }
            if (!this.debug) continue;
            persistenceMemberElement = new Object[]{concurrencyGroupElementArray.getName(), new Integer(concurrencyGroupElementArray.absoluteID)};
            logger.fine("sqlstore.model.classdesc.fieldinfo", (Object[])persistenceMemberElement);
        }
        this.maxVisibleFields = this.fields.size();
    }

    private Object getDiscriminatorValue() {
        String string = this.pcClass.getName();
        int n = -1;
        if (string.compareTo("empdept.Person") == 0) {
            n = 1;
        } else if (string.compareTo("empdept.Employee") == 0) {
            n = 2;
        } else if (string.compareTo("empdept.FullTimeEmployee") == 0) {
            n = 3;
        } else if (string.compareTo("empdept.PartTimeEmployee") == 0) {
            n = 4;
        } else if (string.compareTo("empdept.Department") == 0) {
            n = 1;
        } else if (string.compareTo("empdept.SalesDepartment") == 0) {
            n = 2;
        } else if (string.compareTo("empdept.EngineeringDepartment") == 0) {
            n = 3;
        } else if (string.compareTo("empdept.Insurance") == 0) {
            n = 1;
        } else if (string.compareTo("empdept.PPOInsurance") == 0) {
            n = 2;
        } else if (string.compareTo("empdept.HMOInsurance") == 0) {
            n = 3;
        } else if (string.compareTo("empdept.EPOInsurance") == 0) {
            n = 4;
        } else if (string.compareTo("empdept.Project") == 0) {
            n = 1;
        } else if (string.compareTo("empdept.OutSourcedProject") == 0) {
            n = 2;
        }
        return new Integer(n);
    }

    private void initializeHorizontalDiscriminator() {
        FieldDesc fieldDesc = null;
        if (supportInheritance) {
            for (int i = 0; i < this.declaredFields.size(); ++i) {
                FieldDesc fieldDesc2 = (FieldDesc)this.declaredFields.get(i);
                if (fieldDesc2.getName().compareTo("discriminator") != 0) continue;
                fieldDesc = (LocalFieldDesc)fieldDesc2;
                break;
            }
        }
        if (fieldDesc != null) {
            this.horizontalDiscriminatorFields = new ArrayList();
            this.horizontalDiscriminatorFields.add(fieldDesc);
            fieldDesc.setProperty(8192);
            ((LocalFieldDesc)fieldDesc).fetchGroup = 1;
            ((LocalFieldDesc)fieldDesc).setDiscriminatorValue(this.getDiscriminatorValue());
        }
    }

    private void createSecondaryTableKey(TableDesc tableDesc, MappingReferenceKeyElementImpl mappingReferenceKeyElementImpl) {
        ColumnPairElement[] columnPairElementArray = mappingReferenceKeyElementImpl.getColumnPairs();
        KeyDesc keyDesc = new KeyDesc();
        KeyDesc keyDesc2 = new KeyDesc();
        TableDesc tableDesc2 = this.findTableDesc(((MappingTableElementImpl)mappingReferenceKeyElementImpl.getTable()).getTableObject());
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            ColumnPairElement columnPairElement = columnPairElementArray[i];
            ColumnElement columnElement = columnPairElement.getLocalColumn();
            ColumnElement columnElement2 = columnPairElement.getReferencedColumn();
            keyDesc.addColumn(columnElement);
            LocalFieldDesc localFieldDesc = this.getLocalFieldDesc(columnElement);
            keyDesc.addField(localFieldDesc);
            localFieldDesc.fetchGroup = 1;
            keyDesc2.addColumn(columnElement2);
            keyDesc2.addField(this.getLocalFieldDesc(columnElement2));
        }
        tableDesc.addSecondaryTableKey(new ReferenceKeyDesc(tableDesc2, keyDesc, keyDesc2));
        tableDesc2.setPrimaryTableKey(new ReferenceKeyDesc(tableDesc, keyDesc2, keyDesc));
    }

    private void createSubtableKey(TableDesc tableDesc, MappingReferenceKeyElementImpl mappingReferenceKeyElementImpl) {
        ColumnPairElement[] columnPairElementArray = mappingReferenceKeyElementImpl.getColumnPairs();
        KeyDesc keyDesc = new KeyDesc();
        KeyDesc keyDesc2 = new KeyDesc();
        TableDesc tableDesc2 = this.findTableDesc(((MappingTableElementImpl)mappingReferenceKeyElementImpl.getTable()).getTableObject());
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            ColumnPairElement columnPairElement = columnPairElementArray[i];
            ColumnElement columnElement = columnPairElement.getLocalColumn();
            ColumnElement columnElement2 = columnPairElement.getReferencedColumn();
            keyDesc.addColumn(columnElement);
            LocalFieldDesc localFieldDesc = this.getLocalFieldDesc(columnElement);
            if (!localFieldDesc.isVerticalDiscriminator()) {
                localFieldDesc.setProperty(4096);
                localFieldDesc.setProperty(1);
                this.verticalDiscriminatorField = localFieldDesc;
            }
            keyDesc.addField(localFieldDesc);
            localFieldDesc.fetchGroup = 1;
            keyDesc2.addColumn(columnElement2);
            keyDesc2.addField(this.getLocalFieldDesc(columnElement2));
        }
        tableDesc.setSupertableKey(new ReferenceKeyDesc(tableDesc2, keyDesc, keyDesc2));
        tableDesc2.addSubtableKey(new ReferenceKeyDesc(tableDesc, keyDesc2, keyDesc));
    }

    private void initializeTables() {
        Object object;
        ArrayList arrayList;
        TableDesc tableDesc;
        MappingTableElementImpl mappingTableElementImpl;
        int n;
        ArrayList arrayList2 = this.mdConfig.getTables();
        for (n = 0; n < arrayList2.size(); ++n) {
            mappingTableElementImpl = (MappingTableElementImpl)arrayList2.get(n);
            tableDesc = new TableDesc(mappingTableElementImpl.getTableObject());
            arrayList = mappingTableElementImpl.getKeyObjects();
            object = new KeyDesc();
            tableDesc.setKey((KeyDesc)object);
            ((KeyDesc)object).addColumns(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                ColumnElement columnElement = (ColumnElement)arrayList.get(i);
                if (columnElement == null) continue;
                ((KeyDesc)object).addField(this.getLocalFieldDesc(columnElement));
            }
            this.addTableDesc(tableDesc);
            if (supportInheritance) break;
        }
        for (n = 0; n < this.tables.size(); ++n) {
            mappingTableElementImpl = (MappingTableElementImpl)arrayList2.get(n);
            tableDesc = (TableDesc)this.tables.get(n);
            if (supportInheritance) {
                arrayList = mappingTableElementImpl.getReferencingKeys();
                if (arrayList == null || arrayList.isEmpty()) continue;
                object = (MappingReferenceKeyElementImpl)arrayList.get(0);
                this.createSubtableKey(tableDesc, (MappingReferenceKeyElementImpl)object);
                continue;
            }
            arrayList = mappingTableElementImpl.getReferencingKeys();
            for (int i = 0; i < arrayList.size(); ++i) {
                MappingReferenceKeyElementImpl mappingReferenceKeyElementImpl = (MappingReferenceKeyElementImpl)arrayList.get(i);
                this.createSecondaryTableKey(tableDesc, mappingReferenceKeyElementImpl);
            }
        }
    }

    private void initializeJoinTables() {
        for (int i = 0; i < this.declaredFields.size(); ++i) {
            ForeignFieldDesc foreignFieldDesc;
            FieldDesc fieldDesc = (FieldDesc)this.declaredFields.get(i);
            if (!(fieldDesc instanceof ForeignFieldDesc) || !(foreignFieldDesc = (ForeignFieldDesc)fieldDesc).useJoinTable()) continue;
            TableElement tableElement = ((ColumnElement)foreignFieldDesc.assocLocalColumns.get(0)).getDeclaringTable();
            TableDesc tableDesc = this.findTableDesc(tableElement);
            if (tableDesc == null) {
                tableDesc = new TableDesc(tableElement);
                this.addTableDesc(tableDesc);
            }
            tableDesc.isJoinTable(true);
        }
    }

    public ArrayList getFetchGroup(int n) {
        int n2 = 0;
        if (n > 0) {
            n2 = n;
        } else if (n < 0) {
            n2 = -n + this.maxHierarchicalGroupID;
        } else {
            return null;
        }
        for (int i = this.fetchGroups.size(); i <= n2; ++i) {
            this.fetchGroups.add(null);
        }
        ArrayList arrayList = (ArrayList)this.fetchGroups.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.fetchGroups.set(n2, arrayList);
        }
        return arrayList;
    }

    private void addField(FieldDesc fieldDesc) {
        this.fields.add(fieldDesc);
        this.declaredFields.add(fieldDesc);
    }

    private void addForeignField(ForeignFieldDesc foreignFieldDesc) {
        this.foreignFields.add(foreignFieldDesc);
        this.declaredForeignFields.add(foreignFieldDesc);
    }

    private void initializeFetchGroups() {
        Serializable serializable;
        int n;
        for (n = 0; n < 2; ++n) {
            serializable = null;
            if (n == 0) {
                serializable = this.declaredFields;
            } else {
                serializable = this.declaredHiddenFields;
                if (serializable == null) continue;
            }
            for (int i = 0; i < serializable.size(); ++i) {
                FieldDesc fieldDesc = (FieldDesc)serializable.get(i);
                if (fieldDesc.fetchGroup <= 0) continue;
                ArrayList arrayList = this.getFetchGroup(fieldDesc.fetchGroup);
                arrayList.add(fieldDesc);
            }
        }
        this.maxHierarchicalGroupID = this.fetchGroups.size();
        for (n = 0; n < this.declaredFields.size(); ++n) {
            serializable = (FieldDesc)this.declaredFields.get(n);
            if (((FieldDesc)serializable).fetchGroup >= 0) continue;
            ArrayList arrayList = this.getFetchGroup(((FieldDesc)serializable).fetchGroup);
            arrayList.add(serializable);
        }
    }

    private void initializeConcurrency() {
        this.optimisticConcurrency = new ConcurrencyOptVerify();
        this.optimisticConcurrency.configPersistence(this);
        this.checkDirtyConcurrency = new ConcurrencyCheckDirty();
        this.checkDirtyConcurrency.configPersistence(this);
        this.databaseConcurrency = new ConcurrencyDBNative();
        this.databaseConcurrency.configPersistence(this);
    }

    private void initializePersistenceIDDesc() {
        if (this.oidClass == null || this.persistenceIDDesc != null) {
            return;
        }
        this.keyFields = this.oidClass.getFields();
        this.keyFieldNames = new String[this.keyFields.length];
        if (this.debug) {
            logger.fine("sqlstore.model.classdesc.createsqldesc", this.oidClass);
        }
        SqlIDDesc sqlIDDesc = new SqlIDDesc();
        for (int i = 0; i < this.keyFields.length; ++i) {
            String string;
            Field field = this.keyFields[i];
            this.keyFieldNames[i] = string = field.getName();
            if (string.equals("serialVersionUID")) continue;
            FieldDesc fieldDesc = this.getField(string);
            if (fieldDesc != null) {
                if (this.debug) {
                    logger.fine("sqlstore.model.classdesc.pkfield", fieldDesc.getName());
                }
                sqlIDDesc.addField(fieldDesc);
                fieldDesc.fetchGroup = 1;
                fieldDesc.sqlProperties &= 0xFFFFFFBF;
                fieldDesc.sqlProperties &= 0xFFFFFFFE;
                fieldDesc.sqlProperties |= 0x800;
                continue;
            }
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.noneexistentpkfield", string, this.oidClass.getName(), this.pcClass.getName()));
        }
        this.persistenceIDDesc = sqlIDDesc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareColumns(FieldDesc fieldDesc, FieldDesc fieldDesc2) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        boolean bl = false;
        if (fieldDesc instanceof LocalFieldDesc) {
            arrayList = ((LocalFieldDesc)fieldDesc).columnDescs;
            if (fieldDesc2 instanceof LocalFieldDesc) {
                arrayList2 = ((LocalFieldDesc)fieldDesc2).columnDescs;
                bl = true;
            } else {
                arrayList2 = ((ForeignFieldDesc)fieldDesc2).localColumns;
            }
        } else {
            if (fieldDesc2 instanceof LocalFieldDesc) {
                return false;
            }
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
            ForeignFieldDesc foreignFieldDesc2 = (ForeignFieldDesc)fieldDesc2;
            if (foreignFieldDesc.useJoinTable() && foreignFieldDesc2.useJoinTable()) {
                arrayList = foreignFieldDesc.assocLocalColumns;
                arrayList2 = foreignFieldDesc2.assocLocalColumns;
                arrayList3 = foreignFieldDesc.assocForeignColumns;
                arrayList4 = foreignFieldDesc2.assocForeignColumns;
            } else {
                if (foreignFieldDesc.useJoinTable() || foreignFieldDesc2.useJoinTable()) return false;
                if ((foreignFieldDesc.sqlProperties & 0x40) > 0 && (foreignFieldDesc2.sqlProperties & 0x40) > 0) {
                    arrayList = foreignFieldDesc.localColumns;
                    arrayList2 = foreignFieldDesc2.localColumns;
                } else {
                    if ((foreignFieldDesc.sqlProperties & 0x40) != 0 || (foreignFieldDesc2.sqlProperties & 0x40) != 0) return false;
                    arrayList = foreignFieldDesc.foreignColumns;
                    arrayList2 = foreignFieldDesc2.foreignColumns;
                }
            }
            bl = true;
        }
        boolean bl2 = false;
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                if (arrayList3 == null) return bl2;
                arrayList = arrayList3;
                arrayList2 = arrayList4;
            }
            int n = arrayList.size();
            int n2 = arrayList2.size();
            if (bl && n != n2) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                bl2 = false;
                ColumnElement columnElement = (ColumnElement)arrayList.get(j);
                for (int k = 0; k < n2; ++k) {
                    ColumnElement columnElement2 = (ColumnElement)arrayList2.get(k);
                    if (!columnElement.getName().getFullName().equals(columnElement2.getName().getFullName())) continue;
                    bl2 = true;
                }
                if (bl && !bl2) {
                    return false;
                }
                if (bl || !bl2) continue;
                return true;
            }
        }
        return bl2;
    }

    private int lookupTypePrecedence(Class clazz, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (clazz != classArray[i]) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int computeTypePrecedence(LocalFieldDesc localFieldDesc) {
        ColumnElement columnElement = (ColumnElement)localFieldDesc.columnDescs.get(0);
        int n = columnElement.getType();
        Class clazz = localFieldDesc.getType();
        boolean bl = columnElement.isNullable();
        int n2 = Integer.MAX_VALUE;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (bl) {
                    n2 = this.lookupTypePrecedence(clazz, nullableNonScaledTypes);
                    break;
                }
                n2 = this.lookupTypePrecedence(clazz, nonNullableNonScaledTypes);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (bl) {
                    n2 = this.lookupTypePrecedence(clazz, nullableScaledTypes);
                    break;
                }
                n2 = this.lookupTypePrecedence(clazz, nonNullableScaledTypes);
                break;
            }
            case 2: 
            case 3: {
                int n3 = -1;
                n3 = columnElement.getScale();
                if (n3 == 0) {
                    if (bl) {
                        n2 = this.lookupTypePrecedence(clazz, nullableNonScaledTypes);
                        break;
                    }
                    n2 = this.lookupTypePrecedence(clazz, nonNullableNonScaledTypes);
                    break;
                }
                if (n3 <= 0) break;
                if (bl) {
                    n2 = this.lookupTypePrecedence(clazz, nullableScaledTypes);
                    break;
                }
                n2 = this.lookupTypePrecedence(clazz, nonNullableScaledTypes);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (clazz != String.class) break;
                n2 = 0;
                break;
            }
            case 91: 
            case 93: {
                if (!Date.class.isAssignableFrom(clazz)) break;
                n2 = 0;
                break;
            }
            case -7: {
                if (clazz == Boolean.class) {
                    if (bl) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
                if (clazz != Boolean.TYPE) break;
                n2 = bl ? 1 : 0;
            }
        }
        return n2;
    }

    private void computeTrackedPrimitiveFields() {
        FieldDesc fieldDesc;
        FieldDesc fieldDesc2;
        int n;
        for (n = 0; n < this.declaredFields.size(); ++n) {
            fieldDesc2 = (FieldDesc)this.declaredFields.get(n);
            if (!(fieldDesc2 instanceof LocalFieldDesc)) continue;
            for (int i = 0; i < this.declaredFields.size(); ++i) {
                if (i == n || !((fieldDesc = (FieldDesc)this.declaredFields.get(i)) instanceof LocalFieldDesc) || !this.compareColumns(fieldDesc2, fieldDesc)) continue;
                fieldDesc2.addTrackedField(fieldDesc);
            }
        }
        for (n = 0; n < this.declaredFields.size(); ++n) {
            fieldDesc2 = (FieldDesc)this.declaredFields.get(n);
            ArrayList arrayList = null;
            if (fieldDesc2 instanceof ForeignFieldDesc || (arrayList = fieldDesc2.getTrackedFields()) == null || (fieldDesc2.sqlProperties & 0x310) > 0) continue;
            fieldDesc2.sqlProperties |= 0x200;
            fieldDesc = null;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            n3 = this.computeTypePrecedence((LocalFieldDesc)fieldDesc2);
            if (n3 < n2) {
                fieldDesc = fieldDesc2;
                n2 = n3;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                FieldDesc fieldDesc3 = (FieldDesc)arrayList.get(i);
                if (fieldDesc3 instanceof ForeignFieldDesc) continue;
                fieldDesc3.sqlProperties |= 0x200;
                n3 = this.computeTypePrecedence((LocalFieldDesc)fieldDesc3);
                if (n3 >= n2) continue;
                fieldDesc = fieldDesc3;
                n2 = n3;
            }
            if (fieldDesc == null) {
                fieldDesc = fieldDesc2;
            }
            if (this.debug) {
                logger.fine("sqlstore.model.classdesc.primarytrackedfield", fieldDesc.getName());
            }
            fieldDesc.sqlProperties |= 0x100;
            fieldDesc.sqlProperties &= 0xFFFFFDFF;
        }
    }

    private void computeTrackedRelationshipFields() {
        Serializable serializable;
        int n;
        Serializable serializable2;
        int n2;
        for (n2 = 0; n2 < 2; ++n2) {
            serializable2 = null;
            if (n2 == 0) {
                serializable2 = this.declaredFields;
            } else {
                serializable2 = this.declaredHiddenFields;
                if (serializable2 == null) continue;
            }
            for (int i = 0; i < ((ArrayList)serializable2).size(); ++i) {
                FieldDesc fieldDesc = (FieldDesc)((ArrayList)serializable2).get(i);
                if (fieldDesc instanceof LocalFieldDesc && (fieldDesc.sqlProperties & 0x40) == 0 && (fieldDesc.sqlProperties & 0x800) == 0) continue;
                if (fieldDesc instanceof LocalFieldDesc) {
                    for (n = 0; n < this.declaredForeignFields.size(); ++n) {
                        ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)this.declaredForeignFields.get(n);
                        if (!this.compareColumns(fieldDesc, foreignFieldDesc) || (fieldDesc.sqlProperties & 0x800) > 0 && (foreignFieldDesc.cardinalityUPB > 1 || foreignFieldDesc.cardinalityLWB == 0)) continue;
                        if (fieldDesc.getTrackedFields() == null) {
                            fieldDesc.sqlProperties |= 0x100;
                        }
                        fieldDesc.addTrackedField(foreignFieldDesc);
                        if (!(foreignFieldDesc instanceof ForeignFieldDesc)) continue;
                        fieldDesc.sqlProperties |= 0x400;
                    }
                    continue;
                }
                ForeignFieldDesc foreignFieldDesc = ((ForeignFieldDesc)fieldDesc).getInverseRelationshipField();
                for (int j = 0; j < this.declaredForeignFields.size(); ++j) {
                    serializable = (ForeignFieldDesc)this.declaredForeignFields.get(j);
                    if (fieldDesc == serializable || fieldDesc.getType() != ((FieldDesc)serializable).getType() || !this.compareColumns(fieldDesc, (FieldDesc)serializable)) continue;
                    if (foreignFieldDesc != null && ((ForeignFieldDesc)serializable).getInverseRelationshipField() == null) {
                        ((ForeignFieldDesc)serializable).setInverseRelationshipField(foreignFieldDesc);
                    }
                    if ((fieldDesc.sqlProperties & 0x200) == 0) {
                        fieldDesc.sqlProperties |= 0x100;
                    }
                    if ((((ForeignFieldDesc)serializable).sqlProperties & 0x100) == 0) {
                        ((ForeignFieldDesc)serializable).sqlProperties |= 0x200;
                    }
                    fieldDesc.addTrackedField((FieldDesc)serializable);
                }
            }
        }
        for (n2 = 0; n2 < this.declaredFields.size(); ++n2) {
            FieldDesc fieldDesc;
            ArrayList arrayList;
            serializable2 = (FieldDesc)this.declaredFields.get(n2);
            if (!(serializable2 instanceof LocalFieldDesc) || (arrayList = ((FieldDesc)serializable2).getTrackedFields()) == null) continue;
            int n3 = 1;
            while ((n = arrayList.size() - n3) >= 0 && !((fieldDesc = (FieldDesc)arrayList.get(n)) instanceof LocalFieldDesc)) {
                serializable = fieldDesc.getTrackedFields();
                if (serializable != null) {
                    arrayList.removeAll((Collection<?>)((Object)serializable));
                }
                ++n3;
            }
        }
    }

    private void fixupFieldProperties() {
        for (int i = 0; i < this.declaredForeignFields.size(); ++i) {
            ArrayList arrayList;
            int n;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)this.declaredForeignFields.get(i);
            if (foreignFieldDesc.cardinalityUPB > 1) {
                if (this.debug) {
                    logger.fine("sqlstore.model.classdesc.unsetrefintegrityupdate", foreignFieldDesc.getName());
                }
                foreignFieldDesc.sqlProperties &= 0xFFFFFFBF;
                foreignFieldDesc.sqlProperties &= 0xFFFFFFFE;
                for (n = 0; n < 3; ++n) {
                    arrayList = null;
                    switch (n) {
                        case 0: {
                            arrayList = foreignFieldDesc.getLocalFields();
                            break;
                        }
                        case 1: {
                            arrayList = foreignFieldDesc.getAssocLocalFields();
                            break;
                        }
                        case 2: {
                            arrayList = foreignFieldDesc.getAssocForeignFields();
                        }
                    }
                    if (arrayList == null) continue;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                        if (fieldDesc.absoluteID >= 0) continue;
                        if (this.debug) {
                            logger.fine("sqlstore.model.classdesc.unsetconcurrencychk", fieldDesc.getName());
                        }
                        fieldDesc.sqlProperties &= 0xFFFFFFFE;
                    }
                }
                continue;
            }
            n = 0;
            arrayList = foreignFieldDesc.getLocalFields();
            for (int j = 0; j < arrayList.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                if ((fieldDesc.sqlProperties & 0x40) <= 0) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                if (arrayList.size() < ((SqlIDDesc)this.persistenceIDDesc).getFields().size()) {
                    n = 1;
                } else if (foreignFieldDesc.cardinalityLWB == 1 && foreignFieldDesc.cardinalityUPB == 1) {
                    ArrayList arrayList2 = foreignFieldDesc.getForeignFields();
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        FieldDesc fieldDesc = (FieldDesc)arrayList2.get(j);
                        if ((fieldDesc.sqlProperties & 0x40) > 0) {
                            n = 0;
                            foreignFieldDesc.cardinalityLWB = 0;
                            break;
                        }
                        n = 1;
                    }
                }
            }
            if (n != 0) continue;
            if (this.debug) {
                logger.fine("sqlstore.model.classdesc.unsetrefintegrityupdate", foreignFieldDesc.getName());
            }
            foreignFieldDesc.sqlProperties &= 0xFFFFFFBF;
            foreignFieldDesc.sqlProperties &= 0xFFFFFFFE;
            for (int j = 0; j < arrayList.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                if (fieldDesc.absoluteID >= 0) continue;
                if (this.debug) {
                    logger.fine("sqlstore.model.classdesc.unsetconcurrencychk", fieldDesc.getName());
                }
                fieldDesc.sqlProperties &= 0xFFFFFFFE;
            }
        }
    }

    public void fixupForeignReference(ForeignFieldDesc foreignFieldDesc, ClassDesc classDesc) {
        Object object;
        if (this.debug) {
            object = new Object[]{foreignFieldDesc.getDeclaringClass().getName(), foreignFieldDesc.getName(), classDesc.pcClass.getName()};
            logger.fine("sqlstore.model.classdesc.general", (Object[])object);
        }
        foreignFieldDesc.foreignConfig = classDesc;
        object = this;
        RelationshipElement relationshipElement = this.pcElement.getRelationship(foreignFieldDesc.getName());
        String string = relationshipElement.getInverseRelationshipName();
        if (string != null) {
            if (this.debug) {
                logger.fine("sqlstore.model.classdesc.assocrelatedfield", string);
            }
            foreignFieldDesc.setInverseRelationshipField((ForeignFieldDesc)classDesc.getField(string));
        } else {
            foreignFieldDesc.setInverseRelationshipField(null);
        }
        for (int i = 0; i < 4; ++i) {
            ArrayList arrayList = null;
            ArrayList arrayList2 = null;
            switch (i) {
                case 0: {
                    arrayList2 = foreignFieldDesc.localColumns;
                    arrayList = foreignFieldDesc.getLocalFields();
                    break;
                }
                case 1: {
                    arrayList2 = foreignFieldDesc.assocLocalColumns;
                    arrayList = foreignFieldDesc.getAssocLocalFields();
                    break;
                }
                case 2: {
                    arrayList2 = foreignFieldDesc.assocForeignColumns;
                    arrayList = foreignFieldDesc.getAssocForeignFields();
                    break;
                }
                case 3: {
                    arrayList2 = foreignFieldDesc.foreignColumns;
                    arrayList = foreignFieldDesc.getForeignFields();
                    object = classDesc;
                }
            }
            if (arrayList2 == null) continue;
            for (int j = 0; j < arrayList2.size(); ++j) {
                ColumnElement columnElement = (ColumnElement)arrayList2.get(j);
                TableElement tableElement = columnElement.getDeclaringTable();
                if (tableElement == null) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.columnnotable"));
                }
                arrayList.add(super.getLocalFieldDesc(columnElement));
            }
        }
    }

    private void fixupForeignReferences(SQLStoreManager sQLStoreManager) {
        for (int i = 0; i < this.declaredForeignFields.size(); ++i) {
            ClassDesc classDesc;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)this.declaredForeignFields.get(i);
            Class clazz = null;
            clazz = foreignFieldDesc.getComponentType();
            if (clazz == null) {
                clazz = foreignFieldDesc.getType();
            }
            if ((classDesc = (ClassDesc)sQLStoreManager.getPersistenceConfig(clazz)) == null) continue;
            this.fixupForeignReference(foreignFieldDesc, classDesc);
        }
    }

    private LocalFieldDesc getLocalFieldDesc(ColumnElement columnElement) {
        LocalFieldDesc localFieldDesc;
        for (int i = 0; i < 2; ++i) {
            ArrayList arrayList = null;
            arrayList = i == 0 ? this.fields : this.hiddenFields;
            if (arrayList == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                if (!(fieldDesc instanceof LocalFieldDesc)) continue;
                localFieldDesc = (LocalFieldDesc)fieldDesc;
                for (int k = 0; k < localFieldDesc.columnDescs.size(); ++k) {
                    ColumnElement columnElement2 = (ColumnElement)localFieldDesc.columnDescs.get(k);
                    if (columnElement2.getName().getFullName().compareTo(columnElement.getName().getFullName()) != 0 || fieldDesc.getTrackedFields() != null && (fieldDesc.sqlProperties & 0x100) == 0) continue;
                    return localFieldDesc;
                }
            }
        }
        if (this.hiddenFields == null) {
            this.hiddenFields = new ArrayList();
        }
        if (this.declaredHiddenFields == null) {
            this.declaredHiddenFields = new ArrayList();
        }
        localFieldDesc = new LocalFieldDesc();
        this.hiddenFields.add(localFieldDesc);
        this.declaredHiddenFields.add(localFieldDesc);
        if (this.maxFields != -1) {
            ++this.maxFields;
            ++this.maxHiddenFields;
        }
        localFieldDesc.absoluteID = -this.hiddenFields.size();
        localFieldDesc.columnDescs = new ArrayList();
        if (this.debug) {
            Object[] objectArray = new Object[]{this.pcClass, localFieldDesc.getName(), columnElement.getName().getFullName()};
            logger.fine("sqlstore.model.classdesc.getlocalfielddesc", objectArray);
        }
        localFieldDesc.columnDescs.add(columnElement);
        localFieldDesc.isPersistent = true;
        return localFieldDesc;
    }

    public TableDesc findTableDesc(TableElement tableElement) {
        for (int i = 0; i < this.tables.size(); ++i) {
            TableDesc tableDesc = (TableDesc)this.tables.get(i);
            if (tableDesc.getTableElement() != tableElement) continue;
            return tableDesc;
        }
        if (this.superclassConfig != null) {
            return this.superclassConfig.findTableDesc(tableElement);
        }
        return null;
    }

    public void addTableDesc(TableDesc tableDesc) {
        tableDesc.setConsistencyLevel(this.consistencyLevel);
        this.tables.add(tableDesc);
    }

    public int getTableIndex(TableDesc tableDesc) {
        return this.tables.indexOf(tableDesc);
    }

    public FieldDesc getField(String string) {
        FieldDesc fieldDesc;
        int n;
        for (n = 0; n < this.fields.size(); ++n) {
            fieldDesc = (FieldDesc)this.fields.get(n);
            if (fieldDesc == null || fieldDesc.getName().compareTo(string) != 0) continue;
            return fieldDesc;
        }
        if (this.hiddenFields != null) {
            for (n = 0; n < this.hiddenFields.size(); ++n) {
                fieldDesc = (FieldDesc)this.hiddenFields.get(n);
                if (fieldDesc.getName().compareTo(string) != 0) continue;
                return fieldDesc;
            }
        }
        return null;
    }

    public FieldDesc getField(int n) {
        if (n >= 0) {
            return (FieldDesc)this.fields.get(n);
        }
        return (FieldDesc)this.hiddenFields.get(-(n + 1));
    }

    public ObjectIDDesc getPersistenceIDDesc() {
        return this.persistenceIDDesc;
    }

    public void setPersistenceIDDesc(ObjectIDDesc objectIDDesc) {
        this.persistenceIDDesc = objectIDDesc;
    }

    public Class getPersistenceCapableClass() {
        return this.pcClass;
    }

    public Class getOidClass() {
        return this.oidClass;
    }

    public Concurrency getConcurrency(boolean bl) {
        Concurrency concurrency = null;
        if (this.consistencyLevel == 0) {
            concurrency = bl ? (Concurrency)this.optimisticConcurrency.clone() : (Concurrency)this.databaseConcurrency.clone();
        } else {
            switch (this.consistencyLevel) {
                case 1: {
                    concurrency = (Concurrency)this.checkDirtyConcurrency.clone();
                    break;
                }
                case 8: {
                    concurrency = (Concurrency)this.databaseConcurrency.clone();
                    break;
                }
                default: {
                    throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.configuration.unsupportedconsistencylevel", this.pcClass));
                }
            }
        }
        return concurrency;
    }

    public boolean hasModifiedCheckAtCommitConsistency() {
        return this.consistencyLevel == 1;
    }

    public boolean isPKField(int n) {
        return this.persistentFields[n].isKey();
    }

    public ClassDesc getSuperclassConfig() {
        return this.superclassConfig;
    }

    public ArrayList getSubclassConfigs() {
        return this.subclassConfigs;
    }

    public ArrayList getHorizontalDiscriminatorFields() {
        return this.horizontalDiscriminatorFields;
    }

    public LocalFieldDesc getVerticalDiscriminatorField() {
        return this.verticalDiscriminatorField;
    }

    public Field[] getKeyFields() {
        return this.keyFields;
    }

    public String[] getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public SQLStateManager newStateManagerInstance(PersistenceStore persistenceStore) {
        SQLStateManager sQLStateManager = new SQLStateManager();
        sQLStateManager.store = persistenceStore;
        sQLStateManager.persistenceConfig = this;
        return sQLStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDesc(FieldDesc fieldDesc, PersistenceStore persistenceStore) {
        RetrieveDesc retrieveDesc = null;
        String string = this.generateRDCacheKey(fieldDesc);
        Map map = this.retrieveDescCache;
        synchronized (map) {
            retrieveDesc = (RetrieveDesc)this.retrieveDescCache.get(string);
            if (retrieveDesc == null) {
                Object object;
                Object object2;
                retrieveDesc = persistenceStore.getRetrieveDesc(this.pcClass);
                if (fieldDesc != null) {
                    object2 = null;
                    String string2 = fieldDesc.getName();
                    if (fieldDesc instanceof ForeignFieldDesc) {
                        object = ((ForeignFieldDesc)fieldDesc).foreignConfig.getPersistenceCapableClass();
                        object2 = persistenceStore.getRetrieveDesc((Class)object);
                    }
                    retrieveDesc.addField(string2, (RetrieveDesc)object2);
                }
                object2 = this.getKeyFieldNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = object2[i];
                    int n = this.getField((String)object).getEnumType();
                    retrieveDesc.addConstraint(null, 53, new ParameterInfo(i, n));
                    retrieveDesc.addConstraint((String)object, 5, null);
                    retrieveDesc.addConstraint(null, 9, null);
                }
                this.retrieveDescCache.put(string, retrieveDesc);
            }
        }
        return retrieveDesc;
    }

    private String generateRDCacheKey(FieldDesc fieldDesc) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pcClass.getName());
        if (fieldDesc != null) {
            stringBuffer.append('/');
            stringBuffer.append(fieldDesc.getName());
            stringBuffer.append('/');
            stringBuffer.append(fieldDesc.absoluteID);
        }
        return stringBuffer.toString();
    }

    public UpdateQueryPlan getUpdateQueryPlan(UpdateObjectDescImpl updateObjectDescImpl, SQLStoreManager sQLStoreManager) {
        switch (updateObjectDescImpl.getUpdateAction()) {
            case 1: {
                return this.getUpdateQueryPlanForInsert(updateObjectDescImpl, sQLStoreManager);
            }
            case 2: {
                return this.getUpdateQueryPlanForDelete(updateObjectDescImpl, sQLStoreManager);
            }
            case 3: {
                return this.getUpdateQueryPlanForUpdate(updateObjectDescImpl, sQLStoreManager);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForInsert(UpdateObjectDescImpl updateObjectDescImpl, SQLStoreManager sQLStoreManager) {
        Object object = this.updateQueryPlanForInsertSynchObj;
        synchronized (object) {
            if (this.updateQueryPlanForInsert == null) {
                this.updateQueryPlanForInsert = new UpdateQueryPlan(updateObjectDescImpl, sQLStoreManager);
                this.updateQueryPlanForInsert.build(true);
            }
        }
        return this.updateQueryPlanForInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForDelete(UpdateObjectDescImpl updateObjectDescImpl, SQLStoreManager sQLStoreManager) {
        Object object = this.updateQueryPlanForDeleteSynchObj;
        synchronized (object) {
            if (this.updateQueryPlanForDelete == null) {
                this.updateQueryPlanForDelete = new UpdateQueryPlan(updateObjectDescImpl, sQLStoreManager);
                this.updateQueryPlanForDelete.build(true);
            }
        }
        return this.updateQueryPlanForDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForUpdate(UpdateObjectDescImpl updateObjectDescImpl, SQLStoreManager sQLStoreManager) {
        UpdateQueryPlan updateQueryPlan;
        String string = this.getSortedFieldNumbers(updateObjectDescImpl.getUpdatedFields());
        Map map = this.updateQueryPlanCache;
        synchronized (map) {
            updateQueryPlan = (UpdateQueryPlan)this.updateQueryPlanCache.get(string);
            if (updateQueryPlan == null) {
                updateQueryPlan = new UpdateQueryPlan(updateObjectDescImpl, sQLStoreManager);
                updateQueryPlan.build(true);
                this.updateQueryPlanCache.put(string, updateQueryPlan);
            }
        }
        return updateQueryPlan;
    }

    public String getSortedFieldNumbers(List list) {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            FieldDesc fieldDesc = (FieldDesc)list.get(i);
            nArray[i] = fieldDesc.absoluteID;
        }
        Arrays.sort(nArray);
        return StringHelper.intArrayToSeparatedList(nArray, ",");
    }
}

