/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperTransaction;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import javax.transaction.Synchronization;

public class TransactionImpl
implements Transaction {
    static boolean tracing;
    private static final int TRACE_THREADS = 1;
    private static final int TRACE_RESOURCES = 2;
    private static final int TRACE_SYNCHRONIZATIONS = 4;
    private static final int TRACE_ONE_PHASE = 8;
    static String globalLock;
    private int status = 6;
    private int timeout;
    public static final int TRAN_DEFAULT_TIMEOUT = 0;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int threads;
    public static final int TRAN_MAX_THREADS = 50;
    private boolean startedCommit;
    private boolean onePhase;
    private Synchronization synchronization = null;
    private ArrayList resources;
    private static final int RESOURCE_START = 0;
    private static final int RESOURCE_END = 1;
    private PersistenceManagerFactory pmFactory = null;
    private PersistenceManager persistenceManager = null;
    private Object connectionFactory = null;
    private javax.transaction.Transaction jta = null;
    private boolean isDataSource = false;
    private String username = null;
    private String password = null;
    private Connection _connection = null;
    private int _connectionReferenceCount = 0;
    private boolean retainValues = true;
    private boolean restoreValues = false;
    private boolean optimistic = true;
    private boolean nontransactionalRead = true;
    public static final int NON_MGD = 0;
    public static final int CMT = 1;
    public static final int BMT_UT = 2;
    public static final int BMT_JDO = 3;
    private int txType = -1;
    private static Logger logger;
    private static final ResourceBundle messages;
    private int INTERNAL_ERROR = 1;
    private int INTERNAL_OK = 0;

    public TransactionImpl(PersistenceManager persistenceManager, String string, String string2, int n) {
        this.timeout = n;
        this.startedCommit = false;
        this.onePhase = false;
        this.resources = new ArrayList();
        this.persistenceManager = persistenceManager;
        this.username = string;
        this.password = string2;
        this.pmFactory = (PersistenceManagerFactory)persistenceManager.getPersistenceManagerFactory();
        this.connectionFactory = this.pmFactory.getConnectionFactory();
        if (!(this.connectionFactory instanceof ConnectionFactory)) {
            this.isDataSource = true;
        }
        this.optimistic = this.pmFactory.getOptimistic();
        this.retainValues = this.pmFactory.getRetainValues();
        this.nontransactionalRead = this.pmFactory.getNontransactionalRead();
        this.queryTimeout = this.pmFactory.getQueryTimeout();
        this.updateTimeout = this.pmFactory.getUpdateTimeout();
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.persistenceManager.getCurrentWrapper();
    }

    public boolean isActive() {
        return this.status == 0 || this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetainValues(boolean bl) {
        if (this.isActive() && !this.optimistic && bl) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive() && !this.optimistic && bl) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.retainValues = bl;
            if (bl) {
                this.nontransactionalRead = bl;
                this.persistenceManager.notifyNontransactionalRead(bl);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestoreValues(boolean bl) {
        if (this.isActive()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive()) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.restoreValues = bl;
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNontransactionalRead(boolean bl) {
        if (this.isActive() && this.optimistic && !bl) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive() && this.optimistic && !bl) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.nontransactionalRead = bl;
            this.persistenceManager.notifyNontransactionalRead(bl);
            if (!bl) {
                this.retainValues = bl;
                this.optimistic = bl;
                this.persistenceManager.notifyOptimistic(bl);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUpdateTimeout(int n) {
        this.updateTimeout = n;
    }

    public int getUpdateTimeout() {
        return this.updateTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptimistic(boolean bl) {
        if (!this.isTerminated()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isTerminated()) {
                this.optimistic = bl;
                if (bl) {
                    this.nontransactionalRead = bl;
                    this.persistenceManager.notifyNontransactionalRead(bl);
                }
            } else {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.persistenceManager.notifyOptimistic(bl);
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronization(Synchronization synchronization) {
        if (tracing) {
            this.traceCall("setSynchronization");
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            this.synchronization = synchronization;
            if (tracing) {
                this.traceCallInfo("setSynchronization", 4, null);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synchronization getSynchronization() {
        this.persistenceManager.acquireShareLock();
        try {
            Synchronization synchronization = this.synchronization;
            return synchronization;
        }
        finally {
            this.persistenceManager.releaseShareLock();
        }
    }

    public int getTransactionType() {
        return this.txType;
    }

    public boolean verify(String string, String string2) {
        return !(this.username != null && !this.username.equals(string) || this.username == null && string != null || this.password != null && !this.password.equals(string2)) && (this.password != null || string2 == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        block7: {
            this.persistenceManager.acquireExclusiveLock();
            try {
                this.beginInternal();
                if (EJBHelper.isManaged()) {
                    this.txType = 3;
                    try {
                        EJBHelper.getUserTransaction().begin();
                        this.jta = EJBHelper.getTransaction();
                        EJBHelper.registerSynchronization(this.jta, this);
                        this.pmFactory.registerPersistenceManager(this.persistenceManager, this.jta);
                        break block7;
                    }
                    catch (JDOException jDOException) {
                        throw jDOException;
                    }
                    catch (Exception exception) {
                        throw new JDOFatalInternalException("Cannot register Synchronization", exception);
                    }
                }
                this.txType = 0;
            }
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
    }

    private void beginInternal() {
        this.setTrace();
        if (tracing) {
            this.traceCall("begin");
        }
        if (this.isActive()) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.begin.notnew", TransactionImpl.statusString(this.status)));
        }
        this.setStatus(0);
        this.threads = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(javax.transaction.Transaction transaction) {
        this.persistenceManager.acquireExclusiveLock();
        try {
            this.beginInternal();
            try {
                this.jta = transaction;
                EJBHelper.registerSynchronization(this.jta, this);
            }
            catch (Exception exception) {
                throw new JDOFatalInternalException("Cannot register Synchronization", exception);
            }
            this.txType = 1;
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        block9: {
            this.persistenceManager.acquireExclusiveLock();
            if (this.txType == 1 || this.txType == 2) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.mgd", "commit"));
            }
            if (this.txType == 3) {
                try {
                    EJBHelper.getUserTransaction().commit();
                    return;
                }
                catch (Exception exception) {
                    throw new JDOException("", exception);
                }
            }
            this.setTrace();
            if (tracing) {
                this.traceCall("commit");
            }
            break block9;
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
        this.commitBefore();
        this.commitPrepare();
        this.commitComplete();
        this.notifyAfterCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (this.txType == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.nonmgd", "beforeCompletion"));
        }
        Object object = null;
        try {
            object = EJBHelper.preInvoke(new Object[]{this, this.persistenceManager, this.jta});
            this.commitBefore();
            this.commitPrepare();
            this.commitComplete();
            this.closeConnection();
        }
        catch (Throwable throwable) {
            this.closeConnection();
            EJBHelper.postInvoke(object);
            throw throwable;
        }
        EJBHelper.postInvoke(object);
    }

    public void afterCompletion(int n) {
        if (this.txType == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.nonmgd", "afterCompletion"));
        }
        n = EJBHelper.translateStatus(n);
        if (tracing) {
            this.traceCallInfo("afterCompletion", 4, TransactionImpl.statusString(n));
        }
        if (n == 4) {
            this.setStatus(9);
            this.internalRollback();
        }
        if (n != this.status) {
            this.persistenceManager.forceClose();
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitprepare.wrongstatus", "afterCompletion", TransactionImpl.statusString(this.status), TransactionImpl.statusString(n)));
        }
        this.notifyAfterCompletion();
    }

    private void commitBefore() {
        boolean bl = false;
        boolean bl2 = false;
        if (tracing) {
            this.traceCall("commitBefore");
        }
        if (this.status == 9 || this.status == 4) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.rolledback", "commit", TransactionImpl.statusString(this.status)));
        }
        if (this.status == 1) {
            bl = true;
        } else if (this.status != 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commit_rollback.notactive", "commit", TransactionImpl.statusString(this.status)));
        }
        if (this.startedCommit) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitbefore.incommit", "commit"));
        }
        this.startedCommit = true;
        if (!bl) {
            this.notifyBeforeCompletion();
            bl2 = true;
            if (this.status == 0) {
                this.setStatus(7);
            } else if (this.status == 1) {
                bl = true;
            } else {
                throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitbefore.rolledback"));
            }
        }
        if (bl && this.txType == 0) {
            this.rollback();
            throw new JDOUserException(I18NHelper.getMessage(messages, bl2 ? "transaction.transactionimpl.commitbefore.rollbackonly_insync" : "transaction.transactionimpl.commitbefore.rollbackonly"));
        }
    }

    private void commitPrepare() {
        if (tracing) {
            this.traceCall("commitPrepare");
        }
        if (this.status != 7) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitprepare.wrongstatus", "commitPrepare", "STATUS_PREPARING", TransactionImpl.statusString(this.status)));
        }
        if (this.resources.size() <= 1) {
            this.onePhase = true;
        }
        this.setStatus(2);
    }

    private void commitComplete() {
        if (tracing) {
            this.traceCallInfo("commitComplete", 8, null);
        }
        if (this.status == 9) {
            this.setStatus(9);
            this.internalRollback();
        } else if (this.status == 2) {
            this.setStatus(8);
            this.internalCommit();
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitprepare.wrongstatus", "commitComplete", "STATUS_PREPARED", TransactionImpl.statusString(this.status)));
        }
    }

    private void internalCommit() {
        if (this.txType == 0) {
            int n = this.commitConnection();
            if (n != this.INTERNAL_OK) {
                this.forceRollback();
                throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitcomplete.error", "Connection Error"));
            }
            this.closeConnection();
        }
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        block9: {
            this.persistenceManager.acquireExclusiveLock();
            try {
                if (this.txType == 1 || this.txType == 2) {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.mgd", "rollback"));
                }
                this.setTrace();
                if (tracing) {
                    this.traceCall("rollback");
                }
                if (this.status != 0 && this.status != 1) {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commit_rollback.notactive", "rollback", TransactionImpl.statusString(this.status)));
                }
                this.setStatus(9);
                this.internalRollback();
                this.closeConnection();
                if (this.txType == 3) {
                    try {
                        EJBHelper.getUserTransaction().rollback();
                        break block9;
                    }
                    catch (Exception exception) {
                        throw new JDOException("", exception);
                    }
                }
                this.notifyAfterCompletion();
            }
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
    }

    private void internalRollback() {
        if (tracing) {
            this.traceCall("internalRollback");
        }
        if (this.status == 4) {
            return;
        }
        if (this.status != 9) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "transaction.transactionimpl.commitprepare.wrongstatus", "internalRollback", "STATUS_ROLLING_BACK", TransactionImpl.statusString(this.status)));
        }
        if (this.txType == 0) {
            this.rollbackConnection();
        }
        this.setStatus(4);
    }

    int forceRollback() {
        if (tracing) {
            this.traceCall("forceRollback");
        }
        if (this.status == 9 || this.status == 4 || this.status == 3 || this.status == 6) {
            return this.status;
        }
        this.internalRollback();
        this.notifyAfterCompletion();
        return this.status;
    }

    public void setRollbackOnly() {
        if (tracing) {
            this.traceCall("setRollbackOnly");
        }
        if (this.status == 9 || this.status == 4 || this.status == 1) {
            return;
        }
        if (this.txType != 0) {
            try {
                this.jta.setRollbackOnly();
            }
            catch (Exception exception) {
                throw new JDOException("", exception);
            }
        } else {
            this.setStatus(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        String string = globalLock;
        synchronized (string) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTerminated() {
        String string = globalLock;
        synchronized (string) {
            return this.status == 3 || this.status == 4 || this.status == 6;
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    private void notifyBeforeCompletion() {
        if (this.synchronization != null) {
            try {
                this.synchronization.beforeCompletion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.persistenceManager.beforeCompletion();
    }

    private void notifyAfterCompletion() {
        this.persistenceManager.afterCompletion(this.status);
        if (this.synchronization != null) {
            try {
                this.synchronization.afterCompletion(this.status);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.forget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(int n) {
        String string = globalLock;
        synchronized (string) {
            if (tracing) {
                Object[] objectArray = new Object[5];
                objectArray[0] = Thread.currentThread();
                objectArray[1] = this.toString();
                objectArray[2] = TransactionImpl.statusString(this.status);
                objectArray[3] = TransactionImpl.statusString(n);
                objectArray[4] = this.persistenceManager;
                Object[] objectArray2 = objectArray;
                logger.finest("sqlstore.transactionimpl.status", objectArray2);
            }
            this.status = n;
            this.persistenceManager.notifyStatusChange(this.isActive());
        }
    }

    private void forget() {
        if (tracing) {
            this.traceCall("forget");
        }
        this.threads = 0;
        this.startedCommit = false;
        if (this._connection != null) {
            try {
                if (!this._connection.isClosed()) {
                    this.closeConnection();
                    throw new JDOFatalInternalException("Connection has not been closed");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._connection = null;
        }
        this._connectionReferenceCount = 0;
        this.resources.clear();
        if (this.txType != 0) {
            this.persistenceManager.close();
        }
        this.jta = null;
        this.txType = 0;
        this.setTrace();
    }

    static void setTrace() {
        tracing = logger.isLoggable(300);
    }

    private void traceCall(String string) {
        Object[] objectArray = new Object[6];
        objectArray[0] = Thread.currentThread();
        objectArray[1] = this.toString();
        objectArray[2] = string;
        objectArray[3] = TransactionImpl.statusString(this.status);
        objectArray[4] = this.txTypeString();
        objectArray[5] = this.persistenceManager;
        Object[] objectArray2 = objectArray;
        logger.finest("sqlstore.transactionimpl.call", objectArray2);
    }

    private void traceCallInfo(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Thread.currentThread()").append("Tran[").append(this.toString()).append("].").append(string).append(": status = ").append(TransactionImpl.statusString(this.status));
        if ((n & 1) != 0) {
            stringBuffer.append(", threads = " + this.threads);
        }
        if ((n & 4) != 0) {
            stringBuffer.append(", sync = " + this.synchronization);
        }
        if ((n & 2) != 0) {
            stringBuffer.append(", resources = " + this.resources.size());
        }
        if ((n & 8) != 0 && this.onePhase) {
            stringBuffer.append(", onePhase = true");
        }
        if (string2 != null) {
            stringBuffer.append(", " + string2 + " for " + this.persistenceManager);
        }
        logger.finest("sqlstore.transactionimpl.general", stringBuffer.toString());
    }

    private void traceCallString(String string, String string2) {
        Object[] objectArray = new Object[]{Thread.currentThread(), this.toString(), string, string2, this.persistenceManager};
        logger.finest("sqlstore.transactionimpl.call.info", objectArray);
    }

    private String txTypeString() {
        switch (this.txType) {
            case 0: {
                return "NON_MGD";
            }
            case 1: {
                return "CMT";
            }
            case 2: {
                return "BMT_UT";
            }
            case 3: {
                return "BMT_JDO";
            }
        }
        return "UNKNOWN";
    }

    public static String statusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
        }
        return "STATUS_Invalid[" + n + "]";
    }

    public synchronized Connection getConnection() {
        boolean bl = logger.isLoggable(300);
        if (this._connection == null) {
            if (this.connectionFactory == null) {
                throw new JDOFatalInternalException("ConnectionFactory is NULL");
            }
            this._connection = this.getConnectionInternal();
        }
        ++this._connectionReferenceCount;
        if (bl) {
            Object[] objectArray = new Object[]{this._connection, new Boolean(this.optimistic), new Integer(this._connectionReferenceCount), this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.getconnection", objectArray);
        }
        if (!EJBHelper.isManaged()) {
            try {
                if (!this.optimistic && this.isActive() || this.startedCommit) {
                    if (this._connection.getAutoCommit()) {
                        this._connection.setAutoCommit(false);
                    }
                } else {
                    this._connection.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                logger.log(900, "sqlstore.exception.log", sQLException);
            }
        }
        return this._connection;
    }

    public void replaceConnection() {
        if (EJBHelper.isManaged()) {
            this.releaseConnection();
            this.closeConnection();
            this.getConnection();
        }
    }

    public synchronized void releaseConnection() {
        boolean bl = logger.isLoggable(300);
        if (this._connectionReferenceCount > 0) {
            --this._connectionReferenceCount;
        }
        if (bl) {
            Object[] objectArray = new Object[]{new Boolean(this.optimistic), new Boolean(this.startedCommit), new Integer(this._connectionReferenceCount), this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.releaseconnection", objectArray);
        }
        if (!EJBHelper.isManaged() && !this.optimistic || this.startedCommit) {
            return;
        }
        if (this._connectionReferenceCount == 0) {
            this.closeConnection();
        }
    }

    private Connection getConnectionInternal() {
        if (this.isDataSource) {
            try {
                if (EJBHelper.isManaged()) {
                    return EJBHelper.getConnection(this.connectionFactory, this.username, this.password);
                }
                if (this.username != null) {
                    return ((DataSource)this.connectionFactory).getConnection(this.username, this.password);
                }
                return ((DataSource)this.connectionFactory).getConnection();
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                int n = sQLException.getErrorCode();
                if (string == null) {
                    throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", "null", "" + n), sQLException);
                }
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", string, "" + n), sQLException);
            }
        }
        return ((ConnectionFactory)this.connectionFactory).getConnection();
    }

    private void closeConnection() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this._connection, this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.closeconnection", objectArray);
        }
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._connection = null;
    }

    private void rollbackConnection() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this._connection, this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.rollbackconnection", objectArray);
        }
        if (this._connection != null) {
            try {
                ((ConnectionImpl)this._connection).internalRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int commitConnection() {
        if (this._connection != null) {
            try {
                ((ConnectionImpl)this._connection).internalCommit();
            }
            catch (Exception exception) {
                return this.INTERNAL_ERROR;
            }
        }
        return this.INTERNAL_OK;
    }

    public String toString() {
        String string = "  Transaction: \n   status        = " + TransactionImpl.statusString(this.status) + "\n" + "   Transaction Object       = Transaction@" + this.hashCode() + "\n" + "   threads       = " + this.threads + "\n";
        if (this.timeout != 0) {
            string = string + "   timeout       = " + this.timeout + "\n";
        }
        if (this.startedCommit) {
            string = string + "   startedCommit = true\n";
        }
        if (this.onePhase) {
            string = string + "   onePhase      = true\n";
        }
        if (this.synchronization != null) {
            string = string + "sync:     " + this.synchronization + "\n";
        }
        if (!this.resources.isEmpty()) {
            string = string + "   # resources   = " + this.resources.size() + "\n";
        }
        return string;
    }

    static {
        globalLock = "TranGlobalLock";
        logger = LogHelperTransaction.getLogger();
        messages = I18NHelper.loadBundle(TransactionImpl.class);
    }
}

