/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDODuplicateObjectIdException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.Query;
import com.sun.jdo.spi.persistence.support.sqlstore.ExtentCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RuntimeVersion;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.TransactionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.query.QueryImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.HashSet;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlDate;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTime;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.NullSemaphore;
import com.sun.jdo.spi.persistence.utility.Semaphore;
import com.sun.jdo.spi.persistence.utility.SemaphoreImpl;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import javax.transaction.Transaction;

public class PersistenceManagerImpl
implements PersistenceManager {
    private boolean _isClosed = true;
    private PersistenceManagerWrapper current = null;
    private Transaction _jta = null;
    private PersistenceStore _store = null;
    private TransactionImpl _transaction = null;
    private PersistenceManagerFactory persistenceManagerFactory = null;
    private List _txCache;
    private Set _flushedCache;
    private WeakHashMap _weakCache;
    private static final int _txCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.dirtyCache.initialCapacity", 20);
    private static final int _flushedCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.transactionalCache.initialCapacity", 20);
    private static final float _flushedCacheLoadFactor;
    private static final int _weakCacheInitialCapacity;
    private static final float _weakCacheLoadFactor;
    private Collection queries = new ArrayList();
    private boolean _ignoreCache = true;
    private boolean _optimistic = true;
    private boolean _supersedeDeletedInstance = true;
    private boolean _nontransactionalRead = true;
    private boolean _activeTransaction = false;
    private Object _userObject = null;
    private boolean _insideCommit = false;
    private boolean _insideFlush = false;
    private static final String modelExt = ".mapping";
    private static final String oidName_OID = "OID";
    private static final String oidName_KEY = "KEY";
    private Properties _properties = null;
    private static final Class[] sigSM;
    private final Semaphore _cacheLock;
    private final Semaphore _fieldUpdateLock;
    private Object _readWriteLock = new Object();
    private long _readWriteCount = 0L;
    private long _waiterCount = 0L;
    private Thread _exclusiveLockHolder = null;
    private final boolean _multithreaded;
    private static Logger logger;
    private static final ResourceBundle messages;

    PersistenceManagerImpl(PersistenceManagerFactory persistenceManagerFactory, Transaction transaction, String string, String string2) {
        this.persistenceManagerFactory = persistenceManagerFactory;
        if (logger.isLoggable(300)) {
            Object[] objectArray = new Object[]{new Integer(_txCacheInitialCapacity), new Integer(_flushedCacheInitialCapacity), new Float(_flushedCacheLoadFactor), new Integer(_weakCacheInitialCapacity), new Float(_weakCacheLoadFactor)};
            logger.finest("sqlstore.persistencemgr.cacheproperties", objectArray);
        }
        this._txCache = new ArrayList(_txCacheInitialCapacity);
        this._flushedCache = new java.util.HashSet(_flushedCacheInitialCapacity, _flushedCacheLoadFactor);
        this._weakCache = new WeakHashMap(_weakCacheInitialCapacity, _weakCacheLoadFactor);
        this._transaction = new TransactionImpl(this, string, string2, 0);
        this._ignoreCache = persistenceManagerFactory.getIgnoreCache();
        this._optimistic = persistenceManagerFactory.getOptimistic();
        this._nontransactionalRead = persistenceManagerFactory.getNontransactionalRead();
        this._jta = transaction;
        this._isClosed = false;
        boolean bl = this._multithreaded = !EJBHelper.isManaged();
        if (this._multithreaded) {
            this._cacheLock = new SemaphoreImpl("PersistenceManagerImpl.cacheLock");
            this._fieldUpdateLock = new SemaphoreImpl("PersistenceManagerImpl.fieldUpdateLock");
        } else {
            this._cacheLock = new NullSemaphore("PersistenceManagerImpl.cacheLock");
            this._fieldUpdateLock = new NullSemaphore("PersistenceManagerImpl.fieldUpdateLock");
        }
    }

    protected void setStore(PersistenceStore persistenceStore) {
        this._store = persistenceStore;
    }

    protected PersistenceStore getStore() {
        return this._store;
    }

    protected boolean getIgnoreCache() {
        return this._ignoreCache;
    }

    protected boolean verify(String string, String string2) {
        return this._transaction.verify(string, string2);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void forceClose() {
        this.persistenceManagerFactory.releasePersistenceManager(this, this._jta);
        this._isClosed = true;
        while (this.current != null) {
            this.current.close();
        }
        Collection collection = this._weakCache.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            StateManager stateManager = (StateManager)iterator.next();
            stateManager.release();
        }
        this.disconnectQueries();
        this.persistenceManagerFactory = null;
        this._jta = null;
        this._weakCache.clear();
        this._txCache.clear();
        this._flushedCache.clear();
        this._flushedCache = null;
        this._txCache = null;
        this._weakCache = null;
        this._store = null;
        this._transaction = null;
        this._exclusiveLockHolder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.acquireExclusiveLock();
        try {
            if (this._jta != null) {
                this.persistenceManagerFactory.releasePersistenceManager(this, this._jta);
                this._jta = null;
            }
            if (this.current != null && this._transaction.getTransactionType() != 1) {
                return;
            }
            if (this._activeTransaction || this._flushedCache.size() > 0) {
                throw new JDOException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.close.activetransaction"));
            }
            this.forceClose();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public com.sun.jdo.api.persistence.support.Transaction currentTransaction() {
        this.assertIsOpen();
        return this._transaction;
    }

    public Query newQuery() {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl(this);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Query newQuery(Object object) {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl((PersistenceManager)this, object);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Query newQuery(Class clazz) {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl((PersistenceManager)this, clazz);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Query newQuery(Class clazz, Collection collection) {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl((PersistenceManager)this, clazz, collection);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Query newQuery(Class clazz, String string) {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl((PersistenceManager)this, clazz, string);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Query newQuery(Class clazz, Collection collection, String string) {
        this.assertIsOpen();
        QueryImpl queryImpl = new QueryImpl(this, clazz, collection, string);
        this.registerQuery(queryImpl);
        return queryImpl;
    }

    public Collection getExtent(Class clazz, boolean bl) {
        this.assertIsOpen();
        return new ExtentCollection(this, clazz, bl);
    }

    public Object getObjectById(Object object) {
        return this.getObjectById(object, false);
    }

    public Object getObjectById(Object object, boolean bl) {
        Object[] objectArray;
        boolean bl2 = logger.isLoggable(300);
        this.assertIsOpen();
        this.assertActiveTransaction(true);
        Object object2 = null;
        if (bl2) {
            objectArray = new Object[]{object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.getbyobjid", objectArray);
        }
        if (object == null) {
            return null;
        }
        objectArray = this.lookupObjectById(object, null);
        object2 = objectArray.getPersistent();
        if (bl && !JDOHelper.isTransactional(object2)) {
            try {
                objectArray.loadForRead();
            }
            catch (JDOException jDOException) {
                if (!objectArray.isValid()) {
                    this.deregisterInstance(object);
                    objectArray.release();
                }
                throw jDOException;
            }
            catch (Exception exception) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.fetchinstance.none"), exception);
            }
        }
        objectArray.setValid();
        return object2;
    }

    public StateManager findOrCreateStateManager(Object object, Class clazz) {
        return this.lookupObjectById(object, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateManager lookupObjectById(Object object, Class clazz) {
        StateManager stateManager;
        block11: {
            stateManager = null;
            try {
                this.acquireCacheLock();
                stateManager = (StateManager)this._weakCache.get(object);
                if (stateManager != null) break block11;
                boolean bl = false;
                if (clazz == null) {
                    clazz = this.loadClassForOid(object);
                    if (clazz == null) {
                        throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.getobjectbyid.nometadata"), new Object[]{object});
                    }
                    bl = true;
                }
                try {
                    stateManager = this._store.getStateManager(clazz);
                    this.newInstance(stateManager);
                    if (bl) {
                        object = this.internalCloneOid(object, stateManager);
                    }
                    stateManager.setObjectId(object);
                    this.setKeyFields(stateManager);
                    if (bl) {
                        stateManager.initialize(false);
                    } else {
                        this._weakCache.put(object, stateManager);
                    }
                }
                catch (JDOException jDOException) {
                    throw jDOException;
                }
                catch (Exception exception) {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.fetchinstance.none"), exception);
                }
            }
            finally {
                this.releaseCacheLock();
            }
        }
        return stateManager;
    }

    public Object getObjectId(Object object) {
        Object[] objectArray;
        boolean bl = logger.isLoggable(300);
        this.assertIsOpen();
        this.assertActiveTransaction(true);
        if (bl) {
            objectArray = new Object[]{Thread.currentThread(), object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.getobjid", objectArray);
        }
        try {
            this.assertPersistenceCapable(object);
        }
        catch (Exception exception) {
            if (bl) {
                Object[] objectArray2 = new Object[]{object, this};
                logger.finest("sqlstore.persistencemgr.getobjid.notpc", objectArray2);
            }
            return null;
        }
        objectArray = ((PersistenceCapable)object).jdoGetStateManager();
        if (!this._weakCache.containsValue(objectArray)) {
            if (bl) {
                Object[] objectArray3 = new Object[]{object, this, this._jta};
                logger.finest("sqlstore.persistencemgr.getobjid.notpm", objectArray3);
            }
            return null;
        }
        return this.internalGetObjectId((StateManager)objectArray);
    }

    public Object getTransactionalInstance(Object object) {
        this.assertIsOpen();
        this.assertActiveTransaction(false);
        if (!(object instanceof PersistenceCapable)) {
            return object;
        }
        PersistenceCapable persistenceCapable = (PersistenceCapable)object;
        PersistenceManagerWrapper persistenceManagerWrapper = (PersistenceManagerWrapper)persistenceCapable.jdoGetPersistenceManager();
        PersistenceManagerImpl persistenceManagerImpl = (PersistenceManagerImpl)persistenceManagerWrapper.getPersistenceManager();
        if (persistenceManagerImpl == null || persistenceManagerImpl == this) {
            return object;
        }
        return this.getObjectById(persistenceManagerImpl.internalGetObjectId(persistenceCapable.jdoGetStateManager()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistent(Object object) {
        Object[] objectArray;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            objectArray = new Object[]{Thread.currentThread(), object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.makepersistent", objectArray);
        }
        if (object == null) {
            return;
        }
        this.acquireShareLock();
        try {
            this.assertIsOpen();
            this.assertActiveTransaction(false);
            this.assertPersistenceCapable(object);
            this.internalMakePersistent((PersistenceCapable)object);
            if (bl) {
                objectArray = new Object[]{object, this, this._jta};
                logger.finest("sqlstore.persistencemgr.makepersistent.done", objectArray);
            }
        }
        finally {
            this.releaseShareLock();
        }
    }

    public void makePersistent(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.makePersistent(objectArray[i]);
        }
    }

    public void makePersistent(Collection collection) {
        if (collection == null) {
            return;
        }
        this.makePersistent(collection.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent(Object object) {
        if (object == null) {
            return;
        }
        this.acquireShareLock();
        try {
            this.assertIsOpen();
            this.assertActiveTransaction(false);
            this.assertPersistenceCapable(object);
            this.internalDeletePersistent((PersistenceCapable)object);
        }
        finally {
            this.releaseShareLock();
        }
    }

    public void deletePersistent(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.deletePersistent(objectArray[i]);
        }
    }

    public void deletePersistent(Collection collection) {
        if (collection == null) {
            return;
        }
        this.deletePersistent(collection.toArray());
    }

    public com.sun.jdo.api.persistence.support.PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        if (this.persistenceManagerFactory == null) {
            this.persistenceManagerFactory = persistenceManagerFactory;
        }
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public Properties getProperties() {
        if (this._properties == null) {
            this._properties = RuntimeVersion.getVendorProperties("/com/sun/jdo/spi/persistence/support/sqlstore/sys.properties");
        }
        return this._properties;
    }

    public boolean getSupersedeDeletedInstance() {
        return this._supersedeDeletedInstance;
    }

    public void setSupersedeDeletedInstance(boolean bl) {
        this._supersedeDeletedInstance = bl;
    }

    public Class getObjectIdClass(Class clazz) {
        PersistenceConfig persistenceConfig = this.loadPersistenceConfig(clazz);
        return persistenceConfig.getOidClass();
    }

    public Object newInstance(StateManager stateManager) {
        Object var2_2 = null;
        PersistenceConfig persistenceConfig = stateManager.getPersistenceConfig();
        if (persistenceConfig == null) {
            throw new JDOFatalInternalException("StateManager is not fully configured!");
        }
        Class clazz = persistenceConfig.getPersistenceCapableClass();
        try {
            Constructor constructor = clazz.getConstructor(sigSM);
            if (constructor != null) {
                var2_2 = constructor.newInstance(stateManager);
                stateManager.setPersistenceManager(this);
                stateManager.setPersistent(var2_2);
            }
        }
        catch (Exception exception) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.assertpersistencecapable.error", clazz.getName()), exception);
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection retrieve(RetrieveDesc retrieveDesc, ValueFetcher valueFetcher) {
        this.acquireShareLock();
        try {
            this.assertActiveTransaction(true);
            Collection collection = this._store.retrieve(this, retrieveDesc, valueFetcher);
            return collection;
        }
        finally {
            this.releaseShareLock();
        }
    }

    public Collection retrieve(RetrieveDesc retrieveDesc) {
        return this.retrieve(retrieveDesc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDesc(Class clazz) {
        this.acquireShareLock();
        try {
            this.loadPersistenceConfig(clazz);
            RetrieveDesc retrieveDesc = this._store.getRetrieveDesc(clazz);
            return retrieveDesc;
        }
        finally {
            this.releaseShareLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDesc(String string, Class clazz) {
        this.acquireShareLock();
        try {
            this.loadPersistenceConfig(clazz);
            RetrieveDesc retrieveDesc = this._store.getRetrieveDesc(string, clazz);
            return retrieveDesc;
        }
        finally {
            this.releaseShareLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstance(StateManager stateManager, Object object) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{Thread.currentThread(), object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.registerinstance", objectArray);
        }
        try {
            this.acquireCacheLock();
            if (bl) {
                logger.finest("sqlstore.persistencemgr.registerinstancein_wkc");
            }
            this._weakCache.put(object, stateManager);
        }
        finally {
            this.releaseCacheLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstance(StateManager stateManager, Object object, boolean bl, boolean bl2) {
        Object[] objectArray;
        boolean bl3;
        if (object == null) {
            object = stateManager.getObjectId();
        }
        if (bl3 = logger.isLoggable()) {
            objectArray = new Object[]{Thread.currentThread(), object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.registerinstance", objectArray);
        }
        try {
            this.acquireCacheLock();
            if (!this._weakCache.containsKey(object)) {
                if (bl3) {
                    logger.finest("sqlstore.persistencemgr.registerinstancein_wkc");
                }
                this._weakCache.put(object, stateManager);
            } else if (bl) {
                objectArray = (Object[])this._weakCache.get(object);
                if (this._supersedeDeletedInstance && objectArray.isDeleted()) {
                    if (bl3) {
                        logger.finer(I18NHelper.getMessage(messages, "sqlstore.persistencemgr.replacingdeletedinstance", object));
                    }
                    objectArray.markNotRegistered();
                    objectArray.markVerifyAtDeregister();
                    stateManager.markVerifyAtDeregister();
                    stateManager.markReplacement();
                    this._weakCache.remove(object);
                    objectArray.addDependency(stateManager);
                } else {
                    throw new JDODuplicateObjectIdException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.internalmakepersistent.dups"), new Object[]{stateManager.getPersistent()});
                }
            }
            if (this._activeTransaction && (stateManager.isTransactional() || bl2)) {
                if (bl3) {
                    objectArray = new Object[]{object, stateManager.getPersistent(), this, this._jta};
                    logger.finest("sqlstore.persistencemgr.registerinstancein_txc", objectArray);
                }
                if (stateManager.isDirty()) {
                    this._txCache.add(stateManager);
                }
                this._flushedCache.add(stateManager);
            }
        }
        finally {
            this.releaseCacheLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterInstance(Object object) {
        Object object2;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            object2 = new Object[]{object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.deregisterinstance", (Object[])object2);
        }
        if (object != null) {
            try {
                this.acquireCacheLock();
                object2 = this._weakCache.remove(object);
                if (object2 != null && this._activeTransaction) {
                    this._txCache.remove(object2);
                    this._flushedCache.remove(object2);
                }
            }
            finally {
                this.releaseCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterInstance(Object object, Object object2) {
        Object object3;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            object3 = new Object[]{object, this, this._jta};
            logger.finest("sqlstore.persistencemgr.deregisterinstance.verify", (Object[])object3);
        }
        try {
            this.acquireCacheLock();
            object3 = this._weakCache.get(object);
            if (object3 == object2) {
                this._weakCache.remove(object);
                if (bl) {
                    logger.finest("sqlstore.persistencemgr.deregisterinstance.verified");
                }
            }
            if (this._activeTransaction) {
                this._txCache.remove(object2);
                this._flushedCache.remove(object2);
            }
        }
        finally {
            this.releaseCacheLock();
        }
    }

    public void beforeCompletion() {
        StateManager stateManager;
        StateManager stateManager2;
        Iterator iterator;
        int n;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.beforecompletion");
        }
        this.assertIsOpen();
        this.assertActiveTransaction(false);
        this._insideCommit = true;
        for (n = 0; n < this._txCache.size(); ++n) {
            iterator = (StateManager)this._txCache.get(n);
            iterator.prepareToUpdatePhaseI();
        }
        if (!this._insideFlush) {
            java.util.HashSet hashSet = new java.util.HashSet();
            iterator = this._flushedCache.iterator();
            while (iterator.hasNext()) {
                stateManager2 = (StateManager)iterator.next();
                stateManager2.prepareToUpdatePhaseII(hashSet);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stateManager2 = (StateManager)iterator.next();
                stateManager2.prepareToUpdatePhaseIII();
            }
        }
        n = this._txCache.size();
        for (int i = 0; i < n; ++i) {
            stateManager2 = (StateManager)this._txCache.get(i);
            stateManager = i + 1 < n ? (StateManager)this._txCache.get(i + 1) : null;
            stateManager2.updatePersistent(stateManager);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            stateManager = (StateManager)this._txCache.get(i);
            if (stateManager.isProcessed()) continue;
            arrayList.add(stateManager.getPersistent());
        }
        if (arrayList.size() > 0) {
            this._transaction.setRollbackOnly();
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.not_processed"), arrayList.toArray());
        }
    }

    public void afterCompletion(int n) {
        this.assertIsOpen();
        this._insideCommit = true;
        boolean bl = n == 4 || n == 9 || n == 1;
        boolean bl2 = false;
        bl2 = logger.isLoggable(300);
        if (bl2) {
            logger.finest("sqlstore.persistencemgr.aftercompletion", new Boolean(bl));
        }
        boolean bl3 = this._transaction.getRetainValues();
        Iterator iterator = this._flushedCache.iterator();
        while (iterator.hasNext()) {
            StateManager stateManager = (StateManager)iterator.next();
            if (bl2) {
                logger.finest("sqlstore.persistencemgr.aftercompletion.process", stateManager.getObjectId());
            }
            if (bl) {
                stateManager.rollback(bl3);
                continue;
            }
            stateManager.commit(bl3);
        }
        this._txCache.clear();
        this._flushedCache.clear();
        this._insideCommit = false;
    }

    public void setStateManager(Object object, StateManager stateManager) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoSetStateManager(stateManager);
        }
    }

    public void setFlags(Object object, byte by) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoSetFlags(by);
        }
    }

    public byte getFlags(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetFlags();
        }
        return 0;
    }

    public StateManager getStateManager(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetStateManager();
        }
        return null;
    }

    public void setField(Object object, int n, Object object2) {
        if (object instanceof PersistenceCapable) {
            PersistenceCapable persistenceCapable = (PersistenceCapable)object;
            persistenceCapable.jdoSetField(n, object2);
        }
    }

    public Object getField(Object object, int n) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetField(n);
        }
        return null;
    }

    public void clearFields(Object object) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoClear();
        }
    }

    public Object newSCOInstance(Class clazz, Object object, String string) {
        Object object2 = null;
        object2 = Collection.class.isAssignableFrom(clazz) ? this.newCollectionInstanceInternal(clazz, object, string, null, true, 0) : this.newSCOInstanceInternal(clazz, object, string);
        this.replaceSCO(string, object, object2);
        return object2;
    }

    public Object newSCOInstanceInternal(Class clazz, Object object, String string) {
        java.util.Date date = null;
        if (clazz == Date.class || clazz == SqlDate.class) {
            date = new SqlDate(object, string);
        } else if (clazz == Time.class || clazz == SqlTime.class) {
            date = new SqlTime(object, string);
        } else if (clazz == Timestamp.class || clazz == SqlTimestamp.class) {
            date = new SqlTimestamp(object, string);
        } else if (clazz == com.sun.jdo.spi.persistence.support.sqlstore.sco.Date.class || java.util.Date.class.isAssignableFrom(clazz)) {
            date = new com.sun.jdo.spi.persistence.support.sqlstore.sco.Date(object, string);
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.newscoinstance.wrongclass", clazz.getName()));
        }
        return date;
    }

    public Object newCollectionInstance(Class clazz, Object object, String string, Class clazz2, boolean bl, int n) {
        Object object2 = this.newCollectionInstanceInternal(clazz, object, string, clazz2, bl, n);
        this.replaceSCO(string, object, object2);
        return object2;
    }

    public Object newCollectionInstanceInternal(Class clazz, Object object, String string, Class clazz2, boolean bl, int n) {
        HashSet hashSet = null;
        if (clazz == java.util.HashSet.class || clazz == HashSet.class) {
            if (n == 0) {
                n = 101;
            }
            hashSet = new HashSet(object, string, clazz2, bl, n);
        } else if (Set.class.isAssignableFrom(clazz)) {
            if (n == 0) {
                n = 101;
            }
            hashSet = new HashSet(object, string, clazz2, bl, n);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (n == 0) {
                n = 101;
            }
            hashSet = new HashSet(object, string, clazz2, bl, n);
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.newscoinstance.wrongclass", clazz.getName()));
        }
        boolean bl2 = logger.isLoggable(300);
        if (bl2) {
            logger.finest("sqlstore.persistencemgr.newcollection", hashSet.getClass());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalFlush() {
        this.acquireExclusiveLock();
        try {
            if (!this._optimistic) {
                this._insideFlush = true;
                this.beforeCompletion();
                this._insideCommit = false;
                int n = this._transaction.getStatus();
                if (n == 4 || n == 9 || n == 1) {
                    return;
                }
                for (int i = this._txCache.size() - 1; i >= 0; --i) {
                    StateManager stateManager = (StateManager)this._txCache.get(i);
                    stateManager.flushed();
                }
                this._insideFlush = false;
                this._txCache.clear();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public synchronized void notifyStatusChange(boolean bl) {
        this._activeTransaction = bl;
    }

    public synchronized void notifyOptimistic(boolean bl) {
        this._optimistic = bl;
    }

    public boolean isOptimisticTransaction() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.isoptimistic", new Boolean(this._optimistic));
        }
        return this._optimistic;
    }

    public synchronized void notifyNontransactionalRead(boolean bl) {
        this._nontransactionalRead = bl;
    }

    public boolean isNontransactionalRead() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.isnontxread", new Boolean(this._nontransactionalRead));
        }
        return this._nontransactionalRead;
    }

    public boolean isActiveTransaction() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.isactivetx", new Boolean(this._activeTransaction));
        }
        return this._activeTransaction;
    }

    public PersistenceManagerWrapper getCurrentWrapper() {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.getcurrentwrapper", this.current);
        }
        return this.current;
    }

    protected void pushCurrentWrapper(PersistenceManagerWrapper persistenceManagerWrapper) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this.current, persistenceManagerWrapper};
            logger.finest("sqlstore.persistencemgr.pushcurrentwrapper", objectArray);
        }
        this.current = persistenceManagerWrapper;
    }

    protected void popCurrentWrapper(PersistenceManagerWrapper persistenceManagerWrapper) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this.current, persistenceManagerWrapper};
            logger.finest("sqlstore.persistencemgr.popcurrentwrapper", objectArray);
        }
        this.current = persistenceManagerWrapper;
        if (!this._isClosed && this._jta == null && this.current == null) {
            this.close();
        }
    }

    protected void setJTATransaction(Transaction transaction) {
        if (this._jta != null) {
            throw new JDOFatalInternalException("Attempt to replace not null javax.transaction.Transaction: " + this._jta + " with " + transaction);
        }
        this._jta = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerQuery(QueryImpl queryImpl) {
        this.acquireExclusiveLock();
        try {
            this.queries.add(queryImpl);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void disconnectQueries() {
        Iterator iterator = this.queries.iterator();
        while (iterator.hasNext()) {
            QueryImpl queryImpl = (QueryImpl)iterator.next();
            queryImpl.clearPersistenceManager();
        }
        this.queries.clear();
        this.queries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSCO(String string, Object object, Object object2) {
        block8: {
            if (object instanceof PersistenceCapable) {
                this.acquireShareLock();
                try {
                    PersistenceCapable persistenceCapable = (PersistenceCapable)object;
                    StateManager stateManager = persistenceCapable.jdoGetStateManager();
                    if (object2 instanceof SCOCollection) {
                        this.acquireFieldUpdateLock();
                        try {
                            stateManager.replaceObjectField(string, object2);
                            break block8;
                        }
                        finally {
                            this.releaseFieldUpdateLock();
                        }
                    }
                    stateManager.replaceObjectField(string, object2);
                }
                finally {
                    this.releaseShareLock();
                }
            }
        }
    }

    private Object internalGetObjectId(StateManager stateManager) {
        Object object = stateManager.getObjectId();
        return this.internalCloneOid(object, stateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMakePersistent(PersistenceCapable persistenceCapable) {
        this.acquireFieldUpdateLock();
        try {
            PersistenceCapable persistenceCapable2 = persistenceCapable;
            synchronized (persistenceCapable2) {
                StateManager stateManager = null;
                if (persistenceCapable.jdoIsPersistent()) {
                    stateManager = persistenceCapable.jdoGetStateManager();
                    if (this != persistenceCapable.jdoGetStateManager().getPersistenceManagerInternal()) {
                        throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.another_pm"), new Object[]{persistenceCapable});
                    }
                } else {
                    Class<?> clazz = persistenceCapable.getClass();
                    this.loadPersistenceConfig(clazz);
                    stateManager = this._store.getStateManager(clazz);
                }
                stateManager.makePersistent(this, persistenceCapable);
            }
        }
        finally {
            this.releaseFieldUpdateLock();
        }
    }

    private void internalDeletePersistent(PersistenceCapable persistenceCapable) {
        if (!persistenceCapable.jdoIsPersistent()) {
            throw new JDOException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.internaldeletepersistent.transient"), new Object[]{persistenceCapable});
        }
        StateManager stateManager = persistenceCapable.jdoGetStateManager();
        PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
        if (this != persistenceManager) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.another_pm"), new Object[]{persistenceCapable});
        }
        if (!persistenceCapable.jdoIsDeleted()) {
            stateManager.deletePersistent();
        }
    }

    private Object fetchInstance(Object object) {
        boolean bl = logger.isLoggable(300);
        Collection collection = null;
        try {
            Class clazz = this.loadClassForOid(object);
            if (clazz == null) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.getobjectbyid.nometadata"), new Object[]{object});
            }
            if (bl) {
                logger.finest("sqlstore.persistencemgr.fetchinstance", clazz);
            }
            RetrieveDesc retrieveDesc = this._store.getRetrieveDesc(clazz);
            PersistenceConfig persistenceConfig = this.loadPersistenceConfig(clazz);
            Field[] fieldArray = persistenceConfig.getKeyFields();
            String[] stringArray = persistenceConfig.getKeyFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Field field = fieldArray[i];
                retrieveDesc.addConstraint(stringArray[i], 9, field.get(object));
            }
            collection = this.retrieve(retrieveDesc);
        }
        catch (Exception exception) {
            throw new JDODataStoreException(null, exception);
        }
        if (collection.size() == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.fetchinstance.none"), new Object[]{object});
        }
        if (collection.size() > 1) {
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.fetchinstance.many"), new Object[]{object});
        }
        return collection.toArray()[0];
    }

    private Class loadClassForOid(Object object) {
        Class<?> clazz = object.getClass();
        Class clazz2 = this._store.getClassByOidClass(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        this.loadByName(clazz.getName(), clazz.getClassLoader());
        return this._store.getClassByOidClass(clazz);
    }

    private void loadByName(String string, ClassLoader classLoader) {
        int n = string.length();
        if (n < 4) {
            return;
        }
        String string2 = string.substring(n - 3);
        if (string2.equalsIgnoreCase(oidName_OID) && (string.charAt(n - 4) == '.' || string.charAt(n - 4) == '$')) {
            string = string.substring(0, n - 4);
        } else if (string2.equalsIgnoreCase(oidName_KEY)) {
            string = string.substring(0, n - 3);
        } else {
            return;
        }
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.persistencemgr.loadingclass", string);
        }
        Class<?> clazz = null;
        try {
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Exception exception) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.loadclassforoid.wrongoidclass"), exception);
        }
        this.loadPersistenceConfig(clazz);
    }

    private void loadClassByMethod(Object object, Class clazz) {
        try {
            Method method = clazz.getMethod("getObjectClass", new Class[0]);
            Class clazz2 = (Class)method.invoke(object, new Object[0]);
            this.loadPersistenceConfig(clazz2);
        }
        catch (Exception exception) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.loadclassforoid.wrongoidclass"), exception);
        }
    }

    private void loadDirectory(String string) {
        File file;
        String[] stringArray;
        boolean bl = false;
        bl = logger.isLoggable(300);
        String string2 = "";
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string2.replace('.', File.separatorChar);
        }
        if ((stringArray = (file = new File(System.getProperty("user.dir") + File.separator + string3)).list(new ExtensionFilter(modelExt))) == null) {
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = stringArray[n].lastIndexOf(modelExt);
            String string4 = string2 + "." + stringArray[n].substring(0, n2);
            if (bl) {
                logger.finest("sqlstore.persistencemgr.loadingclass", string4);
                Object[] objectArray = new Object[]{string3, File.separator, stringArray[n]};
                logger.finest("sqlstore.persistencemgr.loadingfile", objectArray);
            }
            if (string4 == null) continue;
            try {
                this._store.getPersistenceConfig(Class.forName(string4));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void assertIsOpen() {
        if (this._isClosed) {
            boolean bl = logger.isLoggable(300);
            if (bl) {
                logger.finest("sqlstore.persistencemgr.assertisopen", this);
            }
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.assertclosed.closed"));
        }
    }

    private void assertActiveTransaction(boolean bl) {
        boolean bl2 = false;
        bl2 = logger.isLoggable(300);
        if (bl2) {
            logger.finest("sqlstore.persistencemgr.assertactivetx", this._transaction);
        }
        if (this._insideCommit || bl && this._transaction.getNontransactionalRead()) {
            return;
        }
        if (!this._activeTransaction) {
            if (bl2) {
                logger.finest("sqlstore.persistencemgr.assertactivetx.closed", this);
            }
            throw new JDOException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.assertactivetransaction.error"));
        }
    }

    private void assertPersistenceCapable(Object object) {
        if (!(object instanceof PersistenceCapable)) {
            throw new JDOException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.assertpersistencecapable.error", object.getClass().getName()), new Object[]{object});
        }
    }

    private void setKeyFields(StateManager stateManager) {
        block4: {
            Object object = stateManager.getPersistent();
            if (object == null) {
                return;
            }
            Object object2 = stateManager.getObjectId();
            try {
                PersistenceConfig persistenceConfig = stateManager.getPersistenceConfig();
                Field[] fieldArray = persistenceConfig.getKeyFields();
                String[] stringArray = persistenceConfig.getKeyFieldNames();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    stateManager.makePresent(stringArray[i], field.get(object2));
                }
            }
            catch (Exception exception) {
                boolean bl = logger.isLoggable(300);
                if (!bl) break block4;
                logger.finest("sqlstore.persistencemgr.setkeyfields", exception);
            }
        }
    }

    private PersistenceConfig loadPersistenceConfig(Class clazz) {
        return this._store.getPersistenceConfig(clazz);
    }

    private Object internalCloneOid(Object object, StateManager stateManager) {
        Object[] objectArray;
        if (object == null) {
            return null;
        }
        boolean bl = logger.isLoggable(300);
        Object var4_4 = null;
        try {
            objectArray = object.getClass();
            var4_4 = objectArray.newInstance();
            PersistenceConfig persistenceConfig = stateManager.getPersistenceConfig();
            Field[] fieldArray = persistenceConfig.getKeyFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                field.set(var4_4, field.get(object));
            }
        }
        catch (Exception exception) {
            if (bl) {
                logger.finest("sqlstore.persistencemgr.internalcloneoid", exception);
            }
            var4_4 = null;
        }
        if (bl) {
            objectArray = new Object[]{object, var4_4, new Boolean(object == var4_4)};
            logger.finest("sqlstore.persistencemgr.internalcloneoid.old", objectArray);
        }
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShareLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            if (this._readWriteCount < 0L && this._exclusiveLockHolder == Thread.currentThread()) {
                return;
            }
            while (this._readWriteCount < 0L) {
                ++this._waiterCount;
                try {
                    if (bl) {
                        logger.finest("sqlstore.persistencemgr.acquiresharedlock", Thread.currentThread());
                    }
                    this._readWriteLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.acquiresharelock.interrupted"), interruptedException);
                }
                finally {
                    --this._waiterCount;
                }
            }
            try {
                this.assertIsOpen();
            }
            catch (JDOException jDOException) {
                if (this._readWriteCount == 0L && this._waiterCount > 0L) {
                    this._readWriteLock.notify();
                }
                throw jDOException;
            }
            ++this._readWriteCount;
            if (bl) {
                logger.finest("sqlstore.persistencemgr.acquiresharedlock.rdwrcount", Thread.currentThread(), new Long(this._readWriteCount));
            }
            if (this._readWriteCount <= 0L) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.acquiresharelock.failed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseShareLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            if (this._readWriteCount < 0L && this._exclusiveLockHolder == Thread.currentThread()) {
                return;
            }
            try {
                if (this._readWriteCount == 0L) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.releasesharelock.failed"));
                }
                --this._readWriteCount;
                Object var4_3 = null;
                if (this._waiterCount > 0L && this._readWriteCount == 0L) {
                    this._readWriteLock.notify();
                }
                if (!bl) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this._waiterCount > 0L && this._readWriteCount == 0L) {
                    this._readWriteLock.notify();
                }
                if (!bl) throw throwable;
                Object[] objectArray = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                logger.finest("sqlstore.persistencemgr.releasesharedlock", objectArray);
                throw throwable;
            }
            Object[] objectArray = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
            logger.finest("sqlstore.persistencemgr.releasesharedlock", objectArray);
            {
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusiveLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (thread == this._exclusiveLockHolder) {
                --this._readWriteCount;
            } else {
                while (this._readWriteCount != 0L) {
                    ++this._waiterCount;
                    try {
                        if (bl) {
                            logger.finest("sqlstore.persistencemgr.acquireexclusivelock", thread);
                        }
                        this._readWriteLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.acquireexclusivelock.interrupted"), interruptedException);
                    }
                    finally {
                        --this._waiterCount;
                    }
                }
                try {
                    this.assertIsOpen();
                }
                catch (JDOException jDOException) {
                    if (this._readWriteCount == 0L && this._waiterCount > 0L) {
                        this._readWriteLock.notify();
                    }
                    throw jDOException;
                }
                this._readWriteCount = -1L;
                this._exclusiveLockHolder = thread;
                if (bl) {
                    Object[] objectArray = new Object[]{thread, new Long(this._readWriteCount)};
                    logger.fine("sqlstore.persistencemgr.acquireexclusivelock.count", objectArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusiveLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            block12: {
                try {
                    if (this._readWriteCount >= 0L) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.releaseexclusivelock.failed"));
                    }
                    ++this._readWriteCount;
                    Object var4_3 = null;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (bl) {
                        Object[] objectArray = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                        logger.finest("sqlstore.persistencemgr.releaseexclusivelock", objectArray);
                    }
                    if (this._readWriteCount == 0L) {
                        if (this._waiterCount > 0L) {
                            this._readWriteLock.notify();
                        }
                        this._exclusiveLockHolder = null;
                    }
                    throw throwable;
                }
                Object[] objectArray = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                logger.finest("sqlstore.persistencemgr.releaseexclusivelock", objectArray);
            }
            if (this._readWriteCount == 0L) {
                if (this._waiterCount > 0L) {
                    this._readWriteLock.notify();
                }
                this._exclusiveLockHolder = null;
            }
        }
    }

    public void acquireFieldUpdateLock() {
        this._fieldUpdateLock.acquire();
    }

    public void releaseFieldUpdateLock() {
        this._fieldUpdateLock.release();
    }

    public void acquireCacheLock() {
        this._cacheLock.acquire();
    }

    public void releaseCacheLock() {
        this._cacheLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        float f = 0.75f;
        try {
            f = Float.valueOf(System.getProperty("com.sun.jdo.api.persistence.support.PersistenceManager.transactionalCache.loadFactor", "0.75")).floatValue();
        }
        finally {
            _flushedCacheLoadFactor = f;
        }
        _weakCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.globalCache.initialCapacity", 20);
        f = 0.75f;
        try {
            f = Float.valueOf(System.getProperty("com.sun.jdo.api.persistence.support.PersistenceManager.globalCache.loadFactor", "0.75")).floatValue();
        }
        finally {
            _weakCacheLoadFactor = f;
        }
        sigSM = new Class[]{StateManager.class};
        logger = LogHelperPersistenceManager.getLogger();
        messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", PersistenceManagerImpl.class.getClassLoader());
    }

    static class ExtensionFilter
    implements FilenameFilter {
        private String ext;

        public ExtensionFilter(String string) {
            this.ext = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.ext);
        }
    }
}

