/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOCanRetryException;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class ConnectionFactoryImpl
implements ConnectionFactory,
Serializable {
    private String URL = null;
    private String userName = null;
    private String password = null;
    private String driverName = null;
    private int maxPool = 0;
    private int minPool = 0;
    private int msInterval = 0;
    private int loginTimeout = 0;
    private int msWait = 0;
    private int _txIsolation = -1;
    private PrintWriter logWriter = null;
    private transient boolean _configured = false;
    private transient ConnectionManager connectionManager = null;
    private static final transient ResourceBundle messages = I18NHelper.loadBundle(ConnectionFactoryImpl.class);

    public ConnectionFactoryImpl() {
    }

    public ConnectionFactoryImpl(String string, String string2, String string3, String string4) {
        this.driverName = string4;
        this.URL = string;
        this.userName = string2;
        this.password = string3;
    }

    public ConnectionFactoryImpl(String string, String string2, String string3, String string4, int n, int n2) {
        this.driverName = string4;
        this.URL = string;
        this.userName = string2;
        this.password = string3;
        this.minPool = n;
        this.maxPool = n2;
    }

    public void setDriverName(String string) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.driverName = string;
        } else {
            try {
                this.connectionManager.setDriverName(string);
            }
            catch (Exception exception) {
                throw new JDOFatalException(null, exception);
            }
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setURL(String string) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.URL = string;
        } else {
            try {
                this.connectionManager.setURL(string);
            }
            catch (Exception exception) {
                throw new JDOFatalException(null, exception);
            }
        }
    }

    public String getURL() {
        return this.URL;
    }

    public void setUserName(String string) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.userName = string;
        } else {
            try {
                this.connectionManager.setUserName(string);
            }
            catch (Exception exception) {
                throw new JDOFatalException(null, exception);
            }
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.password = string;
        } else {
            try {
                this.connectionManager.setPassword(string);
            }
            catch (Exception exception) {
                throw new JDOFatalException(null, exception);
            }
        }
    }

    public void setMinPool(int n) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.minPool = n;
            return;
        }
        try {
            this.connectionManager.setMinPool(n);
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMaxPool(int n) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.maxPool = n;
            return;
        }
        try {
            this.connectionManager.setMaxPool(n);
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setMsInterval(int n) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.msInterval = n;
            return;
        }
        try {
            this.connectionManager.setMsInterval(n);
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    public int getMsInterval() {
        if (this.connectionManager == null) {
            return this.msInterval;
        }
        return this.connectionManager.getMsInterval();
    }

    public void setMsWait(int n) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.msWait = n;
            return;
        }
        try {
            this.connectionManager.setMsWait(n);
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    public int getMsWait() {
        if (this.connectionManager == null) {
            return this.msWait;
        }
        return this.connectionManager.getMsWait();
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.assertNotConfigured();
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLoginTimeout(int n) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.loginTimeout = n;
            return;
        }
        try {
            this.connectionManager.setLoginTimeout(n);
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    public int getLoginTimeout() {
        if (this.connectionManager == null) {
            return this.loginTimeout;
        }
        try {
            return this.connectionManager.getLoginTimeout();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setTransactionIsolation(int n) {
        block7: {
            this.assertNotConfigured();
            if (this.connectionManager == null) {
                this._txIsolation = n;
                return;
            }
            Connection connection = null;
            try {
                connection = this.connectionManager.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData.supportsTransactionIsolationLevel(n)) {
                    this._txIsolation = n;
                    break block7;
                }
                throw new JDOFatalException(I18NHelper.getMessage(messages, "connectionefactoryimpl.isolationlevel_notsupported", n));
            }
            catch (Exception exception) {
                throw new JDOFatalException(null, exception);
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() {
        if (this.connectionManager == null) {
            return this._txIsolation;
        }
        Connection connection = null;
        try {
            if (this._txIsolation == -1) {
                ConnectionFactoryImpl connectionFactoryImpl = this;
                synchronized (connectionFactoryImpl) {
                    if (this._txIsolation == -1) {
                        connection = this.connectionManager.getConnection();
                        this._txIsolation = connection.getTransactionIsolation();
                    }
                }
            }
            int n = this._txIsolation;
            return n;
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public Connection getConnection() {
        try {
            if (this.connectionManager == null) {
                this.initialize();
            }
            Connection connection = this.connectionManager.getConnection();
            connection.setTransactionIsolation(this._txIsolation);
            return connection;
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            int n = sQLException.getErrorCode();
            if (string == null) {
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", "null", "" + n), sQLException);
            }
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", string, "" + n), sQLException);
        }
        catch (Exception exception) {
            throw new JDOCanRetryException(I18NHelper.getMessage(messages, "connectionefactoryimpl.getconnection"), exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ConnectionFactoryImpl) {
            ConnectionFactoryImpl connectionFactoryImpl = (ConnectionFactoryImpl)object;
            return connectionFactoryImpl.URL.equals(this.URL) && connectionFactoryImpl.userName.equals(this.userName) && connectionFactoryImpl.driverName.equals(this.driverName) && connectionFactoryImpl.password.equals(this.password);
        }
        return false;
    }

    public int hashCode() {
        return this.URL.hashCode() + this.userName.hashCode() + this.password.hashCode() + this.driverName.hashCode();
    }

    public void configured(boolean bl) {
        this._configured = bl;
    }

    private void assertNotConfigured() {
        if (this._configured) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.configured"));
        }
    }

    private void assertConnectionWait() {
        if (this.msWait < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.mswaitvalue"));
        }
        if (this.msInterval < 0 || this.msInterval > this.msWait || this.msWait > 0 && this.msInterval == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.msintervalvalue"));
        }
    }

    private synchronized void initialize() {
        if (this.connectionManager != null) {
            return;
        }
        try {
            this.assertConnectionWait();
            this.connectionManager = new ConnectionManager(this.driverName, this.URL, this.userName, this.password, this.minPool, this.maxPool);
            this.connectionManager.setMsWait(this.msWait);
            this.connectionManager.setMsInterval(this.msInterval);
            this.connectionManager.setLoginTimeout(this.loginTimeout);
            if (this._txIsolation > 0) {
                this.setTransactionIsolation(this._txIsolation);
            } else {
                this._txIsolation = this.getTransactionIsolation();
            }
            this.configured(true);
        }
        catch (JDOException jDOException) {
            throw jDOException;
        }
        catch (Exception exception) {
            throw new JDOFatalException(null, exception);
        }
    }

    private void unsupported() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
    }

    private void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection = null;
    }
}

