/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.StatementImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.TransactionHelper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public class EJBHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", EJBHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    static TransactionHelper myHelper = DefaultTransactionHelper.getInstance();

    public static void registerTransactionHelper(TransactionHelper transactionHelper) {
        myHelper = transactionHelper;
        if (myHelper == null) {
            myHelper = DefaultTransactionHelper.getInstance();
        }
    }

    public static Transaction getTransaction() {
        return myHelper.getTransaction();
    }

    public static UserTransaction getUserTransaction() {
        return myHelper.getUserTransaction();
    }

    public static boolean isManaged() {
        return myHelper.isManaged();
    }

    public static int translateStatus(int n) {
        return myHelper.translateStatus(n);
    }

    public static PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        return myHelper.replaceInternalPersistenceManagerFactory(persistenceManagerFactory);
    }

    public static Object preInvoke(Object object) {
        return myHelper.preInvoke(object);
    }

    public static void postInvoke(Object object) {
        myHelper.postInvoke(object);
    }

    public static void registerSynchronization(Transaction transaction, Synchronization synchronization) throws RollbackException, SystemException {
        myHelper.registerSynchronization(transaction, synchronization);
    }

    public static Connection getConnection(Object object, String string, String string2) throws SQLException {
        return myHelper.getConnection(object, string, string2);
    }

    public static void beginInternalTransaction(PersistenceManager persistenceManager) {
        myHelper.beginInternalTransaction(persistenceManager);
    }

    public static void commitInternalTransaction(PersistenceManager persistenceManager) {
        myHelper.commitInternalTransaction(persistenceManager);
    }

    public static void rollbackInternalTransaction(PersistenceManager persistenceManager) {
        myHelper.rollbackInternalTransaction(persistenceManager);
    }

    public static Statement unwrapStatement(Statement statement) {
        return myHelper.unwrapStatement(statement);
    }

    public static void setPersistenceManagerFactoryDefaults(PersistenceManagerFactory persistenceManagerFactory) {
        myHelper.setPersistenceManagerFactoryDefaults(persistenceManagerFactory);
    }

    private static class DefaultTransactionHelper
    implements TransactionHelper {
        private static final DefaultTransactionHelper instance = new DefaultTransactionHelper();

        private DefaultTransactionHelper() {
        }

        public static DefaultTransactionHelper getInstance() {
            return instance;
        }

        public Transaction getTransaction() {
            return null;
        }

        public UserTransaction getUserTransaction() {
            return null;
        }

        public boolean isManaged() {
            return false;
        }

        public int translateStatus(int n) {
            return n;
        }

        public PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
            return persistenceManagerFactory;
        }

        public Object preInvoke(Object object) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "preInvoke"));
        }

        public void postInvoke(Object object) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "postInvoke"));
        }

        public void registerSynchronization(Transaction transaction, Synchronization synchronization) throws RollbackException, SystemException {
        }

        public Connection getConnection(Object object, String string, String string2) throws SQLException {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "getConnection"));
        }

        public void beginInternalTransaction(PersistenceManager persistenceManager) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "beginInternalTransaction"));
        }

        public void commitInternalTransaction(PersistenceManager persistenceManager) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "commitInternalTransaction"));
        }

        public void rollbackInternalTransaction(PersistenceManager persistenceManager) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.ejbhelper.nonmanaged", "rollbackInternalTransaction"));
        }

        public Statement unwrapStatement(Statement statement) {
            if (statement instanceof StatementImpl) {
                return ((StatementImpl)statement).unwrapStatement();
            }
            return statement;
        }

        public void setPersistenceManagerFactoryDefaults(PersistenceManagerFactory persistenceManagerFactory) {
        }
    }
}

