/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ContainerHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB11Helper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB20Helper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;

public class CMPHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", CMPHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    static ContainerHelper containerHelper;
    static Map jdoHelpers;
    private static long counter;

    public static void registerContainerHelper(ContainerHelper containerHelper) {
        CMPHelper.containerHelper = containerHelper;
    }

    public static void registerJDOHelper(String string, JDOEJB11Helper jDOEJB11Helper) {
        jdoHelpers.put(string, jDOEJB11Helper);
    }

    public static JDOEJB11Helper getJDOEJB11Helper(String string) {
        return (JDOEJB11Helper)jdoHelpers.get(string);
    }

    public static JDOEJB20Helper getJDOEJB20Helper(String string) {
        return (JDOEJB20Helper)jdoHelpers.get(string);
    }

    public static synchronized long getNextId() {
        return ++counter;
    }

    public static Properties loadJDOQLElementsProperties(Class clazz, String string) {
        if (clazz == null) {
            JDOFatalUserException jDOFatalUserException = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.cmphelper.missingclass"));
            logger.severe(((Throwable)jDOFatalUserException).toString());
            throw jDOFatalUserException;
        }
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            JDOFatalUserException jDOFatalUserException = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.cmphelper.cannotfindfile", string));
            logger.severe(((Throwable)jDOFatalUserException).toString());
            throw jDOFatalUserException;
        }
        try {
            Properties properties = null;
            properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            JDOFatalUserException jDOFatalUserException = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.cmphelper.errorloadingproperties", string, clazz.getName()), iOException);
            logger.severe(((Throwable)jDOFatalUserException).toString());
            throw jDOFatalUserException;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Object getContainer(Object object) {
        if (containerHelper == null) {
            throw new JDOFatalInternalException("ContainerHelper instance is not registered.");
        }
        return containerHelper.getContainer(object);
    }

    public static EJBObject getEJBObject(Object object, Object object2) {
        return containerHelper.getEJBObject(object, object2);
    }

    public static EJBLocalObject getEJBLocalObject(Object object, Object object2) {
        return containerHelper.getEJBLocalObject(object, object2);
    }

    public static EJBLocalObject getEJBLocalObject(Object object, Object object2, EJBContext eJBContext) {
        return containerHelper.getEJBLocalObject(object, object2, eJBContext);
    }

    public static void removeByEJBLocalObject(EJBLocalObject eJBLocalObject, Object object) {
        containerHelper.removeByEJBLocalObject(eJBLocalObject, object);
    }

    public static void removeByPK(Object object, Object object2) {
        containerHelper.removeByPK(object, object2);
    }

    public static void setCascadeDeleteAfterSuperEJBRemove(EntityContext entityContext) {
        containerHelper.setCascadeDeleteAfterSuperEJBRemove(entityContext);
    }

    static {
        jdoHelpers = Collections.synchronizedMap(new HashMap());
        counter = System.currentTimeMillis();
    }
}

