/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ObjectID;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlID;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputParamValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateStatement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

public class SQLStoreManager
implements PersistenceStore {
    private Map classConfigs = new HashMap();
    private Map classByOidTable = new Hashtable();
    private DBVendorType vendorType;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(SQLStoreManager.class);
    private static int fetchSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager.fetchSize", -1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceConfig getPersistenceConfig(Class clazz) {
        PersistenceConfig persistenceConfig = null;
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sqlstoremanager.getpersistenceconfig", clazz.getName());
        }
        Map map = this.classConfigs;
        synchronized (map) {
            persistenceConfig = (PersistenceConfig)this.classConfigs.get(clazz);
            if (persistenceConfig != null) {
                return persistenceConfig;
            }
            try {
                Model model = Model.RUNTIME;
                String string = clazz.getName();
                ClassLoader classLoader = clazz.getClassLoader();
                MappingClassElement mappingClassElement = model.getMappingClass(string, classLoader);
                Collection collection = null;
                collection = model.validate(string, classLoader, null);
                if (!collection.isEmpty()) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        logger.severe(I18NHelper.getMessage(messages, "core.configuration.validationproblem", string, iterator.next().toString()));
                    }
                    throw new JDOUserException(I18NHelper.getMessage(messages, "core.configuration.validationfailed", string));
                }
                ClassDesc classDesc = new ClassDesc(mappingClassElement, clazz);
                this.classConfigs.put(clazz, classDesc);
                classDesc.initialize(this);
                this.classByOidTable.put(classDesc.getOidClass(), clazz);
                persistenceConfig = classDesc;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.loadfailed", clazz.getName()), illegalArgumentException);
            }
            catch (Exception exception) {
                logger.log(500, "sqlstore.exception.log", exception);
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.loadfailed", clazz.getName()), exception);
            }
        }
        return persistenceConfig;
    }

    public void execute(PersistenceManager persistenceManager, Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ActionDesc actionDesc = (ActionDesc)iterator.next();
            if (actionDesc instanceof UpdateObjectDescImpl) {
                UpdateObjectDescImpl updateObjectDescImpl = (UpdateObjectDescImpl)actionDesc;
                ClassDesc classDesc = this.validateAction(actionDesc);
                UpdateQueryPlan updateQueryPlan = new UpdateQueryPlan(updateObjectDescImpl, this);
                updateQueryPlan.build();
                int n = updateQueryPlan.statements.size();
                for (int i = 0; i < n; ++i) {
                    Statement statement = (Statement)updateQueryPlan.statements.get(i);
                    if (statement == null) continue;
                    this.executeUpdate(persistenceManager, statement);
                }
                continue;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", actionDesc.getClass().getName(), "UpdateObjectDescImpl"));
        }
    }

    private void rollbackXact(Transaction transaction) {
        try {
            transaction.setRollbackOnly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bindInputColumn(DBStatement dBStatement, int n, InputValue inputValue, int n2) throws SQLException {
        dBStatement.bindInputColumn(n, inputValue.value, n2, this.vendorType);
    }

    private void bindInputColumn(DBStatement dBStatement, int n, InputValue inputValue, int n2, ValueFetcher valueFetcher) throws SQLException {
        Object object;
        if (inputValue instanceof InputParamValue) {
            int n3 = (Integer)inputValue.value;
            object = valueFetcher.getValue(n3);
        } else {
            object = inputValue.value;
        }
        dBStatement.bindInputColumn(n, object, n2, this.vendorType);
    }

    private void bindInputColumn(DBStatement dBStatement, ColumnRef columnRef, UpdateObjectDescImpl updateObjectDescImpl, boolean bl) throws SQLException {
        LocalFieldDesc localFieldDesc = (LocalFieldDesc)columnRef.getValue();
        Object object = localFieldDesc.isHorizontalDiscriminator() ? localFieldDesc.getDiscriminatorValue() : (bl ? updateObjectDescImpl.getAfterValue(localFieldDesc) : updateObjectDescImpl.getBeforeValue(localFieldDesc));
        dBStatement.bindInputColumn(columnRef.getIndex(), object, columnRef.getColumnElement().getType(), this.vendorType);
    }

    private void executeUpdate(PersistenceManager persistenceManager, Statement statement) {
        int n = 0;
        DBStatement dBStatement = null;
        Connection connection = null;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate");
        }
        Transaction transaction = (Transaction)persistenceManager.currentTransaction();
        try {
            connection = transaction.getConnection();
            String string = statement.getText();
            if (string.length() > 0) {
                int n2;
                if (bl) {
                    if (logger.isLoggable(400)) {
                        logger.finer(SQLStoreManager.formatSqlText(string, statement.inputDesc));
                    } else {
                        logger.fine(SQLStoreManager.formatSqlText(string, null));
                    }
                }
                dBStatement = new DBStatement(connection, string, transaction.getUpdateTimeout());
                int n3 = statement.inputDesc.values.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    InputValue inputValue = (InputValue)statement.inputDesc.values.get(n2);
                    this.bindInputColumn(dBStatement, n2 + 1, inputValue, inputValue.sqlType);
                }
                n = dBStatement.executeUpdate();
                if (n < statement.minAffectedRows) {
                    this.rollbackXact(transaction);
                    n2 = string.indexOf(32);
                    throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.store.operationfailed", string.substring(0, n2)));
                }
            }
        }
        catch (SQLException sQLException) {
            this.rollbackXact(transaction);
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
        }
        finally {
            SQLStoreManager.close(dBStatement);
            SQLStoreManager.closeConnection(transaction, connection);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeupdate.exit", new Integer(n));
        }
    }

    public Class getClassByOidClass(Class clazz) {
        return (Class)this.classByOidTable.get(clazz);
    }

    public StateManager getStateManager(Class clazz) {
        ClassDesc classDesc = (ClassDesc)this.getPersistenceConfig(clazz);
        if (classDesc != null) {
            return classDesc.newStateManagerInstance(this);
        }
        return null;
    }

    public RetrieveDesc getRetrieveDesc(Class clazz) {
        RetrieveDescImpl retrieveDescImpl = new RetrieveDescImpl(clazz);
        retrieveDescImpl.options |= this.getVendorType().getOptNoCollective();
        return retrieveDescImpl;
    }

    public RetrieveDesc getRetrieveDesc(String string, Class clazz) {
        FieldDesc fieldDesc;
        ClassDesc classDesc = (ClassDesc)this.getPersistenceConfig(clazz);
        if (classDesc != null && (fieldDesc = classDesc.getField(string)) instanceof ForeignFieldDesc) {
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
            return this.getRetrieveDesc(foreignFieldDesc.foreignConfig.getPersistenceCapableClass());
        }
        return null;
    }

    public UpdateObjectDesc getUpdateDesc(Class clazz) {
        return new UpdateObjectDescImpl(clazz);
    }

    public SQLStoreManager(String string) {
        this.setVendorType(string);
    }

    private void setVendorType(String string) {
        try {
            this.vendorType = new DBVendorType(string);
            if (logger.isLoggable()) {
                logger.fine("sqlstore.sqlstoremanager.vendortype", this.vendorType.getName());
            }
        }
        catch (Exception exception) {
            if (exception instanceof JDOException) {
                throw (JDOException)exception;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.getvendortypefailed"), exception);
        }
    }

    public DBVendorType getVendorType() {
        return this.vendorType;
    }

    public Collection retrieve(PersistenceManager persistenceManager, RetrieveDesc retrieveDesc) {
        return this.retrieve(persistenceManager, retrieveDesc, null);
    }

    public Collection retrieve(PersistenceManager persistenceManager, RetrieveDesc retrieveDesc, ValueFetcher valueFetcher) {
        SelectStatement selectStatement;
        if (retrieveDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.nullparam", "action"));
        }
        ClassDesc classDesc = this.validateAction(retrieveDesc);
        if (!(retrieveDesc instanceof RetrieveDescImpl)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", retrieveDesc.getClass().getName(), "RetrieveDescImpl"));
        }
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)retrieveDesc;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SelectQueryPlan selectQueryPlan = null;
        int n = 2;
        Concurrency concurrency = classDesc.getConcurrency(persistenceManager.isOptimisticTransaction());
        selectQueryPlan = retrieveDescImpl.build(this, concurrency, n);
        arrayList2 = selectQueryPlan.getStatements();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            selectStatement = (SelectStatement)arrayList2.get(i);
            arrayList = this.executeQuery(persistenceManager, selectStatement, arrayList, concurrency, valueFetcher);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList.size() > 0 && selectQueryPlan.foreignPlans != null) {
            this.selectForeign(persistenceManager, selectQueryPlan, arrayList, concurrency);
        }
        if (retrieveDescImpl.hasDistinct() && (retrieveDescImpl.hasProjection() || (selectQueryPlan.options & 0x80) > 0 && !this.vendorType.isDistinctSupportedWithUpdateLock())) {
            HashSet<SelectStatement> hashSet = new HashSet<SelectStatement>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                selectStatement = iterator.next();
                if (!hashSet.contains(selectStatement)) {
                    hashSet.add(selectStatement);
                    continue;
                }
                iterator.remove();
            }
        }
        return arrayList;
    }

    private ArrayList executeQuery(PersistenceManager persistenceManager, SelectStatement selectStatement, ArrayList arrayList, Concurrency concurrency, ValueFetcher valueFetcher) {
        ResultSet resultSet = null;
        DBStatement dBStatement = null;
        SelectQueryPlan selectQueryPlan = (SelectQueryPlan)selectStatement.getQueryPlan();
        Connection connection = null;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.executeQuery");
        }
        Transaction transaction = null;
        try {
            String string;
            if (concurrency != null) {
                transaction = concurrency.suspend();
            }
            if (transaction == null) {
                transaction = (Transaction)persistenceManager.currentTransaction();
            }
            connection = transaction.getConnection();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if ((string = selectStatement.getText()).length() > 0) {
                if (bl) {
                    if (logger.isLoggable(400)) {
                        logger.finer(SQLStoreManager.formatSqlText(string, selectStatement.inputDesc));
                    } else {
                        logger.fine(SQLStoreManager.formatSqlText(string, null));
                    }
                }
                dBStatement = new DBStatement(connection, string, transaction.getQueryTimeout());
                int n = selectQueryPlan.getMaxRows();
                if (n == 0) {
                    n = Integer.MAX_VALUE;
                }
                int n2 = selectStatement.inputDesc.values.size();
                for (int i = 0; i < n2; ++i) {
                    InputValue inputValue = (InputValue)selectStatement.inputDesc.values.get(i);
                    this.bindInputColumn(dBStatement, i + 1, inputValue, inputValue.sqlType, valueFetcher);
                }
                if (fetchSize > -1) {
                    dBStatement.getPreparedStatement().setFetchSize(fetchSize);
                }
                this.vendorType.getSpecialDBOperation().defineColumnTypeForResult(dBStatement.getPreparedStatement(), selectStatement.getColumnRefs());
                resultSet = dBStatement.executeQuery();
                if (concurrency != null) {
                    concurrency.resume(transaction);
                }
                ResultDesc resultDesc = selectQueryPlan.getResultDesc();
                resultDesc.getResult(persistenceManager, arrayList, resultSet, n);
            }
            if (bl) {
                logger.fine("sqlstore.sqlstoremanager.executeQuery.exit");
            }
        }
        catch (SQLException sQLException) {
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
        }
        finally {
            SQLStoreManager.close(resultSet);
            SQLStoreManager.close(dBStatement);
            SQLStoreManager.closeConnection(transaction, connection);
        }
        return arrayList;
    }

    private void selectForeign(PersistenceManager persistenceManager, SelectQueryPlan selectQueryPlan, ArrayList arrayList, Concurrency concurrency) {
        if (selectQueryPlan.foreignPlans == null) {
            return;
        }
        ArrayList<SelectQueryPlan> arrayList2 = new ArrayList<SelectQueryPlan>();
        arrayList2.add(selectQueryPlan);
        int n = selectQueryPlan.foreignPlans.size();
        for (int i = 0; i < n; ++i) {
            SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(i);
            arrayList2.add(selectQueryPlan2);
            this.selectForeign(persistenceManager, arrayList2, arrayList, concurrency);
            arrayList2.remove(arrayList2.size() - 1);
        }
    }

    private void selectForeign(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency) {
        SelectQueryPlan selectQueryPlan = (SelectQueryPlan)arrayList.get(arrayList.size() - 1);
        if ((selectQueryPlan.status & 4) == 0) {
            this.selectNonCorrelated(persistenceManager, arrayList, arrayList2, concurrency, selectQueryPlan);
        } else {
            if (selectQueryPlan.foreignPlans == null) {
                return;
            }
            int n = selectQueryPlan.foreignPlans.size();
            for (int i = 0; i < n; ++i) {
                SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(i);
                arrayList.add(selectQueryPlan2);
                this.selectForeign(persistenceManager, arrayList, arrayList2, concurrency);
                arrayList.remove(arrayList.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCollection(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency) {
        SelectQueryPlan selectQueryPlan;
        Object[] objectArray;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectcollection");
        }
        SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)arrayList.get(arrayList.size() - 2);
        SelectQueryPlan selectQueryPlan3 = (SelectQueryPlan)arrayList.get(arrayList.size() - 1);
        if (logger.isLoggable(300)) {
            objectArray = new Object[]{new Integer(arrayList.size()), new Integer(arrayList2.size())};
            logger.finest("sqlstore.sqlstoremanager.plans", objectArray);
        }
        objectArray = selectQueryPlan3.parentField;
        boolean bl2 = false;
        if ((selectQueryPlan3.status & 2) > 0) {
            bl2 = (selectQueryPlan3.status & 8) > 0;
        } else if (arrayList.size() == 2 && arrayList2.size() > 1) {
            selectQueryPlan = selectQueryPlan2;
            synchronized (selectQueryPlan) {
                bl2 = this.checkCorrelatedSelect(selectQueryPlan2, selectQueryPlan3, (ForeignFieldDesc)objectArray);
            }
        }
        if (!bl2) {
            this.selectNonCorrelated(persistenceManager, arrayList, arrayList2, concurrency, selectQueryPlan3);
        } else {
            selectQueryPlan = selectQueryPlan2;
            synchronized (selectQueryPlan) {
                this.selectCorrelated(persistenceManager, arrayList2, concurrency, selectQueryPlan2, selectQueryPlan3, (ForeignFieldDesc)objectArray);
            }
        }
        if (bl) {
            logger.fine("<-- SQLStoreManager.selectCollection()");
        }
    }

    private boolean checkCorrelatedSelect(SelectQueryPlan selectQueryPlan, SelectQueryPlan selectQueryPlan2, ForeignFieldDesc foreignFieldDesc) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.checkcorrelatedselect");
        }
        boolean bl2 = false;
        selectQueryPlan.processOrderConstraints();
        if (logger.isLoggable(300)) {
            Object[] objectArray = new Object[]{new Boolean(selectQueryPlan.correlated), new Integer(foreignFieldDesc.localFields.size()), new Integer(selectQueryPlan.orderBy.size()), new Integer(selectQueryPlan.options)};
            logger.finest("sqlstore.sqlstoremanager.plancorrelated", objectArray);
        }
        if (!(selectQueryPlan.correlated || foreignFieldDesc.localFields.size() > selectQueryPlan.orderBy.size() || (selectQueryPlan.options & 1) != 0 || foreignFieldDesc.localFields.size() > 1 && (selectQueryPlan.options & 2) != 0)) {
            bl2 = true;
        }
        if (bl2) {
            int n = foreignFieldDesc.localFields.size();
            for (int i = 0; i < n; ++i) {
                if (foreignFieldDesc.localFields.get(i) == ((ConstraintFieldDesc)selectQueryPlan.orderBy.get((int)i)).desc) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                int n2;
                ArrayList arrayList = selectQueryPlan2.processOrderConstraints();
                if (arrayList.size() > 0) {
                    n = foreignFieldDesc.localFields.size();
                    if (n > arrayList.size()) {
                        n = arrayList.size();
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        if (foreignFieldDesc.foreignFields.get(n2) == ((ConstraintFieldDesc)arrayList.get((int)n2)).desc) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    if (foreignFieldDesc.foreignFields.size() > arrayList.size()) {
                        for (n = arrayList.size(); n < foreignFieldDesc.foreignFields.size(); ++n) {
                            selectQueryPlan2.constraint.addField((ConstraintFieldDesc)foreignFieldDesc.foreignFields.get(n));
                            selectQueryPlan2.constraint.addOperation(30);
                        }
                        selectQueryPlan2.orderBy = null;
                    }
                } else {
                    bl2 = true;
                    n2 = foreignFieldDesc.foreignFields.size();
                    block3: for (n = 0; n < n2; ++n) {
                        LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(n);
                        int n3 = arrayList.size();
                        for (int i = 0; i < n3; ++i) {
                            ConstraintFieldDesc constraintFieldDesc = (ConstraintFieldDesc)arrayList.get(i);
                            if (localFieldDesc != constraintFieldDesc.desc) continue;
                            bl2 = false;
                            continue block3;
                        }
                    }
                    if (bl2) {
                        for (n = foreignFieldDesc.foreignFields.size() - 1; n >= 0; --n) {
                            selectQueryPlan2.constraint.stack.add(0, new ConstraintOperation(30));
                            selectQueryPlan2.constraint.stack.add(0, new ConstraintFieldDesc((LocalFieldDesc)foreignFieldDesc.foreignFields.get(n)));
                        }
                        selectQueryPlan2.orderBy = null;
                    }
                }
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.checkcorrelatedselect.exit");
        }
        return bl2;
    }

    private void selectNonCorrelated(PersistenceManager persistenceManager, ArrayList arrayList, ArrayList arrayList2, Concurrency concurrency, SelectQueryPlan selectQueryPlan) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectnoncorrelated");
        }
        ArrayList arrayList3 = new ArrayList();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = arrayList2.get(i);
            SQLStateManager sQLStateManager = (SQLStateManager)persistenceManager.getStateManager(object2);
            int n2 = arrayList.size() - 1;
            for (int j = 1; j < n2; ++j) {
                SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)arrayList.get(j);
                object = selectQueryPlan2.parentField.getClass();
                if (object2 == null || !object.equals(object2.getClass())) continue;
                object2 = selectQueryPlan2.parentField.getValue(sQLStateManager);
                sQLStateManager = (SQLStateManager)persistenceManager.getStateManager(object2);
            }
            ArrayList arrayList4 = null;
            if (object2 == null) continue;
            int n3 = selectQueryPlan.statements.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = (Statement)selectQueryPlan.statements.get(n2);
                ((Statement)object).getText();
                int n4 = ((Statement)object).inputDesc.values.size();
                for (int j = 0; j < n4; ++j) {
                    InputValue inputValue = (InputValue)((Statement)object).inputDesc.values.get(j);
                    if (inputValue.field == null) continue;
                    inputValue.value = inputValue.field.getValue(sQLStateManager);
                }
                if ((arrayList4 = this.executeQuery(persistenceManager, (SelectStatement)object, arrayList4, concurrency, null)).size() <= 0 || selectQueryPlan.foreignPlans == null) continue;
                this.selectForeign(persistenceManager, selectQueryPlan, arrayList4, concurrency);
            }
            if (arrayList4.size() > selectQueryPlan.parentField.cardinalityUPB) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toomanyrows", object2.getClass().getName(), selectQueryPlan.parentField.getName(), "" + selectQueryPlan.parentField.cardinalityUPB));
            }
            if (arrayList4.size() < selectQueryPlan.parentField.cardinalityLWB) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toofewrows", object2.getClass().getName(), selectQueryPlan.parentField.getName(), "" + selectQueryPlan.parentField.cardinalityLWB));
            }
            if (selectQueryPlan.getResultDesc().isProjection()) {
                arrayList3.addAll(arrayList4);
                continue;
            }
            if (sQLStateManager.getPresenceMaskBit(selectQueryPlan.parentField.absoluteID)) continue;
            if (selectQueryPlan.parentField.getType().isArray()) {
                Object object3 = Array.newInstance(selectQueryPlan.parentField.getType().getComponentType(), arrayList4.size());
                int n5 = arrayList4.size();
                for (n3 = 0; n3 < n5; ++n3) {
                    Array.set(object3, n3, arrayList4.get(n3));
                }
                selectQueryPlan.parentField.setValue(sQLStateManager, object3);
            } else if (selectQueryPlan.parentField.getComponentType() != null) {
                sQLStateManager.replaceCollection(selectQueryPlan.parentField, arrayList4);
            } else if (arrayList4.size() == 1) {
                Object object4 = selectQueryPlan.parentField.convertValue(arrayList4.get(0), sQLStateManager);
                selectQueryPlan.parentField.setValue(sQLStateManager, object4);
            } else {
                selectQueryPlan.parentField.setValue(sQLStateManager, null);
            }
            sQLStateManager.setPresenceMaskBit(selectQueryPlan.parentField.absoluteID);
        }
        if (selectQueryPlan.getResultDesc().isProjection()) {
            arrayList2.clear();
            arrayList2.addAll(arrayList3);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectnoncorrelated.exit");
        }
    }

    private void selectCorrelated(PersistenceManager persistenceManager, ArrayList arrayList, Concurrency concurrency, SelectQueryPlan selectQueryPlan, SelectQueryPlan selectQueryPlan2, ForeignFieldDesc foreignFieldDesc) {
        ArrayList arrayList2;
        int n;
        Object object;
        Object object2;
        Object object3;
        SelectStatement selectStatement = (SelectStatement)selectQueryPlan.statements.get(0);
        SelectStatement selectStatement2 = (SelectStatement)selectQueryPlan2.statements.get(0);
        StringBuffer stringBuffer = new StringBuffer();
        SqlIDDesc sqlIDDesc = (SqlIDDesc)selectQueryPlan.config.persistenceIDDesc;
        SqlIDDesc sqlIDDesc2 = (SqlIDDesc)selectQueryPlan2.config.persistenceIDDesc;
        ArrayList arrayList3 = sqlIDDesc.getFields();
        ArrayList arrayList4 = sqlIDDesc2.getFields();
        Object e = arrayList.get(arrayList.size() - 1);
        SQLStateManager sQLStateManager = (SQLStateManager)persistenceManager.getStateManager(e);
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectcorrelated");
        }
        selectQueryPlan2.correlated = true;
        if ((selectQueryPlan2.status & 2) != 0) {
            object3 = null;
            object3 = ((ConstraintFieldDesc)selectQueryPlan.orderBy.get((int)0)).desc;
            selectStatement2.inputDesc.values.set(selectStatement2.inputDesc.values.size() - 1, new InputValue(null, ((FieldDesc)object3).getValue(sQLStateManager)));
        } else {
            int n2;
            Object object4;
            int n3 = foreignFieldDesc.foreignFields.size();
            for (int i = 0; i < n3; ++i) {
                LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(i);
                selectQueryPlan2.addColumn(localFieldDesc, true);
            }
            selectQueryPlan2.status |= 8;
            selectQueryPlan2.status |= 2;
            selectStatement = (SelectStatement)selectStatement.clone();
            object3 = new InputDesc();
            int n4 = selectStatement.inputDesc.values.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object4 = selectStatement.inputDesc.values.get(n3);
                ((InputDesc)object3).values.add(object4);
            }
            selectStatement.inputDesc = object3;
            selectStatement.plan.options &= 0xFFFFFF7F;
            selectStatement.plan.setResultDesc(new ResultDesc());
            object2 = new Constraint();
            object = (ConstraintFieldDesc)selectQueryPlan.orderBy.get(0);
            object4 = object.desc;
            int n5 = object.ordering;
            int n6 = 15;
            if (n5 < 0) {
                n6 = 12;
            }
            ((Constraint)object2).addValue(((FieldDesc)object4).getValue(sQLStateManager));
            ((Constraint)object2).addField((LocalFieldDesc)object4);
            ((Constraint)object2).addOperation(n6);
            selectStatement.inputDesc.values.add(new InputValue(null, ((FieldDesc)object4).getValue(sQLStateManager)));
            n = selectStatement.constraint.stack.size();
            for (n2 = 0; n2 < n; ++n2) {
                ConstraintNode constraintNode = (ConstraintNode)selectStatement.constraint.stack.get(n2);
                if (constraintNode instanceof ConstraintOperation) {
                    ConstraintOperation constraintOperation = (ConstraintOperation)constraintNode;
                    if (constraintOperation.operation == 30 || constraintOperation.operation == 31) {
                        ((Constraint)object2).stack.remove(((Constraint)object2).stack.size() - 1);
                        continue;
                    }
                }
                ((Constraint)object2).stack.add(constraintNode);
            }
            selectStatement.constraint = object2;
            selectStatement2.clear(false);
            n = selectStatement.inputDesc.values.size();
            for (n2 = 0; n2 < n; ++n2) {
                selectStatement2.inputDesc.values.add(selectStatement.inputDesc.values.get(n2));
            }
            selectStatement.clear(true);
            selectStatement2.constraint.addValue(stringBuffer);
            n = foreignFieldDesc.foreignFields.size();
            for (n2 = 0; n2 < n; ++n2) {
                selectStatement.addColumn((LocalFieldDesc)foreignFieldDesc.localFields.get(n2));
                selectStatement2.constraint.addField((LocalFieldDesc)foreignFieldDesc.foreignFields.get(n2));
            }
            selectStatement2.constraint.addOperation(14);
            stringBuffer.append(selectStatement.getText());
            selectQueryPlan2.useInstanceKey = true;
            if (arrayList3.size() != foreignFieldDesc.localFields.size()) {
                selectQueryPlan2.useInstanceKey = false;
            } else {
                n = foreignFieldDesc.localFields.size();
                for (n2 = 0; n2 < n; ++n2) {
                    if (foreignFieldDesc.localFields.get(0) == arrayList3.get(n2)) continue;
                    selectQueryPlan2.useInstanceKey = false;
                    break;
                }
            }
            selectQueryPlan2.useDependentKey = true;
            if (arrayList4.size() < arrayList3.size()) {
                selectQueryPlan2.useDependentKey = false;
            } else {
                n = foreignFieldDesc.foreignFields.size();
                for (n2 = 0; n2 < n; ++n2) {
                    if (foreignFieldDesc.foreignFields.get(n2) == arrayList4.get(n2)) continue;
                    selectQueryPlan2.useDependentKey = false;
                    break;
                }
            }
        }
        object3 = null;
        if (!selectQueryPlan2.useInstanceKey) {
            object3 = new SqlID();
        }
        object2 = null;
        if (!selectQueryPlan2.useDependentKey) {
            object2 = new SqlID();
        }
        if (logger.isLoggable(400)) {
            object = new Object[]{new Boolean(selectQueryPlan2.useInstanceKey), new Boolean(selectQueryPlan2.useDependentKey)};
            logger.finer("sqlstore.sqlstoremanager.categorization", (Object[])object);
        }
        if ((arrayList2 = this.executeQuery(persistenceManager, selectStatement2, null, concurrency, null)).size() > 0 && selectQueryPlan2.foreignPlans != null) {
            this.selectForeign(persistenceManager, selectQueryPlan2, arrayList2, concurrency);
        }
        int n7 = 0;
        int n8 = arrayList.size();
        for (int i = 0; i < n8; ++i) {
            int n9;
            Object e2 = arrayList.get(i);
            SQLStateManager sQLStateManager2 = (SQLStateManager)persistenceManager.getStateManager(e2);
            ArrayList arrayList5 = new ArrayList();
            if (selectQueryPlan2.useInstanceKey) {
                object3 = (SqlID)sqlIDDesc.createID(sQLStateManager2);
            } else {
                for (n = ((SqlID)object3).values.size(); n < foreignFieldDesc.localFields.size(); ++n) {
                    ((SqlID)object3).values.add(null);
                }
                int n10 = foreignFieldDesc.localFields.size();
                for (n = 0; n < n10; ++n) {
                    ((SqlID)object3).values.set(n, ((LocalFieldDesc)foreignFieldDesc.localFields.get(n)).getValue(sQLStateManager2));
                }
            }
            sQLStateManager2.setPresenceMaskBit(selectQueryPlan2.parentField.absoluteID);
            while (n7 < arrayList2.size()) {
                Object e3 = arrayList2.get(n7);
                SQLStateManager sQLStateManager3 = (SQLStateManager)persistenceManager.getStateManager(e3);
                if (selectQueryPlan2.useDependentKey) {
                    object2 = (SqlID)sqlIDDesc2.createID(sQLStateManager3);
                } else {
                    for (n9 = ((SqlID)object2).values.size(); n9 < foreignFieldDesc.foreignFields.size(); ++n9) {
                        ((SqlID)object2).values.add(null);
                    }
                    int n11 = foreignFieldDesc.foreignFields.size();
                    for (n9 = 0; n9 < n11; ++n9) {
                        FieldDesc fieldDesc = (FieldDesc)foreignFieldDesc.foreignFields.get(n9);
                        ((SqlID)object2).values.set(n9, fieldDesc.getValue(sQLStateManager3));
                    }
                }
                n9 = ((SqlID)object3).compareID((ObjectID)object2);
                if (n9 != 0 && n9 != 1024) break;
                arrayList5.add(e3);
                ++n7;
            }
            if (foreignFieldDesc.getType().isArray()) {
                Object object5 = Array.newInstance(foreignFieldDesc.getType().getComponentType(), arrayList5.size());
                n9 = arrayList5.size();
                for (int j = 0; j < n9; ++j) {
                    Array.set(object5, j, arrayList5.get(j));
                }
                foreignFieldDesc.setValue(sQLStateManager2, object5);
                continue;
            }
            if (foreignFieldDesc.getComponentType() == null) continue;
            sQLStateManager2.replaceCollection(foreignFieldDesc, arrayList5);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstoremanager.selectcorrelated.exit");
        }
    }

    private ClassDesc validateAction(ActionDesc actionDesc) {
        if (actionDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.nullparam", "action"));
        }
        ClassDesc classDesc = null;
        classDesc = (ClassDesc)this.getPersistenceConfig(actionDesc.getPersistenceCapableClass());
        if (classDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.illegalparam", "action.pcClass", actionDesc.getPersistenceCapableClass().toString()));
        }
        return classDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBatch(PersistenceManager persistenceManager, UpdateDesc updateDesc, boolean bl) {
        Connection connection;
        Transaction transaction;
        block4: {
            boolean bl2 = true;
            UpdateQueryPlan updateQueryPlan = null;
            transaction = null;
            connection = null;
            UpdateObjectDescImpl updateObjectDescImpl = null;
            if (!(updateDesc instanceof UpdateObjectDescImpl)) throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", updateDesc.getClass().getName(), "UpdateObjectDescImpl"));
            updateObjectDescImpl = (UpdateObjectDescImpl)updateDesc;
            ClassDesc classDesc = this.validateAction(updateDesc);
            updateQueryPlan = classDesc.getUpdateQueryPlan(updateObjectDescImpl, this);
            try {
                transaction = (Transaction)persistenceManager.currentTransaction();
                connection = transaction.getConnection();
                boolean bl3 = bl || updateQueryPlan.checkBatchThreshold(transaction);
                int n = updateQueryPlan.statements.size();
                for (int i = 0; i < n; ++i) {
                    UpdateStatement updateStatement = (UpdateStatement)updateQueryPlan.statements.get(i);
                    this.executeUpdateBatch(transaction, connection, updateStatement, updateObjectDescImpl, bl3);
                }
                bl2 = bl;
                Object var15_14 = null;
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (bl2) {
                    SQLStoreManager.closeDBStatements(updateQueryPlan, transaction);
                }
                SQLStoreManager.closeConnection(transaction, connection);
                throw throwable;
            }
            SQLStoreManager.closeDBStatements(updateQueryPlan, transaction);
        }
        SQLStoreManager.closeConnection(transaction, connection);
    }

    private void executeUpdateBatch(Transaction transaction, Connection connection, UpdateStatement updateStatement, UpdateObjectDescImpl updateObjectDescImpl, boolean bl) {
        int[] nArray = null;
        DBStatement dBStatement = null;
        if (logger.isLoggable(500)) {
            logger.fine("sqlstore.sqlstoremanager.executeupdatebatch");
        }
        try {
            dBStatement = updateStatement.getDBStatement(transaction, connection);
            String string = dBStatement.getStatementText();
            if (string.length() > 0) {
                if (logger.isLoggable(500)) {
                    logger.fine(SQLStoreManager.formatSqlText(string, null));
                }
                Iterator iterator = updateStatement.getColumnRefs().iterator();
                while (iterator.hasNext()) {
                    this.bindInputColumn(dBStatement, (ColumnRef)iterator.next(), updateObjectDescImpl, true);
                }
                iterator = updateStatement.getColumnRefsForWhereClause().iterator();
                while (iterator.hasNext()) {
                    this.bindInputColumn(dBStatement, (ColumnRef)iterator.next(), updateObjectDescImpl, !updateObjectDescImpl.isBeforeImageRequired());
                }
                dBStatement.addBatch();
                if (bl) {
                    nArray = dBStatement.executeBatch();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] >= updateStatement.minAffectedRows || nArray[i] == -2) continue;
                        this.rollbackXact(transaction);
                        int n = string.indexOf(32);
                        throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.store.operationfailed", string.substring(0, n)));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.rollbackXact(transaction);
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "core.persistencestore.jdbcerror"), sQLException);
        }
        if (logger.isLoggable(500)) {
            logger.fine("sqlstore.sqlstoremanager.executeupdatebatch.exit", '[' + StringHelper.intArrayToSeparatedList(nArray, ",") + ']');
        }
    }

    public static String formatSqlText(String string, InputDesc inputDesc) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SQL statement<").append(string).append(">");
        if (inputDesc != null) {
            if (inputDesc.values.size() <= 0) {
                stringBuffer.append(" with no input values");
            } else {
                stringBuffer.append(" with input values: ");
                int n = inputDesc.values.size();
                for (int i = 0; i < n; ++i) {
                    InputValue inputValue = (InputValue)inputDesc.values.get(i);
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if (inputValue.value == null) {
                        stringBuffer.append("<null>");
                        continue;
                    }
                    stringBuffer.append(inputValue.getClass().getName());
                    stringBuffer.append(":");
                    stringBuffer.append(inputValue.value.toString());
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorcloseresultset", sQLException.getLocalizedMessage()));
            }
        }
    }

    private static void close(DBStatement dBStatement) {
        if (dBStatement != null) {
            try {
                dBStatement.close();
            }
            catch (SQLException sQLException) {
                logger.finest(I18NHelper.getMessage(messages, "sqlstore.sqlstoremanager.errorclosestatement", sQLException.getLocalizedMessage()));
            }
        }
    }

    private static void closeConnection(Transaction transaction, Connection connection) {
        if (transaction != null && connection != null) {
            transaction.releaseConnection();
        }
    }

    private static void closeDBStatements(UpdateQueryPlan updateQueryPlan, Transaction transaction) {
        if (updateQueryPlan != null && transaction != null) {
            Iterator iterator = updateQueryPlan.getStatements().iterator();
            while (iterator.hasNext()) {
                UpdateStatement updateStatement = (UpdateStatement)iterator.next();
                DBStatement dBStatement = updateStatement.removeDBStatement(transaction);
                SQLStoreManager.close(dBStatement);
            }
        }
    }
}

