/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOObjectNotFoundException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceCapable;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SCO;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.TestStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.QueryValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.state.LifeCycleState;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNonTransactional;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.NullSemaphore;
import com.sun.jdo.spi.persistence.utility.Semaphore;
import com.sun.jdo.spi.persistence.utility.SemaphoreImpl;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class SQLStateManager
implements Cloneable,
StateManager,
TestStateManager {
    private static final int PRESENCE_MASK = 2;
    private static final int SET_MASK = 1;
    private static final int GET_MASK = 0;
    private static final int MAX_MASKS = 3;
    private BitSet fieldMasks;
    public ArrayList hiddenValues;
    public ClassDesc persistenceConfig;
    private PersistenceManager persistenceManager;
    public PersistenceStore store;
    private SQLStateManager beforeImage;
    private Object persistentObject;
    private Object objectId;
    private LifeCycleState state;
    private static final short ST_UPDATE_DISABLED = 1;
    private static final short ST_REGISTERED = 2;
    private static final short ST_VISITED = 4;
    private static final short ST_PREPARED_PHASE_II = 16;
    private static final short ST_FIELD_TRACKING_INPROGRESS = 32;
    private static final short ST_DELETE_INPROGRESS = 64;
    private short stateFlags;
    private boolean relationshipChanged = false;
    private boolean isReplacementInstance = false;
    private boolean needsRegisterAtRollback = false;
    private boolean needsVerifyAtDeregister = false;
    private boolean valid = false;
    private UpdateObjectDescImpl updateDesc;
    private HashSet updatedForeignReferences;
    private int referenceCount;
    private final Semaphore lock = EJBHelper.isManaged() ? new NullSemaphore("SQLStateManager") : new SemaphoreImpl("SQLStateManager");
    private static Logger logger = LogHelperStateManager.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(SQLStateManager.class);
    public static final String USE_BATCH_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.USE_BATCH";
    private static final boolean USE_BATCH = Boolean.valueOf(System.getProperty("com.sun.jdo.spi.persistence.support.sqlstore.USE_BATCH", "true"));

    public synchronized void initialize(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.persistenceManager.isActiveTransaction();
        boolean bl4 = this.persistenceManager.isOptimisticTransaction();
        boolean bl5 = this.persistenceManager.isNontransactionalRead();
        LifeCycleState lifeCycleState = this.state;
        if (this.state == null) {
            if (!bl) {
                this.state = LifeCycleState.getLifeCycleState(0);
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else {
                if (bl3 && !bl4) {
                    this.state = LifeCycleState.getLifeCycleState(2);
                    this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
                } else {
                    this.state = LifeCycleState.getLifeCycleState(1);
                    this.persistenceManager.setFlags(this.persistentObject, (byte)1);
                }
                this.valid = true;
            }
        } else if (this.state.needMerge()) {
            this.state = this.state.transitionReadField(bl4, bl5, bl3);
            if (this.state.needsReload(bl4, bl5, bl3)) {
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else if (this.persistenceManager.getFlags(this.persistentObject) == 1) {
                this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
            }
        }
        this.registerInstance(false, null, lifeCycleState);
    }

    private void registerInstance(boolean bl, ArrayList arrayList, LifeCycleState lifeCycleState) {
        if ((this.stateFlags & 2) == 0 || lifeCycleState != this.state && (lifeCycleState == null || lifeCycleState.isDirty() != this.state.isDirty() || lifeCycleState.isTransactional() != this.state.isTransactional())) {
            this.persistenceManager.registerInstance(this, this.getObjectId(), bl, false);
            this.stateFlags = (short)(this.stateFlags | 2);
            if (arrayList != null && !arrayList.contains(this)) {
                arrayList.add(this);
            }
        }
    }

    public void setPersistenceManager(com.sun.jdo.api.persistence.support.PersistenceManager persistenceManager) {
        this.persistenceManager = (PersistenceManager)persistenceManager;
    }

    public void setPersistent(Object object) {
        this.persistentObject = object;
    }

    public PersistenceStore getStore() {
        return this.store;
    }

    public Object getPersistent() {
        return this.persistentObject;
    }

    public PersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public UpdateObjectDesc getUpdateDesc() {
        if (this.updateDesc == null) {
            this.updateDesc = (UpdateObjectDescImpl)this.store.getUpdateDesc(this.persistenceConfig.getPersistenceCapableClass());
        }
        if (this.updateDesc.getConcurrency() == null) {
            boolean bl = this.persistenceManager.isOptimisticTransaction();
            this.updateDesc.setConcurrency(this.persistenceConfig.getConcurrency(bl));
        }
        return this.updateDesc;
    }

    private void unsetMaskBit(int n, int n2) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        } else if (n >= 0) {
            this.fieldMasks.clear(n + n2 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.clear(-(n + 1) + this.persistenceConfig.maxVisibleFields + n2 * this.persistenceConfig.maxFields);
        }
    }

    private void clearMask(int n) {
        if (this.fieldMasks != null) {
            this.fieldMasks.clear(n * this.persistenceConfig.maxFields, (n + 1) * this.persistenceConfig.maxFields);
        }
    }

    private void setVisibleMaskBits(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        int n2 = n * this.persistenceConfig.maxFields;
        this.fieldMasks.set(n2, n2 + this.persistenceConfig.maxVisibleFields);
    }

    private void newFieldMasks() {
        this.fieldMasks = new BitSet(3 * this.persistenceConfig.maxFields);
    }

    public void setPresenceMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            this.fieldMasks.set(n + 2 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.set(-(n + 1) + this.persistenceConfig.maxVisibleFields + 2 * this.persistenceConfig.maxFields);
        }
    }

    private void setSetMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            this.fieldMasks.set(n + 1 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.set(-(n + 1) + this.persistenceConfig.maxVisibleFields + 1 * this.persistenceConfig.maxFields);
        }
    }

    private void setGetMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            this.fieldMasks.set(n + 0 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.set(-(n + 1) + this.persistenceConfig.maxVisibleFields + 0 * this.persistenceConfig.maxFields);
        }
    }

    public boolean getPresenceMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            return this.fieldMasks.get(n + 2 * this.persistenceConfig.maxFields);
        }
        return this.fieldMasks.get(-(n + 1) + this.persistenceConfig.maxVisibleFields + 2 * this.persistenceConfig.maxFields);
    }

    public boolean getSetMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            return this.fieldMasks.get(n + 1 * this.persistenceConfig.maxFields);
        }
        return this.fieldMasks.get(-(n + 1) + this.persistenceConfig.maxVisibleFields + 1 * this.persistenceConfig.maxFields);
    }

    public boolean getGetMaskBit(int n) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (n >= 0) {
            return this.fieldMasks.get(n + 0 * this.persistenceConfig.maxFields);
        }
        return this.fieldMasks.get(-(n + 1) + this.persistenceConfig.maxVisibleFields + 0 * this.persistenceConfig.maxFields);
    }

    public Object getHiddenValue(int n) {
        if (n >= 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.poshiddenindex", "" + n));
        }
        int n2 = -(n + 1);
        if (this.hiddenValues != null && n2 < this.hiddenValues.size()) {
            return this.hiddenValues.get(n2);
        }
        return null;
    }

    public void setHiddenValue(int n, Object object) {
        if (n >= 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.poshiddenindex", "" + n));
        }
        int n2 = -(n + 1);
        if (this.hiddenValues == null) {
            this.hiddenValues = new ArrayList();
        }
        for (int i = this.hiddenValues.size(); i <= n2; ++i) {
            this.hiddenValues.add(null);
        }
        this.hiddenValues.set(n2, object);
    }

    public synchronized void replaceObjectField(String string, Object object) {
        Object object2;
        Object[] objectArray;
        boolean bl = logger.isLoggable();
        if (bl) {
            objectArray = new Object[]{string, object.getClass().getName()};
            logger.fine("sqlstore.sqlstatemanager.replaceobjectfield", objectArray);
        }
        if ((object2 = this.prepareSetField((FieldDesc)(objectArray = this.persistenceConfig.getField(string)), object)) instanceof SCO && object2 != object) {
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.replaceobjectfield.unsetsco");
            }
            ((SCO)object2).unsetOwner();
        }
    }

    public synchronized void makeDirty(String string) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.makedirty", string);
        }
        FieldDesc fieldDesc = this.persistenceConfig.getField(string);
        Object object = fieldDesc.getValue(this);
        this.prepareUpdateField(fieldDesc, null);
        Object object2 = fieldDesc.getValue(this);
        if (object2 instanceof SCO && object != object2) {
            if (object instanceof SCOCollection) {
                if (bl) {
                    logger.fine("sqlstore.sqlstatemanager.makedirty.fixscocollection");
                }
                ((SCOCollection)object).clearInternal();
                ((SCOCollection)object).addAllInternal((Collection)object2);
            } else if (object instanceof SCODate) {
                if (bl) {
                    logger.fine("sqlstore.sqlstatemanager.makedirty.fixscodate");
                }
                long l = ((Date)object2).getTime();
                int n = 0;
                n = object2 instanceof Timestamp ? ((Timestamp)object2).getNanos() : (int)(l % 1000L * 1000000L);
                if (object instanceof SqlTimestamp) {
                    ((SCODate)object).setTimeInternal(l);
                    ((SqlTimestamp)object).setNanosInternal(n);
                } else if (object2 instanceof Timestamp) {
                    ((SCODate)object).setTimeInternal(l + (long)(n / 1000000));
                } else {
                    ((SCODate)object).setTimeInternal(l);
                }
            }
            this.updateTrackedFields(fieldDesc, object, null, null, null);
            fieldDesc.setValue(this, object);
            if (object2 instanceof SCO) {
                ((SCO)object2).unsetOwner();
            }
        }
    }

    public void applyUpdates(String string, SCOCollection sCOCollection) {
        FieldDesc fieldDesc;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.applyupdates", string);
        }
        if ((fieldDesc = this.persistenceConfig.getField(string)) instanceof ForeignFieldDesc) {
            ArrayList arrayList = new ArrayList(sCOCollection.getRemoved());
            ArrayList arrayList2 = new ArrayList(sCOCollection.getAdded());
            sCOCollection.reset();
            this.processCollectionUpdates((ForeignFieldDesc)fieldDesc, arrayList, arrayList2, null, true, false);
        }
    }

    public void makePresent(String string, Object object) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.makepresent", string);
        }
        FieldDesc fieldDesc = this.persistenceConfig.getField(string);
        fieldDesc.setValue(this, object);
        this.setGetMaskBit(fieldDesc.absoluteID);
        this.setPresenceMaskBit(fieldDesc.absoluteID);
    }

    public void setObjectId(Object object) {
        this.objectId = object;
    }

    public Object getObjectId() {
        if (this.objectId != null) {
            return this.objectId;
        }
        Class clazz = this.persistenceConfig.getOidClass();
        Object var2_2 = null;
        try {
            this.objectId = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantnewoid", clazz.getName()), exception);
        }
        Field[] fieldArray = this.persistenceConfig.getKeyFields();
        String[] stringArray = this.persistenceConfig.getKeyFieldNames();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            try {
                FieldDesc fieldDesc = this.persistenceConfig.getField(stringArray[i]);
                if (fieldDesc == null) continue;
                field.set(this.objectId, fieldDesc.getValue(this));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantsetkeyfield", field.getName()), illegalAccessException);
            }
        }
        return this.objectId;
    }

    private void makeAutoPersistent(Object object) {
        this.persistenceManager.makePersistent(object);
        SQLStateManager sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(object);
        sQLStateManager.state = LifeCycleState.getLifeCycleState(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistent(PersistenceManager persistenceManager, Object object) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.makepersistence", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state != null) {
            if (this.state.isAutoPersistent()) {
                this.state = this.state.transitionMakePersistent();
            }
            return;
        }
        this.persistenceManager = persistenceManager;
        this.persistentObject = object;
        this.setVisibleMaskBits(2);
        this.getBeforeImage();
        boolean bl2 = this.persistenceManager.isOptimisticTransaction();
        this.state = LifeCycleState.getLifeCycleState(4);
        try {
            this.registerInstance(true, null, null);
        }
        catch (JDOException jDOException) {
            this.release();
            throw jDOException;
        }
        persistenceManager.setStateManager(object, this);
        this.valid = true;
        try {
            this.getLock();
            Object object2 = null;
            ArrayList arrayList = this.persistenceConfig.fields;
            for (int i = 0; i < arrayList.size(); ++i) {
                Serializable serializable;
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(i);
                if ((fieldDesc.sqlProperties & 0x200) > 0) continue;
                object2 = fieldDesc.getValue(this);
                if (fieldDesc instanceof ForeignFieldDesc) {
                    Object object3;
                    serializable = (ForeignFieldDesc)fieldDesc;
                    ArrayList arrayList2 = null;
                    if (bl) {
                        logger.fine("sqlstore.sqlstatemanager.processforeign", fieldDesc.getName());
                    }
                    if ((fieldDesc.sqlProperties & 0x100) > 0) {
                        arrayList2 = fieldDesc.getTrackedFields();
                        object3 = object2;
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            FieldDesc fieldDesc2 = (FieldDesc)arrayList2.get(j);
                            Object object4 = fieldDesc2.getValue(this);
                            if (object3 != null && object4 != null && object3 != object4) {
                                if (this.needsVerifyAtDeregister) {
                                    this.persistenceManager.deregisterInstance(this.getObjectId(), this);
                                    this.needsVerifyAtDeregister = false;
                                } else {
                                    this.persistenceManager.deregisterInstance(this.getObjectId());
                                }
                                this.release();
                                throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.conflictingvalues", fieldDesc.getName(), fieldDesc2.getName()));
                            }
                            if (object3 != null || object4 == null) continue;
                            object3 = object4;
                        }
                        if (object3 != object2) {
                            object2 = object3;
                            fieldDesc.setValue(this, object2);
                        }
                    }
                    if (object2 != null) {
                        if (object2 instanceof Collection) {
                            if (((Collection)object2).size() > 0) {
                                object3 = null;
                                ArrayList arrayList3 = new ArrayList((Collection)object2);
                                this.processCollectionUpdates((ForeignFieldDesc)serializable, (ArrayList)object3, arrayList3, null, true, false);
                            }
                        } else {
                            fieldDesc.setValue(this, null);
                            this.updateObjectField((ForeignFieldDesc)fieldDesc, object2, null, true, false);
                            fieldDesc.setValue(this, object2);
                        }
                    } else if (((ForeignFieldDesc)serializable).getInverseRelationshipField() != null && ((ForeignFieldDesc)serializable).cardinalityUPB > 1) {
                        this.replaceCollection((FieldDesc)serializable, null);
                    }
                    this.updateTrackedFields(fieldDesc, fieldDesc.getValue(this), null, null, null);
                } else {
                    if ((fieldDesc.sqlProperties & 0x400) > 0) {
                        FieldDesc fieldDesc3;
                        serializable = fieldDesc.getTrackedFields();
                        boolean bl3 = false;
                        for (int j = ((ArrayList)serializable).size() - 1; j >= 0 && (fieldDesc3 = (FieldDesc)((ArrayList)serializable).get(j)) instanceof ForeignFieldDesc; --j) {
                            if (fieldDesc3.getValue(this) == null) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            this.updateTrackedFields(fieldDesc, object2, null, null, null);
                        }
                    } else {
                        this.updateTrackedFields(fieldDesc, object2, null, null, null);
                    }
                    if ((fieldDesc.sqlProperties & 0x20) > 0) {
                        ((UpdateObjectDescImpl)this.getUpdateDesc()).recordUpdatedField(fieldDesc);
                    }
                }
                if (bl) {
                    logger.fine("sqlstore.sqlstatemanager.makedirtyfield", fieldDesc.getName());
                }
                this.setSetMaskBit(fieldDesc.absoluteID);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (logger.isLoggable()) {
            logger.fine("sqlstore.sqlstatemanager.deletepersistence", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        this.persistenceManager.acquireFieldUpdateLock();
        try {
            try {
                boolean bl;
                this.getLock();
                if (this.state.isDeleted()) {
                    return;
                }
                boolean bl2 = this.persistenceManager.isActiveTransaction();
                boolean bl3 = this.persistenceManager.isOptimisticTransaction();
                if (this.state.needsReload(bl3, bl = this.persistenceManager.isNontransactionalRead(), bl2)) {
                    this.reload(null);
                }
                this.getBeforeImage();
                this.deleteRelationships();
                LifeCycleState lifeCycleState = this.state;
                this.state = this.state.transitionDeletePersistent();
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
                this.registerInstance(false, null, lifeCycleState);
            }
            finally {
                this.releaseLock();
            }
        }
        finally {
            this.persistenceManager.releaseFieldUpdateLock();
        }
    }

    private void deleteRelationships() {
        ArrayList arrayList = this.persistenceConfig.foreignFields;
        int n = arrayList.size();
        this.stateFlags = (short)(this.stateFlags | 0x40);
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable;
            Object object;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)arrayList.get(i);
            ForeignFieldDesc foreignFieldDesc2 = foreignFieldDesc.getInverseRelationshipField();
            if ((foreignFieldDesc.sqlProperties & 0x200) > 0 || foreignFieldDesc.deleteAction != 3 && foreignFieldDesc2 == null) continue;
            this.prepareGetField(foreignFieldDesc);
            if (foreignFieldDesc.cardinalityUPB > 1) {
                object = (Collection)foreignFieldDesc.getValue(this);
                if (object == null) continue;
                cloneable = new ArrayList(object);
                this.processCollectionUpdates(foreignFieldDesc, (ArrayList)cloneable, null, null, true, false);
                if (object instanceof SCOCollection) {
                    ((SCOCollection)object).clearInternal();
                } else {
                    object.clear();
                }
                if (foreignFieldDesc.deleteAction != 3) continue;
                Iterator iterator = ((ArrayList)cloneable).iterator();
                while (iterator.hasNext()) {
                    SQLStateManager sQLStateManager;
                    Object e = iterator.next();
                    if (e == null || (sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e)) == null || sQLStateManager.isDeleted() || (sQLStateManager.stateFlags & 0x40) != 0) continue;
                    try {
                        this.persistenceManager.deletePersistent(e);
                    }
                    catch (Throwable throwable) {}
                }
                continue;
            }
            object = foreignFieldDesc.getValue(this);
            if (object == null) continue;
            this.updateObjectField(foreignFieldDesc, null, null, true, false);
            foreignFieldDesc.setValue(this, null);
            if (foreignFieldDesc.deleteAction != 3 || (cloneable = (SQLStateManager)this.persistenceManager.getStateManager(object)) == null || ((SQLStateManager)cloneable).isDeleted() || (((SQLStateManager)cloneable).stateFlags & 0x40) != 0) continue;
            try {
                this.persistenceManager.deletePersistent(object);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void updatePersistent(StateManager stateManager) {
        boolean bl = logger.isLoggable();
        if ((this.stateFlags & 1) > 0) {
            if (bl) {
                Object[] objectArray = new Object[]{this.persistenceConfig.getPersistenceCapableClass().getName(), this.persistentObject};
                logger.fine("sqlstore.sqlstatemanager.updatepersistence.skipped", objectArray);
            }
            return;
        }
        try {
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.updatepersistent", this.persistenceConfig.getPersistenceCapableClass().getName());
            }
            ArrayList arrayList = new ArrayList();
            this.getUpdateActions(arrayList);
            if (arrayList.size() == 1 && this.useBatch()) {
                UpdateDesc updateDesc = (UpdateDesc)arrayList.get(0);
                this.store.executeBatch(this.persistenceManager, updateDesc, this.requiresImmediateFlush((SQLStateManager)stateManager));
            } else if (arrayList.size() > 0) {
                this.store.execute(this.persistenceManager, arrayList);
            }
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.updatepersistent.exit");
            }
        }
        catch (JDOException jDOException) {
            jDOException.addFailedObject(this.persistentObject);
            throw jDOException;
        }
        catch (Exception exception) {
            logger.throwing("sqlstore.SQLStateManager", "updatePersistent", exception);
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.unknownexception"), exception);
        }
    }

    private boolean useBatch() {
        boolean bl = false;
        if (USE_BATCH) {
            switch (this.state.getUpdateAction()) {
                case 1: {
                    bl = !this.hasChangedRelationships() && !this.hasModifiedByteArrayField();
                    break;
                }
                case 2: 
                case 3: {
                    bl = !this.persistenceManager.isOptimisticTransaction() && !this.persistenceConfig.hasModifiedCheckAtCommitConsistency() && !this.hasChangedRelationships() && !this.hasModifiedByteArrayField();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean hasChangedRelationships() {
        if (this.relationshipChanged) {
            return true;
        }
        if (this.updatedForeignReferences != null && !this.updatedForeignReferences.isEmpty()) {
            return true;
        }
        List list = ((UpdateObjectDescImpl)this.getUpdateDesc()).getUpdatedFields();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldDesc fieldDesc = (FieldDesc)iterator.next();
                if (fieldDesc.absoluteID >= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasModifiedByteArrayField() {
        List list = ((UpdateObjectDescImpl)this.getUpdateDesc()).getUpdatedFields();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldDesc fieldDesc = (FieldDesc)iterator.next();
                if (!fieldDesc.isByteArrayType()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean requiresImmediateFlush(SQLStateManager sQLStateManager) {
        if (sQLStateManager == null) {
            return true;
        }
        if (this.getPersistenceConfig().getPersistenceCapableClass() != sQLStateManager.getPersistenceConfig().getPersistenceCapableClass()) {
            return true;
        }
        if (this.state.getUpdateAction() != sQLStateManager.state.getUpdateAction()) {
            return true;
        }
        if ((sQLStateManager.stateFlags & 1) > 0) {
            return true;
        }
        return !sQLStateManager.useBatch();
    }

    public void refreshPersistent() {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.refreshpersistent", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state.isRefreshable()) {
            LifeCycleState lifeCycleState = this.state;
            this.state = this.state.transitionRefreshPersistent();
            this.reload(null);
            this.registerInstance(false, null, lifeCycleState);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.refreshpersistent.exit");
        }
    }

    private void reload(FieldDesc fieldDesc) {
        Object object;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.reload", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        RetrieveDesc retrieveDesc = this.persistenceConfig.getRetrieveDesc(fieldDesc, this.store);
        Object[] objectArray = null;
        try {
            object = this.persistenceConfig.getKeyFields();
            objectArray = new Object[((Field[])object).length];
            for (int i = 0; i < ((Field[])object).length; ++i) {
                Field field = object[i];
                objectArray[i] = field.get(this.objectId);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(900, "sqlstore.exception.log", illegalAccessException);
        }
        this.clearMask(2);
        this.markKeyFieldsPresent();
        this.clearMask(1);
        object = this.state;
        this.state = this.state.transitionReload(this.persistenceManager.isActiveTransaction());
        Collection collection = this.store.retrieve(this.persistenceManager, retrieveDesc, new QueryValueFetcher(objectArray));
        if (collection.size() == 0 || collection.size() == 1 && collection.iterator().next() != this.persistentObject) {
            this.state = object;
            throw new JDOObjectNotFoundException(I18NHelper.getMessage(messages, "core.statemanager.objectnotfound"), new Object[]{this.persistentObject});
        }
        this.registerInstance(false, null, (LifeCycleState)object);
        if (this.persistenceManager.getFlags(this.persistentObject) == 1) {
            this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.reload.exit");
        }
    }

    private void getCascadeDeleteActions(ArrayList arrayList, boolean bl) {
        ArrayList arrayList2 = this.persistenceConfig.foreignFields;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)arrayList2.get(i);
            if (foreignFieldDesc.deleteAction != 3) continue;
            if (bl) {
                if (foreignFieldDesc.cardinalityUPB <= 1 || (object2 = (Collection)foreignFieldDesc.getValue(this)) == null) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    SQLStateManager sQLStateManager;
                    Object e = object.next();
                    if (e == null || (sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e)) == null) continue;
                    sQLStateManager.getUpdateActions(arrayList);
                }
                continue;
            }
            if (foreignFieldDesc.cardinalityUPB != 1 || (object2 = foreignFieldDesc.getValue(this)) == null || (object = (SQLStateManager)this.persistenceManager.getStateManager(object2)) == null) continue;
            super.getUpdateActions(arrayList);
        }
    }

    public void prepareToUpdatePhaseI() {
        Object object;
        int n;
        int n2;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph1", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if ((n2 = this.state.getUpdateAction()) == 4 || n2 == 2) {
            return;
        }
        UpdateObjectDescImpl updateObjectDescImpl = (UpdateObjectDescImpl)this.getUpdateDesc();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.persistenceConfig.foreignFields;
        int n3 = arrayList2.size();
        for (n = 0; n < n3; ++n) {
            Collection collection;
            object = (ForeignFieldDesc)arrayList2.get(n);
            if (((ForeignFieldDesc)object).cardinalityUPB <= 1 || !this.getSetMaskBit(((ForeignFieldDesc)object).absoluteID) || (collection = (Collection)((FieldDesc)object).getValue(this)) == null || collection instanceof SCO && ((SCO)((Object)collection)).getOwner() != null || collection.size() <= 0) continue;
            ArrayList arrayList3 = null;
            ArrayList arrayList4 = new ArrayList(collection);
            this.processCollectionUpdates((ForeignFieldDesc)object, arrayList3, arrayList4, arrayList, true, false);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (SQLStateManager)arrayList.get(n);
            ((SQLStateManager)object).prepareToUpdatePhaseI();
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph1.exit");
        }
    }

    public void prepareToUpdatePhaseII(HashSet hashSet) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph2", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state.isAutoPersistent()) {
            this.state = this.state.transitionMakePending();
            hashSet.add(this);
            return;
        }
        if ((this.stateFlags & 0x10) > 0) {
            return;
        }
        this.stateFlags = (short)(this.stateFlags | 0x10);
        if (!this.state.isNew() && !this.state.isDirty() || this.state.isDeleted()) {
            return;
        }
        ArrayList arrayList = this.persistenceConfig.foreignFields;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)arrayList.get(i);
            if (foreignFieldDesc.cardinalityUPB <= 1) {
                if (!this.getPresenceMaskBit(foreignFieldDesc.absoluteID) || (object2 = foreignFieldDesc.getValue(this)) == null) continue;
                object = (SQLStateManager)this.persistenceManager.getStateManager(object2);
                if (!((SQLStateManager)object).state.isAutoPersistent()) continue;
                ((SQLStateManager)object).state = ((SQLStateManager)object).state.transitionMakePersistent();
                hashSet.remove(object);
                ((SQLStateManager)object).prepareToUpdatePhaseII(hashSet);
                continue;
            }
            object2 = (Collection)foreignFieldDesc.getValue(this);
            if (object2 == null) continue;
            if (object2 instanceof SCOCollection && (object = (SCOCollection)object2).isDeferred()) {
                object2 = object.getAdded();
            }
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                SQLStateManager sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e);
                if (sQLStateManager == null || !sQLStateManager.state.isAutoPersistent()) continue;
                sQLStateManager.state = sQLStateManager.state.transitionMakePersistent();
                hashSet.remove(sQLStateManager);
                sQLStateManager.prepareToUpdatePhaseII(hashSet);
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph2.exit");
        }
    }

    public void prepareToUpdatePhaseIII() {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph3", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (!this.state.isAutoPersistent() || !this.state.isPersistentInDataStore()) {
            if (this.updateDesc != null) {
                this.updateDesc.clearUpdatedJoinTableRelationships();
            }
            return;
        }
        ArrayList arrayList = this.persistenceConfig.foreignFields;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            Object object;
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)arrayList.get(i);
            if (foreignFieldDesc.cardinalityUPB <= 1) {
                if (!this.getPresenceMaskBit(foreignFieldDesc.absoluteID) || (object = foreignFieldDesc.getValue(this)) == null) continue;
                arrayList2 = (SQLStateManager)this.persistenceManager.getStateManager(object);
                if (!((SQLStateManager)((Object)arrayList2)).state.isAutoPersistent() || !((SQLStateManager)((Object)arrayList2)).state.isPersistentInDataStore()) continue;
                this.updateObjectField(foreignFieldDesc, null, null, false, false);
                continue;
            }
            object = (Collection)foreignFieldDesc.getValue(this);
            if (object == null) continue;
            if (object instanceof SCOCollection && (arrayList2 = (SCOCollection)object).isDeferred()) {
                object = arrayList2.getAdded();
            }
            if (object.size() <= 0) continue;
            arrayList2 = new ArrayList(object);
            ArrayList arrayList3 = null;
            this.processCollectionUpdates(foreignFieldDesc, arrayList2, arrayList3, null, false, false);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph3.exit");
        }
    }

    private void getUpdateActions(ArrayList arrayList) {
        if ((this.stateFlags & 4) > 0) {
            return;
        }
        int n = this.state.getUpdateAction();
        if (n == 4 && this.updateDesc == null) {
            return;
        }
        this.getUpdateDesc();
        this.updateDesc.setObjectInfo(this.getBeforeImage(), this, n);
        if (n == 2 || n == 1 || this.updateDesc.hasUpdatedFields() || this.updateDesc.hasUpdatedJoinTableRelationships()) {
            arrayList.add(this.updateDesc);
        }
        this.stateFlags = (short)(this.stateFlags | 4);
        if (this.updatedForeignReferences != null) {
            Iterator iterator = this.updatedForeignReferences.iterator();
            while (iterator.hasNext()) {
                SQLStateManager sQLStateManager = (SQLStateManager)iterator.next();
                if (sQLStateManager.referenceCount == 1) {
                    sQLStateManager.getUpdateActions(arrayList);
                }
                --sQLStateManager.referenceCount;
            }
        }
    }

    public void release() {
        this.persistenceManager.setStateManager(this.persistentObject, null);
        this.persistentObject = null;
        this.objectId = null;
        this.persistenceManager = null;
        this.beforeImage = null;
        this.hiddenValues = null;
        this.updatedForeignReferences = null;
        this.updateDesc = null;
        this.persistenceConfig = null;
        this.store = null;
        this.valid = false;
    }

    private void reset(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4 = logger.isLoggable();
        if (bl4) {
            object = new Object[]{new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
            logger.fine("sqlstore.sqlstatemanager.reset", (Object[])object);
        }
        if (this.state == null) {
            if (!bl3) {
                this.persistenceManager.clearFields(this.persistentObject);
            }
            this.persistenceManager.setFlags(this.persistentObject, (byte)0);
            if (this.needsVerifyAtDeregister) {
                this.persistenceManager.deregisterInstance(this.getObjectId(), this);
            } else {
                this.persistenceManager.deregisterInstance(this.getObjectId());
            }
            this.release();
        } else {
            this.stateFlags = 0;
            this.beforeImage = null;
            this.updatedForeignReferences = null;
            this.relationshipChanged = false;
            this.referenceCount = 0;
            if (this.updateDesc != null) {
                this.updateDesc.reset();
            }
            if (bl || this.state instanceof PersistentNonTransactional) {
                object = null;
                ArrayList arrayList = this.persistenceConfig.fields;
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (FieldDesc)arrayList.get(i);
                    Object object2 = ((FieldDesc)object).getValue(this);
                    if (bl2 && object instanceof ForeignFieldDesc && object2 == null && ((ForeignFieldDesc)object).getInverseRelationshipField() == null) {
                        if (bl4) {
                            logger.fine("sqlstore.sqlstatemanager.unsetmask", ((FieldDesc)object).getName());
                        }
                        this.unsetMaskBit(((FieldDesc)object).absoluteID, 2);
                    }
                    if (object2 instanceof Collection && !(object2 instanceof SCOCollection) && !bl3) {
                        if (bl4) {
                            logger.fine("sqlstore.sqlstatemanager.resettingcollection");
                        }
                        this.replaceCollection((FieldDesc)object, (Collection)object2);
                        if (!bl4) continue;
                        logger.fine("sqlstore.sqlstatemanager.newtype", ((FieldDesc)object).getValue(this).getClass());
                        continue;
                    }
                    if (object2 instanceof SCOCollection) {
                        ((SCOCollection)object2).reset();
                        continue;
                    }
                    if (!(object2 instanceof Date) || object2 instanceof SCODate || bl3) continue;
                    if (bl4) {
                        logger.fine("sqlstore.sqlstatemanager.resettingdate");
                    }
                    object2 = ((FieldDesc)object).convertValue(object2, this);
                    ((FieldDesc)object).setValue(this, object2);
                    if (!bl4) continue;
                    logger.fine("sqlstore.sqlstatemanager.newtype", ((FieldDesc)object).getValue(this).getClass());
                }
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else {
                this.clearMask(2);
                this.persistenceManager.clearFields(this.persistentObject);
                this.markKeyFieldsPresent();
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            }
            this.clearMask(0);
            this.clearMask(1);
            this.isReplacementInstance = false;
            this.needsRegisterAtRollback = false;
            this.needsVerifyAtDeregister = false;
        }
    }

    public boolean isProcessed() {
        return this.referenceCount == 0;
    }

    public void flushed() {
        this.state = this.state.transitionFlushed();
        this.clearMask(1);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFB);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFE);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFD);
        this.persistenceManager.setFlags(this.persistentObject, (byte)1);
        if (this.updatedForeignReferences != null) {
            this.updatedForeignReferences.clear();
        }
        if (this.updateDesc != null) {
            this.updateDesc.reset();
        }
    }

    public void commit(boolean bl) {
        boolean bl2 = this.state.isNew() && !this.state.isDeleted();
        this.state = this.state.transitionCommit(bl);
        this.reset(bl, bl2, false);
    }

    public void rollback(boolean bl) {
        boolean bl2 = this.state.isNew() && !this.state.isDeleted();
        boolean bl3 = this.state.needsRestoreOnRollback(bl);
        this.state = this.state.transitionRollback(bl);
        boolean bl4 = bl3;
        if (this.beforeImage != null && bl3) {
            ArrayList arrayList = null;
            for (int i = 0; i < 2; ++i) {
                arrayList = i == 0 ? this.persistenceConfig.fields : this.persistenceConfig.hiddenFields;
                for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                    FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                    if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) continue;
                    fieldDesc.setValue(this, fieldDesc.getValue(this.beforeImage));
                }
            }
            bl4 = true;
        }
        if (this.needsRegisterAtRollback && !this.isReplacementInstance) {
            this.persistenceManager.registerInstance(this, this.getObjectId());
        }
        this.reset(bl, bl2, bl4);
    }

    private void markKeyFieldsPresent() {
        Field[] fieldArray = this.persistenceConfig.getKeyFields();
        String[] stringArray = this.persistenceConfig.getKeyFieldNames();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            FieldDesc fieldDesc = this.persistenceConfig.getField(stringArray[i]);
            if (fieldDesc == null) continue;
            this.setPresenceMaskBit(fieldDesc.absoluteID);
        }
    }

    public void prepareGetField(int n) {
        FieldDesc fieldDesc = this.persistenceConfig.getField(n);
        this.prepareGetField(fieldDesc, false, true);
    }

    private void prepareGetField(FieldDesc fieldDesc) {
        this.prepareGetField(fieldDesc, true, false);
    }

    private void prepareGetField(FieldDesc fieldDesc, boolean bl, boolean bl2) {
        boolean bl3 = logger.isLoggable(300);
        if (bl3) {
            logger.finest("sqlstore.sqlstatemanager.preparegetfield", fieldDesc.getName());
        }
        if (bl2) {
            this.persistenceManager.acquireShareLock();
        }
        try {
            block14: {
                try {
                    this.getLock();
                    boolean bl4 = this.persistenceManager.isActiveTransaction();
                    boolean bl5 = this.persistenceManager.isOptimisticTransaction();
                    boolean bl6 = this.persistenceManager.isNontransactionalRead();
                    if (this.state.needsReload(bl5, bl6, bl4)) {
                        this.reload(fieldDesc);
                    }
                    LifeCycleState lifeCycleState = this.state;
                    this.state = this.state.transitionReadField(bl5, bl6, bl4);
                    this.registerInstance(false, null, lifeCycleState);
                    if (!this.state.isNavigable() && bl) break block14;
                    if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
                        this.realizeField(fieldDesc);
                    }
                    if (this.getGetMaskBit(fieldDesc.absoluteID)) break block14;
                    if ((fieldDesc.sqlProperties & 2) > 0) {
                        this.getBeforeImage();
                    }
                    this.setGetMaskBit(fieldDesc.absoluteID);
                }
                catch (JDOException jDOException) {
                    throw jDOException;
                }
                catch (Exception exception) {
                    logger.log(500, "sqlstore.exception.log", exception);
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.getfieldfailed"), exception);
                }
            }
            Object var10_11 = null;
            if (bl2) {
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (bl3) {
                logger.finest("sqlstore.sqlstatemanager.preparegetfield.exit");
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (bl2) {
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (bl3) {
                logger.finest("sqlstore.sqlstatemanager.preparegetfield.exit");
            }
            throw throwable;
        }
    }

    public synchronized void merge(StateManager stateManager) {
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.merge", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state != null && !this.state.needMerge()) {
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.merge.exit.noneed");
            }
            return;
        }
        SQLStateManager sQLStateManager = (SQLStateManager)stateManager;
        ArrayList arrayList = null;
        for (int i = 0; i < 2; ++i) {
            arrayList = i == 0 ? this.persistenceConfig.fields : this.persistenceConfig.hiddenFields;
            for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                if (this.getPresenceMaskBit(fieldDesc.absoluteID) || !sQLStateManager.getPresenceMaskBit(fieldDesc.absoluteID)) continue;
                Object object = fieldDesc.getValue(sQLStateManager);
                if (object instanceof SCOCollection) {
                    this.replaceCollection(fieldDesc, (SCOCollection)object);
                } else {
                    if (object instanceof SCODate) {
                        object = fieldDesc.convertValue(object, this);
                    }
                    fieldDesc.setValue(this, object);
                }
                if (bl) {
                    logger.fine("sqlstore.sqlstatemanager.marking", fieldDesc.getName());
                }
                this.setPresenceMaskBit(fieldDesc.absoluteID);
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.merge.exit");
        }
    }

    private void realizeField(FieldDesc fieldDesc) {
        FieldDesc fieldDesc2;
        int n;
        ArrayList arrayList;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.realizefield", fieldDesc.getName());
        }
        if (!this.persistenceConfig.navigable) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.notnavigable", fieldDesc.getName(), this.persistentObject.getClass().getName()));
        }
        boolean bl2 = false;
        RetrieveDesc retrieveDesc = null;
        if (fieldDesc.fetchGroup == 0) {
            arrayList = new ArrayList();
            arrayList.add(fieldDesc);
        } else {
            arrayList = this.persistenceConfig.getFetchGroup(fieldDesc.fetchGroup);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Class clazz;
            Object object;
            Serializable serializable;
            fieldDesc2 = (FieldDesc)arrayList.get(n);
            if (fieldDesc2 == null) continue;
            if (fieldDesc2 instanceof LocalFieldDesc) {
                if (retrieveDesc == null) {
                    retrieveDesc = this.store.getRetrieveDesc(this.persistenceConfig.getPersistenceCapableClass());
                }
                retrieveDesc.addField(fieldDesc2.getName(), null);
                continue;
            }
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc2;
            boolean bl3 = false;
            if (arrayList.size() <= 1 && !foreignFieldDesc.useJoinTable()) {
                for (int i = 0; i < foreignFieldDesc.localFields.size(); ++i) {
                    serializable = (LocalFieldDesc)foreignFieldDesc.localFields.get(i);
                    bl3 = this.getPresenceMaskBit(((LocalFieldDesc)serializable).absoluteID);
                    if (!bl3) break;
                }
            }
            RetrieveDesc retrieveDesc2 = this.store.getRetrieveDesc(foreignFieldDesc.foreignConfig.getPersistenceCapableClass());
            if (!bl3) {
                if (retrieveDesc == null) {
                    retrieveDesc = this.store.getRetrieveDesc(this.persistenceConfig.getPersistenceCapableClass());
                }
                retrieveDesc.addField(foreignFieldDesc.getName(), retrieveDesc2);
                continue;
            }
            serializable = null;
            boolean bl4 = false;
            for (int i = 0; i < foreignFieldDesc.foreignFields.size(); ++i) {
                FieldDesc fieldDesc3 = (FieldDesc)foreignFieldDesc.localFields.get(i);
                FieldDesc fieldDesc4 = (FieldDesc)foreignFieldDesc.foreignFields.get(i);
                object = this.getSetMaskBit(fieldDesc3.absoluteID) ? fieldDesc3.getValue(this.beforeImage) : fieldDesc3.getValue(this);
                if (object != null) {
                    bl4 = true;
                    retrieveDesc2.addConstraint(fieldDesc4.getName(), 9, object);
                    continue;
                }
                retrieveDesc2.addConstraint(fieldDesc4.getName(), 28, null);
            }
            if (bl4) {
                serializable = (ArrayList)this.store.retrieve(this.persistenceManager, retrieveDesc2);
            }
            if ((clazz = foreignFieldDesc.getType()).isArray()) {
                object = Array.newInstance(foreignFieldDesc.getComponentType(), ((ArrayList)serializable).size());
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    Array.set(object, i, ((ArrayList)serializable).get(i));
                }
                foreignFieldDesc.setValue(this, object);
                this.updateBeforeImage(foreignFieldDesc, object);
            } else if (foreignFieldDesc.getComponentType() != null) {
                this.replaceCollection(foreignFieldDesc, (Collection)((Object)serializable));
            } else if (serializable == null || ((ArrayList)serializable).size() == 0) {
                foreignFieldDesc.setValue(this, null);
            } else {
                if (((ArrayList)serializable).size() > 1) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toomanyobjforcard1", this.persistentObject.getClass().getName(), foreignFieldDesc.getName(), "" + ((ArrayList)serializable).size()));
                }
                object = foreignFieldDesc.convertValue(((ArrayList)serializable).get(0), this);
                foreignFieldDesc.setValue(this, object);
                this.updateBeforeImage(foreignFieldDesc, object);
            }
            this.setPresenceMaskBit(foreignFieldDesc.absoluteID);
            bl2 = true;
        }
        if (!bl2 && retrieveDesc.realizeFields(this)) {
            for (n = 0; n < arrayList.size(); ++n) {
                fieldDesc2 = (FieldDesc)arrayList.get(n);
                this.updateBeforeImage(fieldDesc2, null);
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.realizefield.exit");
        }
    }

    public void mergeChanges(SQLStateManager sQLStateManager) {
        ArrayList arrayList = this.persistenceConfig.fields;
        boolean bl = logger.isLoggable();
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.mergechanges", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldDesc fieldDesc = (FieldDesc)arrayList.get(i);
            if (!sQLStateManager.getSetMaskBit(fieldDesc.absoluteID) && (this.getPresenceMaskBit(fieldDesc.absoluteID) || !sQLStateManager.getPresenceMaskBit(fieldDesc.absoluteID))) continue;
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.merging", fieldDesc.getName());
            }
            fieldDesc.setValue(this, fieldDesc.getValue(sQLStateManager));
            this.setPresenceMaskBit(fieldDesc.absoluteID);
        }
        if (sQLStateManager.hiddenValues != null) {
            ArrayList arrayList2 = this.persistenceConfig.hiddenFields;
            for (int i = 0; i < arrayList2.size(); ++i) {
                FieldDesc fieldDesc = (FieldDesc)arrayList2.get(i);
                if (!sQLStateManager.getSetMaskBit(fieldDesc.absoluteID) && (this.getPresenceMaskBit(fieldDesc.absoluteID) || !sQLStateManager.getPresenceMaskBit(fieldDesc.absoluteID))) continue;
                if (bl) {
                    logger.fine("sqlstore.sqlstatemanager.merging", fieldDesc.getName());
                }
                fieldDesc.setValue(this, fieldDesc.getValue(sQLStateManager));
                this.setPresenceMaskBit(fieldDesc.absoluteID);
            }
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.mergechanges.exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLStateManager getBeforeImage() {
        if (this.beforeImage == null && this.isBeforeImageRequired()) {
            boolean bl = logger.isLoggable();
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.getbeforeimage", this.persistenceConfig.getPersistenceCapableClass().getName());
            }
            try {
                this.getLock();
                this.beforeImage = this.copyPersistent(this);
            }
            finally {
                this.releaseLock();
            }
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.getbeforeimage.exit");
            }
        }
        return this.beforeImage;
    }

    public boolean isBeforeImageRequired() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        boolean bl = this.persistenceManager.isOptimisticTransaction() || this.relationshipChanged || transaction.getRetainValues() || transaction.getRestoreValues() || this.persistenceConfig.hasModifiedCheckAtCommitConsistency();
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sqlstatemanager.isbeforeimagerequired", new Boolean(bl));
        }
        return bl;
    }

    private SQLStateManager copyPersistent(SQLStateManager sQLStateManager) {
        PersistenceManager persistenceManager = (PersistenceManager)sQLStateManager.getPersistenceManagerInternal();
        SQLStateManager sQLStateManager2 = (SQLStateManager)sQLStateManager.clone();
        Object object = persistenceManager.newInstance(sQLStateManager2);
        if (sQLStateManager.fieldMasks != null) {
            sQLStateManager2.fieldMasks = (BitSet)sQLStateManager.fieldMasks.clone();
            sQLStateManager2.clearMask(1);
            sQLStateManager2.clearMask(0);
        }
        ArrayList arrayList = null;
        for (int i = 0; i < 2; ++i) {
            arrayList = i == 0 ? sQLStateManager.persistenceConfig.fields : sQLStateManager.persistenceConfig.hiddenFields;
            for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(j);
                if (!sQLStateManager.getPresenceMaskBit(fieldDesc.absoluteID)) continue;
                fieldDesc.setValue(sQLStateManager2, this.cloneObjectMaybe(fieldDesc.getValue(sQLStateManager)));
                sQLStateManager2.setPresenceMaskBit(fieldDesc.absoluteID);
            }
        }
        return sQLStateManager2;
    }

    private Object cloneObjectMaybe(Object object) {
        block11: {
            if (object != null) {
                if (object instanceof SCO) {
                    return ((SCO)object).cloneInternal();
                }
                if (!(object instanceof Number || object instanceof String || object instanceof Character || object instanceof Boolean || object instanceof PersistenceCapable || object instanceof byte[])) {
                    try {
                        Class<?> clazz = object.getClass();
                        if (!clazz.isArray()) {
                            Method method = clazz.getMethod("clone", null);
                            if (method != null) {
                                return method.invoke(object, null);
                            }
                            break block11;
                        }
                        Object[] objectArray = (Object[])object;
                        Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), objectArray.length);
                        for (int i = 0; i < objectArray.length; ++i) {
                            objectArray2[i] = objectArray[i];
                        }
                        return objectArray2;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (logger.isLoggable()) {
                            Object[] objectArray = new Object[]{noSuchMethodException, object.getClass().getName()};
                            logger.fine("sqlstore.sqlstatemanager.nosuchmethodexcep.clone", objectArray);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        return object;
    }

    private void prepareUpdateField(FieldDesc fieldDesc, ArrayList arrayList) {
        boolean bl;
        if (fieldDesc.isKeyField()) {
            return;
        }
        boolean bl2 = logger.isLoggable(300);
        boolean bl3 = bl = bl2 || logger.isLoggable();
        if (bl) {
            Object[] objectArray = new Object[]{fieldDesc.getName(), this.state};
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefield", objectArray);
        }
        boolean bl4 = this.persistenceManager.isActiveTransaction();
        boolean bl5 = this.persistenceManager.isNontransactionalRead();
        boolean bl6 = this.persistenceManager.isOptimisticTransaction();
        if (this.state.needsReload(bl6, bl5, bl4)) {
            this.reload(fieldDesc);
        }
        LifeCycleState lifeCycleState = this.state;
        this.state = this.state.transitionWriteField(bl4);
        if (this.state == lifeCycleState && this.getSetMaskBit(fieldDesc.absoluteID) && this.getPresenceMaskBit(fieldDesc.absoluteID)) {
            return;
        }
        this.registerInstance(false, arrayList, lifeCycleState);
        if (this.state.isBeforeImageUpdatable() && (fieldDesc.sqlProperties & 4) > 0) {
            this.getBeforeImage();
            if (this.beforeImage != null && !this.beforeImage.getPresenceMaskBit(fieldDesc.absoluteID)) {
                if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
                    this.prepareGetField(fieldDesc);
                }
                Object object = fieldDesc.getValue(this);
                Object object2 = this.cloneObjectMaybe(object);
                if (bl2) {
                    Object[] objectArray = new Object[]{fieldDesc.getName(), object2};
                    logger.fine("sqlstore.sqlstatemanager.loggingfield", objectArray);
                }
                fieldDesc.setValue(this.beforeImage, object2);
                this.beforeImage.setPresenceMaskBit(fieldDesc.absoluteID);
            }
        }
        if (fieldDesc instanceof LocalFieldDesc && (fieldDesc.sqlProperties & 0x20) > 0) {
            if (bl2) {
                logger.fine("sqlstore.sqlstatemanager.recordingfield", fieldDesc.getName());
            }
            ((UpdateObjectDescImpl)this.getUpdateDesc()).recordUpdatedField(fieldDesc);
        }
        this.setSetMaskBit(fieldDesc.absoluteID);
        if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
            if (bl) {
                logger.fine("sqlstore.sqlstatemanager.marking", fieldDesc.getName());
            }
            this.setPresenceMaskBit(fieldDesc.absoluteID);
        }
        if (bl) {
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefield.exit");
        }
    }

    private void updateBeforeImage(FieldDesc fieldDesc, Object object) {
        if (this.beforeImage != null) {
            if (object == null) {
                object = fieldDesc.getValue(this);
            }
            if (logger.isLoggable(400)) {
                Object[] objectArray = new Object[]{fieldDesc.getName(), object};
                logger.finer("sqlstore.sqlstatemanager.updatebeforeimage", objectArray);
            }
            fieldDesc.setValue(this.beforeImage, object);
        }
    }

    public void addDependency(StateManager stateManager) {
        this.addUpdatedForeignReference((SQLStateManager)stateManager);
    }

    private void addUpdatedForeignReference(SQLStateManager sQLStateManager) {
        if (sQLStateManager == this) {
            return;
        }
        if (this.updatedForeignReferences == null) {
            this.updatedForeignReferences = new HashSet();
            if ((this.stateFlags & 2) == 0) {
                this.persistenceManager.registerInstance(this, this.getObjectId(), false, true);
                this.stateFlags = (short)(this.stateFlags | 2);
            }
        }
        if (this.updatedForeignReferences.add(sQLStateManager)) {
            sQLStateManager.stateFlags = (short)(sQLStateManager.stateFlags | 1);
            ++sQLStateManager.referenceCount;
            if (logger.isLoggable(300)) {
                Object[] objectArray = new Object[]{this.persistentObject, sQLStateManager.persistentObject, new Integer(sQLStateManager.referenceCount)};
                logger.fine("sqlstore.sqlstatemanager.addupdate", objectArray);
            }
            if ((sQLStateManager.stateFlags & 2) == 0) {
                this.persistenceManager.registerInstance(sQLStateManager, sQLStateManager.getObjectId(), false, true);
                sQLStateManager.stateFlags = (short)(sQLStateManager.stateFlags | 2);
            }
        }
    }

    private void removeUpdatedForeignReference(SQLStateManager sQLStateManager) {
        if (this.updatedForeignReferences == null || this.updatedForeignReferences.size() == 0) {
            return;
        }
        if (this.updatedForeignReferences.remove(sQLStateManager)) {
            --sQLStateManager.referenceCount;
            if (logger.isLoggable(400)) {
                Object[] objectArray = new Object[]{this.persistentObject, sQLStateManager.persistentObject, new Integer(sQLStateManager.referenceCount)};
                logger.fine("sqlstore.sqlstatemanager.removeupdate", objectArray);
            }
            if (sQLStateManager.referenceCount == 0) {
                sQLStateManager.stateFlags = (short)(sQLStateManager.stateFlags & 0xFFFFFFFE);
            }
        }
    }

    private boolean updateObjectField(ForeignFieldDesc foreignFieldDesc, Object objectArray, ArrayList arrayList, boolean bl, boolean bl2) {
        Object object;
        Object[] objectArray2;
        boolean bl3 = logger.isLoggable();
        if (bl3) {
            objectArray2 = new Object[]{foreignFieldDesc.getName(), foreignFieldDesc.getComponentType()};
            logger.fine("sqlstore.sqlstatemanager.updateobjfield", objectArray2);
        }
        if ((objectArray2 = objectArray) == (object = foreignFieldDesc.getValue(this))) {
            return true;
        }
        SQLStateManager sQLStateManager = null;
        SQLStateManager sQLStateManager2 = null;
        if (objectArray2 != null) {
            sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(objectArray2);
            if (sQLStateManager == null) {
                this.makeAutoPersistent(objectArray2);
                sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(objectArray2);
            }
            sQLStateManager.relationshipChanged = true;
            if (arrayList != null && !arrayList.contains(sQLStateManager)) {
                arrayList.add(sQLStateManager);
            }
        }
        if (sQLStateManager != null && sQLStateManager.isDeleted()) {
            JDOUserException jDOUserException = new JDOUserException(I18NHelper.getMessage(messages, "jdo.lifecycle.deleted.accessField"));
            jDOUserException.addFailedObject(objectArray2);
            throw jDOUserException;
        }
        if (object != null) {
            sQLStateManager2 = (SQLStateManager)this.persistenceManager.getStateManager(object);
            sQLStateManager2.relationshipChanged = true;
        }
        boolean bl4 = (foreignFieldDesc.sqlProperties & 0x40) == 0;
        for (int i = 0; i < foreignFieldDesc.localFields.size(); ++i) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.localFields.get(i);
            LocalFieldDesc localFieldDesc2 = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(i);
            if (bl4) {
                if (sQLStateManager2 != null) {
                    this.removeRelationship(foreignFieldDesc, localFieldDesc2, sQLStateManager2);
                }
                if (sQLStateManager == null) continue;
                Object object2 = localFieldDesc.getValue(this);
                this.addRelationship(foreignFieldDesc, localFieldDesc2, sQLStateManager, object2);
                continue;
            }
            this.updateRelationship(foreignFieldDesc, localFieldDesc, localFieldDesc2, sQLStateManager, sQLStateManager2, objectArray2);
        }
        this.processRelationshipManagement(foreignFieldDesc, sQLStateManager, sQLStateManager2, bl, bl2, bl4);
        if (bl3) {
            logger.fine("sqlstore.sqlstatemanager.updateobjfield.exit");
        }
        return true;
    }

    private void removeRelationship(ForeignFieldDesc foreignFieldDesc, LocalFieldDesc localFieldDesc, SQLStateManager sQLStateManager) {
        if (localFieldDesc.isKeyField()) {
            sQLStateManager.assertPKUpdate(localFieldDesc, null);
        }
        if (!sQLStateManager.getSetMaskBit(localFieldDesc.absoluteID)) {
            if (!sQLStateManager.isDeleted()) {
                sQLStateManager.prepareUpdateField(localFieldDesc, null);
            }
            if (!this.state.isPersistentInDataStore()) {
                this.addUpdatedForeignReference(sQLStateManager);
            } else {
                sQLStateManager.addUpdatedForeignReference(this);
            }
        } else if (!this.state.isPersistentInDataStore()) {
            this.removeUpdatedForeignReference(sQLStateManager);
        } else {
            sQLStateManager.addUpdatedForeignReference(this);
        }
        if (!sQLStateManager.isDeleted()) {
            sQLStateManager.updateTrackedFields(localFieldDesc, null, foreignFieldDesc.getInverseRelationshipField(), foreignFieldDesc, null);
            localFieldDesc.setValue(sQLStateManager, null);
        }
    }

    private void addRelationship(ForeignFieldDesc foreignFieldDesc, LocalFieldDesc localFieldDesc, SQLStateManager sQLStateManager, Object object) {
        if (!sQLStateManager.isDeleted()) {
            if (localFieldDesc.isKeyField()) {
                sQLStateManager.assertPKUpdate(localFieldDesc, object);
            }
            if (!sQLStateManager.getSetMaskBit(localFieldDesc.absoluteID)) {
                sQLStateManager.prepareUpdateField(localFieldDesc, null);
            }
            sQLStateManager.updateTrackedFields(localFieldDesc, object, foreignFieldDesc.getInverseRelationshipField(), foreignFieldDesc, this);
            localFieldDesc.setValue(sQLStateManager, object);
        }
        if (!this.state.isPersistentInDataStore()) {
            this.addUpdatedForeignReference(sQLStateManager);
        }
    }

    private void updateRelationship(ForeignFieldDesc foreignFieldDesc, LocalFieldDesc localFieldDesc, LocalFieldDesc localFieldDesc2, SQLStateManager sQLStateManager, SQLStateManager sQLStateManager2, Object object) {
        if (!this.getSetMaskBit(localFieldDesc.absoluteID)) {
            this.prepareUpdateField(localFieldDesc, null);
        }
        if (object != null) {
            Object object2 = localFieldDesc2.getValue(sQLStateManager);
            if (localFieldDesc.isKeyField()) {
                this.assertPKUpdate(localFieldDesc, object2);
            }
            this.updateTrackedFields(localFieldDesc, object2, foreignFieldDesc, foreignFieldDesc, sQLStateManager);
            localFieldDesc.setValue(this, object2);
            if (!sQLStateManager.state.isPersistentInDataStore()) {
                sQLStateManager.addUpdatedForeignReference(this);
            }
        } else {
            JDOUserException jDOUserException = null;
            if (localFieldDesc.isKeyField()) {
                try {
                    this.assertPKUpdate(localFieldDesc, null);
                }
                catch (JDOUserException jDOUserException2) {
                    if ((this.stateFlags & 0x40) == 0 || foreignFieldDesc.cardinalityLWB == 0) {
                        throw jDOUserException2;
                    }
                    jDOUserException = jDOUserException2;
                }
            }
            if (jDOUserException == null) {
                this.updateTrackedFields(localFieldDesc, null, foreignFieldDesc, null, null);
                localFieldDesc.setValue(this, null);
            }
        }
        if (sQLStateManager2 != null) {
            if (!sQLStateManager2.state.isPersistentInDataStore()) {
                sQLStateManager2.removeUpdatedForeignReference(this);
            } else {
                this.addUpdatedForeignReference(sQLStateManager2);
            }
        }
    }

    private void processRelationshipManagement(ForeignFieldDesc foreignFieldDesc, SQLStateManager sQLStateManager, SQLStateManager sQLStateManager2, boolean bl, boolean bl2, boolean bl3) {
        ForeignFieldDesc foreignFieldDesc2 = foreignFieldDesc.getInverseRelationshipField();
        boolean bl4 = false;
        if (foreignFieldDesc2 != null) {
            boolean bl5 = bl4 = foreignFieldDesc2.cardinalityUPB > 1;
        }
        if (bl && foreignFieldDesc2 != null) {
            SCOCollection sCOCollection;
            Object object = null;
            SQLStateManager sQLStateManager3 = null;
            if (sQLStateManager2 != null) {
                if (!bl4) {
                    sQLStateManager2.prepareSetFieldSpecial(foreignFieldDesc2, this.persistentObject, false);
                    sQLStateManager2.updateTrackedFields(foreignFieldDesc2, null, null, null, null);
                    foreignFieldDesc2.setValue(sQLStateManager2, null);
                } else {
                    try {
                        sQLStateManager2.prepareSetFieldSpecial(foreignFieldDesc2, null, true);
                        sCOCollection = (SCOCollection)foreignFieldDesc2.getValue(sQLStateManager2);
                        sCOCollection.removeInternal(this.persistentObject);
                        sQLStateManager2.updateTrackedFields(foreignFieldDesc2, sCOCollection, null, null, null);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (sQLStateManager != null && !bl2) {
                if (!bl4) {
                    object = sQLStateManager.prepareSetField(foreignFieldDesc2, this.persistentObject, true);
                    if (object != null) {
                        sQLStateManager3 = (SQLStateManager)this.persistenceManager.getStateManager(object);
                    }
                } else {
                    try {
                        sQLStateManager.prepareSetFieldSpecial(foreignFieldDesc2, null, true);
                        sCOCollection = (SCOCollection)foreignFieldDesc2.getValue(sQLStateManager);
                        if (sCOCollection == null) {
                            sQLStateManager.replaceCollection(foreignFieldDesc2, null);
                            sCOCollection = (SCOCollection)foreignFieldDesc2.getValue(sQLStateManager);
                        }
                        sCOCollection.addInternal(this.persistentObject);
                        sQLStateManager.updateTrackedFields(foreignFieldDesc2, sCOCollection, null, null, null);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (!bl4) {
                if (bl3 && sQLStateManager2 != null && sQLStateManager != null) {
                    sQLStateManager2.addUpdatedForeignReference(sQLStateManager);
                }
                if (!bl3 && sQLStateManager3 != null) {
                    super.addUpdatedForeignReference(this);
                }
            }
        }
    }

    private void processCollectionUpdates(ForeignFieldDesc foreignFieldDesc, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, boolean bl, boolean bl2) {
        boolean bl3 = logger.isLoggable();
        if (bl3) {
            Object[] objectArray = new Object[]{arrayList, arrayList2};
            logger.fine("sqlstore.sqlstatemanager.processcollectionupdate", objectArray);
        }
        if (arrayList != null) {
            this.removeCollectionRelationship(foreignFieldDesc, arrayList, arrayList3, bl);
        }
        if (arrayList2 != null) {
            this.addCollectionRelationship(foreignFieldDesc, arrayList2, arrayList3, bl, bl2);
        }
        if (bl3) {
            logger.fine("sqlstore.sqlstatemanager.processcollectionupdate.exit");
        }
    }

    private void removeCollectionRelationship(ForeignFieldDesc foreignFieldDesc, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        ForeignFieldDesc foreignFieldDesc2 = foreignFieldDesc.getInverseRelationshipField();
        boolean bl2 = false;
        if (foreignFieldDesc2 != null) {
            bl2 = foreignFieldDesc2.cardinalityUPB > 1;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SQLStateManager sQLStateManager;
            Object e = arrayList.get(i);
            if (e == null || (sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e)) == null) continue;
            sQLStateManager.relationshipChanged = true;
            if (!foreignFieldDesc.useJoinTable()) {
                if (!sQLStateManager.isDeleted()) {
                    for (int j = 0; j < foreignFieldDesc.localFields.size(); ++j) {
                        LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(j);
                        if (localFieldDesc.isKeyField()) {
                            try {
                                sQLStateManager.assertPKUpdate(localFieldDesc, null);
                            }
                            catch (JDOUnsupportedOptionException jDOUnsupportedOptionException) {
                                throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.wrongusageforoverlappingpkfkdelete"), jDOUnsupportedOptionException);
                            }
                        }
                        sQLStateManager.prepareUpdateField(localFieldDesc, null);
                        sQLStateManager.updateTrackedFields(localFieldDesc, null, foreignFieldDesc2, foreignFieldDesc, null);
                        localFieldDesc.setValue(sQLStateManager, null);
                    }
                }
                if (arrayList2 != null && !arrayList2.contains(sQLStateManager)) {
                    arrayList2.add(sQLStateManager);
                }
                if (this.state.isPersistentInDataStore()) {
                    sQLStateManager.addUpdatedForeignReference(this);
                }
            } else {
                sQLStateManager.removeUpdatedForeignReference(this);
                if (!(((UpdateObjectDescImpl)sQLStateManager.getUpdateDesc()).removeUpdatedJoinTableRelationship(foreignFieldDesc, this) || foreignFieldDesc2 != null && ((UpdateObjectDescImpl)this.getUpdateDesc()).removeUpdatedJoinTableRelationship(foreignFieldDesc2, sQLStateManager))) {
                    this.addUpdatedForeignReference(sQLStateManager);
                    ((UpdateObjectDescImpl)this.getUpdateDesc()).recordUpdatedJoinTableRelationship(foreignFieldDesc, this, sQLStateManager, sQLStateManager, 2);
                }
            }
            if (!bl || foreignFieldDesc2 == null) continue;
            if (!bl2) {
                sQLStateManager.prepareSetFieldSpecial(foreignFieldDesc2, this.persistentObject, false);
                sQLStateManager.updateTrackedFields(foreignFieldDesc2, null, null, null, null);
                foreignFieldDesc2.setValue(sQLStateManager, null);
                continue;
            }
            try {
                sQLStateManager.prepareSetFieldSpecial(foreignFieldDesc2, null, true);
                SCOCollection sCOCollection = (SCOCollection)foreignFieldDesc2.getValue(sQLStateManager);
                sCOCollection.removeInternal(this.persistentObject);
                sQLStateManager.updateTrackedFields(foreignFieldDesc2, sCOCollection, null, null, null);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void addCollectionRelationship(ForeignFieldDesc foreignFieldDesc, ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2) {
        ForeignFieldDesc foreignFieldDesc2 = foreignFieldDesc.getInverseRelationshipField();
        boolean bl3 = false;
        JDOException jDOException = null;
        if (foreignFieldDesc2 != null) {
            bl3 = foreignFieldDesc2.cardinalityUPB > 1;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e == null) continue;
            SQLStateManager sQLStateManager = null;
            sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e);
            if (sQLStateManager == null) {
                this.makeAutoPersistent(e);
                sQLStateManager = (SQLStateManager)this.persistenceManager.getStateManager(e);
            }
            sQLStateManager.relationshipChanged = true;
            if (sQLStateManager.isDeleted()) {
                if (foreignFieldDesc2 == null) continue;
                if (jDOException == null) {
                    jDOException = new JDOUserException(I18NHelper.getMessage(messages, "jdo.lifecycle.deleted.accessField"));
                }
                jDOException.addFailedObject(e);
                continue;
            }
            if (!foreignFieldDesc.useJoinTable()) {
                for (int j = 0; j < foreignFieldDesc.localFields.size(); ++j) {
                    LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.localFields.get(j);
                    LocalFieldDesc localFieldDesc2 = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(j);
                    Object object = localFieldDesc.getValue(this);
                    if (localFieldDesc2.isKeyField()) {
                        sQLStateManager.assertPKUpdate(localFieldDesc2, object);
                    }
                    sQLStateManager.prepareUpdateField(localFieldDesc2, null);
                    sQLStateManager.updateTrackedFields(localFieldDesc2, object, foreignFieldDesc.getInverseRelationshipField(), foreignFieldDesc, this);
                    localFieldDesc2.setValue(sQLStateManager, object);
                }
                if (arrayList2 != null && !arrayList2.contains(sQLStateManager)) {
                    arrayList2.add(sQLStateManager);
                }
                if (!this.state.isPersistentInDataStore()) {
                    this.addUpdatedForeignReference(sQLStateManager);
                }
            } else {
                sQLStateManager.removeUpdatedForeignReference(this);
                if (!(((UpdateObjectDescImpl)this.getUpdateDesc()).removeUpdatedJoinTableRelationship(foreignFieldDesc, sQLStateManager) || foreignFieldDesc2 != null && ((UpdateObjectDescImpl)sQLStateManager.getUpdateDesc()).removeUpdatedJoinTableRelationship(foreignFieldDesc2, this))) {
                    this.addUpdatedForeignReference(sQLStateManager);
                    ((UpdateObjectDescImpl)sQLStateManager.getUpdateDesc()).recordUpdatedJoinTableRelationship(foreignFieldDesc, this, sQLStateManager, this, 1);
                }
            }
            if (!bl || foreignFieldDesc2 == null || bl2) continue;
            if (!bl3) {
                sQLStateManager.prepareSetField(foreignFieldDesc2, this.persistentObject, true);
                continue;
            }
            try {
                sQLStateManager.prepareSetFieldSpecial(foreignFieldDesc2, null, true);
                SCOCollection sCOCollection = (SCOCollection)foreignFieldDesc2.getValue(sQLStateManager);
                sCOCollection.addInternal(this.persistentObject);
                sQLStateManager.updateTrackedFields(foreignFieldDesc2, sCOCollection, null, null, null);
                continue;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            catch (JDOException jDOException2) {
                if (foreignFieldDesc.useJoinTable()) {
                    ((UpdateObjectDescImpl)sQLStateManager.getUpdateDesc()).removeUpdatedJoinTableRelationship(foreignFieldDesc, this);
                }
                throw jDOException2;
            }
        }
        if (jDOException != null) {
            throw jDOException;
        }
    }

    private synchronized void prepareSetFieldSpecial(FieldDesc fieldDesc, Object object, boolean bl) {
        if (fieldDesc.isKeyField()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
        if (this.getSetMaskBit(fieldDesc.absoluteID)) {
            return;
        }
        boolean bl2 = logger.isLoggable(400);
        if (bl2) {
            Object[] objectArray = new Object[]{fieldDesc.getName(), this.state};
            logger.finer("sqlstore.sqlstatemanager.preparesetfieldspl", objectArray);
        }
        boolean bl3 = this.persistenceManager.isOptimisticTransaction();
        boolean bl4 = this.persistenceManager.isActiveTransaction();
        boolean bl5 = this.persistenceManager.isNontransactionalRead();
        if (this.state.needsReload(bl3, bl5, bl4)) {
            if (!bl3) {
                this.persistenceManager.clearFields(this.persistentObject);
            }
            this.reload(null);
        }
        LifeCycleState lifeCycleState = this.state;
        this.state = this.state.transitionWriteField(bl4);
        this.registerInstance(false, null, lifeCycleState);
        this.getBeforeImage();
        if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
            if (!bl) {
                if (!(object instanceof SCOCollection) || !((SCOCollection)object).isDeferred()) {
                    if (this.beforeImage != null) {
                        fieldDesc.setValue(this.beforeImage, object);
                        this.beforeImage.setPresenceMaskBit(fieldDesc.absoluteID);
                    }
                    this.setPresenceMaskBit(fieldDesc.absoluteID);
                }
            } else {
                if (!(fieldDesc instanceof ForeignFieldDesc) || ((ForeignFieldDesc)fieldDesc).cardinalityUPB <= 1) {
                    return;
                }
                Object object2 = fieldDesc.getValue(this);
                if (object2 == null) {
                    SCOCollection sCOCollection = (SCOCollection)this.persistenceManager.newCollectionInstanceInternal(fieldDesc.getType(), this.persistentObject, fieldDesc.getName(), fieldDesc.getComponentType(), false, 10);
                    sCOCollection.markDeferred();
                    fieldDesc.setValue(this, sCOCollection);
                } else {
                    this.makeDirty(fieldDesc.getName());
                }
            }
        }
        if (fieldDesc instanceof LocalFieldDesc && (fieldDesc.sqlProperties & 0x20) > 0) {
            if (bl2) {
                logger.finer("sqlstore.sqlstatemanager.makedirtyfield", fieldDesc.getName());
            }
            ((UpdateObjectDescImpl)this.getUpdateDesc()).recordUpdatedField(fieldDesc);
        }
        this.setSetMaskBit(fieldDesc.absoluteID);
        if (bl2) {
            logger.finer("sqlstore.sqlstatemanager.preparesetfieldspl.exit");
        }
    }

    private void updateTrackedFields(FieldDesc fieldDesc, Object object, ForeignFieldDesc foreignFieldDesc, FieldDesc fieldDesc2, SQLStateManager sQLStateManager) {
        ArrayList arrayList;
        Object[] objectArray;
        ArrayList arrayList2 = fieldDesc.getTrackedFields();
        if (arrayList2 == null) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        if (bl) {
            objectArray = new Object[]{fieldDesc.getName(), object, foreignFieldDesc != null ? foreignFieldDesc.getName() : null};
            logger.finest("sqlstore.sqlstatemanager.updatetrackedfields", objectArray);
        }
        objectArray = fieldDesc.getValue(this);
        int n = arrayList2.size();
        ArrayList arrayList3 = arrayList = foreignFieldDesc != null ? foreignFieldDesc.getTrackedFields() : null;
        if (fieldDesc instanceof ForeignFieldDesc) {
            for (int i = 0; i < n; ++i) {
                FieldDesc fieldDesc3 = (FieldDesc)arrayList2.get(i);
                this.prepareSetFieldSpecial(fieldDesc3, objectArray, false);
                fieldDesc3.setValue(this, object);
            }
        } else {
            Object[] objectArray2 = new Object[n];
            LocalFieldDesc localFieldDesc = null;
            Object object2 = null;
            if ((fieldDesc.sqlProperties & 0x100) > 0) {
                localFieldDesc = (LocalFieldDesc)fieldDesc;
                object2 = object;
            }
            for (int i = 0; i < n; ++i) {
                Object object3;
                Object object4;
                FieldDesc fieldDesc4 = (FieldDesc)arrayList2.get(i);
                if (fieldDesc4 instanceof LocalFieldDesc) {
                    object4 = null;
                    object3 = null;
                    try {
                        object4 = fieldDesc4.convertValue(object, this);
                        object3 = fieldDesc4.convertValue(objectArray, this);
                    }
                    catch (JDOUserException jDOUserException) {
                        for (int j = 0; j < i; ++j) {
                            fieldDesc4 = (FieldDesc)arrayList2.get(j);
                            fieldDesc4.setValue(this, objectArray2[j]);
                        }
                        throw jDOUserException;
                    }
                    if ((fieldDesc4.sqlProperties & 0x100) > 0) {
                        localFieldDesc = (LocalFieldDesc)fieldDesc4;
                        object2 = object4;
                    }
                    this.prepareSetFieldSpecial(fieldDesc4, object3, false);
                    objectArray2[i] = fieldDesc4.getValue(this);
                    fieldDesc4.setValue(this, object4);
                    continue;
                }
                if ((this.stateFlags & 0x20) > 0 || fieldDesc4 == foreignFieldDesc || arrayList != null && arrayList.contains(fieldDesc4)) continue;
                object4 = (ForeignFieldDesc)fieldDesc4;
                object3 = null;
                Object object5 = null;
                if (fieldDesc2 != null && sQLStateManager != null) {
                    object5 = ((ForeignFieldDesc)object4).createObjectId(this, fieldDesc2, sQLStateManager);
                } else if (fieldDesc2 == null && object2 != null) {
                    object5 = ((ForeignFieldDesc)object4).createObjectId(this, localFieldDesc, object2);
                }
                if (object5 != null) {
                    object3 = this.persistenceManager.getObjectById(object5);
                }
                this.stateFlags = (short)(this.stateFlags | 0x20);
                this.prepareSetField((FieldDesc)object4, object3);
                this.stateFlags = (short)(this.stateFlags & 0xFFFFFFDF);
            }
        }
        if (bl) {
            logger.finest("sqlstore.sqlstatemanager.updatetrackedfields.exit");
        }
    }

    private Object doUpdateField(FieldDesc fieldDesc, Object object, boolean bl) {
        Object object2;
        boolean bl2 = false;
        if (fieldDesc instanceof ForeignFieldDesc) {
            bl2 = true;
            this.relationshipChanged = true;
        }
        this.prepareUpdateField(fieldDesc, null);
        if (bl2) {
            object2 = (ForeignFieldDesc)fieldDesc;
            if (((ForeignFieldDesc)object2).cardinalityUPB > 1) {
                this.updateCollectionField((ForeignFieldDesc)object2, (Collection)object, bl);
            } else {
                this.updateObjectField((ForeignFieldDesc)object2, object, null, true, bl);
            }
        }
        this.updateTrackedFields(fieldDesc, object, null, null, null);
        object2 = fieldDesc.getValue(this);
        fieldDesc.setValue(this, object);
        return object2;
    }

    private Object prepareSetField(int n, Object object) {
        FieldDesc fieldDesc = this.persistenceConfig.getField(n);
        return this.prepareSetField(fieldDesc, object, false, true);
    }

    private Object prepareSetField(FieldDesc fieldDesc, Object object) {
        return this.prepareSetField(fieldDesc, object, false, false);
    }

    private Object prepareSetField(FieldDesc fieldDesc, Object object, boolean bl) {
        return this.prepareSetField(fieldDesc, object, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object prepareSetField(FieldDesc fieldDesc, Object object, boolean bl, boolean bl2) {
        boolean bl3 = logger.isLoggable(300);
        if (bl3) {
            logger.finest("sqlstore.sqlstatemanager.preparesetfield", fieldDesc.getName());
        }
        if (bl2) {
            this.persistenceManager.acquireShareLock();
        }
        try {
            Object object2;
            block13: {
                try {
                    this.getLock();
                    if ((fieldDesc.sqlProperties & 0x10) > 0) {
                        throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.readonly", fieldDesc.getName(), this.persistentObject.getClass().getName()));
                    }
                    if (fieldDesc.getTrackedFields() != null || fieldDesc instanceof ForeignFieldDesc) {
                        this.persistenceManager.acquireFieldUpdateLock();
                        try {
                            Object object3 = this.doUpdateField(fieldDesc, object, bl);
                            return object3;
                        }
                        finally {
                            this.persistenceManager.releaseFieldUpdateLock();
                        }
                    }
                    object2 = this.doUpdateField(fieldDesc, object, bl);
                    Object var9_11 = null;
                    if (!bl2) break block13;
                }
                catch (JDOException jDOException) {
                    throw jDOException;
                }
                catch (Exception exception) {
                    logger.log(500, "sqlstore.exception.log", exception);
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.setfieldfailed"), exception);
                }
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (!bl3) return object2;
            logger.finest("sqlstore.sqlstatemanager.preparesetfield.exit");
            return object2;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (bl2) {
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (!bl3) throw throwable;
            logger.finest("sqlstore.sqlstatemanager.preparesetfield.exit");
            throw throwable;
        }
    }

    private void updateCollectionField(ForeignFieldDesc foreignFieldDesc, Collection collection, boolean bl) {
        Object[] objectArray;
        boolean bl2 = logger.isLoggable(300);
        if (bl2) {
            objectArray = new Object[]{collection, collection == null ? "NO" : collection.getClass().getName()};
            logger.finest("sqlstore.sqlstatemanager.processforeignfield", objectArray);
        }
        if ((objectArray = foreignFieldDesc.getValue(this)) != collection) {
            Object object;
            Object object2 = null;
            ArrayList arrayList = null;
            ArrayList arrayList2 = null;
            if (collection != null && collection instanceof SCOCollection) {
                object = (SCOCollection)collection;
                object2 = object.getOwner();
                if (object2 == null) {
                    object.setOwner(this.persistentObject, foreignFieldDesc.getName(), foreignFieldDesc.getComponentType());
                } else if (object2 != this.persistentObject || !foreignFieldDesc.getName().equals(object.getFieldName())) {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.anotherowner"), new Object[]{object2, object.getFieldName()});
                }
                arrayList = new ArrayList(collection);
            }
            object = foreignFieldDesc.getValue(this.beforeImage);
            if (objectArray != null) {
                if (bl2) {
                    logger.finest("sqlstore.sqlstatemanager.processforeignfield.remove");
                }
                if (((Collection)objectArray).size() > 0) {
                    arrayList2 = new ArrayList((Collection)objectArray);
                }
                if (objectArray instanceof SCOCollection) {
                    if (bl2) {
                        logger.finest("sqlstore.sqlstatemanager.processforeignfield.reset");
                    }
                    ((SCO)objectArray).unsetOwner();
                }
            } else if (!this.getSetMaskBit(foreignFieldDesc.absoluteID) && object != null) {
                if (bl2) {
                    logger.finest("sqlstore.sqlstatemanager.processforeignfield.remove_from_bi");
                }
                if (((Collection)object).size() > 0) {
                    arrayList2 = new ArrayList((Collection)object);
                }
            }
            this.processCollectionUpdates(foreignFieldDesc, arrayList2, arrayList, null, true, bl);
        }
    }

    public Object clone() {
        SQLStateManager sQLStateManager = new SQLStateManager();
        sQLStateManager.store = this.store;
        sQLStateManager.persistenceManager = this.persistenceManager;
        sQLStateManager.persistenceConfig = this.persistenceConfig;
        return sQLStateManager;
    }

    private void assertNotPK(int n) {
        if (this.persistenceConfig.isPKField(n)) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
    }

    private void assertPKUpdate(FieldDesc fieldDesc, Object object) {
        Object object2 = fieldDesc.getValue(this);
        boolean bl = false;
        if (object != null && object2 != null) {
            if (object.toString().compareTo(object2.toString()) != 0) {
                bl = true;
            }
        } else if (object != object2) {
            bl = true;
        }
        if (bl) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManagerInternal() {
        return this.persistenceManager;
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.persistenceManager == null ? null : this.persistenceManager.getCurrentWrapper();
    }

    public byte setFlags(byte by) {
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadForRead() {
        boolean bl = logger.isLoggable(400);
        if (bl) {
            logger.finer("sqlstore.sqlstatemanager.loadforread");
        }
        this.persistenceManager.acquireShareLock();
        try {
            this.getLock();
            byte by = this.persistenceManager.getFlags(this.persistentObject);
            if (by != 1) {
                Object var8_3 = null;
                this.persistenceManager.releaseShareLock();
                this.releaseLock();
                if (bl) {
                    logger.finer("sqlstore.sqlstatemanager.loadforread.exit");
                }
                return;
            }
            try {
                boolean bl2 = this.persistenceManager.isActiveTransaction();
                boolean bl3 = this.persistenceManager.isOptimisticTransaction();
                boolean bl4 = this.persistenceManager.isNontransactionalRead();
                if (this.state.needsReload(bl3, bl4, bl2)) {
                    this.reload(null);
                }
                LifeCycleState lifeCycleState = this.state;
                this.state = this.state.transitionReadField(bl3, bl4, bl2);
                this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
                this.registerInstance(false, null, lifeCycleState);
            }
            catch (JDOException jDOException) {
                this.persistenceManager.setFlags(this.persistentObject, by);
                throw jDOException;
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.persistenceManager.releaseShareLock();
            this.releaseLock();
            if (bl) {
                logger.finer("sqlstore.sqlstatemanager.loadforread.exit");
            }
            throw throwable;
        }
        Object var8_4 = null;
        this.persistenceManager.releaseShareLock();
        this.releaseLock();
        if (bl) {
            logger.finer("sqlstore.sqlstatemanager.loadforread.exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadForUpdate() {
        boolean bl = logger.isLoggable(400);
        if (bl) {
            logger.finer("sqlstore.sqlstatemanager.loadforupdate");
        }
        this.persistenceManager.acquireShareLock();
        try {
            this.getLock();
            byte by = this.persistenceManager.getFlags(this.persistentObject);
            if (by == 0) {
                Object var7_3 = null;
                this.persistenceManager.releaseShareLock();
                this.releaseLock();
                if (bl) {
                    logger.finer("sqlstore.sqlstatemanager.loadforupdate.exit");
                }
                return;
            }
            this.persistenceManager.setFlags(this.persistentObject, (byte)0);
            ArrayList arrayList = this.persistenceConfig.fields;
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FieldDesc fieldDesc = (FieldDesc)arrayList.get(i);
                    if (fieldDesc.fetchGroup != 1) continue;
                    this.prepareUpdateField(fieldDesc, null);
                }
            }
            catch (JDOException jDOException) {
                this.persistenceManager.setFlags(this.persistentObject, by);
                throw jDOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.persistenceManager.releaseShareLock();
            this.releaseLock();
            if (bl) {
                logger.finer("sqlstore.sqlstatemanager.loadforupdate.exit");
            }
            throw throwable;
        }
        Object var7_4 = null;
        this.persistenceManager.releaseShareLock();
        this.releaseLock();
        if (bl) {
            logger.finer("sqlstore.sqlstatemanager.loadforupdate.exit");
        }
    }

    public synchronized void replaceCollection(FieldDesc fieldDesc, Collection collection) {
        Collection collection2 = (Collection)fieldDesc.getValue(this);
        SCOCollection sCOCollection = null;
        if (collection2 == null || !(collection2 instanceof SCO)) {
            sCOCollection = (SCOCollection)this.persistenceManager.newCollectionInstanceInternal(fieldDesc.getType(), this.persistentObject, fieldDesc.getName(), fieldDesc.getComponentType(), false, collection != null ? collection.size() : 0);
            fieldDesc.setValue(this, sCOCollection);
            sCOCollection.addAllInternal(collection);
        } else {
            sCOCollection = (SCOCollection)collection2;
            if (sCOCollection.isDeferred()) {
                sCOCollection.applyDeferredUpdates(collection);
                ArrayList arrayList = fieldDesc.getTrackedFields();
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        FieldDesc fieldDesc2 = (FieldDesc)arrayList.get(i);
                        this.setPresenceMaskBit(fieldDesc2.absoluteID);
                    }
                }
            } else {
                sCOCollection.clearInternal();
                sCOCollection.addAllInternal(collection);
            }
        }
        if (collection != null && collection instanceof SCO) {
            ((SCO)((Object)collection)).unsetOwner();
        }
    }

    protected LifeCycleState getCurrentState() {
        return this.state;
    }

    public boolean isDirty() {
        if (this.state != null) {
            return this.state.isDirty();
        }
        return false;
    }

    public boolean isTransactional() {
        if (this.state != null) {
            return this.state.isTransactional();
        }
        return false;
    }

    public boolean isNew() {
        if (this.state != null) {
            return this.state.isNew();
        }
        return false;
    }

    public boolean isDeleted() {
        if (this.state != null) {
            return this.state.isDeleted();
        }
        return false;
    }

    public boolean isPersistent() {
        if (this.state != null) {
            return this.state.isPersistent();
        }
        return false;
    }

    public boolean getBooleanField(int n) {
        this.prepareGetField(n);
        return false;
    }

    public boolean setBooleanField(int n, boolean bl) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Boolean(bl));
        return bl;
    }

    public boolean[] getBooleanArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public boolean[] setBooleanArrayField(int n, boolean[] blArray) {
        this.prepareSetField(n, null);
        return blArray;
    }

    public byte getByteField(int n) {
        this.prepareGetField(n);
        return 0;
    }

    public byte setByteField(int n, byte by) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Byte(by));
        return by;
    }

    public byte[] getByteArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public byte[] setByteArrayField(int n, byte[] byArray) {
        this.prepareSetField(n, null);
        return byArray;
    }

    public short getShortField(int n) {
        this.prepareGetField(n);
        return 0;
    }

    public short setShortField(int n, short s) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Short(s));
        return s;
    }

    public short[] getShortArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public short[] setShortArrayField(int n, short[] sArray) {
        this.prepareSetField(n, null);
        return sArray;
    }

    public int getIntField(int n) {
        this.prepareGetField(n);
        return 0;
    }

    public int setIntField(int n, int n2) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Integer(n2));
        return n2;
    }

    public int[] getIntArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public int[] setIntArrayField(int n, int[] nArray) {
        this.prepareSetField(n, null);
        return nArray;
    }

    public long getLongField(int n) {
        this.prepareGetField(n);
        return 0L;
    }

    public long[] getLongArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public long setLongField(int n, long l) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Long(l));
        return l;
    }

    public long[] setLongArrayField(int n, long[] lArray) {
        this.prepareSetField(n, null);
        return lArray;
    }

    public char getCharField(int n) {
        this.prepareGetField(n);
        return '\u0000';
    }

    public char setCharField(int n, char c) {
        this.assertNotPK(n);
        this.prepareSetField(n, null);
        return c;
    }

    public char[] getCharArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public char setCharArrayField(int n, char c) {
        this.prepareSetField(n, null);
        return c;
    }

    public float getFloatField(int n) {
        this.prepareGetField(n);
        return 0.0f;
    }

    public float setFloatField(int n, float f) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Float(f));
        return f;
    }

    public float[] getFloatArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public float[] setFloatArrayField(int n, float[] fArray) {
        this.prepareSetField(n, null);
        return fArray;
    }

    public double getDoubleField(int n) {
        this.prepareGetField(n);
        return 0.0;
    }

    public double setDoubleField(int n, double d) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)new Double(d));
        return d;
    }

    public double[] getDoubleArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public double[] setDoubleArrayField(int n, double[] dArray) {
        this.prepareSetField(n, null);
        return dArray;
    }

    public String getStringField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public String setStringField(int n, String string) {
        this.assertNotPK(n);
        this.prepareSetField(n, (Object)string);
        return string;
    }

    public String[] getStringArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public String[] setStringArrayField(int n, String[] stringArray) {
        this.prepareSetField(n, null);
        return stringArray;
    }

    public Object getObjectField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public Object setObjectField(int n, Object object) {
        this.assertNotPK(n);
        this.prepareSetField(n, object);
        return object;
    }

    public Object[] getObjectArrayField(int n) {
        this.prepareGetField(n);
        return null;
    }

    public Object[] setObjectArrayField(int n, Object[] objectArray) {
        this.prepareSetField(n, (Object)objectArray);
        return objectArray;
    }

    public boolean testIsLoaded(int n) {
        return this.getPresenceMaskBit(n);
    }

    public boolean testIsLoaded(String string) {
        FieldDesc fieldDesc = this.persistenceConfig.getField(string);
        return this.testIsLoaded(fieldDesc.absoluteID);
    }

    public boolean testIsAutoPersistent() {
        return this.state.isAutoPersistent();
    }

    public void markNotRegistered() {
        this.needsRegisterAtRollback = true;
    }

    public void markVerifyAtDeregister() {
        this.needsVerifyAtDeregister = true;
    }

    public void markReplacement() {
        this.isReplacementInstance = true;
    }

    public void getLock() {
        this.lock.acquire();
    }

    public void releaseLock() {
        this.lock.release();
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid() {
        try {
            this.getLock();
            this.valid = true;
        }
        finally {
            this.releaseLock();
        }
    }
}

