/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SQLObjectInputStream;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public class ResultDesc {
    private ArrayList fields = new ArrayList();
    private ArrayList fnames = new ArrayList();
    private ResultDesc superclassResultDesc;
    private ArrayList subclassResultDescs;
    private ClassDesc config;
    private ForeignFieldDesc parentField;
    private ResultFieldDesc verticalDiscriminator;
    private ResultFieldDesc horizontalDiscriminator;
    private boolean projection = false;
    private ResultFieldDesc fieldProjection = null;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(ResultDesc.class);
    private boolean debug;

    public void addField(FieldDesc fieldDesc, ColumnRef columnRef) {
        this.addField(fieldDesc, columnRef, false);
    }

    public void addField(FieldDesc fieldDesc, ColumnRef columnRef, boolean bl) {
        ResultFieldDesc resultFieldDesc = new ResultFieldDesc(fieldDesc, columnRef);
        resultFieldDesc.setProjection(bl);
        if (bl) {
            this.projection = true;
            this.fieldProjection = resultFieldDesc;
        }
        this.fields.add(resultFieldDesc);
        this.fnames.add(fieldDesc.getName());
        if (fieldDesc.isVerticalDiscriminator()) {
            this.verticalDiscriminator = resultFieldDesc;
        }
        if (fieldDesc.isHorizontalDiscriminator()) {
            this.horizontalDiscriminator = resultFieldDesc;
        }
    }

    public void addField(ResultDesc resultDesc) {
        if (resultDesc != null) {
            this.fields.add(resultDesc);
            this.fnames.add(null);
        }
    }

    public void setSuperclassResultDesc(ResultDesc resultDesc) {
        this.superclassResultDesc = resultDesc;
        this.superclassResultDesc.addSubclassResultDesc(this);
    }

    public ResultDesc getSuperclassResultDesc() {
        return this.superclassResultDesc;
    }

    private void addSubclassResultDesc(ResultDesc resultDesc) {
        if (this.subclassResultDescs == null) {
            this.subclassResultDescs = new ArrayList();
        }
        this.subclassResultDescs.add(resultDesc);
    }

    public void copyFields(ResultDesc resultDesc) {
        ArrayList arrayList = resultDesc.getFields();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            this.fields.add(e);
            if (e instanceof ResultFieldDesc) {
                this.fnames.add(((ResultFieldDesc)e).getFieldDesc().getName());
                continue;
            }
            this.fnames.add(null);
        }
    }

    public ArrayList getFields() {
        return this.fields;
    }

    public void setParentField(ForeignFieldDesc foreignFieldDesc) {
        this.parentField = foreignFieldDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getSerializedObject(ResultSet resultSet, int n, FieldDesc fieldDesc) {
        InputStream inputStream;
        Object object;
        block9: {
            object = null;
            if ((fieldDesc.sqlProperties & 0x80) <= 0) return object;
            inputStream = null;
            inputStream = resultSet.getBinaryStream(n);
            if (inputStream == null) break block9;
            if (this.debug) {
                logger.finest("sqlstore.resultdesc.deserializing", fieldDesc.getName());
            }
            SQLObjectInputStream sQLObjectInputStream = new SQLObjectInputStream(inputStream, fieldDesc.getType().getClassLoader());
            object = sQLObjectInputStream.readObject();
        }
        Object var8_8 = null;
        if (inputStream == null) return object;
        try {
            inputStream.close();
            return object;
        }
        catch (Exception exception) {
            logger.log(500, "sqlstore.exception.log", exception);
        }
        return object;
        {
            catch (Throwable throwable) {
                logger.log(900, "sqlstore.exception.log", throwable);
                Object var8_9 = null;
                if (inputStream == null) return object;
                try {
                    inputStream.close();
                    return object;
                }
                catch (Exception exception) {
                    logger.log(500, "sqlstore.exception.log", exception);
                }
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                logger.log(500, "sqlstore.exception.log", exception);
            }
            throw throwable;
        }
    }

    private Object getConvertedObject(ResultSet resultSet, int n, FieldDesc fieldDesc, StateManager stateManager) {
        int n2 = fieldDesc.getEnumType();
        Object object = null;
        boolean bl = false;
        if ((fieldDesc.sqlProperties & 0x80) > 0) {
            object = this.getSerializedObject(resultSet, n, fieldDesc);
            bl = true;
        } else {
            try {
                switch (n2) {
                    case 1: 
                    case 11: {
                        boolean bl2 = resultSet.getBoolean(n);
                        if (!resultSet.wasNull()) {
                            object = new Boolean(bl2);
                        }
                        bl = true;
                        break;
                    }
                    case 3: 
                    case 13: {
                        byte by = resultSet.getByte(n);
                        if (!resultSet.wasNull()) {
                            object = new Byte(by);
                        }
                        bl = true;
                        break;
                    }
                    case 8: 
                    case 18: {
                        double d = resultSet.getDouble(n);
                        if (!resultSet.wasNull()) {
                            object = new Double(d);
                        }
                        bl = true;
                        break;
                    }
                    case 7: 
                    case 17: {
                        float f = resultSet.getFloat(n);
                        if (!resultSet.wasNull()) {
                            object = new Float(f);
                        }
                        bl = true;
                        break;
                    }
                    case 5: 
                    case 15: {
                        int n3 = resultSet.getInt(n);
                        if (!resultSet.wasNull()) {
                            object = new Integer(n3);
                        }
                        bl = true;
                        break;
                    }
                    case 6: 
                    case 16: {
                        long l = resultSet.getLong(n);
                        if (!resultSet.wasNull()) {
                            object = new Long(l);
                        }
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 14: {
                        short s = resultSet.getShort(n);
                        if (!resultSet.wasNull()) {
                            object = new Short(s);
                        }
                        bl = true;
                        break;
                    }
                    case 21: {
                        object = resultSet.getString(n);
                        bl = true;
                        break;
                    }
                    case 2: 
                    case 12: {
                        String string = resultSet.getString(n);
                        if (string != null) {
                            object = FieldDesc.getCharFromString(string);
                        }
                        bl = true;
                        break;
                    }
                    case 19: 
                    case 20: {
                        object = resultSet.getBigDecimal(n);
                        if (n2 == 20 && object != null) {
                            object = ((BigDecimal)object).toBigInteger();
                        }
                        bl = true;
                        break;
                    }
                    case 51: {
                        InputStream inputStream = resultSet.getBinaryStream(n);
                        object = this.readInputStreamToByteArray(inputStream);
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                try {
                    object = fieldDesc.convertValue(resultSet.getObject(n), stateManager);
                }
                catch (SQLException sQLException) {
                    logger.log(900, "sqlstore.exception.log", sQLException);
                }
            }
        }
        return object;
    }

    private byte[] readInputStreamToByteArray(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[2000];
            int n = 0;
            try {
                while ((n = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                logger.log(900, "sqlstore.exception.log", iOException);
                throw iOException;
            }
        }
        return byArray;
    }

    private Object getObject(ResultSet resultSet, int n, FieldDesc fieldDesc) {
        Object object = null;
        if ((fieldDesc.sqlProperties & 0x80) > 0) {
            object = this.getSerializedObject(resultSet, n, fieldDesc);
        } else {
            try {
                object = resultSet.getObject(n);
            }
            catch (SQLException sQLException) {
                logger.log(900, "sqlstore.exception.log", sQLException);
            }
        }
        return object;
    }

    private ResultDesc getDiscriminatingSubclassResultDesc(ResultSet resultSet) {
        int n = this.subclassResultDescs.size();
        for (int i = 0; i < n; ++i) {
            ResultDesc resultDesc = (ResultDesc)this.subclassResultDescs.get(i);
            ResultDesc resultDesc2 = null;
            ResultFieldDesc resultFieldDesc = resultDesc.horizontalDiscriminator;
            ResultFieldDesc resultFieldDesc2 = resultDesc.verticalDiscriminator;
            int n2 = -1;
            int n3 = -1;
            if (resultFieldDesc2 != null) {
                n3 = this.getObject(resultSet, resultFieldDesc2.getColumnRef().getIndex(), resultFieldDesc2.getFieldDesc()) == null ? 0 : 1;
            }
            if (resultFieldDesc != null) {
                LocalFieldDesc localFieldDesc = (LocalFieldDesc)resultFieldDesc.getFieldDesc();
                Object object = localFieldDesc.getDiscriminatorValue();
                Object object2 = this.getObject(resultSet, resultFieldDesc.getColumnRef().getIndex(), localFieldDesc);
                if (this.debug) {
                    Object[] objectArray = new Object[]{object, object2};
                    logger.finest("sqlstore.resultdesc.dvalue", objectArray);
                }
                n2 = object2 != null && object != null && object.toString().compareTo(object2.toString()) == 0 || object2 == null && object == null ? 1 : 0;
            }
            if (n2 == -1 && n3 == -1) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.resultdesc.nodiscriminators"));
            }
            if (n2 == 1) {
                if (n3 != 0) {
                    return resultDesc;
                }
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "sqlstore.resultdesc.inconsistentmatch"));
            }
            if (n3 == 0) continue;
            if (resultDesc.subclassResultDescs != null && (resultDesc2 = resultDesc.getDiscriminatingResultDesc(resultSet)) != null) {
                return resultDesc2;
            }
            if (n3 != 1 || n2 == 0) continue;
            return resultDesc;
        }
        return null;
    }

    private ResultDesc getDiscriminatingResultDesc(ResultSet resultSet) {
        ResultDesc resultDesc = null;
        if (this.horizontalDiscriminator != null) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)this.horizontalDiscriminator.getFieldDesc();
            Object object = localFieldDesc.getDiscriminatorValue();
            Object object2 = this.getObject(resultSet, this.horizontalDiscriminator.getColumnRef().getIndex(), localFieldDesc);
            if (this.debug) {
                Object[] objectArray = new Object[]{object, object2};
                logger.finest("sqlstore.resultdesc.dvalue", objectArray);
            }
            if (object2 != null && object != null && object.toString().compareTo(object2.toString()) == 0 || object2 == null && object == null) {
                resultDesc = this;
            } else if (this.subclassResultDescs != null) {
                resultDesc = this.getDiscriminatingSubclassResultDesc(resultSet);
            }
        } else {
            if (this.subclassResultDescs != null) {
                resultDesc = this.getDiscriminatingSubclassResultDesc(resultSet);
            }
            if (resultDesc == null) {
                resultDesc = this;
            }
        }
        return resultDesc;
    }

    public void getResult(PersistenceManager persistenceManager, Collection collection, ResultSet resultSet, int n) throws SQLException {
        this.debug = logger.isLoggable(300);
        int n2 = 0;
        while (n2 < n && resultSet.next()) {
            ResultDesc resultDesc = this.getDiscriminatingResultDesc(resultSet);
            if (resultDesc == null) continue;
            collection.add(resultDesc.setFields(persistenceManager, resultSet, null, null));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setFields(PersistenceManager persistenceManager, ResultSet resultSet, Object object, StateManager stateManager) {
        Object object2 = null;
        ArrayList<ResultDesc> arrayList = new ArrayList<ResultDesc>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<StateManager> arrayList3 = new ArrayList<StateManager>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<FieldDesc> arrayList6 = new ArrayList<FieldDesc>();
        ArrayList<StateManager> arrayList7 = new ArrayList<StateManager>();
        Object object3 = this;
        Object object4 = object;
        StateManager stateManager2 = stateManager;
        StateManager stateManager3 = null;
        Boolean bl = Boolean.FALSE;
        Integer n = new Integer(0);
        FieldDesc fieldDesc = null;
        try {
            ResultFieldDesc resultFieldDesc;
            if (stateManager2 != null) {
                stateManager2.getLock();
            }
            while (object3 != null) {
                int n2;
                Object object5;
                int n3;
                if (((ResultDesc)object3).fieldProjection != null && !persistenceManager.isOptimisticTransaction()) {
                    resultFieldDesc = ((ResultDesc)object3).fieldProjection;
                    FieldDesc fieldDesc2 = resultFieldDesc.getFieldDesc();
                    if (this.debug) {
                        logger.finest("sqlstore.resultdesc.returning_field", fieldDesc2.getName());
                    }
                    n3 = resultFieldDesc.getColumnRef().getIndex();
                    object2 = this.getConvertedObject(resultSet, n3, fieldDesc2, null);
                    break;
                }
                if (object4 == null) {
                    stateManager2 = this.findOrCreateStateManager((ResultDesc)object3, resultSet, persistenceManager);
                    if (stateManager2 == null) {
                        bl = Boolean.TRUE;
                    } else {
                        object4 = stateManager2.getPersistent();
                        stateManager2.getLock();
                    }
                }
                if (((ResultDesc)object3).getSuperclassResultDesc() != null && (object5 = ((ResultDesc)object3).getSuperclassResultDesc().setFields(persistenceManager, resultSet, object4, stateManager2)) != object) {
                    object4 = object5;
                    if (stateManager2 != null) {
                        stateManager2.releaseLock();
                    }
                    stateManager2 = persistenceManager.getStateManager(object4);
                    stateManager2.getLock();
                }
                if (((ResultDesc)object3).fieldProjection != null) {
                    ResultFieldDesc resultFieldDesc2 = ((ResultDesc)object3).fieldProjection;
                    FieldDesc fieldDesc3 = resultFieldDesc2.getFieldDesc();
                    if (stateManager2.getPresenceMaskBit(fieldDesc3.absoluteID)) {
                        object2 = fieldDesc3.getValue(stateManager2);
                        if (object2 instanceof SCODate) {
                            object2 = fieldDesc3.convertValue(object2, null);
                        }
                    } else {
                        n3 = resultFieldDesc2.getColumnRef().getIndex();
                        object2 = this.getConvertedObject(resultSet, n3, fieldDesc3, null);
                    }
                    if (!this.debug) break;
                    logger.finest("sqlstore.resultdesc.returning_field", fieldDesc3.getName());
                    break;
                }
                int n4 = ((ResultDesc)object3).getFields().size();
                int n5 = n;
                n3 = n5 >= n4 ? 1 : 0;
                for (n2 = n5; n2 < n4; ++n2) {
                    Object object6;
                    Object object7;
                    Object e = ((ResultDesc)object3).getFields().get(n2);
                    if (e instanceof ResultFieldDesc) {
                        int n6 = n3 = n4 == n2 + 1 ? 1 : 0;
                        if (bl.booleanValue()) continue;
                        object7 = (ResultFieldDesc)e;
                        object6 = ((ResultFieldDesc)object7).getFieldDesc();
                        if (stateManager2.getPresenceMaskBit(((FieldDesc)object6).absoluteID)) continue;
                        int n7 = ((ResultFieldDesc)object7).getColumnRef().getIndex();
                        Object object8 = this.getConvertedObject(resultSet, n7, (FieldDesc)object6, stateManager2);
                        ((FieldDesc)object6).setValue(stateManager2, object8);
                        if (this.debug) {
                            logger.finest("sqlstore.resultdesc.marking_field", ((FieldDesc)object6).getName());
                        }
                        stateManager2.setPresenceMaskBit(((FieldDesc)object6).absoluteID);
                        continue;
                    }
                    object7 = (ResultDesc)e;
                    object6 = ((ResultDesc)object7).getDiscriminatingResultDesc(resultSet);
                    if (object6 == null) {
                        object6 = object7;
                    } else {
                        ((ResultDesc)object6).setProjection(((ResultDesc)object7).isProjection());
                        ((ResultDesc)object6).setClassDesc(((ResultDesc)object7).getClassDesc());
                    }
                    arrayList.add((ResultDesc)object3);
                    arrayList2.add(object4);
                    arrayList3.add(stateManager2);
                    arrayList4.add(bl);
                    arrayList5.add(new Integer(n2 + 1));
                    arrayList6.add(fieldDesc);
                    arrayList7.add(stateManager3);
                    object3 = object6;
                    object4 = null;
                    stateManager3 = stateManager2;
                    if (stateManager2 != null) {
                        stateManager2.releaseLock();
                    }
                    stateManager2 = null;
                    bl = Boolean.FALSE;
                    n = new Integer(0);
                    fieldDesc = ((ResultDesc)object7).parentField;
                    break;
                }
                if (n3 == 0) continue;
                if (!bl.booleanValue()) {
                    stateManager2.initialize(true);
                    object2 = object4;
                }
                if (((ResultDesc)object3).isProjection()) {
                    Object object9 = object2;
                    return object9;
                }
                if (fieldDesc != null) {
                    fieldDesc.setValue(stateManager3, object2);
                    if (this.debug) {
                        logger.finest("sqlstore.resultdesc.marking_foreign_field", fieldDesc.getName());
                    }
                    stateManager3.setPresenceMaskBit(((ForeignFieldDesc)fieldDesc).absoluteID);
                }
                if ((n2 = arrayList.size() - 1) >= 0) {
                    object3 = (ResultDesc)arrayList.remove(n2);
                    object4 = arrayList2.remove(n2);
                    if (stateManager2 != null) {
                        stateManager2.releaseLock();
                    }
                    if ((stateManager2 = (StateManager)arrayList3.remove(n2)) != null) {
                        stateManager2.getLock();
                    }
                    bl = (Boolean)arrayList4.remove(n2);
                    n = (Integer)arrayList5.remove(n2);
                    fieldDesc = (ForeignFieldDesc)arrayList6.remove(n2);
                    stateManager3 = (StateManager)arrayList7.remove(n2);
                    continue;
                }
                object3 = null;
            }
            resultFieldDesc = object2;
            return resultFieldDesc;
        }
        finally {
            if (stateManager2 != null) {
                stateManager2.releaseLock();
            }
        }
    }

    public boolean isProjection() {
        return this.projection;
    }

    public void setProjection(boolean bl) {
        this.projection = bl;
    }

    public void setClassDesc(ClassDesc classDesc) {
        this.config = classDesc;
    }

    public ClassDesc getClassDesc() {
        return this.config;
    }

    private StateManager findOrCreateStateManager(ResultDesc resultDesc, ResultSet resultSet, PersistenceManager persistenceManager) {
        try {
            Class clazz = resultDesc.config.getOidClass();
            Object t = clazz.newInstance();
            Field[] fieldArray = resultDesc.config.getKeyFields();
            String[] stringArray = resultDesc.config.getKeyFieldNames();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string = stringArray[i];
                FieldDesc fieldDesc = resultDesc.config.getField(string);
                int n = resultDesc.fnames.indexOf(string);
                ResultFieldDesc resultFieldDesc = (ResultFieldDesc)resultDesc.getFields().get(n);
                int n2 = resultFieldDesc.getColumnRef().getIndex();
                Object object = this.getConvertedObject(resultSet, n2, fieldDesc, null);
                if (this.debug) {
                    logger.finest("sqlstore.resultdesc.marking_key_field", string);
                }
                if (object == null) {
                    return null;
                }
                field.set(t, object);
            }
            return persistenceManager.findOrCreateStateManager(t, resultDesc.config.getPersistenceCapableClass());
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(exception.getMessage());
        }
    }
}

