/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceWrapper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Enumeration;
import java.util.Hashtable;

public class CacheManager {
    private static int DEFAULT_CACHE_SIZE = 1000;
    private static int CLEAN_CACHE_SIZE = 500;
    private static final int IN_USE = 1;
    private static final int NOT_IN_USE = 2;
    private static final int DELETED = 3;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private CachedInstancePolicy instancePolicy = new CachedInstancePolicy();
    private Hashtable cacheTable = new Hashtable();

    public int getCacheSize() {
        logger.finest("sqlstore.cachemanager.getcachesize");
        return DEFAULT_CACHE_SIZE;
    }

    public int setCacheSize(int n) {
        logger.finest("sqlstore.cachemanager.setcachesize");
        int n2 = DEFAULT_CACHE_SIZE;
        DEFAULT_CACHE_SIZE = n;
        return n2;
    }

    public int getCleanSize() {
        logger.finest("sqlstore.cachemanager.getcleansize");
        return CLEAN_CACHE_SIZE;
    }

    public int setCleanSize(int n) {
        logger.finest("sqlstore.cachemanager.setcleansize");
        int n2 = CLEAN_CACHE_SIZE;
        CLEAN_CACHE_SIZE = n;
        return n2;
    }

    public void setInstancePolicy(CachedInstancePolicy cachedInstancePolicy) {
        logger.finest("sqlstore.cachemanager.setinstancepolicy");
        this.instancePolicy = cachedInstancePolicy;
    }

    public CachedInstancePolicy getInstancePolicy() {
        logger.finest("sqlstore.cachemanager.getinstancepolicy");
        return this.instancePolicy;
    }

    public boolean checkInstance(Object object) {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.cachemanager.checkinstance", new Boolean(this.cacheTable.containsKey(object)));
        }
        return this.cacheTable.containsKey(object);
    }

    public Object getInstance(Object object) {
        boolean bl = logger.isLoggable(300);
        PersistenceWrapper persistenceWrapper = (PersistenceWrapper)this.cacheTable.get(object);
        if (bl) {
            logger.finest("sqlstore.cachemanager.getinstance.tempobj", persistenceWrapper);
        }
        if (persistenceWrapper == null) {
            return null;
        }
        return null;
    }

    public void saveInstance(Object object, Object object2) {
        logger.finest("sqlstore.cachemanager.saveinstance");
        Object var3_3 = null;
    }

    public void invalidate(Object object) {
        logger.finest("sqlstore.cachemanager.invalidate");
        logger.finest("sqlstore.cachemanager.invalidate.end");
    }

    public synchronized void cleanCache() {
        logger.finest("sqlstore.cachemanager.cleancache");
        int n = this.cacheTable.size();
        if (n < DEFAULT_CACHE_SIZE) {
            return;
        }
        Enumeration enumeration = this.cacheTable.keys();
    }

    public class CachedInstancePolicy {
        public Object merge(Object object, Object object2) {
            logger.finest("sqlstore.cachemanager.cachedinstancepolicy.merge");
            return object;
        }

        public void invalidate(Object object) {
            logger.finest("sqlstore.cachemanager.cachedinstancepolicy.invalidate");
            logger.finest("sqlstore.cachemanager.cachedinstancepolicy.invalidate.ok");
        }
    }
}

