/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

public class TypeSupport {
    public static final Object errorType = "error";
    public static final Object booleanType = "boolean";
    public static final Object byteType = "byte";
    public static final Object shortType = "short";
    public static final Object charType = "char";
    public static final Object intType = "int";
    public static final Object longType = "long";
    public static final Object floatType = "float";
    public static final Object doubleType = "double";
    public static final Object booleanClassType = "java.lang.Boolean";
    public static final Object byteClassType = "java.lang.Byte";
    public static final Object shortClassType = "java.lang.Short";
    public static final Object characterClassType = "java.lang.Char";
    public static final Object integerClassType = "java.lang.Integer";
    public static final Object longClassType = "java.lang.Long";
    public static final Object floatClassType = "java.lang.Float";
    public static final Object doubleClassType = "java.lang.Double";
    public static final Object stringType = "java.lang.String";
    protected static Set numericTypes = new HashSet();
    protected static Set numericWrapperTypes = new HashSet();
    protected static Set dateTimeTypes = new HashSet();
    protected Model model;
    protected NameMapper nameMapper;
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(TypeSupport.class);

    public TypeSupport(Model model, NameMapper nameMapper) {
        this.model = model;
        this.nameMapper = nameMapper;
    }

    public Object getTypeInfo(String string) {
        return string;
    }

    public Object getTypeInfo(Class clazz) {
        return this.getTypeInfo(clazz.getName());
    }

    public static boolean isErrorType(Object object) {
        return object.equals(errorType);
    }

    public static boolean isBooleanType(Object object) {
        return object.equals(booleanType) || object.equals(booleanClassType);
    }

    public static boolean isCharType(Object object) {
        return object.equals(charType) || object.equals(characterClassType);
    }

    public static boolean isIntType(Object object) {
        return object.equals(intType) || object.equals(integerClassType);
    }

    public static boolean isDoubleType(Object object) {
        return object.equals(doubleType) || object.equals(doubleClassType);
    }

    public static boolean isNumericType(Object object) {
        return numericTypes.contains(object);
    }

    public static boolean isNumericWrapperType(Object object) {
        return numericWrapperTypes.contains(object);
    }

    public static boolean isNumberType(Object object) {
        return TypeSupport.isNumericType(object) || TypeSupport.isNumericWrapperType(object);
    }

    public static boolean isStringType(Object object) {
        return object.equals(stringType);
    }

    public boolean isCollectionType(Object object) {
        return this.model.isCollection((String)object);
    }

    public boolean isDateTimeType(Object object) {
        return dateTimeTypes.contains(TypeSupport.getTypeName(object));
    }

    public static Object getPrimitiveType(Object object) {
        Object object2 = errorType;
        if (object.equals(booleanClassType)) {
            object2 = booleanType;
        } else if (object.equals(integerClassType)) {
            object2 = intType;
        } else if (object.equals(longClassType)) {
            object2 = longType;
        } else if (object.equals(floatClassType)) {
            object2 = floatType;
        } else if (object.equals(doubleClassType)) {
            object2 = doubleType;
        } else if (object.equals(byteClassType)) {
            object2 = byteType;
        } else if (object.equals(shortClassType)) {
            object2 = shortType;
        } else if (object.equals(characterClassType)) {
            object2 = charType;
        }
        return object2;
    }

    public static Object getWrapperType(Object object) {
        Object object2 = errorType;
        if (object.equals(booleanType)) {
            object2 = booleanClassType;
        } else if (object.equals(intType)) {
            object2 = integerClassType;
        } else if (object.equals(longType)) {
            object2 = longClassType;
        } else if (object.equals(floatType)) {
            object2 = floatClassType;
        } else if (object.equals(doubleType)) {
            object2 = doubleClassType;
        } else if (object.equals(byteType)) {
            object2 = byteClassType;
        } else if (object.equals(shortType)) {
            object2 = shortClassType;
        } else if (object.equals(charType)) {
            object2 = characterClassType;
        }
        return object2;
    }

    public static Object binaryNumericPromotion(Object object, Object object2) {
        if (TypeSupport.isNumericType(object) && TypeSupport.isNumericType(object2)) {
            if (object.equals(doubleType) || object2.equals(doubleType)) {
                return doubleType;
            }
            if (object.equals(floatType) || object2.equals(floatType)) {
                return floatType;
            }
            if (object.equals(longType) || object2.equals(longType)) {
                return longType;
            }
            return intType;
        }
        return errorType;
    }

    public static Object unaryNumericPromotion(Object object) {
        if (TypeSupport.isNumericType(object)) {
            if (object.equals(byteType) || object.equals(shortType) || object.equals(charType)) {
                return intType;
            }
            return object;
        }
        return errorType;
    }

    public boolean isCompatibleWith(Object object, Object object2) {
        String string = TypeSupport.getTypeName(object);
        String string2 = TypeSupport.getTypeName(object2);
        if (this.nameMapper.isLocalInterface(string) && this.nameMapper.isEjbName(string2)) {
            string2 = this.nameMapper.getLocalInterfaceForEjbName(string2);
        } else if (this.nameMapper.isRemoteInterface(string) && this.nameMapper.isEjbName(string2)) {
            string2 = this.nameMapper.getRemoteInterfaceForEjbName(string2);
        } else if (this.nameMapper.isLocalInterface(string2) && this.nameMapper.isEjbName(string)) {
            string = this.nameMapper.getLocalInterfaceForEjbName(string);
        } else if (this.nameMapper.isRemoteInterface(string2) && this.nameMapper.isEjbName(string)) {
            string = this.nameMapper.getRemoteInterfaceForEjbName(string);
        }
        return string.equals(string2);
    }

    public static String getTypeName(Object object) {
        return (String)object;
    }

    public Object getTypeInfoForAbstractSchema(String string) {
        return this.nameMapper.getEjbNameForAbstractSchema(string);
    }

    public String getAbstractSchemaForTypeInfo(Object object) {
        String string = TypeSupport.getTypeName(object);
        return this.nameMapper.isEjbName(string) ? this.nameMapper.getAbstractSchemaForEjbName(string) : string;
    }

    public Object getFieldType(Object object, String string) {
        String string2;
        String string3 = TypeSupport.getTypeName(object);
        if (!this.nameMapper.isEjbName(string3)) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_EjbNameExpected", "TypeSupport.getFieldType", string3));
        }
        if (this.nameMapper.isLocalInterface(string2 = this.model.getFieldType(string3, string))) {
            string2 = this.nameMapper.getEjbNameForLocalInterface(string3, string, string2);
        } else if (this.nameMapper.isRemoteInterface(string2)) {
            string2 = this.nameMapper.getEjbNameForRemoteInterface(string3, string, string2);
        }
        return this.getTypeInfo(string2);
    }

    public Object getFieldInfo(Object object, String string) {
        PersistenceFieldElement persistenceFieldElement = null;
        String string2 = TypeSupport.getTypeName(object);
        if (!this.nameMapper.isEjbName(string2)) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR__EjbNameExpected", "TypeSupport.getFieldInfo", string2));
        }
        String string3 = this.nameMapper.getPersistenceClassForEjbName(string2);
        String string4 = this.nameMapper.getPersistenceFieldForEjbField(string2, string);
        PersistenceClassElement persistenceClassElement = this.model.getPersistenceClass(string3);
        if (persistenceClassElement != null) {
            persistenceFieldElement = persistenceClassElement.getField(string4);
        }
        return persistenceFieldElement;
    }

    public boolean isRelationship(Object object) {
        return object != null && object instanceof RelationshipElement;
    }

    public Object getElementType(Object object) {
        if (object != null && object instanceof RelationshipElement) {
            String string = ((RelationshipElement)object).getElementClass();
            return this.nameMapper.getEjbNameForPersistenceClass(string);
        }
        return null;
    }

    public String getPCForTypeInfo(Object object) {
        String string = TypeSupport.getTypeName(object);
        String string2 = this.nameMapper.getPersistenceClassForEjbName(string);
        return string2 != null ? string2 : string;
    }

    public boolean isEjbName(Object object) {
        return this.nameMapper.isEjbName(TypeSupport.getTypeName(object));
    }

    public boolean isEjbOrInterfaceName(Object object) {
        String string = TypeSupport.getTypeName(object);
        return this.nameMapper.isEjbName(string) || this.nameMapper.isLocalInterface(string) || this.nameMapper.isRemoteInterface(string);
    }

    public boolean isRemoteInterfaceOfEjb(Object object, String string) {
        String string2 = TypeSupport.getTypeName(object);
        String string3 = this.nameMapper.getRemoteInterfaceForEjbName(string);
        return string3 != null && string3.equals(string2);
    }

    public boolean isLocalInterfaceOfEjb(Object object, String string) {
        String string2 = TypeSupport.getTypeName(object);
        String string3 = this.nameMapper.getLocalInterfaceForEjbName(string);
        return string3 != null && string3.equals(string2);
    }

    public boolean isRemoteInterface(Object object) {
        return this.nameMapper.isRemoteInterface(TypeSupport.getTypeName(object));
    }

    public boolean isLocalInterface(Object object) {
        return this.nameMapper.isLocalInterface(TypeSupport.getTypeName(object));
    }

    public boolean hasRemoteInterface(Object object) {
        return this.nameMapper.getRemoteInterfaceForEjbName(TypeSupport.getTypeName(object)) != null;
    }

    public boolean hasLocalInterface(Object object) {
        return this.nameMapper.getLocalInterfaceForEjbName(TypeSupport.getTypeName(object)) != null;
    }

    static {
        numericTypes.add(byteType);
        numericTypes.add(shortType);
        numericTypes.add(charType);
        numericTypes.add(intType);
        numericTypes.add(longType);
        numericTypes.add(floatType);
        numericTypes.add(doubleType);
        numericWrapperTypes.add(byteClassType);
        numericWrapperTypes.add(shortClassType);
        numericWrapperTypes.add(characterClassType);
        numericWrapperTypes.add(integerClassType);
        numericWrapperTypes.add(longClassType);
        numericWrapperTypes.add(floatClassType);
        numericWrapperTypes.add(doubleClassType);
        dateTimeTypes.add("java.util.Date");
        dateTimeTypes.add("java.sql.Date");
        dateTimeTypes.add("java.sql.Time");
        dateTimeTypes.add("java.sql.Timestamp");
    }
}

