/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import antlr.ANTLRException;
import antlr.TokenBuffer;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLAST;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLASTFactory;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLLexer;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLParser;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLCodeGeneration;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLElements;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.LogHelperQueryCompilerEJB;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ParameterSupport;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.Semantic;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.TypeSupport;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ResourceBundle;

public class EJBQLC {
    protected Model model;
    protected NameMapper nameMapper;
    protected EJBQLAST ast;
    private static Logger logger = LogHelperQueryCompilerEJB.getLogger();
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(EJBQLC.class);
    public static final String SIGNATURE = "$RCSfile: EJBQLC.java,v $ $Revision: 1.1.4.6.12.1 $";

    public EJBQLC(Model model, NameMapper nameMapper) {
        this.model = model;
        this.nameMapper = nameMapper;
    }

    public JDOQLElements compile(String string, Method method, int n, boolean bl, String string2) throws EJBQLException {
        boolean bl2 = logger.isLoggable(400);
        boolean bl3 = logger.isLoggable(300);
        if (bl2) {
            logger.finer("LOG_EJBQLCCompile", string2, this.getMethodSignature(method), string);
        }
        JDOQLElements jDOQLElements = null;
        TypeSupport typeSupport = new TypeSupport(this.model, this.nameMapper);
        ParameterSupport parameterSupport = new ParameterSupport(method);
        String string3 = null;
        try {
            string3 = "syntax analysis";
            if (bl2) {
                logger.finer("LOG_EJBQLCStartPass", string3);
            }
            EJBQLParser eJBQLParser = this.createStringParser(string);
            eJBQLParser.query();
            this.ast = (EJBQLAST)eJBQLParser.getAST();
            if (bl3) {
                logger.finest("LOG_EJBQLCDumpTree", this.ast.getTreeRepr("(AST)"));
            }
            string3 = "semantic analysis";
            if (bl2) {
                logger.finer("LOG_EJBQLCStartPass", string3);
            }
            Semantic semantic = new Semantic();
            semantic.init(typeSupport, parameterSupport, method, n, bl, string2);
            semantic.setASTFactory(EJBQLASTFactory.getInstance());
            semantic.query(this.ast);
            this.ast = (EJBQLAST)semantic.getAST();
            if (bl3) {
                logger.finest("LOG_EJBQLCDumpTree", this.ast.getTreeRepr("(typed AST)"));
            }
            string3 = "code generation";
            if (bl2) {
                logger.finer("LOG_EJBQLCStartPass", string3);
            }
            JDOQLCodeGeneration jDOQLCodeGeneration = new JDOQLCodeGeneration();
            jDOQLCodeGeneration.init(typeSupport, parameterSupport);
            jDOQLCodeGeneration.setASTFactory(EJBQLASTFactory.getInstance());
            jDOQLCodeGeneration.query(this.ast);
            jDOQLElements = jDOQLCodeGeneration.getJDOQLElements();
            if (bl2) {
                logger.finer("LOG_EJBQLCResult", jDOQLElements.toString());
            }
        }
        catch (EJBQLException eJBQLException) {
            Object[] objectArray = new Object[]{string2, this.getMethodSignature(method), string, eJBQLException.getMessage()};
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidEJBQLQuery", objectArray), eJBQLException.getCause());
        }
        catch (ANTLRException aNTLRException) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_UnexpectedException", string3), aNTLRException);
        }
        return jDOQLElements;
    }

    private EJBQLParser createStringParser(String string) {
        StringReader stringReader = new StringReader(string);
        EJBQLLexer eJBQLLexer = new EJBQLLexer(stringReader);
        eJBQLLexer.setTokenObjectClass("com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLLexer$EJBQLToken");
        TokenBuffer tokenBuffer = new TokenBuffer(eJBQLLexer);
        EJBQLParser eJBQLParser = new EJBQLParser(tokenBuffer);
        eJBQLParser.setASTFactory(EJBQLASTFactory.getInstance());
        return eJBQLParser;
    }

    private String getMethodSignature(Method method) {
        if (method == null) {
            return "";
        }
        return method.getReturnType().getName() + ' ' + method.getName() + "(" + JavaClassWriterHelper.getParameterTypesList(method) + ")";
    }
}

