/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support.util;

import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class AugmentationTest {
    static boolean debug = false;
    static final PrintStream out = System.out;
    public final int AFFIRMATIVE = 1;
    public final int NEGATIVE = 0;
    public final int ERROR = -1;
    boolean verbose;
    boolean requirePC;
    List classes;
    String className;
    Class classClass;
    private static final String[] transientPrefixes = new String[]{"java.", "javax.", "com.sun.jdo."};

    static final void affirm(boolean bl) {
        if (debug && !bl) {
            throw new RuntimeException("affirmion failed.");
        }
    }

    static final void affirm(Object object) {
        if (debug && object == null) {
            throw new RuntimeException("affirmion failed: obj = null");
        }
    }

    static String toString(int n, Class clazz, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(n));
        stringBuffer.append(" ");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static String toString(int n, String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(n));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("(");
        int n2 = classArray.length - 1;
        for (int i = 0; i <= n2; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= n2) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String toString(int n, Class clazz, String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(n));
        stringBuffer.append(" ");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("(");
        int n2 = classArray.length - 1;
        for (int i = 0; i <= n2; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= n2) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    final void println() {
        out.println();
    }

    final void println(String string) {
        out.println(string);
    }

    final void verbose() {
        if (this.verbose) {
            out.println();
        }
    }

    final void verbose(String string) {
        if (this.verbose) {
            out.println(string);
        }
    }

    public int testLoadingClass() {
        this.verbose();
        this.verbose("Test loading class: " + this.className + " ...");
        try {
            this.classClass = Class.forName(this.className);
            this.verbose("+++ loaded class");
            return 1;
        }
        catch (LinkageError linkageError) {
            this.println("!!! ERROR: linkage error when loading class: " + this.className);
            this.println("    error: " + linkageError);
            this.println("!!! failed loading class");
            return -1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.println("!!! ERROR: class not found: " + this.className);
            this.println("    exception: " + classNotFoundException);
            this.println("!!! failed loading class");
            return -1;
        }
    }

    int implementsInterface(Class clazz) {
        Class<?>[] classArray = this.classClass.getInterfaces();
        for (int i = classArray.length - 1; i >= 0; --i) {
            if (!classArray[i].equals(clazz)) continue;
            this.verbose("+++ implements interface: " + clazz.getName());
            return 1;
        }
        this.verbose("--- not implementing interface: " + clazz.getName());
        return 0;
    }

    int hasField(int n, Class clazz, String string) {
        try {
            Field field = this.classClass.getField(string);
            if (field.getModifiers() != n || !field.getType().equals(clazz)) {
                this.println("!!! ERROR: field declaration: ");
                this.println("    expected: " + AugmentationTest.toString(n, clazz, string));
                this.println("    found:    " + field.toString());
                return -1;
            }
            this.verbose("+++ has field: " + field.toString());
            return 1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.verbose("--- no field: " + AugmentationTest.toString(n, clazz, string));
            return 0;
        }
    }

    int hasConstructor(int n, Class[] classArray) {
        try {
            Constructor constructor = this.classClass.getConstructor(classArray);
            if (constructor.getModifiers() != n) {
                this.println("!!! ERROR: constructor declaration: ");
                this.println("    expected: " + AugmentationTest.toString(n, this.className, classArray));
                this.println("    found:    " + constructor.toString());
                return -1;
            }
            this.verbose("+++ has constructor: " + constructor.toString());
            return 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.verbose("--- no constructor: " + AugmentationTest.toString(n, this.className, classArray));
            return 0;
        }
    }

    int hasMethod(int n, Class clazz, String string, Class[] classArray) {
        try {
            Method method = this.classClass.getMethod(string, classArray);
            if (method.getModifiers() != n || !method.getReturnType().equals(clazz)) {
                this.println("!!! ERROR: method declaration: ");
                this.println("    expected: " + AugmentationTest.toString(n, clazz, string, classArray));
                this.println("    found:    " + method.toString());
                return -1;
            }
            this.verbose("+++ has method: " + method.toString());
            return 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.verbose("--- no method: " + AugmentationTest.toString(n, clazz, string, classArray));
            return 0;
        }
    }

    public int hasGenericAugmentation() {
        AugmentationTest.affirm(true);
        this.verbose();
        this.verbose("Check for \"generic\" augmentation ...");
        AugmentationTest.affirm(this.classClass);
        int[] nArray = new int[15];
        int n = 0;
        nArray[n++] = this.implementsInterface(PersistenceCapable.class);
        nArray[n++] = this.hasField(129, StateManager.class, "jdoStateManager");
        nArray[n++] = this.hasField(129, Byte.TYPE, "jdoFlags");
        nArray[n++] = this.hasMethod(17, StateManager.class, "jdoGetStateManager", new Class[0]);
        nArray[n++] = this.hasMethod(17, Void.TYPE, "jdoSetStateManager", new Class[]{StateManager.class});
        nArray[n++] = this.hasMethod(17, Byte.TYPE, "jdoGetFlags", new Class[0]);
        nArray[n++] = this.hasMethod(17, Void.TYPE, "jdoSetFlags", new Class[]{Byte.TYPE});
        nArray[n++] = this.hasMethod(17, PersistenceManager.class, "jdoGetPersistenceManager", new Class[0]);
        nArray[n++] = this.hasMethod(17, Object.class, "jdoGetObjectId", new Class[0]);
        nArray[n++] = this.hasMethod(17, Boolean.TYPE, "jdoIsDirty", new Class[0]);
        nArray[n++] = this.hasMethod(17, Boolean.TYPE, "jdoIsTransactional", new Class[0]);
        nArray[n++] = this.hasMethod(17, Boolean.TYPE, "jdoIsPersistent", new Class[0]);
        nArray[n++] = this.hasMethod(17, Boolean.TYPE, "jdoIsNew", new Class[0]);
        nArray[n++] = this.hasMethod(17, Boolean.TYPE, "jdoIsDeleted", new Class[0]);
        nArray[n++] = this.hasMethod(17, Void.TYPE, "jdoMakeDirty", new Class[]{String.class});
        AugmentationTest.affirm(n == 15);
        n = 0;
        for (int i = 0; i < 15; ++i) {
            int n2 = nArray[i];
            AugmentationTest.affirm(-1 <= n2 && n2 <= 1);
            if (n2 < n) {
                this.println("!!! ERROR: inconsistent \"generic\" augmentation of class: " + this.className);
                return -1;
            }
            if (n2 <= 0) continue;
            n = n2;
        }
        if (n > 0) {
            this.verbose("+++ has \"generic\" augmentation");
            return 1;
        }
        this.verbose("--- no \"generic\" augmentation");
        return 0;
    }

    public int hasSpecificAugmentation() {
        AugmentationTest.affirm(true);
        this.verbose();
        this.verbose("Check for \"class-specific\" augmentation ...");
        AugmentationTest.affirm(this.classClass);
        int[] nArray = new int[5];
        int n = 0;
        nArray[n++] = this.hasConstructor(1, new Class[]{StateManager.class});
        nArray[n++] = this.hasMethod(1, Object.class, "jdoGetField", new Class[]{Integer.TYPE});
        nArray[n++] = this.hasMethod(1, Void.TYPE, "jdoSetField", new Class[]{Integer.TYPE, Object.class});
        nArray[n++] = this.hasMethod(1, Void.TYPE, "jdoClear", new Class[0]);
        nArray[n++] = this.hasMethod(1, Object.class, "jdoNewInstance", new Class[]{StateManager.class});
        AugmentationTest.affirm(n == 5);
        n = 0;
        for (int i = 0; i < 5; ++i) {
            int n2 = nArray[i];
            AugmentationTest.affirm(-1 <= n2 && n2 <= 1);
            if (n2 < n) {
                this.println("!!! ERROR: inconsistent \"class-specific\" augmentation of class: " + this.className);
                return -1;
            }
            if (n2 <= 0) continue;
            n = n2;
        }
        if (n > 0) {
            this.verbose("+++ has \"class-specific\" augmentation");
            return 1;
        }
        this.verbose("--- no \"class-specific\" augmentation");
        return 0;
    }

    public int testPCFeasibility() {
        Class[] classArray;
        this.verbose();
        this.verbose("Test feasibility of class: " + this.className + " ...");
        int n = 1;
        int n2 = this.classClass.getModifiers();
        if (this.classClass.isPrimitive()) {
            this.println("!!! ERROR: specified class is primitive type");
            n = -1;
        }
        if (this.classClass.isArray()) {
            this.println("!!! ERROR: specified class is array");
            n = -1;
        }
        if (this.classClass.isInterface()) {
            this.println("!!! ERROR: specified class is interface");
            n = -1;
        }
        if (Modifier.isAbstract(n2)) {
            this.println("!!! ERROR: specified class is abstract");
            n = -1;
        }
        if (!Modifier.isPublic(n2)) {
            this.println("!!! ERROR: specified class is not public");
            n = -1;
        }
        if (this.classClass.getDeclaringClass() != null) {
            this.println("!!! ERROR: specified class is inner class");
            n = -1;
        }
        if (Throwable.class.isAssignableFrom(this.classClass)) {
            this.println("!!! ERROR: specified class extends Throwable");
            n = -1;
        }
        for (int i = 0; i < transientPrefixes.length; ++i) {
            classArray = transientPrefixes[i];
            if (!this.className.startsWith((String)classArray)) continue;
            this.println("!!! ERROR: specified class starts with package prefix: " + (String)classArray);
            n = -1;
        }
        Class clazz = this.classClass.getSuperclass();
        if (clazz == null) {
            this.println("!!! ERROR: specified class doesn't have super class");
            n = -1;
        } else {
            try {
                classArray = new Class[]{};
                Constructor constructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.println("!!! ERROR: super class '" + clazz.getName() + "' doesn't provide default constructor");
                n = -1;
            }
        }
        this.verbose(n == 1 ? "+++ is feasible for persistence-capability" : "!!! not feasible for persistence-capability");
        return n;
    }

    public int testJdoConstructor() {
        this.verbose();
        this.verbose("Test JDO constructor ...");
        AugmentationTest.affirm(this.classClass);
        try {
            Class[] classArray = new Class[]{StateManager.class};
            Constructor constructor = this.classClass.getConstructor(classArray);
            Object[] objectArray = new Object[]{null};
            Object t = constructor.newInstance(objectArray);
            PersistenceCapable persistenceCapable = (PersistenceCapable)t;
            if (persistenceCapable.jdoGetStateManager() != null) {
                this.println("!!! ERROR: invokation of JDO constructor:");
                this.println("    pc.jdoStateManager != null");
                this.println("!!! failed testing JDO constructor");
                return -1;
            }
            if (persistenceCapable.jdoGetFlags() != 1) {
                this.println("!!! ERROR: invokation of JDO constructor:");
                this.println("    pc.jdoFlags != 0");
                this.println("!!! failed testing JDO constructor");
                return -1;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.println("!!! ERROR: no JDO constructor");
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (InstantiationException instantiationException) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + instantiationException);
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + illegalAccessException);
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + invocationTargetException);
            this.println("    nested:    " + invocationTargetException.getTargetException());
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        this.verbose("+++ tested JDO constructor");
        return 1;
    }

    public int test(String string) {
        AugmentationTest.affirm(string);
        this.className = string;
        this.verbose();
        this.verbose("-------------------------------------------------------------------------------");
        this.verbose();
        this.verbose("Test class for augmentation: " + string + " ...");
        if (this.testLoadingClass() < 1) {
            return -1;
        }
        int n = this.hasGenericAugmentation();
        int n2 = this.hasSpecificAugmentation();
        if (n2 < 0 || n < 0) {
            return -1;
        }
        AugmentationTest.affirm(n2 >= 0 && n >= 0);
        if (n2 == 0 && n == 0) {
            if (this.requirePC) {
                this.println();
                this.println("!!! ERROR: class not augmented: " + string);
                return -1;
            }
            this.println();
            this.println("--- not augmented: " + string);
            return 0;
        }
        if (n == 0) {
            this.println();
            this.println("!!! ERROR: class lacking \"generic\" augmentation: " + string);
            return -1;
        }
        if (n2 == 0) {
            this.println();
            this.println("!!! ERROR: class lacking \"class-specific\" augmentation: " + string);
            return -1;
        }
        AugmentationTest.affirm(n2 > 0 && n > 0);
        int n3 = this.testPCFeasibility();
        if (n3 < 1) {
            return -1;
        }
        int n4 = this.testJdoConstructor();
        if (n4 < 1) {
            return -1;
        }
        this.println();
        this.println("+++ augmented: " + string);
        return 1;
    }

    public int test(boolean bl, boolean bl2, List list) {
        int n;
        AugmentationTest.affirm(list);
        this.verbose = bl;
        this.requirePC = bl2;
        int n2 = list.size();
        this.println();
        this.println("AugmentationTest: Testing classes for being enhanced for persistence-capability");
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.test((String)list.get(n)) >= 0) continue;
            ++n3;
        }
        n = n2 - n3;
        this.println();
        this.println("AugmentationTest: Summary:  TESTED: " + n2 + "  PASSED: " + n + "  FAILED: " + n3);
        return n3;
    }

    static void usage() {
        out.println();
        out.println("Usage: AugmentationTest <options> <classes>...");
        out.println();
        out.println("This class tests if classes have been correctly enhanced");
        out.println("for persistence-capability (\"augmented\").");
        out.println();
        out.println("Options include:");
        out.println("    -h, --help        print usage");
        out.println("    -v, --verbose     enable verbose output");
        out.println("    -pc, --requirePC  require all classes to be augmented");
        out.println();
        out.println("A non-zero value is returned in case of any errors.");
        out.println();
    }

    public static void main(String[] stringArray) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string.equals("-h") || string.equals("--help")) {
                AugmentationTest.usage();
                return;
            }
            if (string.equals("-v") || string.equals("--verbose")) {
                bl = true;
                continue;
            }
            if (string.equals("-pc") || string.equals("--requirePC")) {
                bl2 = true;
                continue;
            }
            if (string.equals("--debug")) {
                debug = true;
                continue;
            }
            if (string.startsWith("-")) {
                out.println();
                out.println("Unrecognized option: " + string);
                AugmentationTest.usage();
                return;
            }
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            out.println();
            out.println("Missing classes argument");
            AugmentationTest.usage();
            return;
        }
        if (debug) {
            out.println("options:");
            out.println("    verbose = " + bl);
            out.println("    requirePC = " + bl2);
            out.print("    classes =");
            for (n = 0; n < arrayList.size(); ++n) {
                out.print(" " + arrayList.get(n));
            }
            out.println();
        }
        AugmentationTest augmentationTest = new AugmentationTest();
        int n2 = augmentationTest.test(bl, bl2, arrayList);
        System.exit(n2);
    }
}

