/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.Transaction;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;

public class SynchronizationManager
implements Synchronization {
    protected static int defaultCapacity = 100;
    protected final List synchronizations;

    public SynchronizationManager(int n) {
        this.synchronizations = new ArrayList(n);
    }

    public SynchronizationManager() {
        this(defaultCapacity);
    }

    public static void registerSynchronization(Synchronization synchronization, PersistenceManager persistenceManager) {
        SynchronizationManager synchronizationManager = SynchronizationManager.getSynchronizationManager(persistenceManager);
        synchronizationManager.registerSynchronization(synchronization);
    }

    public static void setDefaultCapacity(int n) {
        defaultCapacity = n;
    }

    protected SynchronizationManager(PersistenceManager persistenceManager) {
        this();
        Transaction transaction = persistenceManager.currentTransaction();
        transaction.setSynchronization(this);
    }

    protected static SynchronizationManager getSynchronizationManager(PersistenceManager persistenceManager) {
        Transaction transaction = persistenceManager.currentTransaction();
        Synchronization synchronization = transaction.getSynchronization();
        if (synchronization instanceof SynchronizationManager) {
            return (SynchronizationManager)synchronization;
        }
        SynchronizationManager synchronizationManager = new SynchronizationManager(persistenceManager);
        if (synchronization != null) {
            synchronizationManager.registerSynchronization(synchronization);
        }
        return synchronizationManager;
    }

    public void beforeCompletion() {
        int n = this.synchronizations.size();
        for (int i = 0; i < n; ++i) {
            Synchronization synchronization = (Synchronization)this.synchronizations.get(i);
            synchronization.beforeCompletion();
        }
    }

    public void afterCompletion(int n) {
        int n2 = this.synchronizations.size();
        for (int i = 0; i < n2; ++i) {
            Synchronization synchronization = (Synchronization)this.synchronizations.get(i);
            synchronization.afterCompletion(n);
        }
        this.synchronizations.clear();
    }

    protected void registerSynchronization(Synchronization synchronization) {
        this.synchronizations.add(synchronization);
    }
}

