/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.JDOHelper;
import java.io.PrintStream;
import java.io.PrintWriter;

public class JDOException
extends RuntimeException {
    Exception nested;
    Object[] failed;

    public JDOException() {
    }

    public JDOException(String string) {
        super(string);
    }

    public JDOException(String string, Exception exception) {
        super(string);
        this.nested = exception;
    }

    public JDOException(String string, Object[] objectArray) {
        super(string);
        this.failed = objectArray;
    }

    public JDOException(String string, Exception exception, Object[] objectArray) {
        super(string);
        this.nested = exception;
        this.failed = objectArray;
    }

    public void addFailedObject(Object object) {
        if (this.failed == null) {
            this.failed = new Object[]{object};
        } else {
            int n = this.failed.length;
            Object[] objectArray = this.failed;
            this.failed = new Object[n + 1];
            for (int i = 0; i < n; ++i) {
                this.failed[i] = objectArray[i];
            }
            this.failed[n] = object;
        }
    }

    public Object[] getFailedObjectArray() {
        return this.failed;
    }

    public Exception getNestedException() {
        return this.nested;
    }

    public String toString() {
        int n = 0;
        if (this.failed != null) {
            n = this.failed.length;
        }
        StringBuffer stringBuffer = new StringBuffer(100 + 10 * n);
        stringBuffer.append(super.toString());
        if (this.nested != null) {
            stringBuffer.append("\nNestedException: ");
            stringBuffer.append(this.nested.toString());
        }
        if (n > 0) {
            stringBuffer.append("\nFailedObjectArray: [");
            Object object = this.failed[0];
            stringBuffer.append(JDOHelper.printObject(object));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", ");
                object = this.failed[i];
                stringBuffer.append(JDOHelper.printObject(object));
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (this.nested != null) {
                printStream.println("\nNestedStackTrace: ");
                this.nested.printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this.nested != null) {
                printWriter.println("\nNestedStackTrace: ");
                this.nested.printStackTrace(printWriter);
            }
        }
    }
}

