/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.util;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class DumpMapping {
    public static Model model = Model.RUNTIME;

    public static void dumpMappingCache(PrintStream printStream) {
        printStream.println("Mapping cache (class names -> MappingClassElements)");
        Iterator iterator = model.getMappingCache().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            MappingClassElement mappingClassElement = (MappingClassElement)entry.getValue();
            String string2 = mappingClassElement.getClass() + "@" + Integer.toHexString(System.identityHashCode(mappingClassElement));
            printStream.println("\t" + string + " ->\t" + string2);
        }
    }

    public static void dumpClassLoaderCache(PrintStream printStream) {
        printStream.println("ClassLoader cache (class names -> ClassLoaders)");
        Iterator iterator = model.getClassLoaderCache().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            ClassLoader classLoader = (ClassLoader)entry.getValue();
            printStream.println("\t" + string + " ->\t" + classLoader);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            DumpMapping.println(0, "\nClass " + string + ":");
            try {
                MappingClassElementImpl mappingClassElementImpl = (MappingClassElementImpl)model.getMappingClass(string);
                if (mappingClassElementImpl != null) {
                    DumpMapping.printPersistenceClassElement(mappingClassElementImpl.getPersistenceElement());
                    DumpMapping.printMappingClassElement(mappingClassElementImpl);
                    continue;
                }
                DumpMapping.println(0, "Cannot find mapping info for class " + string + " (getMappingClass returns null)");
                continue;
            }
            catch (Exception exception) {
                DumpMapping.println(0, "Problems during accessing mapping info for class " + string);
                exception.printStackTrace();
            }
        }
    }

    public static void printPersistenceClassElement(PersistenceClassElement persistenceClassElement) {
        DumpMapping.println(0, "\n--> PersistenceClassElement ");
        DumpMapping.println(1, "package  = " + persistenceClassElement.getPackage());
        DumpMapping.println(1, "name     = " + persistenceClassElement.getName());
        DumpMapping.println(1, "identity = " + DumpMapping.getObjectIdentityTypeRepr(persistenceClassElement.getObjectIdentityType()));
        DumpMapping.println(1, "keyClass = " + persistenceClassElement.getKeyClass());
        DumpMapping.printPersistenceFieldElements(1, persistenceClassElement.getFields());
        DumpMapping.printConcurrencyGroupElements(1, persistenceClassElement.getConcurrencyGroups());
        DumpMapping.println(0, "<-- PersistenceClassElement\n ");
    }

    public static void printPersistenceFieldElements(int n, PersistenceFieldElement[] persistenceFieldElementArray) {
        if (persistenceFieldElementArray != null && persistenceFieldElementArray.length > 0) {
            DumpMapping.println(n, "--> fields ");
            for (int i = 0; i < persistenceFieldElementArray.length; ++i) {
                PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[i];
                DumpMapping.println(n, "[" + i + "] " + persistenceFieldElement.getClass());
                DumpMapping.println(n + 1, "name             = " + persistenceFieldElement.getName());
                DumpMapping.println(n + 1, "declaringClass   = " + persistenceFieldElement.getDeclaringClass());
                DumpMapping.println(n + 1, "fieldNumber      = " + persistenceFieldElement.getFieldNumber());
                DumpMapping.println(n + 1, "persistenceType  = " + DumpMapping.getPersistenceTypeRepr(persistenceFieldElement.getPersistenceType()));
                DumpMapping.println(n + 1, "read / write     = " + persistenceFieldElement.isReadSensitive() + " / " + persistenceFieldElement.isWriteSensitive());
                DumpMapping.println(n + 1, "isKey            = " + persistenceFieldElement.isKey());
                if (persistenceFieldElement instanceof RelationshipElement) {
                    RelationshipElement relationshipElement = (RelationshipElement)persistenceFieldElement;
                    DumpMapping.println(n + 1, "bounds          = " + relationshipElement.getLowerBound() + " / " + relationshipElement.getUpperBound());
                    DumpMapping.println(n + 1, "deleteAction    = " + relationshipElement.getDeleteAction());
                    DumpMapping.println(n + 1, "updateAction    = " + relationshipElement.getUpdateAction());
                    DumpMapping.println(n + 1, "collectionClass = " + relationshipElement.getCollectionClass());
                    DumpMapping.println(n + 1, "elementClass\t = " + relationshipElement.getElementClass());
                    DumpMapping.println(n + 1, "isPrefetch      = " + relationshipElement.isPrefetch());
                }
                DumpMapping.printConcurrencyGroupElements(n + 1, persistenceFieldElement.getConcurrencyGroups());
            }
            DumpMapping.println(n, "<-- fields ");
        }
    }

    public static void printConcurrencyGroupElements(int n, ConcurrencyGroupElement[] concurrencyGroupElementArray) {
        if (concurrencyGroupElementArray != null && concurrencyGroupElementArray.length > 0) {
            DumpMapping.println(n, "--> concurrency groups");
            for (int i = 0; i < concurrencyGroupElementArray.length; ++i) {
                ConcurrencyGroupElement concurrencyGroupElement = concurrencyGroupElementArray[i];
                DumpMapping.println(n, "[" + i + "] " + concurrencyGroupElement.getClass());
                DumpMapping.println(n + 1, "name           = " + concurrencyGroupElement.getName());
                DumpMapping.println(n + 1, "declaringClass = " + concurrencyGroupElement.getDeclaringClass());
                DumpMapping.println(n + 1, "fields         = " + concurrencyGroupElement.getFields());
            }
            DumpMapping.println(n, "<-- concurrency groups");
        }
    }

    public static void printMappingClassElement(MappingClassElement mappingClassElement) {
        DumpMapping.println(0, "\n--> MappingClassElement");
        DumpMapping.println(1, "databaseRoot = " + mappingClassElement.getDatabaseRoot());
        DumpMapping.printMappingTableElements(1, mappingClassElement.getTables());
        DumpMapping.printMappingFieldElements(1, mappingClassElement.getFields());
        DumpMapping.println(0, "<-- MappingClassElement");
    }

    public static void printMappingTableElements(int n, ArrayList arrayList) {
        int n2;
        int n3 = n2 = arrayList != null ? arrayList.size() : 0;
        if (n2 > 0) {
            DumpMapping.println(n, "--> tables ");
            for (int i = 0; i < n2; ++i) {
                MappingTableElementImpl mappingTableElementImpl = (MappingTableElementImpl)arrayList.get(i);
                DumpMapping.println(n, "[" + i + "] " + mappingTableElementImpl.getClass());
                DumpMapping.println(n + 1, "table           = " + mappingTableElementImpl.getTable());
                DumpMapping.println(n + 1, "tableObject     = " + mappingTableElementImpl.getTableObject());
                DumpMapping.println(n + 1, "key             = " + mappingTableElementImpl.getKey());
                DumpMapping.println(n + 1, "keyObjects      = " + mappingTableElementImpl.getKeyObjects());
                DumpMapping.printMappingRefKeyElements(n + 1, mappingTableElementImpl.getReferencingKeys());
            }
            DumpMapping.println(n, "<-- tables ");
        }
    }

    public static void printMappingRefKeyElements(int n, ArrayList arrayList) {
        int n2;
        int n3 = n2 = arrayList != null ? arrayList.size() : 0;
        if (n2 > 0) {
            DumpMapping.println(n, "--> tables ");
            for (int i = 0; i < n2; ++i) {
                MappingReferenceKeyElement mappingReferenceKeyElement = (MappingReferenceKeyElement)arrayList.get(i);
                DumpMapping.println(n, "[" + i + "] " + mappingReferenceKeyElement.getClass());
                DumpMapping.println(n + 1, "table           = " + mappingReferenceKeyElement.getDeclaringTable());
                DumpMapping.println(n + 1, "pairs           = " + mappingReferenceKeyElement.getColumnPairNames());
            }
            DumpMapping.println(n, "<-- tables ");
        }
    }

    public static void printMappingFieldElements(int n, ArrayList arrayList) {
        int n2;
        int n3 = n2 = arrayList != null ? arrayList.size() : 0;
        if (n2 > 0) {
            DumpMapping.println(n, "--> fields ");
            for (int i = 0; i < n2; ++i) {
                DBMemberElement dBMemberElement;
                int n4;
                MappingFieldElementImpl mappingFieldElementImpl = (MappingFieldElementImpl)arrayList.get(i);
                DumpMapping.println(n, "[" + i + "] " + mappingFieldElementImpl.getClass());
                DumpMapping.println(n + 1, "name            = " + mappingFieldElementImpl.getName());
                DumpMapping.println(n + 1, "fetchGroup      = " + mappingFieldElementImpl.getFetchGroup());
                DumpMapping.println(n + 1, "columns         = " + mappingFieldElementImpl.getColumns());
                if (!(mappingFieldElementImpl instanceof MappingRelationshipElement)) {
                    DumpMapping.println(n + 1, "columnObjects\t = " + mappingFieldElementImpl.getColumnObjects());
                    continue;
                }
                MappingRelationshipElementImpl mappingRelationshipElementImpl = (MappingRelationshipElementImpl)mappingFieldElementImpl;
                ArrayList arrayList2 = mappingRelationshipElementImpl.getColumnObjects();
                int n5 = n4 = arrayList2 != null ? arrayList2.size() : 0;
                if (n4 > 0) {
                    DumpMapping.println(n + 1, "--> columnsObjects ");
                    for (int j = 0; j < n4; ++j) {
                        ColumnPairElement columnPairElement = (ColumnPairElement)arrayList2.get(j);
                        dBMemberElement = columnPairElement != null ? columnPairElement.getReferencedColumn() : null;
                        DumpMapping.println(n + 1, "[" + j + "] " + columnPairElement + " -> " + dBMemberElement);
                    }
                    DumpMapping.println(n + 1, "<-- columnsObjects ");
                }
                DumpMapping.println(n + 1, "associatedColumns = " + mappingRelationshipElementImpl.getAssociatedColumns());
                ArrayList arrayList3 = mappingRelationshipElementImpl.getAssociatedColumnObjects();
                int n6 = n4 = arrayList3 != null ? arrayList3.size() : 0;
                if (n4 <= 0) continue;
                DumpMapping.println(n + 1, "--> associatedColumnObjects ");
                for (int j = 0; j < n4; ++j) {
                    dBMemberElement = (ColumnPairElement)arrayList3.get(j);
                    ColumnElement columnElement = dBMemberElement != null ? ((ColumnPairElement)dBMemberElement).getReferencedColumn() : null;
                    DumpMapping.println(n + 1, "[" + j + "] " + dBMemberElement + " -> " + columnElement);
                }
                DumpMapping.println(n + 1, "<-- associatedColumnObjects ");
            }
            DumpMapping.println(n, "<-- fields ");
        }
    }

    static String getObjectIdentityTypeRepr(int n) {
        switch (n) {
            case 0: {
                return "APPLICATION_IDENTITY";
            }
            case 1: {
                return "DATABASE_IDENTITY_IDENTITY";
            }
            case 2: {
                return "UNMANAGED_IDENTITY";
            }
        }
        return "UNKNOWN";
    }

    static String getPersistenceTypeRepr(int n) {
        switch (n) {
            case 0: {
                return "PERSISTENT";
            }
            case 1: {
                return "DERIVED";
            }
            case 2: {
                return "TRANSIENT";
            }
        }
        return "UNKNOWN";
    }

    static void println(int n, String string) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println(string);
    }
}

