/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class MappingFieldElementImpl
extends MappingMemberElementImpl
implements MappingFieldElement {
    private ArrayList _columns;
    private transient ArrayList _columnObjects;
    private int _fetchGroup;
    private int _properties;
    public static final int CLONE_FIELD = 1;
    public static final int CLONE_DEEP = 2;
    public static final int CLONE_MASK = 3;
    public static final int LOG_ON_ACCESS = 4;
    public static final int LOG_ON_MASK = 48;
    public static final int LOG_ON_UPDATE = 16;
    public static final int MOD_BI_ON_UPDATE = 32;
    public static final int OBSERVE_ON_ACCESS = 8;
    public static final int RECORD_ON_UPDATE = 64;
    public static final int SEND_BEFORE_IMAGE = 128;
    public static final int READ_ONLY = 256;
    public static final int REF_INTEGRITY_UPDATES = 512;
    public static final int IN_CONCURRENCY_CHECK = 1024;
    public static final int XLATE_FIELD = 2048;

    public MappingFieldElementImpl() {
        this(null, null);
    }

    public MappingFieldElementImpl(String string, MappingClassElement mappingClassElement) {
        super(string, mappingClassElement);
        this.setFetchGroupInternal(1);
    }

    public boolean isReadOnly() {
        return this.getProperty(256);
    }

    public void setReadOnly(boolean bl) throws ModelException {
        Boolean bl2 = new Boolean(this.isReadOnly());
        Boolean bl3 = new Boolean(bl);
        try {
            this.fireVetoableChange("readOnly", bl2, bl3);
            this.setProperty(bl, 256);
            this.firePropertyChange("readOnly", bl2, bl3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public boolean isInConcurrencyCheck() {
        return this.getProperty(1024);
    }

    public void setInConcurrencyCheck(boolean bl) throws ModelException {
        Boolean bl2 = new Boolean(this.isInConcurrencyCheck());
        Boolean bl3 = new Boolean(bl);
        try {
            this.fireVetoableChange("inConcurrencyCheck", bl2, bl3);
            this.setProperty(bl, 1024);
            this.firePropertyChange("inConcurrencyCheck", bl2, bl3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public int getFetchGroup() {
        return this._fetchGroup;
    }

    public void setFetchGroup(int n) throws ModelException {
        Integer n2 = new Integer(this.getFetchGroup());
        Integer n3 = new Integer(n);
        try {
            this.fireVetoableChange("fetchGroup", n2, n3);
            this.setFetchGroupInternal(n);
            this.firePropertyChange("fetchGroup", n2, n3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    protected void setFetchGroupInternal(int n) {
        this._fetchGroup = n;
    }

    public ArrayList getColumns() {
        if (this._columns == null) {
            this._columns = new ArrayList();
        }
        return this._columns;
    }

    public void addColumn(DBMemberElement dBMemberElement) throws ModelException {
        if (dBMemberElement != null) {
            String string;
            ArrayList arrayList = this.getColumns();
            if (!arrayList.contains(string = NameUtil.getRelativeMemberName(dBMemberElement.getName().getFullName()))) {
                try {
                    this.fireVetoableChange("columns", null, null);
                    arrayList.add(string);
                    this.firePropertyChange("columns", null, null);
                    this._columnObjects = null;
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new ModelVetoException(propertyVetoException);
                }
            }
        } else {
            throw new ModelException(I18NHelper.getMessage(MappingFieldElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    public void removeColumn(String string) throws ModelException {
        if (string != null) {
            try {
                this.fireVetoableChange("columns", null, null);
                if (!this.getColumns().remove(string)) {
                    throw new ModelException(I18NHelper.getMessage(MappingFieldElementImpl.getMessages(), "mapping.element.element_not_removed", string));
                }
                this.firePropertyChange("columns", null, null);
                this._columnObjects = null;
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new ModelVetoException(propertyVetoException);
            }
        }
    }

    protected boolean isMappedToTable(MappingTableElement mappingTableElement) {
        String string = mappingTableElement.getName();
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (!NameUtil.getTableName(string2).equals(string)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getColumnObjects() {
        if (this._columnObjects == null) {
            this._columnObjects = MappingClassElementImpl.toColumnObjects(this.getDeclaringClass().getDatabaseRoot(), this.getColumns());
        }
        return this._columnObjects;
    }

    final PersistenceFieldElement getPersistenceFieldElement() {
        return ((MappingClassElementImpl)this.getDeclaringClass()).getPersistenceElement().getField(this.getName());
    }

    public int getFieldNumber() {
        return this.getPersistenceFieldElement().getFieldNumber();
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return this.getPersistenceFieldElement().getConcurrencyGroups();
    }

    private boolean getProperty(int n) {
        return (this.getProperties() & n) > 0;
    }

    public void setProperty(boolean bl, int n) {
        this._properties = bl ? this._properties | n : this._properties & ~n;
    }

    public int getProperties() {
        return this._properties;
    }

    public boolean getLogOnAccess() {
        return this.getProperty(4);
    }

    public void setLogOnAccess(boolean bl) {
        this.setProperty(bl, 4);
    }

    public boolean getLogOnUpdate() {
        return this.getProperty(16);
    }

    public void setLogOnUpdate(boolean bl) {
        this.setProperty(bl, 16);
    }

    public boolean getObserveOnAccess() {
        return this.getProperty(8);
    }

    public void setObserveOnAccess(boolean bl) {
        this.setProperty(bl, 8);
    }

    public boolean getRecordOnUpdate() {
        return this.getProperty(64);
    }

    public void setRecordOnUpdate(boolean bl) {
        this.setProperty(bl, 64);
    }

    public boolean getModifyBeforeImageOnUpdate() {
        return this.getProperty(32);
    }

    public void setModifyBeforeImageOnUpdate(boolean bl) {
        this.setProperty(bl, 32);
    }

    public boolean getReferentialIntegrityUpdates() {
        return this.getProperty(512);
    }

    public void setReferentialIntegrityUpdates(boolean bl) {
        this.setProperty(bl, 512);
    }

    public boolean getSendBeforeImage() {
        return this.getProperty(128);
    }

    public void setSendBeforeImage(boolean bl) {
        this.setProperty(bl, 128);
    }

    public int getCloneDepth() {
        return this._properties & 3;
    }

    public void setCloneDepth(int n) {
        if (n < 1 || n > 2) {
            // empty if block
        }
        this._properties = this._properties & 0xFFFFFFFC | n;
    }

    protected void stripSchemaName() {
        if (this._columns != null) {
            ListIterator<String> listIterator = this._columns.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(NameUtil.getRelativeMemberName((String)listIterator.next()));
            }
        }
    }
}

