/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingElement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.Collator;
import java.util.ResourceBundle;

public abstract class MappingElementImpl
implements MappingElement {
    private static final ResourceBundle _messages = I18NHelper.loadBundle("com.sun.jdo.api.persistence.model.Bundle", MappingElementImpl.class.getClassLoader());
    private PropertyChangeSupport _support;
    private transient VetoableChangeSupport _vetoableSupport;
    String _name;

    public MappingElementImpl() {
        this(null);
    }

    public MappingElementImpl(String string) {
        this._name = string;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass() == object.getClass() && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.fireVetoableChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            MappingElementImpl mappingElementImpl = this;
            synchronized (mappingElementImpl) {
                if (this._support == null) {
                    this._support = new PropertyChangeSupport(this);
                }
            }
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableSupport == null) {
            this._vetoableSupport = new VetoableChangeSupport(this);
        }
        this._vetoableSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableSupport != null) {
            this._vetoableSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) throws ModelException {
        String string2 = this.getName();
        try {
            this.fireVetoableChange("name", string2, string);
            this._name = string;
            this.firePropertyChange("name", string2, string);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        if (object == this) {
            return 0;
        }
        String string = this.getName();
        String string2 = ((MappingElementImpl)object).getName();
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = Collator.getInstance().compare(string, string2);
        if (n == 0 && this.getClass() != object.getClass()) {
            n = this.getClass().getName().compareTo(object.getClass().getName());
        }
        return n;
    }
}

