/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceMemberElement;
import java.util.ArrayList;

public class PersistenceFieldElement
extends PersistenceMemberElement {
    public static final int PERSISTENT = 0;
    public static final int DERIVED = 1;
    public static final int TRANSIENT = 2;

    public PersistenceFieldElement() {
        this(null, null);
    }

    public PersistenceFieldElement(Impl impl, PersistenceClassElement persistenceClassElement) {
        super(impl, persistenceClassElement);
    }

    final Impl getFieldImpl() {
        return (Impl)this.getImpl();
    }

    public int getPersistenceType() {
        return this.getFieldImpl().getPersistenceType();
    }

    public void setPersistenceType(int n) throws ModelException {
        this.getFieldImpl().setPersistenceType(n);
    }

    public boolean isReadSensitive() {
        return this.getPersistenceType() == 1 && this.getFieldImpl().isReadSensitive();
    }

    public void setReadSensitive(boolean bl) throws ModelException {
        this.getFieldImpl().setReadSensitive(bl);
    }

    public boolean isWriteSensitive() {
        return this.getPersistenceType() == 1 && this.getFieldImpl().isWriteSensitive();
    }

    public void setWriteSensitive(boolean bl) throws ModelException {
        this.getFieldImpl().setWriteSensitive(bl);
    }

    public boolean isKey() {
        return this.getFieldImpl().isKey();
    }

    public void setKey(boolean bl) throws ModelException {
        this.getFieldImpl().setKey(bl);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        ConcurrencyGroupElement[] concurrencyGroupElementArray = this.getDeclaringClass().getConcurrencyGroups();
        int n = concurrencyGroupElementArray != null ? concurrencyGroupElementArray.length : 0;
        ArrayList<ConcurrencyGroupElement> arrayList = new ArrayList<ConcurrencyGroupElement>(n);
        for (int i = 0; i < n; ++i) {
            ConcurrencyGroupElement concurrencyGroupElement = concurrencyGroupElementArray[i];
            if (!concurrencyGroupElement.containsField(this)) continue;
            arrayList.add(concurrencyGroupElement);
        }
        n = arrayList.size();
        return arrayList.toArray(new ConcurrencyGroupElement[n]);
    }

    public int getFieldNumber() {
        PersistenceFieldElement[] persistenceFieldElementArray = this.getDeclaringClass().getFields();
        int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!this.equals(persistenceFieldElementArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static interface Impl
    extends PersistenceMemberElement.Impl {
        public int getPersistenceType();

        public void setPersistenceType(int var1) throws ModelException;

        public boolean isReadSensitive();

        public void setReadSensitive(boolean var1) throws ModelException;

        public boolean isWriteSensitive();

        public void setWriteSensitive(boolean var1) throws ModelException;

        public boolean isKey();

        public void setKey(boolean var1) throws ModelException;
    }
}

