/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElementProperties;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.text.Collator;
import java.util.ResourceBundle;

public abstract class PersistenceElement
implements PersistenceElementProperties,
Comparable {
    private static final ResourceBundle _messages = I18NHelper.loadBundle("com.sun.jdo.api.persistence.model.Bundle", PersistenceElement.class.getClassLoader());
    Impl _impl;

    public PersistenceElement() {
        this(null);
    }

    protected PersistenceElement(Impl impl) {
        this.setImpl(impl);
    }

    public final Impl getImpl() {
        return this._impl;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getImpl().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getImpl().removePropertyChangeListener(propertyChangeListener);
    }

    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getImpl().addVetoableChangeListener(vetoableChangeListener);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getImpl().removeVetoableChangeListener(vetoableChangeListener);
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public void setName(String string) throws ModelException {
        this.getImpl().setName(string);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass() == object.getClass() && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        if (object == this) {
            return 0;
        }
        String string = this.getName();
        String string2 = ((PersistenceElement)object).getName();
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = Collator.getInstance().compare(string, string2);
        if (n == 0 && this.getClass() != object.getClass()) {
            n = this.getClass().getName().compareTo(object.getClass().getName());
        }
        return n;
    }

    public void setImpl(Impl impl) {
        this._impl = impl;
        if (this._impl != null) {
            this.getImpl().attachToElement(this);
        }
    }

    public static interface Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;

        public void attachToElement(PersistenceElement var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public String getName();

        public void setName(String var1) throws ModelException;
    }
}

