/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.Type;

class DevelopmentModel
extends Model {
    private HashMap _locks;
    private HashMap primitiveTypes = new HashMap();

    DevelopmentModel() {
        this.primitiveTypes.put("boolean", Type.BOOLEAN);
        this.primitiveTypes.put("byte", Type.BYTE);
        this.primitiveTypes.put("short", Type.SHORT);
        this.primitiveTypes.put("char", Type.CHAR);
        this.primitiveTypes.put("int", Type.INT);
        this.primitiveTypes.put("long", Type.LONG);
        this.primitiveTypes.put("float", Type.FLOAT);
        this.primitiveTypes.put("double", Type.DOUBLE);
        this.primitiveTypes.put("void", Type.VOID);
    }

    public boolean isInterface(String string) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        return classElement != null ? classElement.isInterface() : false;
    }

    protected BufferedInputStream getInputStreamForResource(String string, ClassLoader classLoader, String string2) {
        try {
            FileObject fileObject = this.getFile(string, string2);
            return fileObject != null ? new BufferedInputStream(fileObject.getInputStream()) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String findPenultimateSuperclass(String string) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        Identifier identifier = ClassElement.ROOT_OBJECT;
        Identifier identifier2 = null;
        if (classElement == null) {
            return string;
        }
        while ((identifier2 = classElement.getSuperclass()) != null) {
            String string2 = identifier2.getFullName();
            if (identifier2.equals((Object)identifier)) break;
            classElement = (ClassElement)this.getClass(string2);
            if (classElement != null) continue;
            return Model.RUNTIME.findPenultimateSuperclass(string2);
        }
        return classElement.getName().getFullName();
    }

    protected String getSuperclass(String string) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        if (classElement != null) {
            Identifier identifier = classElement.getSuperclass();
            return identifier != null ? identifier.getFullName() : null;
        }
        return null;
    }

    private synchronized HashMap getLocks() {
        if (this._locks == null) {
            this._locks = new HashMap();
        }
        return this._locks;
    }

    private synchronized FileLock getLock(String string) {
        return (FileLock)this.getLocks().get(string);
    }

    private synchronized void putLock(String string, FileLock fileLock) {
        this.getLocks().put(string, fileLock);
    }

    private synchronized void removeLock(String string) {
        this.getLocks().remove(string);
    }

    protected BufferedOutputStream createFile(String string, String string2, String string3) throws IOException {
        char c = '.';
        FileObject fileObject = this.getFile(string, string2 + c + string3);
        if (fileObject == null) {
            String string4;
            int n;
            String string5;
            Repository repository = TopManager.getDefault().getRepository();
            FileObject fileObject2 = repository.find(string5 = (n = string.lastIndexOf(c)) == -1 ? "" : string.substring(0, n), string4 = n == -1 ? string : string.substring(n + 1), "java");
            if (fileObject2 != null) {
                fileObject = fileObject2.getParent().createData(string4, string3);
            } else {
                throw new FileNotFoundException();
            }
        }
        if (fileObject != null) {
            return new BufferedOutputStream(fileObject.getOutputStream(this.lockFile(string, fileObject)));
        }
        return null;
    }

    public void lockFile(String string) throws IOException {
        this.lockFile(string, this.getFile(string, this.getFileNameWithExtension(string)));
    }

    private FileLock lockFile(String string, FileObject fileObject) throws IOException {
        FileLock fileLock = null;
        if (fileObject != null && (fileLock = this.getLock(string)) == null) {
            fileLock = fileObject.lock();
            this.putLock(string, fileLock);
        }
        return fileLock;
    }

    public void unlockFile(String string) {
        FileLock fileLock;
        if (string != null && (fileLock = this.getLock(string)) != null) {
            fileLock.releaseLock();
            this.removeLock(string);
        }
        super.unlockFile(string);
    }

    public void updateKeyForClass(MappingClassElement mappingClassElement, String string) {
        FileLock fileLock;
        super.updateKeyForClass(mappingClassElement, string);
        if (string != null && (fileLock = this.getLock(string)) != null) {
            this.unlockFile(string);
            if (mappingClassElement != null) {
                try {
                    this.lockFile(mappingClassElement.getName());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFile(String string, String string2) throws IOException {
        FileObject fileObject = this.getFile(string, string2);
        FileLock fileLock = this.lockFile(string, fileObject);
        try {
            fileObject.delete(fileLock);
        }
        finally {
            this.unlockFile(string);
        }
    }

    protected FileObject getFile(String string, String string2) throws IOException {
        if (string2 != null) {
            Enumeration enumeration = TopManager.getDefault().getRepository().findAllResources(string2.replace(File.separatorChar, '/'));
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (fileObject.getFileSystem().isReadOnly()) continue;
                return fileObject;
            }
        }
        return null;
    }

    public Object getClass(String string, ClassLoader classLoader) {
        return string != null ? ClassElement.forName((String)string) : null;
    }

    public boolean implementsInterface(Object object, String string) {
        Identifier identifier;
        if (object == null || !(object instanceof ClassElement) || string == null) {
            return false;
        }
        ClassElement classElement = (ClassElement)object;
        Identifier[] identifierArray = classElement.getInterfaces();
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.length; ++i) {
                if (!identifierArray[i].getFullName().equals(string)) continue;
                return true;
            }
        }
        if ((identifier = classElement.getSuperclass()) == null || identifier.equals((Object)ClassElement.ROOT_OBJECT)) {
            return false;
        }
        return this.implementsInterface((ClassElement)this.getClass(identifier.getFullName()), string);
    }

    public boolean hasConstructor(String string) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        return classElement != null ? classElement.getConstructors().length != 0 : false;
    }

    public Object getConstructor(String string, String[] stringArray) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        return classElement != null ? classElement.getConstructor(this.getTypesForNames(stringArray)) : null;
    }

    public Object getMethod(String string, String string2, String[] stringArray) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        return classElement != null ? classElement.getMethod(Identifier.create((String)string2), this.getTypesForNames(stringArray)) : null;
    }

    public String getType(Object object) {
        return this.getNameForType(this.getTypeObject(object));
    }

    public List getFields(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassElement classElement = (ClassElement)this.getClass(string);
        if (classElement != null) {
            FieldElement[] fieldElementArray = classElement.getFields();
            int n = fieldElementArray != null ? fieldElementArray.length : 0;
            for (int i = 0; i < n; ++i) {
                arrayList.add(fieldElementArray[i].getName().getName());
            }
        }
        return arrayList;
    }

    public Object getField(String string, String string2) {
        ClassElement classElement = (ClassElement)this.getClass(string);
        if (classElement != null) {
            Identifier identifier = Identifier.create((String)string2);
            return classElement.getField(identifier);
        }
        return null;
    }

    public boolean isSerializable(Object object) {
        Type type = this.getTypeObject(object);
        ClassElement classElement = null;
        if (type == null || !(object instanceof FieldElement)) {
            return false;
        }
        while (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isPrimitive()) {
            return true;
        }
        classElement = ClassElement.forName((String)type.getClassName().getFullName());
        return classElement == null ? false : this.implementsInterface(classElement, "java.io.Serializable");
    }

    public boolean isArray(String string, String string2) {
        Object object = this.getField(string, string2);
        return object != null ? this.getTypeObject(object).isArray() : false;
    }

    public int getModifiers(Object object) {
        int n = 0;
        if (object != null && object instanceof MemberElement) {
            n = ((MemberElement)object).getModifiers();
        }
        return n;
    }

    protected Type getTypeObject(Object object) {
        Type type = null;
        if (object != null) {
            if (object instanceof FieldElement) {
                type = ((FieldElement)object).getType();
            } else if (object instanceof MethodElement) {
                type = ((MethodElement)object).getReturn();
            }
        }
        return type;
    }

    private String getNameForType(Type type) {
        String string = null;
        if (type != null) {
            string = type.isArray() ? this.getNameForType(type.getElementType()) + "[]" : (type.isPrimitive() ? type.toString() : type.getClassName().getFullName());
        }
        return string;
    }

    private Type[] getTypesForNames(String[] stringArray) {
        Type[] typeArray = new Type[stringArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = this.getTypeForName(stringArray[i]);
        }
        return typeArray;
    }

    private Type getTypeForName(String string) {
        Type type = (Type)this.primitiveTypes.get(string);
        if (type == null) {
            type = Type.createClass((Identifier)Identifier.create((String)string));
        }
        return type;
    }
}

