/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.ZipFileClassPackageEnumerator;
import com.sun.jdo.api.persistence.enhancer.util.ZipFileRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipFileClassPathElement
extends ClassPathElement {
    private File zipFileElement;
    private ZipFile zipFile;

    public ClassFileSource sourceOf(String string) {
        ZipEntry zipEntry;
        if (this.zipFile != null && (zipEntry = this.zipFile.getEntry(ClassPath.zipFileNameOf(string))) != null) {
            return new ClassFileSource(string, this.zipFile);
        }
        return null;
    }

    public Enumeration classesInPackage(String string) {
        if (this.zipFile == null) {
            return null;
        }
        return new ZipFileClassPackageEnumerator(this.zipFile, string);
    }

    boolean matches(File file) {
        return false;
    }

    ZipFileClassPathElement(File file) {
        this.zipFileElement = file;
        this.checkValid();
    }

    private void checkValid() {
        if (ZipFileClassPathElement.looksLikeZipName(this.zipFileElement.getPath()) && this.zipFileElement.isFile()) {
            try {
                this.zipFile = ZipFileRegistry.openZipFile(this.zipFileElement);
            }
            catch (IOException iOException) {
                System.err.println("IO exception while reading " + this.zipFileElement.getPath());
                this.zipFile = null;
            }
        }
    }
}

