/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public final class Timer {
    PrintWriter out = new PrintWriter(System.out, true);
    HashMap methods = new HashMap();
    private final ArrayList calls = new ArrayList(16);

    public Timer() {
        this.out = this.out;
    }

    public Timer(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public final synchronized void push(String string) {
        this.push(string, string);
    }

    public final synchronized void push(String string, String string2) {
        long l = System.currentTimeMillis();
        MethodDescriptor methodDescriptor = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(string);
            this.methods.put(string, methodDescriptor);
        }
        ++methodDescriptor.calls;
        ++methodDescriptor.instantiations;
        this.calls.add(new MethodCall(methodDescriptor, string2, l, l));
    }

    public final synchronized void pop() {
        Object object;
        long l = System.currentTimeMillis();
        MethodCall methodCall = (MethodCall)this.calls.remove(this.calls.size() - 1);
        long l2 = l - methodCall.self;
        long l3 = l - methodCall.total;
        if (this.calls.size() > 0) {
            object = (MethodCall)this.calls.get(this.calls.size() - 1);
            ((MethodCall)object).self += l3;
        }
        object = methodCall.method;
        ((MethodDescriptor)object).self += l2;
        if (--((MethodDescriptor)object).instantiations == 0) {
            ((MethodDescriptor)object).total += l3;
        }
    }

    private static final String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        n -= string.length();
        while (n > 0) {
            stringBuffer.append(' ');
            --n;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public final synchronized void print() {
        this.out.println("Timer : printing accumulated times ...");
        Object[] objectArray = this.methods.values().toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return (int)(((MethodDescriptor)object2).total - ((MethodDescriptor)object).total);
            }

            public boolean equals(Object object) {
                return this.compare(this, object) == 0;
            }
        });
        this.out.println("Timer :  total s    self s  #calls  name");
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        for (int i = 0; i < objectArray.length; ++i) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)objectArray[i];
            this.out.println("Timer : " + Timer.pad(decimalFormat.format((double)methodDescriptor.total / 1000.0), 8) + "  " + Timer.pad(decimalFormat.format((double)methodDescriptor.self / 1000.0), 8) + "  " + Timer.pad(String.valueOf(methodDescriptor.calls), 6) + "  " + methodDescriptor.name);
        }
    }

    private static class MethodCall {
        final MethodDescriptor method;
        final String message;
        long self;
        long total;

        MethodCall(MethodDescriptor methodDescriptor, String string, long l, long l2) {
            this.method = methodDescriptor;
            this.message = string;
            this.self = l;
            this.total = l2;
        }
    }

    private static class MethodDescriptor {
        final String name;
        int instantiations;
        int calls;
        long self;
        long total;

        MethodDescriptor(String string) {
            this.name = string;
        }
    }
}

