/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPackageEnumeration;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ClassPath {
    private String theClassPathSpec;
    private ClassPathElement theClassPath;

    public ClassPath(String string) {
        this.theClassPathSpec = string;
        this.parsePath();
    }

    public ClassFileSource findClass(String string) {
        return ClassPath.findClass(string, this.theClassPath);
    }

    static ClassFileSource findClass(String string, ClassPathElement classPathElement) {
        for (ClassPathElement classPathElement2 = classPathElement; classPathElement2 != null; classPathElement2 = classPathElement2.next()) {
            ClassFileSource classFileSource = classPathElement2.sourceOf(string);
            if (classFileSource == null) continue;
            classFileSource.setSourceElement(classPathElement2);
            return classFileSource;
        }
        return null;
    }

    public static String fileNameOf(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(c);
            }
            stringBuffer.append(stringTokenizer.nextToken());
            bl = false;
        }
        stringBuffer.append(".class");
        return stringBuffer.toString();
    }

    public static String fileNameOf(String string) {
        return ClassPath.fileNameOf(string, File.separatorChar);
    }

    public static String zipFileNameOf(String string) {
        return ClassPath.fileNameOf(string, '/');
    }

    public static String classNameOf(String string) {
        int n = string.length();
        if (n > 6 && string.regionMatches(true, n - 6, ".class", 0, 6)) {
            string = string.substring(0, string.length() - 6);
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/", false);
            boolean bl = true;
            while (stringTokenizer.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(stringTokenizer.nextToken());
                bl = false;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean remove(File file) {
        boolean bl = false;
        ClassPathElement classPathElement = this.theClassPath;
        ClassPathElement classPathElement2 = null;
        for (ClassPathElement classPathElement3 = classPathElement; classPathElement3 != null; classPathElement3 = classPathElement3.next()) {
            if (classPathElement3.matches(file)) {
                bl = true;
                if (classPathElement2 == null) {
                    classPathElement = classPathElement3.next();
                    continue;
                }
                classPathElement2.setNext(classPathElement3.next());
                continue;
            }
            classPathElement2 = classPathElement3;
        }
        this.theClassPath = classPathElement;
        return bl;
    }

    public void append(File file) {
        this.append(ClassPathElement.create(file.getPath()));
    }

    public void append(ClassPathElement classPathElement) {
        if (this.theClassPath == null) {
            this.theClassPath = classPathElement;
        } else {
            this.theClassPath.append(classPathElement);
        }
    }

    public Enumeration classesInPackage(String string) {
        return new ClassPackageEnumeration(this, string);
    }

    ClassPathElement getPathElements() {
        return this.theClassPath;
    }

    private void parsePath() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.theClassPathSpec, File.pathSeparator, false);
        ClassPathElement classPathElement = null;
        while (stringTokenizer.hasMoreElements()) {
            ClassPathElement classPathElement2 = ClassPathElement.create(stringTokenizer.nextToken());
            if (classPathElement == null) {
                this.theClassPath = classPathElement2;
            } else {
                classPathElement.append(classPathElement2);
            }
            classPathElement = classPathElement2;
        }
    }
}

