/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstNameAndType;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnConstOp;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnInterfaceInvoke;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnUtils;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.AnnotationConstants;
import com.sun.jdo.api.persistence.enhancer.impl.AnnotationFragment;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.InsnNote;
import com.sun.jdo.api.persistence.enhancer.impl.StackState;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.InternalError;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

class MethodAnnotater
extends Support
implements AnnotationConstants {
    private final ClassAction ca;
    private final ClassMethod method;
    private final ConstantPool pool;
    private final Environment env;
    private int annotate;
    private Vector tmpRegisters;
    private Vector tmpDoubleRegisters;
    private short annotationStack = 0;
    private Map insnNotes = new HashMap(11);

    boolean needsAnnotation() {
        return this.annotate != 0;
    }

    MethodAnnotater(ClassAction classAction, ClassMethod classMethod, Environment environment) {
        this.ca = classAction;
        this.method = classMethod;
        this.env = environment;
        this.pool = classAction.classFile().pool();
    }

    void checkMethod() {
        this.env.message("checking method " + this.ca.userClassName() + "." + this.method.name().asString() + Descriptor.userMethodArgs(this.method.signature().asString()));
        this.annotate = 0;
        CodeAttribute codeAttribute = this.method.codeAttribute();
        if (codeAttribute == null) {
            return;
        }
        if (this.avoidAnnotation()) {
            return;
        }
        this.checkCode(codeAttribute);
    }

    private boolean avoidAnnotation() {
        return false;
    }

    void checkCode(CodeAttribute codeAttribute) {
        Object object;
        Object object2;
        Insn insn;
        for (Insn insn2 = insn = codeAttribute.theCode(); insn2 != null; insn2 = insn2.next()) {
            insn2.markTargets();
        }
        int n = 0;
        for (object2 = insn; object2 != null; object2 = ((Insn)object2).next()) {
            object = null;
            switch (((Insn)object2).opcode()) {
                case 180: {
                    object = this.noteGetFieldAnnotation((Insn)object2);
                    break;
                }
                case 181: {
                    object = this.notePutFieldAnnotation((Insn)object2);
                    break;
                }
            }
            if (object == null) continue;
            this.addNoteList((InsnNote)object);
            MethodAnnotater.affirm(((InsnNote)object).next() == null, "Number of annotation notes for instruction > 1.");
            n |= ((InsnNote)object).insnFlags;
        }
        object2 = this.method.name().asString();
        object = this.method.signature().asString();
        boolean bl = this.ca.getImplementsPersistence();
        if (((String)object2).equals("clone") && ((String)object).equals("()Ljava/lang/Object;") && bl) {
            n |= 0x8000;
        }
        this.annotate = n;
    }

    private InsnNote noteGetFieldAnnotation(Insn insn) {
        InsnConstOp insnConstOp = (InsnConstOp)insn;
        ConstFieldRef constFieldRef = (ConstFieldRef)insnConstOp.value();
        String string = constFieldRef.className().asString();
        String string2 = constFieldRef.nameAndType().name().asString();
        JDOMetaData jDOMetaData = this.env.getJDOMetaData();
        if (!jDOMetaData.isPersistentField(string, string2)) {
            return null;
        }
        boolean bl = jDOMetaData.isDefaultFetchGroupField(string, string2);
        boolean bl2 = jDOMetaData.isPrimaryKeyField(string, string2);
        int n = jDOMetaData.getFieldNo(string, string2);
        String string3 = jDOMetaData.getPersistenceCapableRootClass(string);
        int n2 = 0;
        String string4 = constFieldRef.nameAndType().signature().asString();
        Insn insn2 = this.findArgDepositer(insn, 0);
        n2 = insn2 != null && insn2.opcode() == 42 && !this.method.isStatic() ? (n2 |= 1) : (n2 |= 0x10);
        if (bl) {
            n2 |= 0x800;
        }
        if (bl2) {
            n2 |= 0x1000;
        }
        return new InsnNote(insn, n2, 0, string4, string, string2, n, string3);
    }

    private InsnNote notePutFieldAnnotation(Insn insn) {
        InsnConstOp insnConstOp = (InsnConstOp)insn;
        ConstFieldRef constFieldRef = (ConstFieldRef)insnConstOp.value();
        String string = constFieldRef.className().asString();
        String string2 = constFieldRef.nameAndType().name().asString();
        JDOMetaData jDOMetaData = this.env.getJDOMetaData();
        if (!jDOMetaData.isPersistentField(string, string2)) {
            return null;
        }
        boolean bl = jDOMetaData.isDefaultFetchGroupField(string, string2);
        boolean bl2 = jDOMetaData.isPrimaryKeyField(string, string2);
        int n = jDOMetaData.getFieldNo(string, string2);
        String string3 = jDOMetaData.getPersistenceCapableRootClass(string);
        int n2 = 0;
        String string4 = constFieldRef.nameAndType().signature().asString();
        int n3 = string4.equals("J") || string4.equals("D") ? 2 : 1;
        Insn insn2 = this.findArgDepositer(insn, n3);
        n2 = insn2 != null && insn2.opcode() == 42 && !this.method.isStatic() ? (n2 |= 2) : (n2 |= 0x20);
        if (bl) {
            n2 |= 0x800;
        }
        if (bl2) {
            n2 |= 0x1000;
        }
        return new InsnNote(insn, n2, n3, string4, string, string2, n, string3);
    }

    void annotateMethod() {
        CodeAttribute codeAttribute = this.method.codeAttribute();
        if (codeAttribute == null || !this.needsAnnotation()) {
            return;
        }
        this.env.message("annotating method " + this.ca.userClassName() + "." + this.method.name().asString() + Descriptor.userMethodArgs(this.method.signature().asString()));
        Insn insn = codeAttribute.theCode();
        block3: for (Insn insn2 = insn.next(); insn2 != null; insn2 = insn2.next()) {
            switch (insn2.opcode()) {
                case 180: 
                case 181: {
                    insn2 = this.insnAnnotation(insn2);
                    continue block3;
                }
            }
        }
        if ((this.annotate & 0x8000) != 0) {
            String string = this.ca.classFile().superName().asString();
            this.annotateClone(codeAttribute, string);
        }
        if (this.annotationStack > 0) {
            codeAttribute.setStackUsed(codeAttribute.stackUsed() + this.annotationStack);
        }
    }

    private void annotateClone(CodeAttribute codeAttribute, String string) {
        for (Insn insn = codeAttribute.theCode(); insn != null; insn = insn.next()) {
            VMConstants vMConstants;
            boolean bl;
            if (insn.opcode() != 183) continue;
            InsnConstOp insnConstOp = (InsnConstOp)insn;
            ConstMethodRef constMethodRef = (ConstMethodRef)insnConstOp.value();
            ConstNameAndType constNameAndType = constMethodRef.nameAndType();
            String string2 = constNameAndType.name().asString();
            String string3 = constNameAndType.signature().asString();
            if (!string2.equals("clone") || !string3.equals("()Ljava/lang/Object;")) continue;
            String string4 = this.ca.className();
            Insn insn2 = insn.next();
            if (insn2.opcode() != 192) {
                bl = true;
            } else {
                vMConstants = (ConstClass)((InsnConstOp)insn2).value();
                if (((ConstClass)vMConstants).asString().equals(string4)) {
                    insn = insn2;
                    bl = false;
                } else {
                    bl = true;
                }
            }
            vMConstants = Insn.create(89);
            if (bl) {
                ((Insn)vMConstants).append(Insn.create(192, this.pool.addClass(string4)));
            }
            ((Insn)vMConstants).append(Insn.create(89));
            ((Insn)vMConstants).append(Insn.create(1));
            ((Insn)vMConstants).append(Insn.create(181, this.pool.addFieldRef(string4, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            ((Insn)vMConstants).append(Insn.create(3));
            ((Insn)vMConstants).append(Insn.create(181, this.pool.addFieldRef(string4, "jdoFlags", "B")));
            insn.insert((Insn)vMConstants);
            this.noteStack(3);
        }
    }

    private Insn insnAnnotation(Insn insn) {
        int n = 0;
        InsnNote insnNote = this.getNoteList(insn);
        if (insnNote == null) {
            return insn;
        }
        MethodAnnotater.affirm(insn == insnNote.insn);
        MethodAnnotater.affirm(insnNote.next() == null, "Number of annotation notes for instruction > 1.");
        boolean bl = insnNote.fetchPersistent() || insnNote.fetchThis();
        boolean bl2 = insnNote.dirtyPersistent() || insnNote.dirtyThis();
        MethodAnnotater.affirm(bl ^ bl2, "Inconsistent fetch/dirty flags.");
        boolean bl3 = insnNote.dfgFieldAccess();
        boolean bl4 = insnNote.pkFieldAccess();
        if (bl4 && bl) {
            return insn;
        }
        if (bl4 || !bl3) {
            Insn insn2 = insn.prev();
            insn.remove();
            AnnotationFragment annotationFragment = this.buildAccessAnnotation(insnNote);
            MethodAnnotater.affirm(annotationFragment, "Illegal annotation of PK or non-dfg field.");
            Insn insn3 = insn2.insert(annotationFragment.annotation);
            this.noteStack(annotationFragment.stackRequired - insnNote.arg());
            return insn3;
        }
        AnnotationFragment annotationFragment = this.buildBasicAnnotation(insnNote);
        MethodAnnotater.affirm(annotationFragment, "Illegal annotation of dfg field.");
        StackState stackState = new StackState(insnNote.arg(), insnNote.sig(), insn.prev());
        this.minimizeStack(stackState);
        Insn insn4 = null;
        if (stackState.argDepth == 0) {
            insn4 = annotationFragment.annotation;
            this.noteStack(annotationFragment.stackRequired);
        } else if (stackState.argDepth == 1) {
            insn4 = Insn.create(95);
            insn4.append(annotationFragment.annotation);
            insn4.append(Insn.create(95));
            this.noteStack(annotationFragment.stackRequired - (insnNote.arg() - 1));
        } else {
            int n2;
            int n3;
            Stack stack = stackState.stackTypes;
            int n4 = stack.size() - 1;
            int n5 = n;
            int n6 = 0;
            int[] nArray = new int[n3];
            int n7 = 0;
            for (n3 = stackState.argDepth; n3 > 0; n3 -= n2) {
                int n8 = (Integer)stack.elementAt(n4--);
                n2 = Descriptor.elementSize(n8);
                int n9 = n2 == 1 ? this.tmpReg(n5++) : this.tmpReg2(n6++);
                nArray[n7++] = n9;
                Insn insn5 = InsnUtils.store(n8, n9, this.pool);
                if (insn4 == null) {
                    insn4 = insn5;
                    continue;
                }
                insn4.append(insn5);
            }
            MethodAnnotater.affirm(n3 >= 0, "Stack underflow while computing save registers");
            insn4.append(annotationFragment.annotation);
            while (n7 > 0) {
                insn4.append(InsnUtils.load((Integer)stack.elementAt(++n4), nArray[--n7], this.pool));
            }
            this.noteStack(annotationFragment.stackRequired - insnNote.arg());
        }
        stackState.insn.insert(insn4);
        return insn;
    }

    private AnnotationFragment buildAccessAnnotation(InsnNote insnNote) {
        int n;
        Insn insn;
        String string = insnNote.targetClassName;
        String string2 = insnNote.targetFieldName;
        String string3 = insnNote.targetPCRootClass;
        boolean bl = insnNote.fetchPersistent() || insnNote.fetchThis();
        boolean bl2 = insnNote.dirtyPersistent() || insnNote.dirtyThis();
        MethodAnnotater.affirm(bl ^ bl2, "Inconsistent fetch/dirty flags.");
        int n2 = insnNote.arg();
        String string4 = insnNote.sig();
        int n3 = Descriptor.elementType(string4);
        int n4 = insnNote.targetFieldIndex;
        if (bl) {
            Insn insn2 = insn = Insn.create(89);
            insn2 = insn2.append(Insn.create(180, this.pool.addFieldRef(string3, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            InsnTarget insnTarget = new InsnTarget();
            InsnTarget insnTarget2 = new InsnTarget();
            insn2 = insn2.append(Insn.create(89));
            insn2 = insn2.append(Insn.create(199, insnTarget));
            insn2 = insn2.append(Insn.create(87));
            insn2 = insn2.append(Insn.create(167, insnTarget2));
            insn2 = insn2.append(insnTarget);
            insn2 = insn2.append(InsnUtils.integerConstant(n4, this.pool));
            n = 2;
            insn2 = insn2.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "prepareGetField", "(I)V"), n));
            insn2 = insn2.append(insnTarget2);
            insn2 = insn2.append(insnNote.insn);
        } else {
            int n5 = 0;
            int n6 = 0;
            MethodAnnotater.affirm(n2 > 0);
            int n7 = n2 == 1 ? this.tmpReg(n5++) : this.tmpReg2(n6++);
            Insn insn3 = insn = InsnUtils.store(n3, n7, this.pool);
            insn3 = insn3.append(Insn.create(89));
            insn3 = insn3.append(Insn.create(180, this.pool.addFieldRef(string3, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            InsnTarget insnTarget = new InsnTarget();
            InsnTarget insnTarget3 = new InsnTarget();
            insn3 = insn3.append(Insn.create(89));
            insn3 = insn3.append(Insn.create(199, insnTarget));
            insn3 = insn3.append(Insn.create(87));
            MethodAnnotater.affirm(n2 > 0);
            insn3 = insn3.append(InsnUtils.load(n3, n7, this.pool));
            insn3 = insn3.append(insnNote.insn);
            insn3 = insn3.append(Insn.create(167, insnTarget3));
            insn3 = insn3.append(insnTarget);
            insn3 = insn3.append(InsnUtils.integerConstant(n4, this.pool));
            MethodAnnotater.affirm(n2 > 0);
            insn3 = insn3.append(InsnUtils.load(n3, n7, this.pool));
            switch (n3) {
                case 4: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setBooleanField", "(IB)B"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 5: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setCharField", "(IC)C"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 8: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setByteField", "(IZ)Z"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 9: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setShortField", "(IS)S"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 10: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setIntField", "(II)I"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 11: {
                    n = 4;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setLongField", "(IJ)J"), n));
                    insn3 = insn3.append(Insn.create(88));
                    insn3 = insn3.append(Insn.create(87));
                    break;
                }
                case 6: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setFloatField", "(IF)F"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                case 7: {
                    n = 4;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setDoubleField", "(ID)D"), n));
                    insn3 = insn3.append(Insn.create(88));
                    insn3 = insn3.append(Insn.create(87));
                    break;
                }
                case 12: 
                case 13: {
                    n = 3;
                    insn3 = insn3.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setObjectField", "(ILjava/lang/Object;)Ljava/lang/Object;"), n));
                    insn3 = insn3.append(Insn.create(88));
                    break;
                }
                default: {
                    throw new InternalError("Unexpected field type");
                }
            }
            insn3 = insn3.append(insnTarget3);
        }
        return new AnnotationFragment(insn, n);
    }

    private AnnotationFragment buildBasicAnnotation(InsnNote insnNote) {
        int n = 2;
        Insn insn = null;
        String string = insnNote.targetClassName;
        String string2 = insnNote.targetFieldName;
        String string3 = insnNote.targetPCRootClass;
        boolean bl = insnNote.fetchPersistent() || insnNote.fetchThis();
        boolean bl2 = insnNote.dirtyPersistent() || insnNote.dirtyThis();
        MethodAnnotater.affirm(bl ^ bl2, "Inconsistent fetch/dirty flags.");
        Insn insn2 = null;
        insn = insn2 = Insn.create(89);
        insn2 = insn2.append(Insn.create(180, this.pool.addFieldRef(string3, "jdoFlags", "B")));
        InsnTarget insnTarget = new InsnTarget();
        insn2 = insn2.append(Insn.create(bl ? 158 : 153, insnTarget));
        insn2 = insn2.append(Insn.create(89));
        insn2 = insn2.append(Insn.create(180, this.pool.addFieldRef(string3, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
        insn2 = insn2.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", bl ? "loadForRead" : "loadForUpdate", "()V"), 1));
        insn2 = insn2.append(insnTarget);
        return new AnnotationFragment(insn, n);
    }

    private int tmpReg2(int n) {
        if (this.tmpDoubleRegisters == null) {
            this.tmpDoubleRegisters = new Vector(3);
        }
        while (this.tmpDoubleRegisters.size() <= n) {
            CodeAttribute codeAttribute = this.method.codeAttribute();
            int n2 = codeAttribute.localsUsed();
            this.tmpDoubleRegisters.addElement(new Integer(n2));
            codeAttribute.setLocalsUsed(n2 + 2);
        }
        return (Integer)this.tmpDoubleRegisters.elementAt(n);
    }

    private int tmpReg(int n) {
        if (this.tmpRegisters == null) {
            this.tmpRegisters = new Vector(3);
        }
        while (this.tmpRegisters.size() <= n) {
            CodeAttribute codeAttribute = this.method.codeAttribute();
            int n2 = codeAttribute.localsUsed();
            this.tmpRegisters.addElement(new Integer(n2));
            codeAttribute.setLocalsUsed(n2 + 1);
        }
        return (Integer)this.tmpRegisters.elementAt(n);
    }

    private void noteStack(int n) {
        if (n > this.annotationStack) {
            this.annotationStack = (short)n;
        }
    }

    private Insn findArgDepositer(Insn insn, int n) {
        Insn insn2 = null;
        Insn insn3 = insn.prev();
        while (!(n < 0 || insn3.branches() || insn3 instanceof InsnTarget && ((InsnTarget)insn3).isBranchTarget())) {
            int n2 = insn3.nStackArgs();
            int n3 = insn3.nStackResults();
            if (n - n3 < 0) {
                if (n3 > 1 && insn3.opcode() != 89) break;
                insn2 = insn3;
                switch (insn3.opcode()) {
                    case 89: {
                        if (n != 0) break;
                        ++n;
                        break;
                    }
                    case 192: {
                        break;
                    }
                    default: {
                        return insn3;
                    }
                }
            }
            n += n2 - n3;
            insn3 = insn3.prev();
        }
        return insn2;
    }

    private void minimizeStack(StackState stackState) {
        Insn insn = stackState.insn;
        int n = stackState.argDepth;
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        Stack stack3 = new Stack();
        this.copyStack(stackState.stackTypes, stack3);
        while (!(n <= 0 || insn.branches() || insn instanceof InsnTarget && ((InsnTarget)insn).isBranchTarget())) {
            int n2 = insn.nStackArgs();
            int n3 = insn.nStackResults();
            String string = insn.argTypes();
            String string2 = insn.resultTypes();
            if ((n -= n3) < 0) break;
            n += n2;
            if (insn.opcode() == 95) {
                Object e = stack3.pop();
                Object e2 = stack3.pop();
                stack3.push(e);
                stack3.push(e2);
            } else {
                while (!stack.empty()) {
                    stack.pop();
                }
                while (!stack2.empty()) {
                    stack2.pop();
                }
                Descriptor.computeStackTypes(string, stack);
                Descriptor.computeStackTypes(string2, stack2);
                int n4 = 0;
                while (!stack2.empty()) {
                    n4 += Descriptor.elementSize((Integer)stack2.pop());
                }
                while (n4 > 0) {
                    n4 -= Descriptor.elementSize((Integer)stack3.pop());
                }
                if (n4 < 0) {
                    return;
                }
                this.transferStackArgs(stack, stack3);
            }
            if (n >= 0 && n < stackState.argDepth && this.knownTypes(stack3, n)) {
                stackState.argDepth = n;
                stackState.insn = insn.prev();
                this.copyStack(stack3, stackState.stackTypes);
            }
            insn = insn.prev();
        }
    }

    private final void transferStackArgs(Stack stack, Stack stack2) {
        if (!stack.empty()) {
            Object e = stack.pop();
            this.transferStackArgs(stack, stack2);
            stack2.push(e);
        }
    }

    private final void copyStack(Stack stack, Stack stack2) {
        while (!stack2.empty()) {
            stack2.pop();
        }
        for (int i = 0; i < stack.size(); ++i) {
            stack2.addElement(stack.elementAt(i));
        }
    }

    private final boolean knownTypes(Stack stack, int n) {
        int n2;
        for (int i = stack.size() - 1; i >= 0 && n > 0; n -= n2, --i) {
            n2 = 0;
            switch ((Integer)stack.elementAt(i)) {
                case 15: 
                case 16: 
                case 17: {
                    return false;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 1;
                }
                case 7: 
                case 11: {
                    n2 = 2;
                }
            }
        }
        return true;
    }

    private final void addNoteList(InsnNote insnNote) {
        this.insnNotes.put(insnNote.insn, insnNote);
    }

    private final InsnNote getNoteList(Insn insn) {
        return (InsnNote)this.insnNotes.get(insn);
    }
}

