/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.FieldTypeInfo;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Support;

final class FieldAction
extends Support
implements VMConstants {
    private ClassField theField;
    private ClassAction ca;
    private final Environment env;
    private boolean fieldIsPrimaryKey;
    private boolean fieldIsMutableSCO;
    private boolean fieldIsPersistent;
    private int nFieldArrayDims;
    private String fieldClassName;
    private FieldTypeInfo fieldTypeInfo;

    FieldAction(ClassAction classAction, ClassField classField, Environment environment) {
        this.ca = classAction;
        this.theField = classField;
        this.env = environment;
    }

    String typeDescriptor() {
        return this.theField.signature().asString();
    }

    String typeName() {
        String string = this.typeDescriptor();
        if (string.charAt(0) == 'L') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    boolean isPrimaryKey() {
        return this.fieldIsPrimaryKey;
    }

    boolean isMutableSCO() {
        return this.fieldIsMutableSCO;
    }

    boolean isPersistent() {
        return this.fieldIsPersistent;
    }

    String fieldName() {
        return this.theField.name().asString();
    }

    boolean isSynthetic() {
        return this.theField.attributes().findAttribute("Synthetic") != null;
    }

    String createMethod() {
        return this.fieldTypeInfo.fieldCreateMethod;
    }

    String createMethodSig() {
        return this.fieldTypeInfo.fieldCreateMethodSig;
    }

    String setMethod() {
        return this.fieldTypeInfo.fieldSetMethod;
    }

    String setMethodSig() {
        return this.fieldTypeInfo.fieldSetMethodSig;
    }

    int setMethodArg() {
        return this.fieldTypeInfo.fieldSetArgType;
    }

    String getMethod() {
        return this.fieldTypeInfo.fieldGetMethod;
    }

    String getMethodSig() {
        return this.fieldTypeInfo.fieldGetMethodSig;
    }

    int getMethodReturn() {
        return this.fieldTypeInfo.fieldGetReturnType;
    }

    String fieldClassName() {
        return this.fieldClassName;
    }

    int nDims() {
        return this.nFieldArrayDims;
    }

    void check() {
        String string = this.theField.signature().asString();
        this.fieldTypeInfo = FieldTypeInfo.determineFieldType(string, this.env);
        String string2 = this.ca.className();
        String string3 = this.ca.userClassName();
        String string4 = this.theField.name().asString();
        String string5 = this.userFieldName();
        JDOMetaData jDOMetaData = this.env.getJDOMetaData();
        boolean bl = jDOMetaData.isPersistentField(string2, string4);
        this.fieldIsPrimaryKey = jDOMetaData.isPrimaryKeyField(string2, string4);
        this.fieldIsMutableSCO = jDOMetaData.isMutableSecondClassObjectType(this.typeName());
        this.nFieldArrayDims = 0;
        while (string.charAt(this.nFieldArrayDims) == '[') {
            ++this.nFieldArrayDims;
        }
        if (string.charAt(this.nFieldArrayDims) == 'L') {
            this.fieldClassName = string.substring(this.nFieldArrayDims + 1, string.length() - 1);
        }
        if (!bl) {
            return;
        }
        FieldAction.affirm(!this.theField.isStatic(), "The field " + string5 + " is a static field which cannot be made persistent.");
        FieldAction.affirm(!this.theField.isFinal(), "The field " + string5 + " is a final field which cannot be made persistent.");
        FieldAction.affirm(this.fieldClassName == null || jDOMetaData.isSecondClassObjectType(this.fieldClassName) || jDOMetaData.isPersistenceCapableClass(this.fieldClassName), "The field " + string5 + " cannot be made persistent because of a non-primitive, " + " non-sco, or non-pc target type " + this.fieldClassName);
        this.fieldIsPersistent = true;
    }

    String userFieldName() {
        return this.ca.userClassName() + "." + this.theField.name().asString();
    }

    private String userSig(String string) {
        return Descriptor.userFieldSig(string);
    }
}

