/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class Environment
extends Support {
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private boolean timingOption = false;
    private boolean verboseOption = false;
    private boolean quietOption = false;
    private boolean noWriteOption = false;
    private boolean disableThisHookHoisting;
    private boolean disableInitializerAnnotationSuppression;
    private boolean forceOverwriteOption = false;
    private boolean updateInPlaceOption = false;
    private int errorsEncountered = 0;
    private File destinationDirectory = null;
    private Hashtable classMap = new Hashtable(11);
    private HashMap missingClasses = new HashMap(11);
    private ClassPath classPathOption = new ClassPath("");
    private ClassPath destClassPath;
    private Hashtable fieldSuppressions = new Hashtable();
    private Hashtable classSuppressions = new Hashtable();
    private JDOMetaData jdoMetaData;
    private String lastErrorMessage = null;

    public void setDoTimingStatistics(boolean bl) {
        this.timingOption = bl;
    }

    public boolean doTimingStatistics() {
        return this.timingOption;
    }

    public void error(String string) {
        ++this.errorsEncountered;
        this.lastErrorMessage = Environment.getI18N("enhancer.enumerated_error", this.errorsEncountered, string);
        this.err.println(this.lastErrorMessage);
    }

    public void warning(String string) {
        if (!this.quietOption) {
            this.out.println(Environment.getI18N("enhancer.warning", string));
        }
    }

    public void warning(String string, String string2) {
        if (!this.quietOption && !this.classWarningsSuppressed(string2)) {
            this.out.println(Environment.getI18N("enhancer.warning", string));
        }
    }

    public void warning(String string, String string2, String string3) {
        if (!(this.quietOption || this.classWarningsSuppressed(string2) || this.fieldWarningsSuppressed(string2, string3))) {
            this.out.print(Environment.getI18N("enhancer.warning", string));
        }
    }

    public void message(String string) {
        if (this.verboseOption) {
            this.out.println("JDO ENHANCER: " + string);
        }
    }

    public void messageNL(String string) {
        if (this.verboseOption) {
            this.out.println();
            this.out.println("JDO ENHANCER: " + string);
        }
    }

    public int errorCount() {
        return this.errorsEncountered;
    }

    public final String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public boolean forceOverwrite() {
        return this.forceOverwriteOption;
    }

    public boolean updateInPlace() {
        return this.updateInPlaceOption;
    }

    public File destinationDirectory() {
        return this.destinationDirectory;
    }

    public boolean writeClasses() {
        return !this.noWriteOption && this.errorsEncountered == 0;
    }

    public boolean doThisOptimization() {
        return !this.disableThisHookHoisting;
    }

    public boolean doInitializerOptimization() {
        return !this.disableInitializerAnnotationSuppression;
    }

    public JDOMetaData getJDOMetaData() {
        return this.jdoMetaData;
    }

    public void setJDOMetaData(JDOMetaData jDOMetaData) {
        this.jdoMetaData = jDOMetaData;
    }

    public void addClass(ClassControl classControl) {
        String string = classControl.className();
        ClassControl classControl2 = this.getClass(string);
        if (classControl2 != null) {
            if (!classControl2.source().sameAs(classControl.source())) {
                this.error(Environment.getI18N("enhancer.class_already_entered", classControl.userClassName(), classControl.sourceName(), classControl2.sourceName()));
                return;
            }
            if (classControl.persistType() == 0 || classControl2.persistType() == 2 || classControl2.persistType() == 1 && classControl.persistType() != 2) {
                return;
            }
        }
        if (classControl2 == null && classControl.sourceName() != null) {
            this.message("adding class " + classControl.userClassName() + " from " + classControl.sourceName());
        }
        this.classMap.put(string, classControl);
    }

    public boolean canFindClass(String string) {
        return this.findClass(string) != null;
    }

    public ClassControl getClass(String string) {
        return (ClassControl)this.classMap.get(string);
    }

    public Iterator getClasses() {
        return this.classMap.values().iterator();
    }

    public ClassControl findClass(String string) {
        ClassControl classControl = (ClassControl)this.classMap.get(string);
        if (classControl == null && this.missingClasses.get(string) == null) {
            classControl = this.lookupClass(string);
            if (classControl != null) {
                this.message("Reading class " + classControl.userClassName() + " from " + classControl.sourceName());
                this.classMap.put(string, classControl);
            } else {
                this.missingClasses.put(string, string);
            }
        }
        return classControl;
    }

    public ClassControl lookupClass(String string) {
        ClassFileSource classFileSource = this.classPathOption.findClass(string);
        while (classFileSource != null) {
            try {
                ClassControl classControl = new ClassControl(classFileSource, this);
                if (classControl.className() != null && classControl.className().equals(string)) {
                    return classControl;
                }
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
            classFileSource = classFileSource.nextSource(string);
        }
        return null;
    }

    public ArrayList collectClasses(int n) {
        ArrayList<ClassControl> arrayList = new ArrayList<ClassControl>();
        Iterator iterator = this.classMap.values().iterator();
        while (iterator.hasNext()) {
            ClassControl classControl = (ClassControl)iterator.next();
            if (classControl.persistType() != n) continue;
            arrayList.add(classControl);
        }
        return arrayList;
    }

    public ArrayList collectClasses() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.classMap.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public ClassFileSource lookupDestClass(String string) {
        if (this.destClassPath == null && this.destinationDirectory != null) {
            this.destClassPath = new ClassPath(this.destinationDirectory.getPath());
        }
        return this.destClassPath == null ? null : this.destClassPath.findClass(string);
    }

    public void setDestinationDirectory(String string) {
        File file = new File(string);
        if (this.destinationDirectory != null) {
            this.error(Environment.getI18N("destination_directory_already_set", string, this.destinationDirectory.getPath()));
            return;
        }
        if (!file.isDirectory()) {
            this.error(Environment.getI18N("enhancer.destination_directory_not_exist", string));
            return;
        }
        this.destinationDirectory = file;
    }

    public void excludeDestinationDirectory() {
        if (this.destinationDirectory != null) {
            this.classPathOption.remove(this.destinationDirectory);
        }
    }

    public void moveDestinationDirectoryToEnd() {
        if (this.destinationDirectory != null && this.classPathOption.remove(this.destinationDirectory)) {
            this.classPathOption.append(this.destinationDirectory);
        }
    }

    public void setOutputWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter getOutputWriter() {
        return this.out;
    }

    public void setErrorWriter(PrintWriter printWriter) {
        this.err = printWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.err;
    }

    public void setVerbose(boolean bl) {
        this.verboseOption = bl;
    }

    public boolean isVerbose() {
        return this.verboseOption;
    }

    public void setQuiet(boolean bl) {
        this.quietOption = bl;
    }

    public void setNoWrite(boolean bl) {
        this.noWriteOption = bl;
    }

    public void setNoThisOptimization(boolean bl) {
        this.disableThisHookHoisting = bl;
    }

    public void setNoInitializerOptimization(boolean bl) {
        this.disableInitializerAnnotationSuppression = bl;
    }

    public void setNoOptimization(boolean bl) {
        this.disableThisHookHoisting = bl;
        this.disableInitializerAnnotationSuppression = bl;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwriteOption = bl;
    }

    public void suppressClassWarnings(String string) {
        this.classSuppressions.put(string, string);
    }

    public void suppressFieldWarnings(String string) {
        this.fieldSuppressions.put(string, string);
    }

    static String validVMPackage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (n != 0) {
                if (string.charAt(n) != '.') {
                    return null;
                }
                stringBuffer.append("/");
                if (++n == string.length()) {
                    return null;
                }
            }
            if (!Character.isJavaIdentifierStart(string.charAt(n))) {
                return null;
            }
            stringBuffer.append(string.charAt(n++));
            while (n < string.length() && Character.isJavaIdentifierPart(string.charAt(n))) {
                stringBuffer.append(string.charAt(n++));
            }
        }
        return stringBuffer.toString();
    }

    private boolean classWarningsSuppressed(String string) {
        return this.classSuppressions.get(string) != null;
    }

    private boolean fieldWarningsSuppressed(String string, String string2) {
        return this.fieldSuppressions.get(string + "." + string2) != null;
    }

    public void reset() {
        this.errorsEncountered = 0;
        this.classMap.clear();
        this.missingClasses.clear();
        this.fieldSuppressions.clear();
        this.classSuppressions.clear();
    }
}

