/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.ArrayList;
import java.util.Iterator;

public class EnhancerControl {
    private Environment env;

    public EnhancerControl(Environment environment) {
        this.env = environment;
    }

    protected static void dumpClass(ClassControl classControl) {
        String string = classControl.userClassName();
        System.out.println();
        System.out.println("dumping class " + string + " {");
        classControl.classFile().print(System.out);
        System.out.println("} // end of class " + string);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyClasses() {
        try {
            ClassControl classControl;
            ArrayList arrayList;
            if (this.env.doTimingStatistics()) {
                Support.timer.push("EnhancerControl.modifyClasses()");
            }
            if ((arrayList = this.env.collectClasses()).size() > 1) {
                this.env.messageNL("scanning classes");
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                classControl = (ClassControl)iterator.next();
                classControl.scan1();
            }
            if (this.env.errorCount() > 0) {
                return;
            }
            if (arrayList.size() > 1) {
                this.env.messageNL("augmenting classes");
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                classControl = (ClassControl)iterator.next();
                classControl.augment();
            }
            if (this.env.errorCount() > 0) {
                return;
            }
            if (arrayList.size() > 1) {
                this.env.messageNL("annotating classes");
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                classControl = (ClassControl)iterator.next();
                classControl.annotate();
            }
        }
        finally {
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
    }
}

